/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz.listener;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.ClassHelper;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.JobExecutionException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingJobListener
implements IJobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingJobListener.class);

    @Nonnull
    @Nonempty
    public String getName() {
        return "LoggingJobListener";
    }

    @Nonnull
    @Nonempty
    protected String getJobName(@Nonnull IJobExecutionContext iJobExecutionContext) {
        String string;
        String string2 = iJobExecutionContext.getJobDetail().getKey().toString();
        if (!string2.contains(string = ClassHelper.getClassLocalName((Class)iJobExecutionContext.getJobDetail().getJobClass()))) {
            string2 = string2 + "@" + string;
        }
        return string2;
    }

    public void jobToBeExecuted(@Nonnull IJobExecutionContext iJobExecutionContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Job to be executed: " + this.getJobName(iJobExecutionContext));
        }
    }

    public void jobExecutionVetoed(@Nonnull IJobExecutionContext iJobExecutionContext) {
        LOGGER.warn("Job execution vetoed by trigger listener: " + this.getJobName(iJobExecutionContext));
    }

    public void jobWasExecuted(@Nonnull IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        Object object = iJobExecutionContext.getResult();
        long l = iJobExecutionContext.getJobRunTime();
        String string = "Job was executed: " + this.getJobName(iJobExecutionContext) + (object == null ? "" : "; result=" + object) + "; duration=" + l + "ms";
        if (jobExecutionException == null) {
            LOGGER.info(string);
        } else {
            LOGGER.error(string, (Throwable)jobExecutionException);
        }
    }
}

