
package com.helger.schematron.svrl.jaxb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * &lt;p&gt;Java class for SchematronOutputType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="SchematronOutputType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element ref="{http://purl.oclc.org/dsdl/svrl}text" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{http://purl.oclc.org/dsdl/svrl}ns-prefix-in-attribute-values" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;sequence maxOccurs="unbounded"&amp;gt;
 *           &amp;lt;element ref="{http://purl.oclc.org/dsdl/svrl}active-pattern"/&amp;gt;
 *           &amp;lt;sequence maxOccurs="unbounded" minOccurs="0"&amp;gt;
 *             &amp;lt;element ref="{http://purl.oclc.org/dsdl/svrl}fired-rule"/&amp;gt;
 *             &amp;lt;choice maxOccurs="unbounded" minOccurs="0"&amp;gt;
 *               &amp;lt;element ref="{http://purl.oclc.org/dsdl/svrl}failed-assert"/&amp;gt;
 *               &amp;lt;element ref="{http://purl.oclc.org/dsdl/svrl}successful-report"/&amp;gt;
 *             &amp;lt;/choice&amp;gt;
 *           &amp;lt;/sequence&amp;gt;
 *         &amp;lt;/sequence&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attribute name="title" type="{http://www.w3.org/2001/XMLSchema}string" /&amp;gt;
 *       &amp;lt;attribute name="phase" type="{http://www.w3.org/2001/XMLSchema}NMTOKEN" /&amp;gt;
 *       &amp;lt;attribute name="schemaVersion" type="{http://www.w3.org/2001/XMLSchema}string" /&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SchematronOutputType", propOrder = {
    "text",
    "nsPrefixInAttributeValues",
    "activePatternAndFiredRuleAndFailedAssert"
})
@CodingStyleguideUnaware
public class SchematronOutputType implements Serializable, IExplicitlyCloneable
{

    private List<Text> text;
    @XmlElement(name = "ns-prefix-in-attribute-values")
    private List<NsPrefixInAttributeValues> nsPrefixInAttributeValues;
    @XmlElements({
        @XmlElement(name = "active-pattern", required = true, type = ActivePattern.class),
        @XmlElement(name = "fired-rule", required = true, type = FiredRule.class),
        @XmlElement(name = "failed-assert", required = true, type = FailedAssert.class),
        @XmlElement(name = "successful-report", required = true, type = SuccessfulReport.class)
    })
    private List<Object> activePatternAndFiredRuleAndFailedAssert;
    @XmlAttribute(name = "title")
    private String title;
    @XmlAttribute(name = "phase")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "NMTOKEN")
    private String phase;
    @XmlAttribute(name = "schemaVersion")
    private String schemaVersion;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public SchematronOutputType() {
    }

    /**
     * Gets the value of the text property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the text property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getText().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link Text }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Text> getText() {
        if (text == null) {
            text = new ArrayList<Text>();
        }
        return this.text;
    }

    /**
     * Gets the value of the nsPrefixInAttributeValues property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the nsPrefixInAttributeValues property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getNsPrefixInAttributeValues().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NsPrefixInAttributeValues }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NsPrefixInAttributeValues> getNsPrefixInAttributeValues() {
        if (nsPrefixInAttributeValues == null) {
            nsPrefixInAttributeValues = new ArrayList<NsPrefixInAttributeValues>();
        }
        return this.nsPrefixInAttributeValues;
    }

    /**
     * Gets the value of the activePatternAndFiredRuleAndFailedAssert property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the activePatternAndFiredRuleAndFailedAssert property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getActivePatternAndFiredRuleAndFailedAssert().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link ActivePattern }
     * {@link FiredRule }
     * {@link FailedAssert }
     * {@link SuccessfulReport }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Object> getActivePatternAndFiredRuleAndFailedAssert() {
        if (activePatternAndFiredRuleAndFailedAssert == null) {
            activePatternAndFiredRuleAndFailedAssert = new ArrayList<Object>();
        }
        return this.activePatternAndFiredRuleAndFailedAssert;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTitle(
        @Nullable
        String value) {
        this.title = value;
    }

    /**
     * Gets the value of the phase property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getPhase() {
        return phase;
    }

    /**
     * Sets the value of the phase property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPhase(
        @Nullable
        String value) {
        this.phase = value;
    }

    /**
     * Gets the value of the schemaVersion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * Sets the value of the schemaVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchemaVersion(
        @Nullable
        String value) {
        this.schemaVersion = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SchematronOutputType rhs = ((SchematronOutputType) o);
        if (!EqualsHelper.equalsCollection(activePatternAndFiredRuleAndFailedAssert, rhs.activePatternAndFiredRuleAndFailedAssert)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(nsPrefixInAttributeValues, rhs.nsPrefixInAttributeValues)) {
            return false;
        }
        if (!EqualsHelper.equals(phase, rhs.phase)) {
            return false;
        }
        if (!EqualsHelper.equals(schemaVersion, rhs.schemaVersion)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(text, rhs.text)) {
            return false;
        }
        if (!EqualsHelper.equals(title, rhs.title)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(activePatternAndFiredRuleAndFailedAssert).append(nsPrefixInAttributeValues).append(phase).append(schemaVersion).append(text).append(title).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("activePatternAndFiredRuleAndFailedAssert", activePatternAndFiredRuleAndFailedAssert).append("nsPrefixInAttributeValues", nsPrefixInAttributeValues).append("phase", phase).append("schemaVersion", schemaVersion).append("text", text).append("title", title).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setText(
        @Nullable
        final List<Text> aList) {
        text = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setNsPrefixInAttributeValues(
        @Nullable
        final List<NsPrefixInAttributeValues> aList) {
        nsPrefixInAttributeValues = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setActivePatternAndFiredRuleAndFailedAssert(
        @Nullable
        final List<Object> aList) {
        activePatternAndFiredRuleAndFailedAssert = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTextEntries() {
        return (!getText().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTextEntries() {
        return getText().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTextCount() {
        return getText().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Text getTextAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getText().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addText(
        @Nonnull
        final Text elem) {
        getText().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNsPrefixInAttributeValuesEntries() {
        return (!getNsPrefixInAttributeValues().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoNsPrefixInAttributeValuesEntries() {
        return getNsPrefixInAttributeValues().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getNsPrefixInAttributeValuesCount() {
        return getNsPrefixInAttributeValues().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NsPrefixInAttributeValues getNsPrefixInAttributeValuesAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNsPrefixInAttributeValues().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addNsPrefixInAttributeValues(
        @Nonnull
        final NsPrefixInAttributeValues elem) {
        getNsPrefixInAttributeValues().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasActivePatternAndFiredRuleAndFailedAssertEntries() {
        return (!getActivePatternAndFiredRuleAndFailedAssert().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoActivePatternAndFiredRuleAndFailedAssertEntries() {
        return getActivePatternAndFiredRuleAndFailedAssert().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getActivePatternAndFiredRuleAndFailedAssertCount() {
        return getActivePatternAndFiredRuleAndFailedAssert().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Object getActivePatternAndFiredRuleAndFailedAssertAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getActivePatternAndFiredRuleAndFailedAssert().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addActivePatternAndFiredRuleAndFailedAssert(
        @Nonnull
        final Object elem) {
        getActivePatternAndFiredRuleAndFailedAssert().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        SchematronOutputType ret) {
        if (activePatternAndFiredRuleAndFailedAssert == null) {
            ret.activePatternAndFiredRuleAndFailedAssert = null;
        } else {
            List<Object> retActivePatternAndFiredRuleAndFailedAssert = new ArrayList<Object>();
            for (Object aItem: getActivePatternAndFiredRuleAndFailedAssert()) {
                retActivePatternAndFiredRuleAndFailedAssert.add(aItem);
            }
            ret.activePatternAndFiredRuleAndFailedAssert = retActivePatternAndFiredRuleAndFailedAssert;
        }
        if (nsPrefixInAttributeValues == null) {
            ret.nsPrefixInAttributeValues = null;
        } else {
            List<NsPrefixInAttributeValues> retNsPrefixInAttributeValues = new ArrayList<NsPrefixInAttributeValues>();
            for (NsPrefixInAttributeValues aItem: getNsPrefixInAttributeValues()) {
                retNsPrefixInAttributeValues.add(((aItem == null)?null:aItem.clone()));
            }
            ret.nsPrefixInAttributeValues = retNsPrefixInAttributeValues;
        }
        ret.phase = phase;
        ret.schemaVersion = schemaVersion;
        if (text == null) {
            ret.text = null;
        } else {
            List<Text> retText = new ArrayList<Text>();
            for (Text aItem: getText()) {
                retText.add(((aItem == null)?null:aItem.clone()));
            }
            ret.text = retText;
        }
        ret.title = title;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SchematronOutputType clone() {
        SchematronOutputType ret = new SchematronOutputType();
        cloneTo(ret);
        return ret;
    }

}
