/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.api.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.ICallback;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.state.EValidity;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.schematron.AbstractSchematronResource;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.api.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.api.xslt.ISchematronXSLTBasedResource;
import com.helger.schematron.api.xslt.validator.ISchematronOutputValidityDeterminator;
import com.helger.schematron.api.xslt.validator.SchematronOutputValidityDeterminatorDefault;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.xml.XMLFactory;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.transform.DefaultTransformURIResolver;
import com.helger.xml.transform.LoggingTransformErrorListener;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

@NotThreadSafe
public abstract class AbstractSchematronXSLTBasedResource<IMPLTYPE extends AbstractSchematronXSLTBasedResource<IMPLTYPE>>
extends AbstractSchematronResource
implements ISchematronXSLTBasedResource,
IGenericImplTrait<IMPLTYPE> {
    public static final boolean DEFAULT_VALIDATE_SVRL = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchematronXSLTBasedResource.class);
    protected ErrorListener m_aCustomErrorListener;
    protected URIResolver m_aCustomURIResolver = new DefaultTransformURIResolver();
    protected final ICommonsOrderedMap<String, Object> m_aCustomParameters = new CommonsLinkedHashMap();
    private ISchematronOutputValidityDeterminator m_aSOVDeterminator = new SchematronOutputValidityDeterminatorDefault();
    private boolean m_bValidateSVRL = true;

    @Nullable
    private static String _findBaseURL(@Nonnull IReadableResource iReadableResource) {
        if (iReadableResource instanceof FileSystemResource) {
            return FileHelper.getAsURLString((File)((FileSystemResource)iReadableResource).getAsFile().getParentFile());
        }
        URL uRL = iReadableResource.getAsURL();
        return uRL != null ? uRL.toExternalForm() : null;
    }

    public AbstractSchematronXSLTBasedResource(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
        String string = AbstractSchematronXSLTBasedResource._findBaseURL(iReadableResource);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using '" + string + "' as base URL for SCH resource " + iReadableResource);
        }
        this.setURIResolver((URIResolver)new DefaultTransformURIResolver().setDefaultBase(string));
    }

    @Override
    @Nullable
    public final ErrorListener getErrorListener() {
        return this.m_aCustomErrorListener;
    }

    @Nonnull
    public final IMPLTYPE setErrorListener(@Nullable ErrorListener errorListener) {
        this.m_aCustomErrorListener = errorListener;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Override
    @Nullable
    public final URIResolver getURIResolver() {
        return this.m_aCustomURIResolver;
    }

    @Nonnull
    public final IMPLTYPE setURIResolver(@Nullable URIResolver uRIResolver) {
        this.m_aCustomURIResolver = uRIResolver;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedMap<String, Object> parameters() {
        return this.m_aCustomParameters;
    }

    @Nonnull
    public final IMPLTYPE setEntityResolver(@Nullable EntityResolver entityResolver) {
        this.internalSetEntityResolver(entityResolver);
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Nullable
    public abstract ISchematronXSLTBasedProvider getXSLTProvider();

    @Override
    @Nonnull
    public final ISchematronOutputValidityDeterminator getOutputValidityDeterminator() {
        return this.m_aSOVDeterminator;
    }

    @Nonnull
    public final IMPLTYPE setOutputValidityDeterminator(@Nonnull ISchematronOutputValidityDeterminator iSchematronOutputValidityDeterminator) {
        ValueEnforcer.notNull((Object)iSchematronOutputValidityDeterminator, (String)"SchematronOutputValidityDeterminator");
        this.m_aSOVDeterminator = iSchematronOutputValidityDeterminator;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Override
    public final boolean isValidateSVRL() {
        return this.m_bValidateSVRL;
    }

    @Nonnull
    public final IMPLTYPE setValidateSVRL(boolean bl) {
        this.m_bValidateSVRL = bl;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Override
    public final boolean isValidSchematron() {
        ISchematronXSLTBasedProvider iSchematronXSLTBasedProvider = this.getXSLTProvider();
        return iSchematronXSLTBasedProvider != null && iSchematronXSLTBasedProvider.isValidSchematron();
    }

    @Override
    @Nonnull
    public final EValidity getSchematronValidity(@Nonnull Node node, @Nullable String string) throws Exception {
        ValueEnforcer.notNull((Object)node, (String)"XMLNode");
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(node, string);
        if (schematronOutputType == null) {
            return EValidity.INVALID;
        }
        return this.m_aSOVDeterminator.getSchematronOutputValidity(schematronOutputType);
    }

    @Override
    @Nullable
    public final Document applySchematronValidation(@Nonnull Node node, @Nullable String string) throws TransformerException {
        ValueEnforcer.notNull((Object)node, (String)"XMLNode");
        ISchematronXSLTBasedProvider iSchematronXSLTBasedProvider = this.getXSLTProvider();
        if (iSchematronXSLTBasedProvider == null || !iSchematronXSLTBasedProvider.isValidSchematron()) {
            LOGGER.warn("Cannot apply the Schematron validation, due to errors in the Schematron rules");
            return null;
        }
        if (SchematronDebug.isShowCreatedXSLT()) {
            LOGGER.info("Created XSLT document: " + XMLWriter.getNodeAsString((Node)iSchematronXSLTBasedProvider.getXSLTDocument()));
        }
        Document document = XMLFactory.newDocument();
        Transformer transformer = iSchematronXSLTBasedProvider.getXSLTTransformer();
        if (this.m_aCustomErrorListener != null) {
            transformer.setErrorListener(this.m_aCustomErrorListener);
        } else {
            transformer.setErrorListener((ErrorListener)new LoggingTransformErrorListener(Locale.US));
        }
        if (this.m_aCustomURIResolver != null) {
            transformer.setURIResolver(this.m_aCustomURIResolver);
        }
        if (this.m_aCustomParameters != null) {
            for (Map.Entry entry : this.m_aCustomParameters.entrySet()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding XSLT parameter '" + (String)entry.getKey() + "' = '" + entry.getValue() + "'");
                }
                transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Applying Schematron XSLT on XML [start]");
        }
        DOMSource dOMSource = new DOMSource(node);
        dOMSource.setSystemId(string);
        transformer.transform(dOMSource, new DOMResult(document));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Applying Schematron XSLT on XML [end]");
        }
        if (SchematronDebug.isShowCreatedSVRL()) {
            LOGGER.info("Created SVRL:\n" + XMLWriter.getNodeAsString((Node)document));
        }
        return document;
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Node node, @Nullable String string) throws Exception {
        Document document = this.applySchematronValidation(node, string);
        if (document == null) {
            return null;
        }
        if (document.getDocumentElement() == null) {
            throw new IllegalStateException("Internal error: created SVRL DOM Document has no document node!");
        }
        SVRLMarshaller sVRLMarshaller = new SVRLMarshaller(this.m_bValidateSVRL);
        if (GlobalDebug.isDebugMode()) {
            sVRLMarshaller.readExceptionCallbacks().set((ICallback)((IExceptionCallback)jAXBException -> LOGGER.error("Error parsing the following SVRL:\n" + XMLWriter.getNodeAsString((Node)document), jAXBException)));
        }
        return (SchematronOutputType)sVRLMarshaller.read(document);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("CustomErrorListener", (Object)this.m_aCustomErrorListener).append("CustomURIResolver", (Object)this.m_aCustomURIResolver).append("CustomParameters", this.m_aCustomParameters).append("XSLTValidator", (Object)this.m_aSOVDeterminator).append("ValidateSVRL", this.m_bValidateSVRL).getToString();
    }
}

