/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.state.EValidity;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.bound.IPSBoundSchema;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.errorhandler.LoggingPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.PSActive;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.validation.IPSPartialValidationHandler;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.validation.PSValidationHandlerBreakOnFirstError;
import com.helger.schematron.pure.validation.SchematronValidationException;
import com.helger.schematron.pure.validation.xpath.PSXPathValidationHandlerSVRL;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.w3c.dom.Node;

public abstract class AbstractPSBoundSchema
implements IPSBoundSchema {
    private final IPSQueryBinding m_aQueryBinding;
    private final PSSchema m_aOrigSchema;
    private final IPSErrorHandler m_aErrorHandler;
    private final boolean m_bDefaultErrorHandler;
    private final MapBasedNamespaceContext m_aNamespaceContext;
    private final String m_sPhaseID;
    private final PSPhase m_aPhase;
    private final ICommonsList<PSPattern> m_aPatterns = new CommonsArrayList();
    private final IPSValidationHandler m_aCustomValidationHandler;

    public AbstractPSBoundSchema(@Nonnull IPSQueryBinding iPSQueryBinding, @Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable IPSValidationHandler iPSValidationHandler) {
        String string2;
        ValueEnforcer.notNull((Object)iPSQueryBinding, (String)"QueryBinding");
        ValueEnforcer.notNull((Object)pSSchema, (String)"OrigSchema");
        this.m_aQueryBinding = iPSQueryBinding;
        this.m_aOrigSchema = pSSchema;
        this.m_aErrorHandler = iPSErrorHandler != null ? iPSErrorHandler : new LoggingPSErrorHandler();
        this.m_bDefaultErrorHandler = iPSErrorHandler == null;
        this.m_aNamespaceContext = pSSchema.getAsNamespaceContext();
        String string3 = string2 = string != null ? string : "#DEFAULT";
        if (string2.equals("#DEFAULT") && (string2 = pSSchema.getDefaultPhase()) == null) {
            string2 = "#ALL";
        }
        if (!string2.equals("#ALL")) {
            this.m_aPhase = pSSchema.getPhaseOfID(string2);
            if (this.m_aPhase == null) {
                this.warn(pSSchema, "Failed to resolve phase with ID '" + string2 + "' - default to all patterns");
            }
        } else {
            this.m_aPhase = null;
        }
        this.m_sPhaseID = string2;
        if (this.m_aPhase == null) {
            this.m_aPatterns.addAll(pSSchema.getAllPatterns());
        } else {
            for (PSActive pSActive : this.m_aPhase.getAllActives()) {
                String string4 = pSActive.getPattern();
                PSPattern pSPattern = pSSchema.getPatternOfID(string4);
                if (pSPattern == null) {
                    this.warn(pSSchema, "Failed to resolve pattern with ID '" + string4 + "' - ignoring this pattern in phase '" + string2 + "'");
                    continue;
                }
                this.m_aPatterns.add((Object)pSPattern);
            }
        }
        if (this.m_aPatterns.isEmpty()) {
            if (this.m_aPhase == null) {
                this.error(pSSchema, "No patterns found in schema!");
            } else {
                this.error(pSSchema, "No patterns found in schema for phase '" + this.m_aPhase.getID() + "!");
            }
        }
        this.m_aCustomValidationHandler = iPSValidationHandler;
    }

    @Nonnull
    public final IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    public final boolean isDefaultErrorHandler() {
        return this.m_bDefaultErrorHandler;
    }

    @OverridingMethodsMustInvokeSuper
    protected void warn(@Nonnull IPSElement iPSElement, @Nonnull String string) {
        this.getErrorHandler().handleError((IError)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderWarn().setErrorLocation((ILocation)new SimpleLocation(this.m_aOrigSchema.getResource().getPath()))).setErrorFieldName(IPSErrorHandler.getErrorFieldName(iPSElement))).setErrorText(string)).build());
    }

    @OverridingMethodsMustInvokeSuper
    protected void error(@Nonnull IPSElement iPSElement, @Nonnull String string) {
        this.error(iPSElement, string, null);
    }

    @OverridingMethodsMustInvokeSuper
    protected void error(@Nonnull IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        this.getErrorHandler().handleError((IError)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorLocation((ILocation)new SimpleLocation(this.m_aOrigSchema.getResource().getPath()))).setErrorFieldName(IPSErrorHandler.getErrorFieldName(iPSElement))).setErrorText(string)).setLinkedException(throwable)).build());
    }

    @Override
    @Nonnull
    public final IPSQueryBinding getQueryBinding() {
        return this.m_aQueryBinding;
    }

    @Override
    @Nonnull
    public final PSSchema getOriginalSchema() {
        return this.m_aOrigSchema;
    }

    @Override
    @Nonnull
    public final MapBasedNamespaceContext getNamespaceContext() {
        return this.m_aNamespaceContext;
    }

    @Override
    @Nonnull
    public final String getPhaseID() {
        return this.m_sPhaseID;
    }

    @Override
    @Nullable
    public final PSPhase getPhase() {
        return this.m_aPhase;
    }

    @Override
    public final boolean isPhaseSpecified() {
        return this.m_aPhase != null;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<PSPattern> getAllRelevantPatterns() {
        return (ICommonsList)this.m_aPatterns.getClone();
    }

    @Nullable
    public final IPSValidationHandler getCustomValidationHandler() {
        return this.m_aCustomValidationHandler;
    }

    @Nonnull
    @OverrideOnDemand
    protected IPSPartialValidationHandler createPartialValidationHandler() {
        return new PSValidationHandlerBreakOnFirstError();
    }

    @Override
    @Nonnull
    public EValidity validatePartially(@Nonnull Node node, @Nullable String string) throws SchematronValidationException {
        IPSPartialValidationHandler iPSPartialValidationHandler = this.createPartialValidationHandler();
        this.validate(node, string, iPSPartialValidationHandler.and(this.m_aCustomValidationHandler));
        return iPSPartialValidationHandler.getValidity();
    }

    @Override
    @Nonnull
    public SchematronOutputType validateComplete(@Nonnull Node node, @Nullable String string) throws SchematronValidationException {
        PSXPathValidationHandlerSVRL pSXPathValidationHandlerSVRL = new PSXPathValidationHandlerSVRL(this.getErrorHandler());
        this.validate(node, string, pSXPathValidationHandlerSVRL.and(this.m_aCustomValidationHandler));
        return pSXPathValidationHandlerSVRL.getSVRL();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("queryBinding", (Object)this.m_aQueryBinding).append("origSchema", (Object)this.m_aOrigSchema).appendIfNotNull("errorHandler", (Object)this.m_aErrorHandler).append("namespaceContext", (Object)this.m_aNamespaceContext).appendIfNotNull("phaseID", (Object)this.m_sPhaseID).appendIfNotNull("phase", (Object)this.m_aPhase).append("patterns", this.m_aPatterns).getToString();
    }
}

