/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.SchematronBindException;
import com.helger.schematron.pure.binding.xpath.PSXPathVariables;
import com.helger.schematron.pure.bound.AbstractPSBoundSchema;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundPattern;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundRule;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSName;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.validation.SchematronValidationException;
import com.helger.schematron.pure.xpath.IXPathConfig;
import com.helger.schematron.pure.xpath.XPathConfigBuilder;
import com.helger.schematron.pure.xpath.XPathEvaluationHelper;
import com.helger.schematron.saxon.SaxonNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.xpath.XPathHelper;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.xpath.XPathEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NotThreadSafe
public class PSXPathBoundSchema
extends AbstractPSBoundSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSXPathBoundSchema.class);
    private final IXPathConfig m_aXPathConfig;
    private ICommonsList<PSXPathBoundPattern> m_aBoundPatterns;

    @Nullable
    private static XPathExpression _compileXPath(@Nonnull XPath xPath, @Nonnull String string) throws XPathExpressionException {
        XPathExpression xPathExpression = null;
        xPathExpression = xPath.compile(string);
        return xPathExpression;
    }

    @Nullable
    private ICommonsList<PSXPathBoundElement> _createBoundElements(@Nonnull IPSHasMixedContent iPSHasMixedContent, @Nonnull XPath xPath, @Nonnull PSXPathVariables pSXPathVariables) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = false;
        for (Object e : iPSHasMixedContent.getAllContentElements()) {
            XPathExpression xPathExpression;
            String string;
            IPSClonableElement<PSName> iPSClonableElement;
            if (e instanceof PSName) {
                iPSClonableElement = (PSName)e;
                if (((PSName)iPSClonableElement).hasPath()) {
                    string = pSXPathVariables.getAppliedReplacement(((PSName)iPSClonableElement).getPath());
                    try {
                        xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                        commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement, string, xPathExpression));
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this.error(iPSClonableElement, "Failed to compile XPath expression in <name>: '" + string + "'", xPathExpressionException.getCause() != null ? xPathExpressionException.getCause() : xPathExpressionException);
                        bl = true;
                    }
                    continue;
                }
                commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement));
                continue;
            }
            if (e instanceof PSValueOf) {
                iPSClonableElement = (PSValueOf)e;
                string = pSXPathVariables.getAppliedReplacement(((PSValueOf)iPSClonableElement).getSelect());
                try {
                    xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                    commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement, string, xPathExpression));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(iPSClonableElement, "Failed to compile XPath expression in <value-of>: '" + string + "'", xPathExpressionException);
                    bl = true;
                }
                continue;
            }
            if (e instanceof String) {
                commonsArrayList.add((Object)new PSXPathBoundElement((String)e));
                continue;
            }
            commonsArrayList.add((Object)new PSXPathBoundElement((IPSElement)e));
        }
        if (bl) {
            return null;
        }
        return commonsArrayList;
    }

    @Nullable
    private ICommonsMap<String, PSXPathBoundDiagnostic> _createBoundDiagnostics(@Nonnull XPath xPath, @Nonnull PSXPathVariables pSXPathVariables) {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        boolean bl = false;
        PSSchema pSSchema = this.getOriginalSchema();
        if (pSSchema.hasDiagnostics()) {
            for (PSDiagnostic pSDiagnostic : pSSchema.getDiagnostics().getAllDiagnostics()) {
                ICommonsList<PSXPathBoundElement> iCommonsList = this._createBoundElements(pSDiagnostic, xPath, pSXPathVariables);
                if (iCommonsList == null) {
                    bl = true;
                    continue;
                }
                PSXPathBoundDiagnostic pSXPathBoundDiagnostic = new PSXPathBoundDiagnostic(pSDiagnostic, iCommonsList);
                if (commonsHashMap.put((Object)pSDiagnostic.getID(), (Object)pSXPathBoundDiagnostic) == null) continue;
                this.error(pSDiagnostic, "A diagnostic element with ID '" + pSDiagnostic.getID() + "' was overwritten!");
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return commonsHashMap;
    }

    @Nullable
    private ICommonsList<PSXPathBoundPattern> _createBoundPatterns(@Nonnull XPath xPath, @Nonnull ICommonsMap<String, PSXPathBoundDiagnostic> iCommonsMap, @Nonnull PSXPathVariables pSXPathVariables) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = false;
        for (PSPattern pSPattern : this.getAllRelevantPatterns()) {
            Object object2;
            PSXPathVariables pSXPathVariables2;
            if (pSPattern.hasAnyLet()) {
                pSXPathVariables2 = pSXPathVariables.getClone();
                for (Object object2 : pSPattern.getAllLetsAsMap().entrySet()) {
                    if (!pSXPathVariables2.add((Map.Entry<String, String>)object2).isUnchanged()) continue;
                    this.error(pSPattern, "Duplicate <let> with name '" + (String)object2.getKey() + "' in <pattern>");
                }
            } else {
                pSXPathVariables2 = pSXPathVariables;
            }
            CommonsArrayList commonsArrayList2 = new CommonsArrayList();
            for (PSRule pSRule : pSPattern.getAllRules()) {
                Object object3;
                Object object42;
                Object object52;
                PSXPathVariables pSXPathVariables3;
                if (pSRule.hasAnyLet()) {
                    pSXPathVariables3 = pSXPathVariables2.getClone();
                    for (Object object52 : pSRule.getAllLetsAsMap().entrySet()) {
                        if (!pSXPathVariables3.add((Map.Entry<String, String>)object52).isUnchanged()) continue;
                        this.error(pSRule, "Duplicate <let> with name '" + (String)object52.getKey() + "' in <rule>");
                    }
                } else {
                    pSXPathVariables3 = pSXPathVariables2;
                }
                CommonsArrayList commonsArrayList3 = new CommonsArrayList();
                for (Object object42 : pSRule.getAllAssertReports()) {
                    object3 = pSXPathVariables3.getAppliedReplacement(((PSAssertReport)object42).getTest());
                    try {
                        XPathExpression xPathExpression = PSXPathBoundSchema._compileXPath(xPath, (String)object3);
                        ICommonsList<PSXPathBoundElement> iCommonsList = this._createBoundElements((IPSHasMixedContent)object42, xPath, pSXPathVariables3);
                        if (iCommonsList == null) {
                            bl = true;
                            continue;
                        }
                        PSXPathBoundAssertReport pSXPathBoundAssertReport = new PSXPathBoundAssertReport((PSAssertReport)object42, (String)object3, xPathExpression, iCommonsList, iCommonsMap);
                        commonsArrayList3.add((Object)pSXPathBoundAssertReport);
                    }
                    catch (Throwable throwable) {
                        this.error((IPSElement)object42, "Failed to compile XPath expression in <" + (((PSAssertReport)object42).isAssert() ? "assert" : "report") + ">: '" + (String)object3 + "' with the following variables: " + pSXPathVariables3.getAll(), throwable);
                        bl = true;
                    }
                }
                object52 = pSXPathVariables.getAppliedReplacement(this.getValidationContext(pSRule.getContext()));
                object42 = null;
                try {
                    object3 = PSXPathBoundSchema._compileXPath(xPath, (String)object52);
                    object42 = new PSXPathBoundRule(pSRule, (String)object52, (XPathExpression)object3, (ICommonsList<PSXPathBoundAssertReport>)commonsArrayList3);
                    commonsArrayList2.add(object42);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to compile XPath expression in <rule>: '" + (String)object52 + "'", xPathExpressionException.getCause() != null ? xPathExpressionException.getCause() : xPathExpressionException);
                    bl = true;
                }
            }
            object2 = new PSXPathBoundPattern(pSPattern, (ICommonsList<PSXPathBoundRule>)commonsArrayList2);
            commonsArrayList.add(object2);
        }
        if (bl) {
            return null;
        }
        return commonsArrayList;
    }

    public PSXPathBoundSchema(@Nonnull IPSQueryBinding iPSQueryBinding, @Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable IPSValidationHandler iPSValidationHandler, @Nullable IXPathConfig iXPathConfig) throws SchematronBindException {
        super(iPSQueryBinding, pSSchema, string, iPSErrorHandler, iPSValidationHandler);
        if (iXPathConfig != null) {
            this.m_aXPathConfig = iXPathConfig;
        } else {
            try {
                this.m_aXPathConfig = new XPathConfigBuilder().build();
            }
            catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
                throw new SchematronBindException("Failed to create XPath configuration", xPathFactoryConfigurationException);
            }
        }
    }

    @Nonnull
    private XPath _createXPathContext() {
        MapBasedNamespaceContext mapBasedNamespaceContext = this.getNamespaceContext();
        XPath xPath = XPathHelper.createNewXPath((XPathFactory)this.m_aXPathConfig.getXPathFactory(), (XPathVariableResolver)this.m_aXPathConfig.getXPathVariableResolver(), (XPathFunctionResolver)this.m_aXPathConfig.getXPathFunctionResolver(), (NamespaceContext)mapBasedNamespaceContext);
        if ("net.sf.saxon.xpath.XPathEvaluator".equals(xPath.getClass().getName())) {
            XPathEvaluator xPathEvaluator = (XPathEvaluator)xPath;
            xPathEvaluator.setNamespaceContext((NamespaceContext)new SaxonNamespaceContext(mapBasedNamespaceContext));
            Function<Configuration, ErrorReporter> function = configuration -> {
                IPSErrorHandler iPSErrorHandler = this.getErrorHandler();
                return xmlProcessingError -> {
                    SimpleLocation simpleLocation = xmlProcessingError.getLocation() == null ? null : new SimpleLocation(xmlProcessingError.getLocation().getSystemId(), xmlProcessingError.getLocation().getLineNumber(), xmlProcessingError.getLocation().getColumnNumber());
                    iPSErrorHandler.handleError((IError)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builder().setErrorLevel((IErrorLevel)(xmlProcessingError.isWarning() ? EErrorLevel.WARN : EErrorLevel.ERROR))).setErrorID(xmlProcessingError.getErrorCode() != null ? xmlProcessingError.getErrorCode().toString() : null)).setErrorLocation((ILocation)simpleLocation)).setErrorText(xmlProcessingError.getMessage())).setLinkedException(xmlProcessingError.getCause())).build());
                };
            };
            xPathEvaluator.getConfiguration().setErrorReporterFactory(function);
        }
        return xPath;
    }

    @Nonnull
    public PSXPathBoundSchema bind() throws SchematronBindException {
        Object object;
        Iterator iterator;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Binding pure Schematron");
        }
        if (this.m_aBoundPatterns != null) {
            throw new IllegalStateException("bind must only be called once!");
        }
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        PSXPathVariables pSXPathVariables = new PSXPathVariables();
        if (pSSchema.hasAnyLet()) {
            iterator = pSSchema.getAllLetsAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (!pSXPathVariables.add((Map.Entry<String, String>)object).isUnchanged()) continue;
                this.error(pSSchema, "Duplicate <let> with name '" + (String)object.getKey() + "' in global <schema>");
            }
        }
        if (pSPhase != null) {
            iterator = pSPhase.getAllLetsAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (!pSXPathVariables.add((Map.Entry<String, String>)object).isUnchanged()) continue;
                this.error(pSSchema, "Duplicate <let> with name '" + (String)object.getKey() + "' in <phase> with name '" + this.getPhaseID() + "'");
            }
        }
        if ((object = this._createBoundDiagnostics((XPath)((Object)(iterator = this._createXPathContext())), pSXPathVariables)) == null) {
            throw new SchematronBindException("Failed to precompile the diagnostics of the supplied schema. Check the " + (this.isDefaultErrorHandler() ? "log output" : "error listener") + " for XPath errors!");
        }
        this.m_aBoundPatterns = this._createBoundPatterns((XPath)((Object)iterator), (ICommonsMap<String, PSXPathBoundDiagnostic>)object, pSXPathVariables);
        if (this.m_aBoundPatterns == null) {
            throw new SchematronBindException("Failed to precompile the supplied schema.");
        }
        return this;
    }

    @Nullable
    public XPathVariableResolver getXPathVariableResolver() {
        return this.m_aXPathConfig.getXPathVariableResolver();
    }

    @Nullable
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.m_aXPathConfig.getXPathFunctionResolver();
    }

    @Override
    @Nonnull
    public String getValidationContext(@Nonnull String string) {
        if (string.startsWith("/")) {
            return string;
        }
        return "//" + string;
    }

    @Override
    public void validate(@Nonnull Node node, @Nullable String string, @Nonnull IPSValidationHandler iPSValidationHandler) throws SchematronValidationException {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)iPSValidationHandler, (String)"ValidationHandler");
        if (this.m_aBoundPatterns == null) {
            throw new IllegalStateException("bind was never called!");
        }
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        iPSValidationHandler.onStart(pSSchema, pSPhase, string);
        for (PSXPathBoundPattern pSXPathBoundPattern : this.m_aBoundPatterns) {
            PSPattern pSPattern = pSXPathBoundPattern.getPattern();
            iPSValidationHandler.onPattern(pSPattern);
            for (PSXPathBoundRule pSXPathBoundRule : pSXPathBoundPattern.getAllBoundRules()) {
                PSRule pSRule = pSXPathBoundRule.getRule();
                NodeList nodeList = null;
                try {
                    nodeList = XPathEvaluationHelper.evaluateAsNodeList(pSXPathBoundRule.getBoundRuleContext(), node, string);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to evaluate XPath expression to a nodeset: '" + pSXPathBoundRule.getRuleContext() + "'", xPathExpressionException.getCause() != null ? xPathExpressionException.getCause() : xPathExpressionException);
                    continue;
                }
                iPSValidationHandler.onRuleStart(pSRule, nodeList);
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    iPSValidationHandler.onFiredRule(pSRule, pSXPathBoundRule.getRuleContext(), i, n);
                    for (PSXPathBoundAssertReport pSXPathBoundAssertReport : pSXPathBoundRule.getAllBoundAssertReports()) {
                        PSAssertReport pSAssertReport = pSXPathBoundAssertReport.getAssertReport();
                        boolean bl = pSAssertReport.isAssert();
                        XPathExpression xPathExpression = pSXPathBoundAssertReport.getBoundTestExpression();
                        Node node2 = nodeList.item(i);
                        try {
                            boolean bl2 = XPathEvaluationHelper.evaluateAsBoolean(xPathExpression, node2, string);
                            if (!(bl ? !bl2 && iPSValidationHandler.onFailedAssert(pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport).isBreak() : bl2 && iPSValidationHandler.onSuccessfulReport(pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport).isBreak())) continue;
                            return;
                        }
                        catch (XPathExpressionException xPathExpressionException) {
                            this.error(pSRule, "Failed to evaluate XPath expression to a boolean: '" + pSXPathBoundAssertReport.getTestExpression() + "'", xPathExpressionException.getCause() != null ? xPathExpressionException.getCause() : xPathExpressionException);
                        }
                    }
                }
            }
        }
        iPSValidationHandler.onEnd(pSSchema, pSPhase);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("boundPatterns", this.m_aBoundPatterns).getToString();
    }
}

