/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.validation.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.state.EContinue;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSDiagnostics;
import com.helger.schematron.pure.model.PSDir;
import com.helger.schematron.pure.model.PSEmph;
import com.helger.schematron.pure.model.PSName;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.model.PSSpan;
import com.helger.schematron.pure.model.PSTitle;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.validation.SchematronValidationException;
import com.helger.schematron.pure.xpath.XPathEvaluationHelper;
import com.helger.schematron.svrl.jaxb.ActivePattern;
import com.helger.schematron.svrl.jaxb.DiagnosticReference;
import com.helger.schematron.svrl.jaxb.FailedAssert;
import com.helger.schematron.svrl.jaxb.FiredRule;
import com.helger.schematron.svrl.jaxb.NsPrefixInAttributeValues;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.svrl.jaxb.SuccessfulReport;
import com.helger.schematron.svrl.jaxb.Text;
import com.helger.xml.XMLHelper;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@NotThreadSafe
public class PSXPathValidationHandlerSVRL
implements IPSValidationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSXPathValidationHandlerSVRL.class);
    private final IPSErrorHandler m_aErrorHandler;
    private SchematronOutputType m_aSchematronOutput;
    private PSSchema m_aSchema;
    private MapBasedNamespaceContext m_aNSContext;
    private String m_sBaseURI;

    public PSXPathValidationHandlerSVRL(@Nonnull IPSErrorHandler iPSErrorHandler) {
        ValueEnforcer.notNull((Object)iPSErrorHandler, (String)"ErrorHandler");
        this.m_aErrorHandler = iPSErrorHandler;
    }

    @Nonnull
    public final IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    private void _warn(@Nonnull IPSElement iPSElement, @Nonnull String string) {
        if (this.m_aSchema == null) {
            throw new IllegalStateException("No schema is present!");
        }
        this.getErrorHandler().handleError((IError)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorLocation((ILocation)new SimpleLocation(this.m_aSchema.getResource().getPath()))).errorFieldName(IPSErrorHandler.getErrorFieldName(iPSElement))).errorText(string)).build());
    }

    private void _error(@Nonnull IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        if (this.m_aSchema == null) {
            throw new IllegalStateException("No schema is present!");
        }
        this.getErrorHandler().handleError((IError)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorLocation((ILocation)new SimpleLocation(this.m_aSchema.getResource().getPath()))).errorFieldName(IPSErrorHandler.getErrorFieldName(iPSElement))).errorText(string)).linkedException(throwable)).build());
    }

    @Nullable
    private static String _getTitleAsString(@Nullable PSTitle pSTitle) throws SchematronValidationException {
        if (pSTitle == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : pSTitle.getAllContentElements()) {
            if (e instanceof String) {
                stringBuilder.append((String)e);
                continue;
            }
            if (e instanceof PSDir) {
                stringBuilder.append(((PSDir)e).getAsText());
                continue;
            }
            throw new SchematronValidationException("Unsupported title content element: " + e);
        }
        return stringBuilder.toString();
    }

    @Override
    public void onStart(@Nonnull PSSchema pSSchema, @Nullable PSPhase pSPhase, @Nullable String string) throws SchematronValidationException {
        SchematronOutputType schematronOutputType = new SchematronOutputType();
        if (pSPhase != null) {
            schematronOutputType.setPhase(pSPhase.getID());
        }
        schematronOutputType.setSchemaVersion(pSSchema.getSchemaVersion());
        schematronOutputType.setTitle(PSXPathValidationHandlerSVRL._getTitleAsString(pSSchema.getTitle()));
        this.m_aSchematronOutput = schematronOutputType;
        this.m_aSchema = pSSchema;
        this.m_aNSContext = pSSchema.getAsNamespaceContext();
        this.m_sBaseURI = string;
        for (Map.Entry entry : this.m_aNSContext.getPrefixToNamespaceURIMap().entrySet()) {
            NsPrefixInAttributeValues nsPrefixInAttributeValues = new NsPrefixInAttributeValues();
            nsPrefixInAttributeValues.setPrefix((String)entry.getKey());
            nsPrefixInAttributeValues.setUri((String)entry.getValue());
            schematronOutputType.getNsPrefixInAttributeValues().add(nsPrefixInAttributeValues);
        }
    }

    @Override
    public void onPattern(@Nonnull PSPattern pSPattern) {
        ActivePattern activePattern = new ActivePattern();
        activePattern.setId(pSPattern.getID());
        this.m_aSchematronOutput.getActivePatternAndFiredRuleAndFailedAssert().add(activePattern);
    }

    @Override
    public void onFiredRule(@Nonnull PSRule pSRule, @Nonnull String string, @Nonnull int n, @Nonnull int n2) {
        PSRichGroup pSRichGroup;
        FiredRule firedRule = new FiredRule();
        firedRule.setContext(string);
        firedRule.setFlag(pSRule.getFlag());
        firedRule.setId(pSRule.getID());
        if (pSRule.hasLinkable()) {
            firedRule.setRole(pSRule.getLinkable().getRole());
        }
        if ((pSRichGroup = pSRule.getRich()) != null) {
            firedRule.setLang(pSRichGroup.getXmlLang());
            if (pSRichGroup.hasXmlSpace()) {
                firedRule.setSpace(pSRichGroup.getXmlSpace().getID());
            }
            firedRule.setIcon(pSRichGroup.getIcon());
            firedRule.setSee(pSRichGroup.getSee());
            firedRule.setFpi(pSRichGroup.getFPI());
        }
        this.m_aSchematronOutput.getActivePatternAndFiredRuleAndFailedAssert().add(firedRule);
    }

    @Nonnull
    private Text _getErrorText(@Nonnull List<PSXPathBoundElement> list, @Nonnull Node node) throws SchematronValidationException {
        StringBuilder stringBuilder = new StringBuilder();
        for (PSXPathBoundElement pSXPathBoundElement : list) {
            IPSClonableElement<PSName> iPSClonableElement;
            Object object = pSXPathBoundElement.getElement();
            if (object instanceof String) {
                stringBuilder.append((String)object);
                continue;
            }
            if (object instanceof PSName) {
                iPSClonableElement = (PSName)object;
                if (((PSName)iPSClonableElement).hasPath()) {
                    try {
                        stringBuilder.append(XPathEvaluationHelper.evaluateAsString(pSXPathBoundElement.getBoundExpression(), node, this.m_sBaseURI));
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this._error(iPSClonableElement, "Failed to evaluate XPath expression to a string: '" + pSXPathBoundElement.getExpression() + "'", xPathExpressionException.getCause() != null ? xPathExpressionException.getCause() : xPathExpressionException);
                        stringBuilder.append(((PSName)iPSClonableElement).getPath());
                    }
                    continue;
                }
                stringBuilder.append(node.getNodeName());
                continue;
            }
            if (object instanceof PSValueOf) {
                iPSClonableElement = (PSValueOf)object;
                try {
                    stringBuilder.append(XPathEvaluationHelper.evaluateAsString(pSXPathBoundElement.getBoundExpression(), node, this.m_sBaseURI));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this._error(iPSClonableElement, "Failed to evaluate XPath expression to a string: '" + pSXPathBoundElement.getExpression() + "'", xPathExpressionException);
                    stringBuilder.append(((PSValueOf)iPSClonableElement).getSelect());
                }
                continue;
            }
            if (object instanceof PSEmph) {
                stringBuilder.append(((PSEmph)object).getAsText());
                continue;
            }
            if (object instanceof PSDir) {
                stringBuilder.append(((PSDir)object).getAsText());
                continue;
            }
            if (object instanceof PSSpan) {
                stringBuilder.append(((PSSpan)object).getAsText());
                continue;
            }
            throw new SchematronValidationException("Unsupported assert/report content element: " + object);
        }
        Text text = new Text();
        text.addContent((Object)stringBuilder.toString());
        return text;
    }

    private void _handleDiagnosticReferences(@Nullable List<String> list, @Nonnull List<? super DiagnosticReference> list2, @Nonnull PSXPathBoundAssertReport pSXPathBoundAssertReport, @Nonnull Node node) throws SchematronValidationException {
        if (CollectionHelper.isNotEmpty(list)) {
            if (this.m_aSchema.hasDiagnostics()) {
                PSDiagnostics pSDiagnostics = this.m_aSchema.getDiagnostics();
                for (String string : list) {
                    PSXPathBoundDiagnostic pSXPathBoundDiagnostic = pSXPathBoundAssertReport.getBoundDiagnosticOfID(string);
                    if (pSXPathBoundDiagnostic == null) {
                        this._warn(pSDiagnostics, "Failed to resolve diagnostics with ID '" + string + "'");
                        continue;
                    }
                    DiagnosticReference diagnosticReference = new DiagnosticReference();
                    diagnosticReference.setDiagnostic(string);
                    PSRichGroup pSRichGroup = pSXPathBoundDiagnostic.getDiagnostic().getRich();
                    if (pSRichGroup != null) {
                        diagnosticReference.setLang(pSRichGroup.getXmlLang());
                        if (pSRichGroup.hasXmlSpace()) {
                            diagnosticReference.setSpace(pSRichGroup.getXmlSpace().getID());
                        }
                        diagnosticReference.setIcon(pSRichGroup.getIcon());
                        diagnosticReference.setSee(pSRichGroup.getSee());
                        diagnosticReference.setFpi(pSRichGroup.getFPI());
                    }
                    diagnosticReference.getContent().add(this._getErrorText((List<PSXPathBoundElement>)pSXPathBoundDiagnostic.getAllBoundContentElements(), node));
                    list2.add((DiagnosticReference)diagnosticReference);
                }
            } else {
                this._warn(this.m_aSchema, "Failed to resolve diagnostic because schema has no diagnostics");
            }
        }
    }

    @Nonnull
    private String _getPathToNode(@Nonnull Node node) {
        String string = XMLHelper.pathToNodeBuilder().node(node).separator("/").excludeDocumentNode().oneBasedIndex().forceUseIndex(false).trailingSeparator(false).compareIncludingNamespaceURI(true).namespaceContext((NamespaceContext)this.m_aNSContext).build();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Converted Node to path '" + string + "'");
        }
        return string;
    }

    @Override
    @Nonnull
    public EContinue onFailedAssert(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, int n, @Nullable Object object) throws SchematronValidationException {
        if (!(object instanceof PSXPathBoundAssertReport)) {
            throw new SchematronValidationException("The passed context must be an XPath object but is a " + object);
        }
        PSXPathBoundAssertReport pSXPathBoundAssertReport = (PSXPathBoundAssertReport)object;
        FailedAssert failedAssert = new FailedAssert();
        failedAssert.setFlag(pSAssertReport.getFlag());
        failedAssert.setId(pSAssertReport.getID());
        failedAssert.setLocation(this._getPathToNode(node));
        if (pSAssertReport.hasLinkable()) {
            failedAssert.setRole(pSAssertReport.getLinkable().getRole());
        }
        failedAssert.setTest(string);
        failedAssert.getDiagnosticReferenceOrPropertyReferenceOrText().add(this._getErrorText((List<PSXPathBoundElement>)pSXPathBoundAssertReport.getAllBoundContentElements(), node));
        this._handleDiagnosticReferences((List<String>)pSAssertReport.getAllDiagnostics(), failedAssert.getDiagnosticReferenceOrPropertyReferenceOrText(), pSXPathBoundAssertReport, node);
        this.m_aSchematronOutput.addActivePatternAndFiredRuleAndFailedAssert((Object)failedAssert);
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EContinue onSuccessfulReport(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, int n, @Nullable Object object) throws SchematronValidationException {
        if (!(object instanceof PSXPathBoundAssertReport)) {
            throw new SchematronValidationException("The passed context must be an XPath object but is a " + object);
        }
        PSXPathBoundAssertReport pSXPathBoundAssertReport = (PSXPathBoundAssertReport)object;
        SuccessfulReport successfulReport = new SuccessfulReport();
        successfulReport.setFlag(pSAssertReport.getFlag());
        successfulReport.setId(pSAssertReport.getID());
        successfulReport.setLocation(this._getPathToNode(node));
        if (pSAssertReport.hasLinkable()) {
            successfulReport.setRole(pSAssertReport.getLinkable().getRole());
        }
        successfulReport.setTest(string);
        successfulReport.getDiagnosticReferenceOrPropertyReferenceOrText().add(this._getErrorText((List<PSXPathBoundElement>)pSXPathBoundAssertReport.getAllBoundContentElements(), node));
        this._handleDiagnosticReferences((List<String>)pSAssertReport.getAllDiagnostics(), successfulReport.getDiagnosticReferenceOrPropertyReferenceOrText(), pSXPathBoundAssertReport, node);
        this.m_aSchematronOutput.addActivePatternAndFiredRuleAndFailedAssert((Object)successfulReport);
        return EContinue.CONTINUE;
    }

    @Nullable
    public SchematronOutputType getSVRL() {
        return this.m_aSchematronOutput;
    }
}

