/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.xpath;

import com.helger.commons.lang.GenericReflection;
import com.helger.xml.XMLHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class XPathEvaluationHelper {
    private XPathEvaluationHelper() {
    }

    @Nullable
    public static <T> T evaluate(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nonnull QName qName, @Nullable String string) throws XPathExpressionException {
        Object object;
        Node node2 = node;
        if (string != null && "net.sf.saxon.xpath.XPathExpressionImpl".equals(xPathExpression.getClass().getName())) {
            object = (XPathExpressionImpl)xPathExpression;
            node2 = new DocumentWrapper((Node)XMLHelper.getOwnerDocument((Node)node), string, object.getConfiguration()).wrap(node);
        }
        object = xPathExpression.evaluate(node2, qName);
        return (T)GenericReflection.uncheckedCast((Object)object);
    }

    @Nullable
    public static Boolean evaluateAsBooleanObj(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (Boolean)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.BOOLEAN, string);
    }

    public static boolean evaluateAsBoolean(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        Boolean bl = XPathEvaluationHelper.evaluateAsBooleanObj(xPathExpression, node, string);
        if (bl == null) {
            throw new XPathExpressionException("Failed to evaluate the XPath expression as boolean");
        }
        return bl;
    }

    @Nullable
    public static Node evaluateAsNode(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (Node)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.NODE, string);
    }

    @Nullable
    public static NodeList evaluateAsNodeList(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (NodeList)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.NODESET, string);
    }

    @Nullable
    public static Double evaluateAsNumber(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (Double)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.NUMBER, string);
    }

    @Nullable
    public static String evaluateAsString(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (String)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.STRING, string);
    }
}

