/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignAttributes;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSExtends
implements IPSElement,
IPSHasForeignAttributes {
    private String m_sRule;
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText((String)this.m_sRule)) {
            iPSErrorHandler.error(this, "<extends> has no 'rule'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText((String)this.m_sRule)) {
            iPSErrorHandler.error(this, "<extends> has no 'rule'");
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    public void setRule(@Nullable String string) {
        this.m_sRule = string;
    }

    @Nullable
    public String getRule() {
        return this.m_sRule;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "extends");
        microElement.setAttribute("rule", this.m_sRule);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("rule", (Object)this.m_sRule).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

