/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.testfiles;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.file.FileSystemRecursiveIterator;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.testfiles.SchematronTestFile;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.File;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchematronTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronTestHelper.class);
    private static final ICommonsList<SchematronTestFile> SCH = SchematronTestHelper._readDirIndex((IReadableResource)new ClassPathResource("external/test-sch/dirindex.xml"));
    private static final ICommonsList<SchematronTestFile> SVRL = SchematronTestHelper._readDirIndex((IReadableResource)new ClassPathResource("external/test-svrl/dirindex.xml"));
    private static final ICommonsList<SchematronTestFile> XML = SchematronTestHelper._readDirIndex((IReadableResource)new ClassPathResource("external/test-xml/dirindex.xml"));

    @Nonnull
    private static ICommonsList<SchematronTestFile> _readDirIndex(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.isTrue((boolean)iReadableResource.exists(), () -> "Resource " + String.valueOf(iReadableResource) + " does not exist!");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource);
        if (iMicroDocument == null) {
            throw new IllegalArgumentException("Failed to open/parse " + String.valueOf(iReadableResource) + " as XML");
        }
        String string = null;
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements()) {
            if (iMicroElement.getTagName().equals("directory")) {
                string = "external/" + iMicroElement.getAttributeValue("basename");
                continue;
            }
            if (iMicroElement.getTagName().equals("file")) {
                commonsArrayList.add((Object)new SchematronTestFile(string, (IReadableResource)new ClassPathResource("external/" + iMicroElement.getAttributeValue("name")), iMicroElement.getAttributeValue("basename")));
                continue;
            }
            throw new IllegalArgumentException("Cannot handle " + String.valueOf(iMicroElement));
        }
        return commonsArrayList;
    }

    private SchematronTestHelper() {
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllValidSchematronFiles() {
        return SCH.getAllMapped(schematronTestFile -> !schematronTestFile.getFileBaseName().startsWith("invalid") && !schematronTestFile.getParentDirBaseName().endsWith("include"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllInvalidSchematronFiles() {
        return SCH.getAllMapped(schematronTestFile -> schematronTestFile.getFileBaseName().startsWith("invalid") && !schematronTestFile.getParentDirBaseName().endsWith("include"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllValidSVRLFiles() {
        return SVRL.getAllMapped(schematronTestFile -> !schematronTestFile.getFileBaseName().startsWith("invalid"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllInvalidSVRLFiles() {
        return SVRL.getAllMapped(schematronTestFile -> schematronTestFile.getFileBaseName().startsWith("invalid"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllValidXMLFiles() {
        return XML.getAllMapped(schematronTestFile -> !schematronTestFile.getFileBaseName().startsWith("invalid"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllInvalidXMLFiles() {
        return XML.getAllMapped(schematronTestFile -> schematronTestFile.getFileBaseName().startsWith("invalid"), SchematronTestFile::getResource);
    }

    private static /* synthetic */ void lambda$_readDirIndex$1(String string) {
        LOGGER.info(string);
        if (new File(string).isDirectory()) {
            FileSystemRecursiveIterator fileSystemRecursiveIterator = new FileSystemRecursiveIterator(new File(string));
            fileSystemRecursiveIterator.forEach(file -> LOGGER.info(StringHelper.getRepeated((String)"  ", (int)fileSystemRecursiveIterator.getLevel()) + String.valueOf(file)));
        }
    }
}

