<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<xsl:stylesheet xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:can="urn:oasis:names:specification:ubl:schema:xsd:ContractAwardNotice-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:cn="urn:oasis:names:specification:ubl:schema:xsd:ContractNotice-2" xmlns:efac="http://data.europa.eu/p27/eforms-ubl-extension-aggregate-components/1" xmlns:efbc="http://data.europa.eu/p27/eforms-ubl-extension-basic-components/1" xmlns:efext="http://data.europa.eu/p27/eforms-ubl-extensions/1" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:pin="urn:oasis:names:specification:ubl:schema:xsd:PriorInformationNotice-2" xmlns:saxon="http://saxon.sf.net/" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
<!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->

<xsl:param name="archiveDirParameter" />
  <xsl:param name="archiveNameParameter" />
  <xsl:param name="fileNameParameter" />
  <xsl:param name="fileDirParameter" />
  <xsl:variable name="document-uri">
    <xsl:value-of select="document-uri(/)" />
  </xsl:variable>

<!--PHASES-->


<!--PROLOG-->
<xsl:output indent="yes" method="xml" omit-xml-declaration="no" standalone="yes" />

<!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
    <xsl:apply-templates mode="schematron-get-full-path" select="." />
  </xsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
    <xsl:apply-templates mode="schematron-get-full-path" select="parent::*" />
    <xsl:text>/</xsl:text>
    <xsl:choose>
      <xsl:when test="namespace-uri()=''">
        <xsl:value-of select="name()" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>*:</xsl:text>
        <xsl:value-of select="local-name()" />
        <xsl:text>[namespace-uri()='</xsl:text>
        <xsl:value-of select="namespace-uri()" />
        <xsl:text>']</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])" />
    <xsl:text>[</xsl:text>
    <xsl:value-of select="1+ $preceding" />
    <xsl:text>]</xsl:text>
  </xsl:template>
  <xsl:template match="@*" mode="schematron-get-full-path">
    <xsl:apply-templates mode="schematron-get-full-path" select="parent::*" />
    <xsl:text>/</xsl:text>
    <xsl:choose>
      <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()" />
</xsl:when>
      <xsl:otherwise>
        <xsl:text>@*[local-name()='</xsl:text>
        <xsl:value-of select="local-name()" />
        <xsl:text>' and namespace-uri()='</xsl:text>
        <xsl:value-of select="namespace-uri()" />
        <xsl:text>']</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
    <xsl:for-each select="ancestor-or-self::*">
      <xsl:text>/</xsl:text>
      <xsl:value-of select="name(.)" />
      <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
        <xsl:text>[</xsl:text>
        <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1" />
        <xsl:text>]</xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:if test="not(self::*)">
      <xsl:text />/@<xsl:value-of select="name(.)" />
    </xsl:if>
  </xsl:template>
<!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->

<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
    <xsl:for-each select="ancestor-or-self::*">
      <xsl:text>/</xsl:text>
      <xsl:value-of select="name(.)" />
      <xsl:if test="parent::*">
        <xsl:text>[</xsl:text>
        <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1" />
        <xsl:text>]</xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:if test="not(self::*)">
      <xsl:text />/@<xsl:value-of select="name(.)" />
    </xsl:if>
  </xsl:template>

<!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path" />
  <xsl:template match="text()" mode="generate-id-from-path">
    <xsl:apply-templates mode="generate-id-from-path" select="parent::*" />
    <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')" />
  </xsl:template>
  <xsl:template match="comment()" mode="generate-id-from-path">
    <xsl:apply-templates mode="generate-id-from-path" select="parent::*" />
    <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')" />
  </xsl:template>
  <xsl:template match="processing-instruction()" mode="generate-id-from-path">
    <xsl:apply-templates mode="generate-id-from-path" select="parent::*" />
    <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')" />
  </xsl:template>
  <xsl:template match="@*" mode="generate-id-from-path">
    <xsl:apply-templates mode="generate-id-from-path" select="parent::*" />
    <xsl:value-of select="concat('.@', name())" />
  </xsl:template>
  <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
    <xsl:apply-templates mode="generate-id-from-path" select="parent::*" />
    <xsl:text>.</xsl:text>
    <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')" />
  </xsl:template>

<!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
  <xsl:template match="*" mode="generate-id-2" priority="2">
    <xsl:text>U</xsl:text>
    <xsl:number count="*" level="multiple" />
  </xsl:template>
  <xsl:template match="node()" mode="generate-id-2">
    <xsl:text>U.</xsl:text>
    <xsl:number count="*" level="multiple" />
    <xsl:text>n</xsl:text>
    <xsl:number count="node()" />
  </xsl:template>
  <xsl:template match="@*" mode="generate-id-2">
    <xsl:text>U.</xsl:text>
    <xsl:number count="*" level="multiple" />
    <xsl:text>_</xsl:text>
    <xsl:value-of select="string-length(local-name(.))" />
    <xsl:text>_</xsl:text>
    <xsl:value-of select="translate(name(),':','.')" />
  </xsl:template>
<!--Strip characters-->  <xsl:template match="text()" priority="-1" />

<!--SCHEMA SETUP-->
<xsl:template match="/">
    <svrl:schematron-output schemaVersion="" title="eForms schematron rules">
      <xsl:comment>
        <xsl:value-of select="$archiveDirParameter" />   
		 <xsl:value-of select="$archiveNameParameter" />  
		 <xsl:value-of select="$fileNameParameter" />  
		 <xsl:value-of select="$fileDirParameter" />
      </xsl:comment>
      <svrl:ns-prefix-in-attribute-values prefix="xs" uri="http://www.w3.org/2001/XMLSchema" />
      <svrl:ns-prefix-in-attribute-values prefix="sch" uri="http://purl.oclc.org/dsdl/schematron" />
      <svrl:ns-prefix-in-attribute-values prefix="cbc" uri="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" />
      <svrl:ns-prefix-in-attribute-values prefix="cac" uri="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" />
      <svrl:ns-prefix-in-attribute-values prefix="ext" uri="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" />
      <svrl:ns-prefix-in-attribute-values prefix="efac" uri="http://data.europa.eu/p27/eforms-ubl-extension-aggregate-components/1" />
      <svrl:ns-prefix-in-attribute-values prefix="efext" uri="http://data.europa.eu/p27/eforms-ubl-extensions/1" />
      <svrl:ns-prefix-in-attribute-values prefix="efbc" uri="http://data.europa.eu/p27/eforms-ubl-extension-basic-components/1" />
      <svrl:ns-prefix-in-attribute-values prefix="can" uri="urn:oasis:names:specification:ubl:schema:xsd:ContractAwardNotice-2" />
      <svrl:ns-prefix-in-attribute-values prefix="cn" uri="urn:oasis:names:specification:ubl:schema:xsd:ContractNotice-2" />
      <svrl:ns-prefix-in-attribute-values prefix="pin" uri="urn:oasis:names:specification:ubl:schema:xsd:PriorInformationNotice-2" />
      <svrl:ns-prefix-in-attribute-values prefix="fn" uri="http://www.w3.org/2005/xpath-functions" />
      <svrl:active-pattern>
        <xsl:attribute name="document">
          <xsl:value-of select="document-uri(/)" />
        </xsl:attribute>
        <xsl:attribute name="id">EFORMS-validation-stage-1a</xsl:attribute>
        <xsl:attribute name="name">EFORMS-validation-stage-1a</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates mode="M14" select="/" />
      <svrl:active-pattern>
        <xsl:attribute name="document">
          <xsl:value-of select="document-uri(/)" />
        </xsl:attribute>
        <xsl:attribute name="id">EFORMS-validation-stage-1b</xsl:attribute>
        <xsl:attribute name="name">EFORMS-validation-stage-1b</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates mode="M15" select="/" />
      <svrl:active-pattern>
        <xsl:attribute name="document">
          <xsl:value-of select="document-uri(/)" />
        </xsl:attribute>
        <xsl:attribute name="id">EFORMS-validation-stage-2a</xsl:attribute>
        <xsl:attribute name="name">EFORMS-validation-stage-2a</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates mode="M16" select="/" />
      <svrl:active-pattern>
        <xsl:attribute name="document">
          <xsl:value-of select="document-uri(/)" />
        </xsl:attribute>
        <xsl:attribute name="id">EFORMS-validation-stage-2b</xsl:attribute>
        <xsl:attribute name="name">EFORMS-validation-stage-2b</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates mode="M17" select="/" />
      <svrl:active-pattern>
        <xsl:attribute name="document">
          <xsl:value-of select="document-uri(/)" />
        </xsl:attribute>
        <xsl:attribute name="id">EFORMS-validation-stage-3a</xsl:attribute>
        <xsl:attribute name="name">EFORMS-validation-stage-3a</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates mode="M18" select="/" />
      <svrl:active-pattern>
        <xsl:attribute name="document">
          <xsl:value-of select="document-uri(/)" />
        </xsl:attribute>
        <xsl:attribute name="id">EFORMS-validation-stage-3b</xsl:attribute>
        <xsl:attribute name="name">EFORMS-validation-stage-3b</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates mode="M19" select="/" />
      <svrl:active-pattern>
        <xsl:attribute name="document">
          <xsl:value-of select="document-uri(/)" />
        </xsl:attribute>
        <xsl:attribute name="id">EFORMS-validation-stage-4</xsl:attribute>
        <xsl:attribute name="name">EFORMS-validation-stage-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates mode="M20" select="/" />
      <svrl:active-pattern>
        <xsl:attribute name="document">
          <xsl:value-of select="document-uri(/)" />
        </xsl:attribute>
        <xsl:attribute name="id">EFORMS-validation-stage-5</xsl:attribute>
        <xsl:attribute name="name">EFORMS-validation-stage-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates mode="M21" select="/" />
    </svrl:schematron-output>
  </xsl:template>

<!--SCHEMATRON PATTERNS-->
<svrl:text>eForms schematron rules</svrl:text>
  <xsl:param name="noticeSubType" select="/*/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:NoticeSubType/cbc:SubTypeCode/text()" />

<!--PATTERN EFORMS-validation-stage-1a-->


	<!--RULE -->
<xsl:template match="/*" mode="M14" priority="1030">
    <svrl:fired-rule context="/*" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:NoticeSubType/cbc:SubTypeCode) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:NoticeSubType/cbc:SubTypeCode) > 0">
          <xsl:attribute name="id">P-0001</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0001
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="(cbc:NoticeTypeCode/text() = ('pin-buyer', 'brin-eeig', 'brin-ecs') and count(cac:ProcurementProjectLot) = 0) or (not(cbc:NoticeTypeCode/text() = ('pin-buyer', 'brin-eeig', 'brin-ecs')) and count(cac:ProcurementProjectLot) > 0)" />
      <xsl:otherwise>
        <svrl:failed-assert test="(cbc:NoticeTypeCode/text() = ('pin-buyer', 'brin-eeig', 'brin-ecs') and count(cac:ProcurementProjectLot) = 0) or (not(cbc:NoticeTypeCode/text() = ('pin-buyer', 'brin-eeig', 'brin-ecs')) and count(cac:ProcurementProjectLot) > 0)">
          <xsl:attribute name="id">P-0002</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0002
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cac:ProcurementProjectLot/cbc:ID" mode="M14" priority="1029">
    <svrl:fired-rule context="cac:ProcurementProjectLot/cbc:ID" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@schemeName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@schemeName">
          <xsl:attribute name="id">P-0004</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0004
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cac:ProcurementProjectLot/cbc:ID/@schemeName" mode="M14" priority="1028">
    <svrl:fired-rule context="cac:ProcurementProjectLot/cbc:ID/@schemeName" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="normalize-space(.) = ('Part', 'Lot', 'LotsGroup')" />
      <xsl:otherwise>
        <svrl:failed-assert test="normalize-space(.) = ('Part', 'Lot', 'LotsGroup')">
          <xsl:attribute name="id">P-0005</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0005
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:ActivityTypeCode" mode="M14" priority="1027">
    <svrl:fired-rule context="cbc:ActivityTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0006</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0006
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:AwardingCriterionTypeCode" mode="M14" priority="1026">
    <svrl:fired-rule context="cbc:AwardingCriterionTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0007</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0007
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:CalculationExpressionCode" mode="M14" priority="1025">
    <svrl:fired-rule context="cbc:CalculationExpressionCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0008</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0008
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:Code" mode="M14" priority="1024">
    <svrl:fired-rule context="cbc:Code" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0009</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0009
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:ContractingSystemTypeCode" mode="M14" priority="1023">
    <svrl:fired-rule context="cbc:ContractingSystemTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0010</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0010
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:CountrySubentityCode" mode="M14" priority="1022">
    <svrl:fired-rule context="cbc:CountrySubentityCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0011</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0011
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:CriterionTypeCode" mode="M14" priority="1021">
    <svrl:fired-rule context="cbc:CriterionTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0012</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0012
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:DescriptionCode" mode="M14" priority="1020">
    <svrl:fired-rule context="cbc:DescriptionCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0013</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0013
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:DocumentTypeCode" mode="M14" priority="1019">
    <svrl:fired-rule context="cbc:DocumentTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0014</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0014
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:ExecutionRequirementCode" mode="M14" priority="1018">
    <svrl:fired-rule context="cbc:ExecutionRequirementCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0015</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0015
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:FundingProgramCode" mode="M14" priority="1017">
    <svrl:fired-rule context="cbc:FundingProgramCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0016</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0016
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:GuaranteeTypeCode" mode="M14" priority="1016">
    <svrl:fired-rule context="cbc:GuaranteeTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0017</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0017
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:IndustryClassificationCode" mode="M14" priority="1015">
    <svrl:fired-rule context="cbc:IndustryClassificationCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0018</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0018
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:ItemClassificationCode" mode="M14" priority="1014">
    <svrl:fired-rule context="cbc:ItemClassificationCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0019</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0019
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:NoticeTypeCode" mode="M14" priority="1013">
    <svrl:fired-rule context="cbc:NoticeTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0020</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0020
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:PartPresentationCode" mode="M14" priority="1012">
    <svrl:fired-rule context="cbc:PartPresentationCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0021</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0021
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:PartyTypeCode" mode="M14" priority="1011">
    <svrl:fired-rule context="cbc:PartyTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0022</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0022
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:ProcedureCode" mode="M14" priority="1010">
    <svrl:fired-rule context="cbc:ProcedureCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0023</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0023
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:ProcessReasonCode" mode="M14" priority="1009">
    <svrl:fired-rule context="cbc:ProcessReasonCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0024</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0024
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:ProcurementTypeCode" mode="M14" priority="1008">
    <svrl:fired-rule context="cbc:ProcurementTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0025</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0025
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:RequiredCurriculaCode" mode="M14" priority="1007">
    <svrl:fired-rule context="cbc:RequiredCurriculaCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0026</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0026
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:SubcontractingConditionsCode" mode="M14" priority="1006">
    <svrl:fired-rule context="cbc:SubcontractingConditionsCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0027</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0027
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:SubmissionMethodCode" mode="M14" priority="1005">
    <svrl:fired-rule context="cbc:SubmissionMethodCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0028</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0028
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:TendererRequirementTypeCode" mode="M14" priority="1004">
    <svrl:fired-rule context="cbc:TendererRequirementTypeCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0029</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0029
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:TenderResultCode" mode="M14" priority="1003">
    <svrl:fired-rule context="cbc:TenderResultCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0030</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0030
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:VariantConstraintCode" mode="M14" priority="1002">
    <svrl:fired-rule context="cbc:VariantConstraintCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0031</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0031
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="cbc:ReasonCode" mode="M14" priority="1001">
    <svrl:fired-rule context="cbc:ReasonCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0032</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0032
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="efbc:StatisticsCode" mode="M14" priority="1000">
    <svrl:fired-rule context="efbc:StatisticsCode" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="@listName" />
      <xsl:otherwise>
        <svrl:failed-assert test="@listName">
          <xsl:attribute name="id">P-0033</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>
			rule|text|P-0033
		</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>
  <xsl:template match="text()" mode="M14" priority="-1" />
  <xsl:template match="@*|node()" mode="M14" priority="-2">
    <xsl:apply-templates mode="M14" select="@*|*" />
  </xsl:template>

<!--PATTERN EFORMS-validation-stage-1b-->


	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '1']" mode="M15" priority="1954">
    <svrl:fired-rule context="/*[$noticeSubType = '1']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '2']" mode="M15" priority="1953">
    <svrl:fired-rule context="/*[$noticeSubType = '2']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '3']" mode="M15" priority="1952">
    <svrl:fired-rule context="/*[$noticeSubType = '3']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '4']" mode="M15" priority="1951">
    <svrl:fired-rule context="/*[$noticeSubType = '4']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '5']" mode="M15" priority="1950">
    <svrl:fired-rule context="/*[$noticeSubType = '5']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '6']" mode="M15" priority="1949">
    <svrl:fired-rule context="/*[$noticeSubType = '6']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '7']" mode="M15" priority="1948">
    <svrl:fired-rule context="/*[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '8']" mode="M15" priority="1947">
    <svrl:fired-rule context="/*[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '9']" mode="M15" priority="1946">
    <svrl:fired-rule context="/*[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '10']" mode="M15" priority="1945">
    <svrl:fired-rule context="/*[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '11']" mode="M15" priority="1944">
    <svrl:fired-rule context="/*[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '12']" mode="M15" priority="1943">
    <svrl:fired-rule context="/*[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '13']" mode="M15" priority="1942">
    <svrl:fired-rule context="/*[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '14']" mode="M15" priority="1941">
    <svrl:fired-rule context="/*[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '15']" mode="M15" priority="1940">
    <svrl:fired-rule context="/*[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '16']" mode="M15" priority="1939">
    <svrl:fired-rule context="/*[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-ProcedureTerms-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTerms-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '17']" mode="M15" priority="1938">
    <svrl:fired-rule context="/*[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '18']" mode="M15" priority="1937">
    <svrl:fired-rule context="/*[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '19']" mode="M15" priority="1936">
    <svrl:fired-rule context="/*[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '20']" mode="M15" priority="1935">
    <svrl:fired-rule context="/*[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '21']" mode="M15" priority="1934">
    <svrl:fired-rule context="/*[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '22']" mode="M15" priority="1933">
    <svrl:fired-rule context="/*[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '23']" mode="M15" priority="1932">
    <svrl:fired-rule context="/*[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '24']" mode="M15" priority="1931">
    <svrl:fired-rule context="/*[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '25']" mode="M15" priority="1930">
    <svrl:fired-rule context="/*[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '26']" mode="M15" priority="1929">
    <svrl:fired-rule context="/*[$noticeSubType = '26']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '27']" mode="M15" priority="1928">
    <svrl:fired-rule context="/*[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '28']" mode="M15" priority="1927">
    <svrl:fired-rule context="/*[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '29']" mode="M15" priority="1926">
    <svrl:fired-rule context="/*[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '30']" mode="M15" priority="1925">
    <svrl:fired-rule context="/*[$noticeSubType = '30']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '31']" mode="M15" priority="1924">
    <svrl:fired-rule context="/*[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '32']" mode="M15" priority="1923">
    <svrl:fired-rule context="/*[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '33']" mode="M15" priority="1922">
    <svrl:fired-rule context="/*[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '34']" mode="M15" priority="1921">
    <svrl:fired-rule context="/*[$noticeSubType = '34']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '35']" mode="M15" priority="1920">
    <svrl:fired-rule context="/*[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '36']" mode="M15" priority="1919">
    <svrl:fired-rule context="/*[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '37']" mode="M15" priority="1918">
    <svrl:fired-rule context="/*[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '38']" mode="M15" priority="1917">
    <svrl:fired-rule context="/*[$noticeSubType = '38']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '39']" mode="M15" priority="1916">
    <svrl:fired-rule context="/*[$noticeSubType = '39']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = '40']" mode="M15" priority="1915">
    <svrl:fired-rule context="/*[$noticeSubType = '40']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = 'CEI']" mode="M15" priority="1914">
    <svrl:fired-rule context="/*[$noticeSubType = 'CEI']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = 'T01']" mode="M15" priority="1913">
    <svrl:fired-rule context="/*[$noticeSubType = 'T01']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = 'T02']" mode="M15" priority="1912">
    <svrl:fired-rule context="/*[$noticeSubType = 'T02']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) = 0">
          <xsl:attribute name="id">ND-GazetteReference-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) = 0">
          <xsl:attribute name="id">ND-BusinessParty-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) > 0">
          <xsl:attribute name="id">ND-ContractingParty-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) = 0">
          <xsl:attribute name="id">ND-SenderContact-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) = 0">
          <xsl:attribute name="id">ND-OperationType-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = 'X01']" mode="M15" priority="1911">
    <svrl:fired-rule context="/*[$noticeSubType = 'X01']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) > 0">
          <xsl:attribute name="id">ND-GazetteReference-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) > 0">
          <xsl:attribute name="id">ND-BusinessParty-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) = 0">
          <xsl:attribute name="id">ND-ContractingParty-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) = 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) > 0">
          <xsl:attribute name="id">ND-SenderContact-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) = 0">
          <xsl:attribute name="id">ND-ProcedureTerms-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTerms-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) > 0">
          <xsl:attribute name="id">ND-OperationType-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*[$noticeSubType = 'X02']" mode="M15" priority="1910">
    <svrl:fired-rule context="/*[$noticeSubType = 'X02']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalDocumentReference) > 0">
          <xsl:attribute name="id">ND-GazetteReference-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-GazetteReference-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:BusinessParty) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:BusinessParty) > 0">
          <xsl:attribute name="id">ND-BusinessParty-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessParty-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractingParty) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractingParty) = 0">
          <xsl:attribute name="id">ND-ContractingParty-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ContractingParty-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) = 0">
          <xsl:attribute name="id">ND-ProcedureProcurementScope-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureProcurementScope-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SenderParty/cac:Contact) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SenderParty/cac:Contact) > 0">
          <xsl:attribute name="id">ND-SenderContact-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SenderContact-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-ProcedureTenderingProcess-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTenderingProcess-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) = 0">
          <xsl:attribute name="id">ND-ProcedureTerms-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedureTerms-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:NoticePurpose) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:NoticePurpose) > 0">
          <xsl:attribute name="id">ND-OperationType-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OperationType-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-RootExtension-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-RootExtension-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:BusinessParty[$noticeSubType = 'X01']" mode="M15" priority="1909">
    <svrl:fired-rule context="/*/cac:BusinessParty[$noticeSubType = 'X01']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Contact) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Contact) = 0">
          <xsl:attribute name="id">ND-BusinessContact-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessContact-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PartyLegalEntity) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PartyLegalEntity) > 0">
          <xsl:attribute name="id">ND-LocalEntity-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LocalEntity-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostalAddress) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostalAddress) = 0">
          <xsl:attribute name="id">ND-BusinessAddress-X01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessAddress-X01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:BusinessParty[$noticeSubType = 'X02']" mode="M15" priority="1908">
    <svrl:fired-rule context="/*/cac:BusinessParty[$noticeSubType = 'X02']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PartyLegalEntity) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PartyLegalEntity) > 0">
          <xsl:attribute name="id">ND-LocalEntity-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LocalEntity-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostalAddress) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostalAddress) > 0">
          <xsl:attribute name="id">ND-BusinessAddress-X02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-BusinessAddress-X02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '1']" mode="M15" priority="1907">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '1']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '2']" mode="M15" priority="1906">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '2']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '3']" mode="M15" priority="1905">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '3']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '4']" mode="M15" priority="1904">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '4']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '5']" mode="M15" priority="1903">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '5']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '6']" mode="M15" priority="1902">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '6']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '7']" mode="M15" priority="1901">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '8']" mode="M15" priority="1900">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '9']" mode="M15" priority="1899">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '10']" mode="M15" priority="1898">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '11']" mode="M15" priority="1897">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '12']" mode="M15" priority="1896">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '13']" mode="M15" priority="1895">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '14']" mode="M15" priority="1894">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '15']" mode="M15" priority="1893">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '16']" mode="M15" priority="1892">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '17']" mode="M15" priority="1891">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '18']" mode="M15" priority="1890">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '19']" mode="M15" priority="1889">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '20']" mode="M15" priority="1888">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '21']" mode="M15" priority="1887">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '22']" mode="M15" priority="1886">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '23']" mode="M15" priority="1885">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '24']" mode="M15" priority="1884">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '25']" mode="M15" priority="1883">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '26']" mode="M15" priority="1882">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '26']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '27']" mode="M15" priority="1881">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '28']" mode="M15" priority="1880">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '29']" mode="M15" priority="1879">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '30']" mode="M15" priority="1878">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '30']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '31']" mode="M15" priority="1877">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '32']" mode="M15" priority="1876">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '33']" mode="M15" priority="1875">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '34']" mode="M15" priority="1874">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '34']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '35']" mode="M15" priority="1873">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '36']" mode="M15" priority="1872">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '37']" mode="M15" priority="1871">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '38']" mode="M15" priority="1870">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '38']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '39']" mode="M15" priority="1869">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '39']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = '40']" mode="M15" priority="1868">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = '40']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = 'CEI']" mode="M15" priority="1867">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = 'CEI']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = 'T01']" mode="M15" priority="1866">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = 'T01']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ContractingParty[$noticeSubType = 'T02']" mode="M15" priority="1865">
    <svrl:fired-rule context="/*/cac:ContractingParty[$noticeSubType = 'T02']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Party) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Party) > 0">
          <xsl:attribute name="id">ND-ServiceProvider-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ServiceProvider-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProject[$noticeSubType = 'T01']" mode="M15" priority="1864">
    <svrl:fired-rule context="/*/cac:ProcurementProject[$noticeSubType = 'T01']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RealizedLocation) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RealizedLocation) = 0">
          <xsl:attribute name="id">ND-ProcedurePlacePerformanceAdditionalInformation-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedurePlacePerformanceAdditionalInformation-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProject[$noticeSubType = 'T02']" mode="M15" priority="1863">
    <svrl:fired-rule context="/*/cac:ProcurementProject[$noticeSubType = 'T02']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RealizedLocation) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RealizedLocation) = 0">
          <xsl:attribute name="id">ND-ProcedurePlacePerformanceAdditionalInformation-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ProcedurePlacePerformanceAdditionalInformation-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '1']" mode="M15" priority="1862">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '1']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) = 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '2']" mode="M15" priority="1861">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '2']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) = 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '3']" mode="M15" priority="1860">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '3']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) = 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '4']" mode="M15" priority="1859">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '4']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) = 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '5']" mode="M15" priority="1858">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '5']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) = 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '6']" mode="M15" priority="1857">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '6']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) = 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '7']" mode="M15" priority="1856">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '8']" mode="M15" priority="1855">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '9']" mode="M15" priority="1854">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '10']" mode="M15" priority="1853">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '11']" mode="M15" priority="1852">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '12']" mode="M15" priority="1851">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '13']" mode="M15" priority="1850">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '14']" mode="M15" priority="1849">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '15']" mode="M15" priority="1848">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '16']" mode="M15" priority="1847">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '17']" mode="M15" priority="1846">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '18']" mode="M15" priority="1845">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '19']" mode="M15" priority="1844">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '20']" mode="M15" priority="1843">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '21']" mode="M15" priority="1842">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '22']" mode="M15" priority="1841">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '23']" mode="M15" priority="1840">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '24']" mode="M15" priority="1839">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '25']" mode="M15" priority="1838">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '26']" mode="M15" priority="1837">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '26']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '27']" mode="M15" priority="1836">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '28']" mode="M15" priority="1835">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '29']" mode="M15" priority="1834">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '30']" mode="M15" priority="1833">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '30']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '31']" mode="M15" priority="1832">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '32']" mode="M15" priority="1831">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '33']" mode="M15" priority="1830">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '34']" mode="M15" priority="1829">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '34']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '35']" mode="M15" priority="1828">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '36']" mode="M15" priority="1827">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '37']" mode="M15" priority="1826">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '38']" mode="M15" priority="1825">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '38']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '39']" mode="M15" priority="1824">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '39']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '40']" mode="M15" priority="1823">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = '40']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = 'CEI']" mode="M15" priority="1822">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = 'CEI']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = 'T01']" mode="M15" priority="1821">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = 'T01']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = 'T02']" mode="M15" priority="1820">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot'][$noticeSubType = 'T02']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotProcurementScope-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementScope-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcess-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcess-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingTerms) > 0">
          <xsl:attribute name="id">ND-LotTenderingTerms-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingTerms-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '1']" mode="M15" priority="1819">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '1']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotAdditionalClassification-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAdditionalClassification-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotMainClassification-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RealizedLocation) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RealizedLocation) = 0">
          <xsl:attribute name="id">ND-LotPlacePerformance-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPlacePerformance-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '2']" mode="M15" priority="1818">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '2']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotAdditionalClassification-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAdditionalClassification-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotMainClassification-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RealizedLocation) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RealizedLocation) = 0">
          <xsl:attribute name="id">ND-LotPlacePerformance-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPlacePerformance-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '3']" mode="M15" priority="1817">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '3']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotAdditionalClassification-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAdditionalClassification-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotMainClassification-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RealizedLocation) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RealizedLocation) = 0">
          <xsl:attribute name="id">ND-LotPlacePerformance-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPlacePerformance-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '4']" mode="M15" priority="1816">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '4']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotAdditionalClassification-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAdditionalClassification-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotMainClassification-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RealizedLocation) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RealizedLocation) = 0">
          <xsl:attribute name="id">ND-LotPlacePerformance-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPlacePerformance-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-4</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-4</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '5']" mode="M15" priority="1815">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '5']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotAdditionalClassification-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAdditionalClassification-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotMainClassification-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RealizedLocation) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RealizedLocation) = 0">
          <xsl:attribute name="id">ND-LotPlacePerformance-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPlacePerformance-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-5</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-5</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '6']" mode="M15" priority="1814">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '6']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AdditionalCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AdditionalCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotAdditionalClassification-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAdditionalClassification-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) = 0">
          <xsl:attribute name="id">ND-LotMainClassification-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RealizedLocation) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RealizedLocation) = 0">
          <xsl:attribute name="id">ND-LotPlacePerformance-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPlacePerformance-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-6</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-6</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '7']" mode="M15" priority="1813">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '8']" mode="M15" priority="1812">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '9']" mode="M15" priority="1811">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '10']" mode="M15" priority="1810">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '11']" mode="M15" priority="1809">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '12']" mode="M15" priority="1808">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '13']" mode="M15" priority="1807">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '14']" mode="M15" priority="1806">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '15']" mode="M15" priority="1805">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) > 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '16']" mode="M15" priority="1804">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '17']" mode="M15" priority="1803">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) > 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '18']" mode="M15" priority="1802">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) > 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '19']" mode="M15" priority="1801">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '20']" mode="M15" priority="1800">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '21']" mode="M15" priority="1799">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '22']" mode="M15" priority="1798">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '23']" mode="M15" priority="1797">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '24']" mode="M15" priority="1796">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '25']" mode="M15" priority="1795">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '26']" mode="M15" priority="1794">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '26']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '27']" mode="M15" priority="1793">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '28']" mode="M15" priority="1792">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '29']" mode="M15" priority="1791">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '30']" mode="M15" priority="1790">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '30']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '31']" mode="M15" priority="1789">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '32']" mode="M15" priority="1788">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '33']" mode="M15" priority="1787">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '34']" mode="M15" priority="1786">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '34']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '35']" mode="M15" priority="1785">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '36']" mode="M15" priority="1784">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '37']" mode="M15" priority="1783">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) = 0">
          <xsl:attribute name="id">ND-LotDuration-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '38']" mode="M15" priority="1782">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '38']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '39']" mode="M15" priority="1781">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '39']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '40']" mode="M15" priority="1780">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = '40']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = 'CEI']" mode="M15" priority="1779">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = 'CEI']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PlannedPeriod) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PlannedPeriod) > 0">
          <xsl:attribute name="id">ND-LotDuration-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotDuration-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = 'T01']" mode="M15" priority="1778">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = 'T01']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = 'T02']" mode="M15" priority="1777">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:ProcurementProject[$noticeSubType = 'T02']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExtension) = 0">
          <xsl:attribute name="id">ND-OptionsAndRenewals-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-OptionsAndRenewals-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:MainCommodityClassification) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:MainCommodityClassification) > 0">
          <xsl:attribute name="id">ND-LotMainClassification-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotMainClassification-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:RequestedTenderTotal) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:RequestedTenderTotal) = 0">
          <xsl:attribute name="id">ND-LotValueEstimate-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotValueEstimate-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '1']" mode="M15" priority="1776">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '1']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-1</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-1</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '2']" mode="M15" priority="1775">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '2']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-2</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-2</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '3']" mode="M15" priority="1774">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '3']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-3</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-3</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '7']" mode="M15" priority="1773">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '8']" mode="M15" priority="1772">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '9']" mode="M15" priority="1771">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '10']" mode="M15" priority="1770">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '11']" mode="M15" priority="1769">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '12']" mode="M15" priority="1768">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '13']" mode="M15" priority="1767">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '14']" mode="M15" priority="1766">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '15']" mode="M15" priority="1765">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '16']" mode="M15" priority="1764">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) > 0">
          <xsl:attribute name="id">ND-AuctionTerms-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '17']" mode="M15" priority="1763">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) > 0">
          <xsl:attribute name="id">ND-AuctionTerms-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '18']" mode="M15" priority="1762">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) > 0">
          <xsl:attribute name="id">ND-AuctionTerms-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '19']" mode="M15" priority="1761">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '22']" mode="M15" priority="1760">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) > 0">
          <xsl:attribute name="id">ND-AuctionTerms-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '23']" mode="M15" priority="1759">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '24']" mode="M15" priority="1758">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '25']" mode="M15" priority="1757">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '26']" mode="M15" priority="1756">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '26']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '27']" mode="M15" priority="1755">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '28']" mode="M15" priority="1754">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '29']" mode="M15" priority="1753">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) > 0">
          <xsl:attribute name="id">ND-AuctionTerms-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '30']" mode="M15" priority="1752">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '30']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) > 0">
          <xsl:attribute name="id">ND-AuctionTerms-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '31']" mode="M15" priority="1751">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) > 0">
          <xsl:attribute name="id">ND-AuctionTerms-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '32']" mode="M15" priority="1750">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '33']" mode="M15" priority="1749">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '34']" mode="M15" priority="1748">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '34']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '35']" mode="M15" priority="1747">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '36']" mode="M15" priority="1746">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '37']" mode="M15" priority="1745">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '38']" mode="M15" priority="1744">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '38']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:NoticeDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:NoticeDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotPreviousPlanning-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPreviousPlanning-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '39']" mode="M15" priority="1743">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '39']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:NoticeDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:NoticeDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotPreviousPlanning-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPreviousPlanning-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '40']" mode="M15" priority="1742">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = '40']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:NoticeDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:NoticeDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotPreviousPlanning-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPreviousPlanning-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = 'CEI']" mode="M15" priority="1741">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess[$noticeSubType = 'CEI']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AuctionTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AuctionTerms) = 0">
          <xsl:attribute name="id">ND-AuctionTerms-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AuctionTerms-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-SecondStage-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecondStage-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-FA-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-FA-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:NoticeDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:NoticeDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotPreviousPlanning-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotPreviousPlanning-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:OpenTenderEvent) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:OpenTenderEvent) = 0">
          <xsl:attribute name="id">ND-PublicOpening-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PublicOpening-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcessJustification) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcessJustification) = 0">
          <xsl:attribute name="id">ND-NonEsubmission-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonEsubmission-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-LotTenderingProcessExtension-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotTenderingProcessExtension-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '7']" mode="M15" priority="1740">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '8']" mode="M15" priority="1739">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) > 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '9']" mode="M15" priority="1738">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '10']" mode="M15" priority="1737">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) > 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '11']" mode="M15" priority="1736">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) > 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '12']" mode="M15" priority="1735">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) > 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '13']" mode="M15" priority="1734">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) > 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '14']" mode="M15" priority="1733">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) > 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '15']" mode="M15" priority="1732">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '16']" mode="M15" priority="1731">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '17']" mode="M15" priority="1730">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '18']" mode="M15" priority="1729">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '19']" mode="M15" priority="1728">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '20']" mode="M15" priority="1727">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '21']" mode="M15" priority="1726">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '22']" mode="M15" priority="1725">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '23']" mode="M15" priority="1724">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '24']" mode="M15" priority="1723">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '29']" mode="M15" priority="1722">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '30']" mode="M15" priority="1721">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '30']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '31']" mode="M15" priority="1720">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '32']" mode="M15" priority="1719">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '33']" mode="M15" priority="1718">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '34']" mode="M15" priority="1717">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '34']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '35']" mode="M15" priority="1716">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '36']" mode="M15" priority="1715">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '37']" mode="M15" priority="1714">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = 'CEI']" mode="M15" priority="1713">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingProcess/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = 'CEI']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:AnswerReceptionPeriod) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:AnswerReceptionPeriod) = 0">
          <xsl:attribute name="id">ND-PMCAnswersDeadline-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PMCAnswersDeadline-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:InterestExpressionReceptionPeriod) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:InterestExpressionReceptionPeriod) > 0">
          <xsl:attribute name="id">ND-InterestExpressionReceptionPeriod-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-InterestExpressionReceptionPeriod-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '7']" mode="M15" priority="1712">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '8']" mode="M15" priority="1711">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '9']" mode="M15" priority="1710">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EmploymentLegislationDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EmploymentLegislationDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotEmploymentLegislation-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotEmploymentLegislation-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EnvironmentalLegislationDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EnvironmentalLegislationDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotEnvironmentalLegislation-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotEnvironmentalLegislation-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FiscalLegislationDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FiscalLegislationDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotFiscalLegislation-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotFiscalLegislation-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '10']" mode="M15" priority="1709">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '11']" mode="M15" priority="1708">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '12']" mode="M15" priority="1707">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '13']" mode="M15" priority="1706">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '14']" mode="M15" priority="1705">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '15']" mode="M15" priority="1704">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '16']" mode="M15" priority="1703">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) > 0">
          <xsl:attribute name="id">ND-PostAwarProcess-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '17']" mode="M15" priority="1702">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) > 0">
          <xsl:attribute name="id">ND-PaymentTerms-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '18']" mode="M15" priority="1701">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) > 0">
          <xsl:attribute name="id">ND-SubcontractTerms-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) > 0">
          <xsl:attribute name="id">ND-PaymentTerms-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '19']" mode="M15" priority="1700">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '20']" mode="M15" priority="1699">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '21']" mode="M15" priority="1698">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '22']" mode="M15" priority="1697">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) > 0">
          <xsl:attribute name="id">ND-PaymentTerms-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) > 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '23']" mode="M15" priority="1696">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) > 0">
          <xsl:attribute name="id">ND-AwardingTerms-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '24']" mode="M15" priority="1695">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) > 0">
          <xsl:attribute name="id">ND-AwardingTerms-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '25']" mode="M15" priority="1694">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '26']" mode="M15" priority="1693">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '26']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '27']" mode="M15" priority="1692">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '28']" mode="M15" priority="1691">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '29']" mode="M15" priority="1690">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) > 0">
          <xsl:attribute name="id">ND-AwardingTerms-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '30']" mode="M15" priority="1689">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '30']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '31']" mode="M15" priority="1688">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) > 0">
          <xsl:attribute name="id">ND-AwardingTerms-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '32']" mode="M15" priority="1687">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) > 0">
          <xsl:attribute name="id">ND-AwardingTerms-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '33']" mode="M15" priority="1686">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '34']" mode="M15" priority="1685">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '34']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '35']" mode="M15" priority="1684">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '36']" mode="M15" priority="1683">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '37']" mode="M15" priority="1682">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '38']" mode="M15" priority="1681">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '38']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) = 0">
          <xsl:attribute name="id">ND-AwardingTerms-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-38</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-38</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '39']" mode="M15" priority="1680">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '39']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) = 0">
          <xsl:attribute name="id">ND-AwardingTerms-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-39</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-39</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '40']" mode="M15" priority="1679">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = '40']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) = 0">
          <xsl:attribute name="id">ND-AwardingTerms-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-40</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-40</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = 'CEI']" mode="M15" priority="1678">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = 'CEI']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) > 0">
          <xsl:attribute name="id">ND-SubcontractTerms-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) > 0">
          <xsl:attribute name="id">ND-LotReviewTerms-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) = 0">
          <xsl:attribute name="id">ND-AwardingTerms-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) > 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EmploymentLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EmploymentLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotEmploymentLegislation-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotEmploymentLegislation-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EnvironmentalLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EnvironmentalLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotEnvironmentalLegislation-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotEnvironmentalLegislation-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FiscalLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FiscalLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotFiscalLegislation-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotFiscalLegislation-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) > 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = 'T01']" mode="M15" priority="1677">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = 'T01']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) = 0">
          <xsl:attribute name="id">ND-LotReviewTerms-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) = 0">
          <xsl:attribute name="id">ND-AwardingTerms-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) = 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EmploymentLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EmploymentLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotEmploymentLegislation-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotEmploymentLegislation-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EnvironmentalLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EnvironmentalLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotEnvironmentalLegislation-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotEnvironmentalLegislation-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FiscalLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FiscalLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotFiscalLegislation-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotFiscalLegislation-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-T01</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-T01</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = 'T02']" mode="M15" priority="1676">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms[$noticeSubType = 'T02']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AllowedSubcontractTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AllowedSubcontractTerms) = 0">
          <xsl:attribute name="id">ND-SubcontractTerms-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SubcontractTerms-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AppealTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AppealTerms) = 0">
          <xsl:attribute name="id">ND-LotReviewTerms-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReviewTerms-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingTerms) = 0">
          <xsl:attribute name="id">ND-AwardingTerms-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-AwardingTerms-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:CallForTendersDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:CallForTendersDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotProcurementDocument-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotProcurementDocument-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ContractExecutionRequirement) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ContractExecutionRequirement) > 0">
          <xsl:attribute name="id">ND-ExecutionRequirements-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-ExecutionRequirements-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EconomicOperatorShortList) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EconomicOperatorShortList) = 0">
          <xsl:attribute name="id">ND-Participants-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Participants-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EmploymentLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EmploymentLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotEmploymentLegislation-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotEmploymentLegislation-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:EnvironmentalLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:EnvironmentalLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotEnvironmentalLegislation-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotEnvironmentalLegislation-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:FiscalLegislationDocumentReference) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:FiscalLegislationDocumentReference) = 0">
          <xsl:attribute name="id">ND-LotFiscalLegislation-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotFiscalLegislation-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PaymentTerms) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PaymentTerms) = 0">
          <xsl:attribute name="id">ND-PaymentTerms-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PaymentTerms-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:PostAwardProcess) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:PostAwardProcess) = 0">
          <xsl:attribute name="id">ND-PostAwarProcess-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-PostAwarProcess-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SecurityClearanceTerm) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SecurityClearanceTerm) = 0">
          <xsl:attribute name="id">ND-SecurityClearanceTerms-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SecurityClearanceTerms-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TendererQualificationRequest) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TendererQualificationRequest) = 0">
          <xsl:attribute name="id">ND-LotReservedParticipation-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotReservedParticipation-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension) = 0">
          <xsl:attribute name="id">ND-NonUBLTenderingTerms-T02</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-NonUBLTenderingTerms-T02</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '7']" mode="M15" priority="1675">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '8']" mode="M15" priority="1674">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '9']" mode="M15" priority="1673">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '10']" mode="M15" priority="1672">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '11']" mode="M15" priority="1671">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '12']" mode="M15" priority="1670">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '13']" mode="M15" priority="1669">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '14']" mode="M15" priority="1668">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '15']" mode="M15" priority="1667">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '16']" mode="M15" priority="1666">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '17']" mode="M15" priority="1665">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '18']" mode="M15" priority="1664">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '19']" mode="M15" priority="1663">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '20']" mode="M15" priority="1662">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '21']" mode="M15" priority="1661">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '22']" mode="M15" priority="1660">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '25']" mode="M15" priority="1659">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '26']" mode="M15" priority="1658">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '26']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-26</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-26</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '27']" mode="M15" priority="1657">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '28']" mode="M15" priority="1656">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '29']" mode="M15" priority="1655">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingCriterion) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingCriterion) > 0">
          <xsl:attribute name="id">ND-LotAwardCriteria-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriteria-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '30']" mode="M15" priority="1654">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '30']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-30</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-30</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '31']" mode="M15" priority="1653">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingCriterion) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingCriterion) > 0">
          <xsl:attribute name="id">ND-LotAwardCriteria-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriteria-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '32']" mode="M15" priority="1652">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:AwardingCriterion) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:AwardingCriterion) > 0">
          <xsl:attribute name="id">ND-LotAwardCriteria-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriteria-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '33']" mode="M15" priority="1651">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '34']" mode="M15" priority="1650">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '34']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-34</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-34</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '35']" mode="M15" priority="1649">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '36']" mode="M15" priority="1648">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '37']" mode="M15" priority="1647">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:Prize) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:Prize) = 0">
          <xsl:attribute name="id">ND-Prize-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-Prize-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '7']" mode="M15" priority="1646">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '8']" mode="M15" priority="1645">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '9']" mode="M15" priority="1644">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '10']" mode="M15" priority="1643">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '11']" mode="M15" priority="1642">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '12']" mode="M15" priority="1641">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '13']" mode="M15" priority="1640">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '14']" mode="M15" priority="1639">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '15']" mode="M15" priority="1638">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '16']" mode="M15" priority="1637">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '17']" mode="M15" priority="1636">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '18']" mode="M15" priority="1635">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '19']" mode="M15" priority="1634">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '20']" mode="M15" priority="1633">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '21']" mode="M15" priority="1632">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '22']" mode="M15" priority="1631">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '23']" mode="M15" priority="1630">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '24']" mode="M15" priority="1629">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '25']" mode="M15" priority="1628">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '27']" mode="M15" priority="1627">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '28']" mode="M15" priority="1626">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '29']" mode="M15" priority="1625">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SubordinateAwardingCriterion) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SubordinateAwardingCriterion) > 0">
          <xsl:attribute name="id">ND-LotAwardCriterion-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterion-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '31']" mode="M15" priority="1624">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SubordinateAwardingCriterion) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SubordinateAwardingCriterion) > 0">
          <xsl:attribute name="id">ND-LotAwardCriterion-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterion-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '32']" mode="M15" priority="1623">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:SubordinateAwardingCriterion) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:SubordinateAwardingCriterion) > 0">
          <xsl:attribute name="id">ND-LotAwardCriterion-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterion-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '33']" mode="M15" priority="1622">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '35']" mode="M15" priority="1621">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '36']" mode="M15" priority="1620">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '37']" mode="M15" priority="1619">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberComplicatedUnpublish-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberComplicatedUnpublish-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '7']" mode="M15" priority="1618">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '8']" mode="M15" priority="1617">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '9']" mode="M15" priority="1616">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '10']" mode="M15" priority="1615">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '11']" mode="M15" priority="1614">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '12']" mode="M15" priority="1613">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '13']" mode="M15" priority="1612">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '14']" mode="M15" priority="1611">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '15']" mode="M15" priority="1610">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '16']" mode="M15" priority="1609">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '17']" mode="M15" priority="1608">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '18']" mode="M15" priority="1607">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '19']" mode="M15" priority="1606">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '20']" mode="M15" priority="1605">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '21']" mode="M15" priority="1604">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '22']" mode="M15" priority="1603">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '23']" mode="M15" priority="1602">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '24']" mode="M15" priority="1601">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '25']" mode="M15" priority="1600">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '27']" mode="M15" priority="1599">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '28']" mode="M15" priority="1598">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '29']" mode="M15" priority="1597">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '31']" mode="M15" priority="1596">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '32']" mode="M15" priority="1595">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '33']" mode="M15" priority="1594">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '35']" mode="M15" priority="1593">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '36']" mode="M15" priority="1592">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '37']" mode="M15" priority="1591">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionTypeUnpublish-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionTypeUnpublish-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '7']" mode="M15" priority="1590">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '8']" mode="M15" priority="1589">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '9']" mode="M15" priority="1588">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '10']" mode="M15" priority="1587">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '11']" mode="M15" priority="1586">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '12']" mode="M15" priority="1585">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '13']" mode="M15" priority="1584">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '14']" mode="M15" priority="1583">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '15']" mode="M15" priority="1582">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '16']" mode="M15" priority="1581">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '17']" mode="M15" priority="1580">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '18']" mode="M15" priority="1579">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '19']" mode="M15" priority="1578">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '20']" mode="M15" priority="1577">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '21']" mode="M15" priority="1576">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '22']" mode="M15" priority="1575">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '23']" mode="M15" priority="1574">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '24']" mode="M15" priority="1573">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '25']" mode="M15" priority="1572">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '25']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-25</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-25</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '27']" mode="M15" priority="1571">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '27']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-27</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-27</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '28']" mode="M15" priority="1570">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '28']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-28</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-28</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '29']" mode="M15" priority="1569">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '29']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-29</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-29</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '31']" mode="M15" priority="1568">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '31']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-31</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-31</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '32']" mode="M15" priority="1567">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '32']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-32</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-32</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '33']" mode="M15" priority="1566">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '33']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-33</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-33</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '35']" mode="M15" priority="1565">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '35']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-35</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-35</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '36']" mode="M15" priority="1564">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '36']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-36</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-36</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '37']" mode="M15" priority="1563">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/cac:AwardingTerms/cac:AwardingCriterion/cac:SubordinateAwardingCriterion/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension/efac:AwardCriterionParameter[$noticeSubType = '37']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:FieldsPrivacy) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:FieldsPrivacy) = 0">
          <xsl:attribute name="id">ND-LotAwardCriterionNumberUnpublish-37</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotAwardCriterionNumberUnpublish-37</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '7']" mode="M15" priority="1562">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '8']" mode="M15" priority="1561">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '9']" mode="M15" priority="1560">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '10']" mode="M15" priority="1559">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '11']" mode="M15" priority="1558">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '12']" mode="M15" priority="1557">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '13']" mode="M15" priority="1556">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '14']" mode="M15" priority="1555">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '15']" mode="M15" priority="1554">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '16']" mode="M15" priority="1553">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '17']" mode="M15" priority="1552">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '18']" mode="M15" priority="1551">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '19']" mode="M15" priority="1550">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '20']" mode="M15" priority="1549">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '21']" mode="M15" priority="1548">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '22']" mode="M15" priority="1547">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '23']" mode="M15" priority="1546">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '24']" mode="M15" priority="1545">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = '24']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-24</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-24</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = 'CEI']" mode="M15" priority="1544">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='Lot']/cac:TenderingTerms/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/efext:EformsExtension[$noticeSubType = 'CEI']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(efac:SelectionCriteria) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(efac:SelectionCriteria) > 0">
          <xsl:attribute name="id">ND-SelectionCriteria-CEI</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-SelectionCriteria-CEI</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '7']" mode="M15" priority="1543">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '7']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-7</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-7</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '8']" mode="M15" priority="1542">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '8']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-8</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-8</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '9']" mode="M15" priority="1541">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '9']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-9</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-9</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '10']" mode="M15" priority="1540">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '10']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-10</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-10</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '11']" mode="M15" priority="1539">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '11']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-11</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-11</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '12']" mode="M15" priority="1538">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '12']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-12</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-12</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '13']" mode="M15" priority="1537">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '13']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-13</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-13</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '14']" mode="M15" priority="1536">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '14']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess/cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess/cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-LotsGroupFA-14</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupFA-14</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '15']" mode="M15" priority="1535">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '15']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess/cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess/cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-LotsGroupFA-15</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupFA-15</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '16']" mode="M15" priority="1534">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '16']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-16</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-16</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '17']" mode="M15" priority="1533">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '17']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-17</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-17</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '18']" mode="M15" priority="1532">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '18']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-18</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-18</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '19']" mode="M15" priority="1531">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '19']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess/cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess/cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-LotsGroupFA-19</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupFA-19</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '20']" mode="M15" priority="1530">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '20']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-20</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-20</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '21']" mode="M15" priority="1529">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '21']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-21</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-21</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '22']" mode="M15" priority="1528">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '22']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-22</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-22</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates mode="M15" select="@*|*" />
  </xsl:template>

	<!--RULE -->
<xsl:template match="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '23']" mode="M15" priority="1527">
    <svrl:fired-rule context="/*/cac:ProcurementProjectLot[cbc:ID/@schemeName='LotsGroup'][$noticeSubType = '23']" />

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:ProcurementProject) > 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:ProcurementProject) > 0">
          <xsl:attribute name="id">ND-LotsGroupProcurementScope-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
            <xsl:apply-templates mode="schematron-select-full-path" select="." />
          </xsl:attribute>
          <svrl:text>rule|text|ND-LotsGroupProcurementScope-23</svrl:text>
        </svrl:failed-assert>
      </xsl:otherwise>
    </xsl:choose>

		<!--ASSERT ERROR-->
<xsl:choose>
      <xsl:when test="count(cac:TenderingProcess/cac:FrameworkAgreement) = 0" />
      <xsl:otherwise>
        <svrl:failed-assert test="count(cac:TenderingProcess/cac:FrameworkAgreement) = 0">
          <xsl:attribute name="id">ND-LotsGroupFA-23</xsl:attribute>
          <xsl:attribute name="role">ERROR</xsl:attribute>
          <xsl:attribute name="location">
    