/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.validator;

import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.relaxng.RelaxNGCompactSchemaCache;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.sax.CollectingSAXErrorHandler;
import com.helger.xml.transform.TransformSourceFactory;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@Immutable
public final class SchematronValidator {
    public static final String SCHEMATRON_RNC_PATH = "external/schemas/iso-schematron-2006.rnc";
    public static final ClassPathResource SCHEMATRON_RNC = new ClassPathResource("external/schemas/iso-schematron-2006.rnc");
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronValidator.class);
    private static final SchematronValidator INSTANCE = new SchematronValidator();

    private SchematronValidator() {
    }

    public static boolean isValidSchematron(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == null) {
            return false;
        }
        return SchematronValidator.isValidSchematron((Source)TransformSourceFactory.create((String)MicroWriter.getNodeAsString((IMicroNode)iMicroNode)));
    }

    public static boolean isValidSchematron(@Nullable Node node) {
        if (node == null) {
            return false;
        }
        return SchematronValidator.isValidSchematron(TransformSourceFactory.create((Node)node));
    }

    public static boolean isValidSchematron(@Nullable IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            return false;
        }
        return SchematronValidator.isValidSchematron(TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    public static IErrorList validateSchematron(@Nullable Source source) {
        if (source == null) {
            return null;
        }
        try {
            CollectingSAXErrorHandler collectingSAXErrorHandler;
            Validator validator = RelaxNGCompactSchemaCache.getInstance().getValidator((IReadableResource)SCHEMATRON_RNC);
            ErrorHandler errorHandler = validator.getErrorHandler();
            if (errorHandler instanceof CollectingSAXErrorHandler) {
                collectingSAXErrorHandler = (CollectingSAXErrorHandler)errorHandler;
            } else {
                collectingSAXErrorHandler = new CollectingSAXErrorHandler();
                validator.setErrorHandler((ErrorHandler)collectingSAXErrorHandler.andThen(errorHandler));
            }
            validator.validate(source, null);
            return collectingSAXErrorHandler.getErrorList();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            LOGGER.warn("Failed to read source " + String.valueOf(source), (Throwable)iOException);
        }
        return null;
    }

    public static boolean isValidSchematron(@Nullable Source source) {
        IErrorList iErrorList = SchematronValidator.validateSchematron(source);
        return iErrorList != null && iErrorList.getMostSevereErrorLevel().isLT((IErrorLevel)EErrorLevel.ERROR);
    }
}

