/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.resource.inmemory.ReadableResourceByteArray;
import com.helger.commons.io.resource.inmemory.ReadableResourceInputStream;
import com.helger.schematron.api.xslt.AbstractSchematronXSLTBasedResource;
import com.helger.schematron.api.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.SchematronResourceXSLTCache;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SchematronResourceXSLT
extends AbstractSchematronXSLTBasedResource<SchematronResourceXSLT> {
    public SchematronResourceXSLT(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    @Nullable
    public ISchematronXSLTBasedProvider getXSLTProvider() {
        if (this.isUseCache()) {
            return SchematronResourceXSLTCache.getSchematronXSLTProvider(this.getResource(), this.getErrorListener(), this.getURIResolver());
        }
        return SchematronResourceXSLTCache.createSchematronXSLTProvider(this.getResource(), this.getErrorListener(), this.getURIResolver());
    }

    @Nonnull
    public static SchematronResourceXSLT fromClassPath(@Nonnull @Nonempty String string) {
        return new SchematronResourceXSLT((IReadableResource)new ClassPathResource(string));
    }

    @Nonnull
    public static SchematronResourceXSLT fromFile(@Nonnull @Nonempty String string) {
        return new SchematronResourceXSLT((IReadableResource)new FileSystemResource(string));
    }

    @Nonnull
    public static SchematronResourceXSLT fromFile(@Nonnull File file) {
        return new SchematronResourceXSLT((IReadableResource)new FileSystemResource(file));
    }

    @Nonnull
    public static SchematronResourceXSLT fromURL(@Nonnull @Nonempty String string) throws MalformedURLException {
        return new SchematronResourceXSLT((IReadableResource)new URLResource(string));
    }

    @Nonnull
    public static SchematronResourceXSLT fromURL(@Nonnull URL uRL) {
        return new SchematronResourceXSLT((IReadableResource)new URLResource(uRL));
    }

    @Nonnull
    public static SchematronResourceXSLT fromInputStream(@Nonnull InputStream inputStream) {
        return new SchematronResourceXSLT((IReadableResource)new ReadableResourceInputStream(inputStream));
    }

    @Nonnull
    public static SchematronResourceXSLT fromByteArray(@Nonnull byte[] byArray) {
        return new SchematronResourceXSLT((IReadableResource)new ReadableResourceByteArray(byArray));
    }

    @Nonnull
    public static SchematronResourceXSLT fromString(@Nonnull String string, @Nonnull Charset charset) {
        return SchematronResourceXSLT.fromByteArray(string.getBytes(charset));
    }
}

