
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AwardingCriterionTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CalculationExpressionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CalculationExpressionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MaximumAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MaximumQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MinimumAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MinimumImprovementBidType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MinimumQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.WeightNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.WeightType;


/**
 * 
 * &lt;pre&gt;
 * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ABIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Details&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A class to define a criterion from the contracting party that will be taken into account when awarding a contract. An awarding criterion can be objective, when it can be evaluated following a formula, or subjective, when human analysis is required.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;/ccts:Component&amp;gt;
 * &lt;/pre&gt;
 * 
 * 
 * &lt;p&gt;Java class for AwardingCriterionType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="AwardingCriterionType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AwardingCriterionTypeCode" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeightNumeric" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Weight" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CalculationExpression" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CalculationExpressionCode" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumQuantity" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumQuantity" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumAmount" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumAmount" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumImprovementBid" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SubordinateAwardingCriterion" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AwardingCriterionType", propOrder = {
    "id",
    "awardingCriterionTypeCode",
    "description",
    "weightNumeric",
    "weight",
    "calculationExpression",
    "calculationExpressionCode",
    "minimumQuantity",
    "maximumQuantity",
    "minimumAmount",
    "maximumAmount",
    "minimumImprovementBid",
    "subordinateAwardingCriterion"
})
@CodingStyleguideUnaware
public class AwardingCriterionType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "AwardingCriterionTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AwardingCriterionTypeCodeType awardingCriterionTypeCode;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "WeightNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WeightNumericType weightNumeric;
    @XmlElement(name = "Weight", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<WeightType> weight;
    @XmlElement(name = "CalculationExpression", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<CalculationExpressionType> calculationExpression;
    @XmlElement(name = "CalculationExpressionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CalculationExpressionCodeType calculationExpressionCode;
    @XmlElement(name = "MinimumQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MinimumQuantityType minimumQuantity;
    @XmlElement(name = "MaximumQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumQuantityType maximumQuantity;
    @XmlElement(name = "MinimumAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MinimumAmountType minimumAmount;
    @XmlElement(name = "MaximumAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumAmountType maximumAmount;
    @XmlElement(name = "MinimumImprovementBid", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<MinimumImprovementBidType> minimumImprovementBid;
    @XmlElement(name = "SubordinateAwardingCriterion")
    private List<AwardingCriterionType> subordinateAwardingCriterion;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public AwardingCriterionType() {
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Identifier&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;Identifies a specific awarding criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Identifier&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Identifier&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Identifier. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Awarding Criterion Type Code. Code&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A code used to define this awarding criterion. &amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Awarding Criterion Type Code&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Code&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Code. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link AwardingCriterionTypeCodeType }
     *     
     */
    @Nullable
    public AwardingCriterionTypeCodeType getAwardingCriterionTypeCode() {
        return awardingCriterionTypeCode;
    }

    /**
     * Sets the value of the awardingCriterionTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link AwardingCriterionTypeCodeType }
     *     
     */
    public void setAwardingCriterionTypeCode(
        @Nullable
        AwardingCriterionTypeCodeType value) {
        this.awardingCriterionTypeCode = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Description. Text&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A description of the awarding criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Description&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Text&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Text. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the description property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the description property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDescription().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Weight Numeric. Numeric&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A number defining the comparative weighting assigned to this awarding criterion, to enable formulaic evaluation.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Weight Numeric&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Numeric&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Numeric. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link WeightNumericType }
     *     
     */
    @Nullable
    public WeightNumericType getWeightNumeric() {
        return weightNumeric;
    }

    /**
     * Sets the value of the weightNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeightNumericType }
     *     
     */
    public void setWeightNumeric(
        @Nullable
        WeightNumericType value) {
        this.weightNumeric = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Weight. Text&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A description of the comparative weighting for this awarding criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Weight&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Text&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Text. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the weight property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the weight property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getWeight().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link WeightType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WeightType> getWeight() {
        if (weight == null) {
            weight = new ArrayList<WeightType>();
        }
        return this.weight;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Calculation Expression. Text&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The mathematical expression that will be used to evaluate this criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Calculation Expression&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Text&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Text. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the calculationExpression property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the calculationExpression property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getCalculationExpression().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link CalculationExpressionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CalculationExpressionType> getCalculationExpression() {
        if (calculationExpression == null) {
            calculationExpression = new ArrayList<CalculationExpressionType>();
        }
        return this.calculationExpression;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Calculation Expression Code. Code&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A code identifying the mathematical expression that will be used to evaluate this criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Calculation Expression Code&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Code&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Code. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link CalculationExpressionCodeType }
     *     
     */
    @Nullable
    public CalculationExpressionCodeType getCalculationExpressionCode() {
        return calculationExpressionCode;
    }

    /**
     * Sets the value of the calculationExpressionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CalculationExpressionCodeType }
     *     
     */
    public void setCalculationExpressionCode(
        @Nullable
        CalculationExpressionCodeType value) {
        this.calculationExpressionCode = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Minimum_ Quantity. Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The minimum quantity for an awarding criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Minimum&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Quantity&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Quantity. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link MinimumQuantityType }
     *     
     */
    @Nullable
    public MinimumQuantityType getMinimumQuantity() {
        return minimumQuantity;
    }

    /**
     * Sets the value of the minimumQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link MinimumQuantityType }
     *     
     */
    public void setMinimumQuantity(
        @Nullable
        MinimumQuantityType value) {
        this.minimumQuantity = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Maximum_ Quantity. Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The maximum quantity for an awarding criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Maximum&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Quantity&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Quantity. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link MaximumQuantityType }
     *     
     */
    @Nullable
    public MaximumQuantityType getMaximumQuantity() {
        return maximumQuantity;
    }

    /**
     * Sets the value of the maximumQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumQuantityType }
     *     
     */
    public void setMaximumQuantity(
        @Nullable
        MaximumQuantityType value) {
        this.maximumQuantity = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Minimum_ Amount. Amount&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The minimum monetary amount for an awarding criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Minimum&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Amount&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Amount&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Amount. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link MinimumAmountType }
     *     
     */
    @Nullable
    public MinimumAmountType getMinimumAmount() {
        return minimumAmount;
    }

    /**
     * Sets the value of the minimumAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link MinimumAmountType }
     *     
     */
    public void setMinimumAmount(
        @Nullable
        MinimumAmountType value) {
        this.minimumAmount = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Maximum_ Amount. Amount&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The maximum monetary amount for an awarding criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Maximum&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Amount&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Amount&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Amount. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link MaximumAmountType }
     *     
     */
    @Nullable
    public MaximumAmountType getMaximumAmount() {
        return maximumAmount;
    }

    /**
     * Sets the value of the maximumAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumAmountType }
     *     
     */
    public void setMaximumAmount(
        @Nullable
        MaximumAmountType value) {
        this.maximumAmount = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Minimum Improvement Bid. Text&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;Describes the minimum improvement bid for this awarding criterion when used in an auction.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Minimum Improvement Bid&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Text&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Text. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the minimumImprovementBid property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the minimumImprovementBid property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getMinimumImprovementBid().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link MinimumImprovementBidType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<MinimumImprovementBidType> getMinimumImprovementBid() {
        if (minimumImprovementBid == null) {
            minimumImprovementBid = new ArrayList<MinimumImprovementBidType>();
        }
        return this.minimumImprovementBid;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Awarding Criterion. Subordinate_ Awarding Criterion. Awarding Criterion&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;Defines any subsidiary awarding criterion.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Subordinate&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Awarding Criterion&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Awarding Criterion&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Awarding Criterion&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the subordinateAwardingCriterion property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the subordinateAwardingCriterion property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getSubordinateAwardingCriterion().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link AwardingCriterionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AwardingCriterionType> getSubordinateAwardingCriterion() {
        if (subordinateAwardingCriterion == null) {
            subordinateAwardingCriterion = new ArrayList<AwardingCriterionType>();
        }
        return this.subordinateAwardingCriterion;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AwardingCriterionType rhs = ((AwardingCriterionType) o);
        if (!EqualsHelper.equals(awardingCriterionTypeCode, rhs.awardingCriterionTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(calculationExpression, rhs.calculationExpression)) {
            return false;
        }
        if (!EqualsHelper.equals(calculationExpressionCode, rhs.calculationExpressionCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumAmount, rhs.maximumAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumQuantity, rhs.maximumQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumAmount, rhs.minimumAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(minimumImprovementBid, rhs.minimumImprovementBid)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumQuantity, rhs.minimumQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(subordinateAwardingCriterion, rhs.subordinateAwardingCriterion)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(weight, rhs.weight)) {
            return false;
        }
        if (!EqualsHelper.equals(weightNumeric, rhs.weightNumeric)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(awardingCriterionTypeCode).append(calculationExpression).append(calculationExpressionCode).append(description).append(id).append(maximumAmount).append(maximumQuantity).append(minimumAmount).append(minimumImprovementBid).append(minimumQuantity).append(subordinateAwardingCriterion).append(weight).append(weightNumeric).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("awardingCriterionTypeCode", awardingCriterionTypeCode).append("calculationExpression", calculationExpression).append("calculationExpressionCode", calculationExpressionCode).append("description", description).append("id", id).append("maximumAmount", maximumAmount).append("maximumQuantity", maximumQuantity).append("minimumAmount", minimumAmount).append("minimumImprovementBid", minimumImprovementBid).append("minimumQuantity", minimumQuantity).append("subordinateAwardingCriterion", subordinateAwardingCriterion).append("weight", weight).append("weightNumeric", weightNumeric).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setWeight(
        @Nullable
        final List<WeightType> aList) {
        weight = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setCalculationExpression(
        @Nullable
        final List<CalculationExpressionType> aList) {
        calculationExpression = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setMinimumImprovementBid(
        @Nullable
        final List<MinimumImprovementBidType> aList) {
        minimumImprovementBid = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setSubordinateAwardingCriterion(
        @Nullable
        final List<AwardingCriterionType> aList) {
        subordinateAwardingCriterion = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasWeightEntries() {
        return (!getWeight().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoWeightEntries() {
        return getWeight().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getWeightCount() {
        return getWeight().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WeightType getWeightAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWeight().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addWeight(
        @Nonnull
        final WeightType elem) {
        getWeight().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasCalculationExpressionEntries() {
        return (!getCalculationExpression().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoCalculationExpressionEntries() {
        return getCalculationExpression().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getCalculationExpressionCount() {
        return getCalculationExpression().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CalculationExpressionType getCalculationExpressionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCalculationExpression().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addCalculationExpression(
        @Nonnull
        final CalculationExpressionType elem) {
        getCalculationExpression().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasMinimumImprovementBidEntries() {
        return (!getMinimumImprovementBid().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoMinimumImprovementBidEntries() {
        return getMinimumImprovementBid().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getMinimumImprovementBidCount() {
        return getMinimumImprovementBid().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public MinimumImprovementBidType getMinimumImprovementBidAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMinimumImprovementBid().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addMinimumImprovementBid(
        @Nonnull
        final MinimumImprovementBidType elem) {
        getMinimumImprovementBid().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasSubordinateAwardingCriterionEntries() {
        return (!getSubordinateAwardingCriterion().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoSubordinateAwardingCriterionEntries() {
        return getSubordinateAwardingCriterion().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getSubordinateAwardingCriterionCount() {
        return getSubordinateAwardingCriterion().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AwardingCriterionType getSubordinateAwardingCriterionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSubordinateAwardingCriterion().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addSubordinateAwardingCriterion(
        @Nonnull
        final AwardingCriterionType elem) {
        getSubordinateAwardingCriterion().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        AwardingCriterionType ret) {
        ret.awardingCriterionTypeCode = ((awardingCriterionTypeCode == null)?null:awardingCriterionTypeCode.clone());
        if (calculationExpression == null) {
            ret.calculationExpression = null;
        } else {
            List<CalculationExpressionType> retCalculationExpression = new ArrayList<CalculationExpressionType>();
            for (CalculationExpressionType aItem: getCalculationExpression()) {
                retCalculationExpression.add(((aItem == null)?null:aItem.clone()));
            }
            ret.calculationExpression = retCalculationExpression;
        }
        ret.calculationExpressionCode = ((calculationExpressionCode == null)?null:calculationExpressionCode.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<DescriptionType>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.maximumAmount = ((maximumAmount == null)?null:maximumAmount.clone());
        ret.maximumQuantity = ((maximumQuantity == null)?null:maximumQuantity.clone());
        ret.minimumAmount = ((minimumAmount == null)?null:minimumAmount.clone());
        if (minimumImprovementBid == null) {
            ret.minimumImprovementBid = null;
        } else {
            List<MinimumImprovementBidType> retMinimumImprovementBid = new ArrayList<MinimumImprovementBidType>();
            for (MinimumImprovementBidType aItem: getMinimumImprovementBid()) {
                retMinimumImprovementBid.add(((aItem == null)?null:aItem.clone()));
            }
            ret.minimumImprovementBid = retMinimumImprovementBid;
        }
        ret.minimumQuantity = ((minimumQuantity == null)?null:minimumQuantity.clone());
        if (subordinateAwardingCriterion == null) {
            ret.subordinateAwardingCriterion = null;
        } else {
            List<AwardingCriterionType> retSubordinateAwardingCriterion = new ArrayList<AwardingCriterionType>();
            for (AwardingCriterionType aItem: getSubordinateAwardingCriterion()) {
                retSubordinateAwardingCriterion.add(((aItem == null)?null:aItem.clone()));
            }
            ret.subordinateAwardingCriterion = retSubordinateAwardingCriterion;
        }
        if (weight == null) {
            ret.weight = null;
        } else {
            List<WeightType> retWeight = new ArrayList<WeightType>();
            for (WeightType aItem: getWeight()) {
                retWeight.add(((aItem == null)?null:aItem.clone()));
            }
            ret.weight = retWeight;
        }
        ret.weightNumeric = ((weightNumeric == null)?null:weightNumeric.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AwardingCriterionType clone() {
        AwardingCriterionType ret = new AwardingCriterionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type MinimumAmountType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public MinimumAmountType setMinimumAmount(
        @Nullable
        final BigDecimal valueParam) {
        MinimumAmountType aObj = getMinimumAmount();
        if (aObj == null) {
            aObj = new MinimumAmountType(valueParam);
            setMinimumAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type MaximumAmountType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public MaximumAmountType setMaximumAmount(
        @Nullable
        final BigDecimal valueParam) {
        MaximumAmountType aObj = getMaximumAmount();
        if (aObj == null) {
            aObj = new MaximumAmountType(valueParam);
            setMaximumAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type AwardingCriterionTypeCodeType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public AwardingCriterionTypeCodeType setAwardingCriterionTypeCode(
        @Nullable
        final String valueParam) {
        AwardingCriterionTypeCodeType aObj = getAwardingCriterionTypeCode();
        if (aObj == null) {
            aObj = new AwardingCriterionTypeCodeType(valueParam);
            setAwardingCriterionTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type CalculationExpressionCodeType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public CalculationExpressionCodeType setCalculationExpressionCode(
        @Nullable
        final String valueParam) {
        CalculationExpressionCodeType aObj = getCalculationExpressionCode();
        if (aObj == null) {
            aObj = new CalculationExpressionCodeType(valueParam);
            setCalculationExpressionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type IDType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type WeightNumericType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public WeightNumericType setWeightNumeric(
        @Nullable
        final BigDecimal valueParam) {
        WeightNumericType aObj = getWeightNumeric();
        if (aObj == null) {
            aObj = new WeightNumericType(valueParam);
            setWeightNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type MinimumQuantityType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public MinimumQuantityType setMinimumQuantity(
        @Nullable
        final BigDecimal valueParam) {
        MinimumQuantityType aObj = getMinimumQuantity();
        if (aObj == null) {
            aObj = new MinimumQuantityType(valueParam);
            setMinimumQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type MaximumQuantityType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public MaximumQuantityType setMaximumQuantity(
        @Nullable
        final BigDecimal valueParam) {
        MaximumQuantityType aObj = getMaximumQuantity();
        if (aObj == null) {
            aObj = new MaximumQuantityType(valueParam);
            setMaximumQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AwardingCriterionTypeCodeType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AwardingCriterionTypeCodeType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getAwardingCriterionTypeCodeValue() {
        AwardingCriterionTypeCodeType aObj = getAwardingCriterionTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeightNumericType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeightNumericType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getWeightNumericValue() {
        WeightNumericType aObj = getWeightNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CalculationExpressionCodeType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CalculationExpressionCodeType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getCalculationExpressionCodeValue() {
        CalculationExpressionCodeType aObj = getCalculationExpressionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MinimumQuantityType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MinimumQuantityType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getMinimumQuantityValue() {
        MinimumQuantityType aObj = getMinimumQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumQuantityType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumQuantityType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getMaximumQuantityValue() {
        MaximumQuantityType aObj = getMaximumQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MinimumAmountType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MinimumAmountType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getMinimumAmountValue() {
        MinimumAmountType aObj = getMinimumAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumAmountType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumAmountType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getMaximumAmountValue() {
        MaximumAmountType aObj = getMaximumAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
