
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ParentDocumentLineReferenceIDType;


/**
 * 
 * &lt;pre&gt;
 * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ABIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Details&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A class to describe a line item for utility consumption. To specify more than one utility item, use separate consumption lines.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;/ccts:Component&amp;gt;
 * &lt;/pre&gt;
 * 
 * 
 * &lt;p&gt;Java class for ConsumptionLineType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="ConsumptionLineType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ParentDocumentLineReferenceID" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InvoicedQuantity"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LineExtensionAmount"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Period" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Delivery" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AllowanceCharge" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TaxTotal" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}UtilityItem"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Price" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}UnstructuredPrice" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConsumptionLineType", propOrder = {
    "id",
    "parentDocumentLineReferenceID",
    "invoicedQuantity",
    "lineExtensionAmount",
    "period",
    "delivery",
    "allowanceCharge",
    "taxTotal",
    "utilityItem",
    "price",
    "unstructuredPrice"
})
@CodingStyleguideUnaware
public class ConsumptionLineType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "ParentDocumentLineReferenceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ParentDocumentLineReferenceIDType parentDocumentLineReferenceID;
    @XmlElement(name = "InvoicedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private InvoicedQuantityType invoicedQuantity;
    @XmlElement(name = "LineExtensionAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private LineExtensionAmountType lineExtensionAmount;
    @XmlElement(name = "Period")
    private PeriodType period;
    @XmlElement(name = "Delivery")
    private List<DeliveryType> delivery;
    @XmlElement(name = "AllowanceCharge")
    private List<AllowanceChargeType> allowanceCharge;
    @XmlElement(name = "TaxTotal")
    private List<TaxTotalType> taxTotal;
    @XmlElement(name = "UtilityItem", required = true)
    private UtilityItemType utilityItem;
    @XmlElement(name = "Price")
    private PriceType price;
    @XmlElement(name = "UnstructuredPrice")
    private UnstructuredPriceType unstructuredPrice;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ConsumptionLineType() {
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Identifier&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;An identifier for this consumption line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Identifier&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Identifier&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Identifier. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;ccts:Examples&amp;gt;1&amp;lt;/ccts:Examples&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Parent_ Document Line Reference Identifier. Identifier&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;An identifier for the transaction line on a related document (such as an invoice) that covers this consumption line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Parent&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Document Line Reference Identifier&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Identifier&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Identifier. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;ccts:Examples&amp;gt;Consumption&amp;lt;/ccts:Examples&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link ParentDocumentLineReferenceIDType }
     *     
     */
    @Nullable
    public ParentDocumentLineReferenceIDType getParentDocumentLineReferenceID() {
        return parentDocumentLineReferenceID;
    }

    /**
     * Sets the value of the parentDocumentLineReferenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ParentDocumentLineReferenceIDType }
     *     
     */
    public void setParentDocumentLineReferenceID(
        @Nullable
        ParentDocumentLineReferenceIDType value) {
        this.parentDocumentLineReferenceID = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Invoiced_ Quantity. Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The quantity invoiced.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Invoiced&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Quantity&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Quantity. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link InvoicedQuantityType }
     *     
     */
    @Nullable
    public InvoicedQuantityType getInvoicedQuantity() {
        return invoicedQuantity;
    }

    /**
     * Sets the value of the invoicedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link InvoicedQuantityType }
     *     
     */
    public void setInvoicedQuantity(
        @Nullable
        InvoicedQuantityType value) {
        this.invoicedQuantity = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Line Extension Amount. Amount&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The monetary amount, including discount, to be charged for this consumption line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Line Extension Amount&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Amount&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Amount. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link LineExtensionAmountType }
     *     
     */
    @Nullable
    public LineExtensionAmountType getLineExtensionAmount() {
        return lineExtensionAmount;
    }

    /**
     * Sets the value of the lineExtensionAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineExtensionAmountType }
     *     
     */
    public void setLineExtensionAmount(
        @Nullable
        LineExtensionAmountType value) {
        this.lineExtensionAmount = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Period&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The period of time covered by this consumption line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Period&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Period&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Period&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getPeriod() {
        return period;
    }

    /**
     * Sets the value of the period property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setPeriod(
        @Nullable
        PeriodType value) {
        this.period = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Delivery&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A delivery of the utility item on this consumption line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Delivery&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Delivery&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Delivery&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the delivery property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the delivery property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDelivery().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DeliveryType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DeliveryType> getDelivery() {
        if (delivery == null) {
            delivery = new ArrayList<DeliveryType>();
        }
        return this.delivery;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Allowance Charge&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;An allowance or charge that applies to this consumption line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Allowance Charge&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Allowance Charge&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Allowance Charge&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the allowanceCharge property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the allowanceCharge property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getAllowanceCharge().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link AllowanceChargeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AllowanceChargeType> getAllowanceCharge() {
        if (allowanceCharge == null) {
            allowanceCharge = new ArrayList<AllowanceChargeType>();
        }
        return this.allowanceCharge;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Tax Total&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A total amount of taxes of a particular kind applicable to this consumption line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Tax Total&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Tax Total&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Tax Total&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the taxTotal property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the taxTotal property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTaxTotal().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link TaxTotalType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TaxTotalType> getTaxTotal() {
        if (taxTotal == null) {
            taxTotal = new ArrayList<TaxTotalType>();
        }
        return this.taxTotal;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Utility Item&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The utility item consumed.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Utility Item&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Utility Item&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Utility Item&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link UtilityItemType }
     *     
     */
    @Nullable
    public UtilityItemType getUtilityItem() {
        return utilityItem;
    }

    /**
     * Sets the value of the utilityItem property.
     * 
     * @param value
     *     allowed object is
     *     {@link UtilityItemType }
     *     
     */
    public void setUtilityItem(
        @Nullable
        UtilityItemType value) {
        this.utilityItem = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Price&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The price associated with this consumption line, expressed in a data structure containing multiple properties.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Price&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Price&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Price&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link PriceType }
     *     
     */
    @Nullable
    public PriceType getPrice() {
        return price;
    }

    /**
     * Sets the value of the price property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceType }
     *     
     */
    public void setPrice(
        @Nullable
        PriceType value) {
        this.price = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Consumption Line. Unstructured Price&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The price associated with this consumption line expressed in a less structured form that includes just the amount and the time of use.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Consumption Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Unstructured Price&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Unstructured Price&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Unstructured Price&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link UnstructuredPriceType }
     *     
     */
    @Nullable
    public UnstructuredPriceType getUnstructuredPrice() {
        return unstructuredPrice;
    }

    /**
     * Sets the value of the unstructuredPrice property.
     * 
     * @param value
     *     allowed object is
     *     {@link UnstructuredPriceType }
     *     
     */
    public void setUnstructuredPrice(
        @Nullable
        UnstructuredPriceType value) {
        this.unstructuredPrice = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ConsumptionLineType rhs = ((ConsumptionLineType) o);
        if (!EqualsHelper.equalsCollection(allowanceCharge, rhs.allowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(delivery, rhs.delivery)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(invoicedQuantity, rhs.invoicedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(lineExtensionAmount, rhs.lineExtensionAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(parentDocumentLineReferenceID, rhs.parentDocumentLineReferenceID)) {
            return false;
        }
        if (!EqualsHelper.equals(period, rhs.period)) {
            return false;
        }
        if (!EqualsHelper.equals(price, rhs.price)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(taxTotal, rhs.taxTotal)) {
            return false;
        }
        if (!EqualsHelper.equals(unstructuredPrice, rhs.unstructuredPrice)) {
            return false;
        }
        if (!EqualsHelper.equals(utilityItem, rhs.utilityItem)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(allowanceCharge).append(delivery).append(id).append(invoicedQuantity).append(lineExtensionAmount).append(parentDocumentLineReferenceID).append(period).append(price).append(taxTotal).append(unstructuredPrice).append(utilityItem).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("allowanceCharge", allowanceCharge).append("delivery", delivery).append("id", id).append("invoicedQuantity", invoicedQuantity).append("lineExtensionAmount", lineExtensionAmount).append("parentDocumentLineReferenceID", parentDocumentLineReferenceID).append("period", period).append("price", price).append("taxTotal", taxTotal).append("unstructuredPrice", unstructuredPrice).append("utilityItem", utilityItem).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDelivery(
        @Nullable
        final List<DeliveryType> aList) {
        delivery = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setAllowanceCharge(
        @Nullable
        final List<AllowanceChargeType> aList) {
        allowanceCharge = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTaxTotal(
        @Nullable
        final List<TaxTotalType> aList) {
        taxTotal = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDeliveryEntries() {
        return (!getDelivery().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDeliveryEntries() {
        return getDelivery().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDeliveryCount() {
        return getDelivery().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DeliveryType getDeliveryAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDelivery().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDelivery(
        @Nonnull
        final DeliveryType elem) {
        getDelivery().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasAllowanceChargeEntries() {
        return (!getAllowanceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoAllowanceChargeEntries() {
        return getAllowanceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getAllowanceChargeCount() {
        return getAllowanceCharge().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AllowanceChargeType getAllowanceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAllowanceCharge().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addAllowanceCharge(
        @Nonnull
        final AllowanceChargeType elem) {
        getAllowanceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTaxTotalEntries() {
        return (!getTaxTotal().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTaxTotalEntries() {
        return getTaxTotal().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTaxTotalCount() {
        return getTaxTotal().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TaxTotalType getTaxTotalAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTaxTotal().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTaxTotal(
        @Nonnull
        final TaxTotalType elem) {
        getTaxTotal().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        ConsumptionLineType ret) {
        if (allowanceCharge == null) {
            ret.allowanceCharge = null;
        } else {
            List<AllowanceChargeType> retAllowanceCharge = new ArrayList<AllowanceChargeType>();
            for (AllowanceChargeType aItem: getAllowanceCharge()) {
                retAllowanceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.allowanceCharge = retAllowanceCharge;
        }
        if (delivery == null) {
            ret.delivery = null;
        } else {
            List<DeliveryType> retDelivery = new ArrayList<DeliveryType>();
            for (DeliveryType aItem: getDelivery()) {
                retDelivery.add(((aItem == null)?null:aItem.clone()));
            }
            ret.delivery = retDelivery;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.invoicedQuantity = ((invoicedQuantity == null)?null:invoicedQuantity.clone());
        ret.lineExtensionAmount = ((lineExtensionAmount == null)?null:lineExtensionAmount.clone());
        ret.parentDocumentLineReferenceID = ((parentDocumentLineReferenceID == null)?null:parentDocumentLineReferenceID.clone());
        ret.period = ((period == null)?null:period.clone());
        ret.price = ((price == null)?null:price.clone());
        if (taxTotal == null) {
            ret.taxTotal = null;
        } else {
            List<TaxTotalType> retTaxTotal = new ArrayList<TaxTotalType>();
            for (TaxTotalType aItem: getTaxTotal()) {
                retTaxTotal.add(((aItem == null)?null:aItem.clone()));
            }
            ret.taxTotal = retTaxTotal;
        }
        ret.unstructuredPrice = ((unstructuredPrice == null)?null:unstructuredPrice.clone());
        ret.utilityItem = ((utilityItem == null)?null:utilityItem.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ConsumptionLineType clone() {
        ConsumptionLineType ret = new ConsumptionLineType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type LineExtensionAmountType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public LineExtensionAmountType setLineExtensionAmount(
        @Nullable
        final BigDecimal valueParam) {
        LineExtensionAmountType aObj = getLineExtensionAmount();
        if (aObj == null) {
            aObj = new LineExtensionAmountType(valueParam);
            setLineExtensionAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type IDType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type ParentDocumentLineReferenceIDType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public ParentDocumentLineReferenceIDType setParentDocumentLineReferenceID(
        @Nullable
        final String valueParam) {
        ParentDocumentLineReferenceIDType aObj = getParentDocumentLineReferenceID();
        if (aObj == null) {
            aObj = new ParentDocumentLineReferenceIDType(valueParam);
            setParentDocumentLineReferenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type InvoicedQuantityType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public InvoicedQuantityType setInvoicedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        InvoicedQuantityType aObj = getInvoicedQuantity();
        if (aObj == null) {
            aObj = new InvoicedQuantityType(valueParam);
            setInvoicedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ParentDocumentLineReferenceIDType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ParentDocumentLineReferenceIDType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getParentDocumentLineReferenceIDValue() {
        ParentDocumentLineReferenceIDType aObj = getParentDocumentLineReferenceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained InvoicedQuantityType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained InvoicedQuantityType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getInvoicedQuantityValue() {
        InvoicedQuantityType aObj = getInvoicedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LineExtensionAmountType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LineExtensionAmountType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getLineExtensionAmountValue() {
        LineExtensionAmountType aObj = getLineExtensionAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
