
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CalculationRateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ExchangeMarketIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MathematicOperatorCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.SourceCurrencyBaseRateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.SourceCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TargetCurrencyBaseRateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TargetCurrencyCodeType;


/**
 * 
 * &lt;pre&gt;
 * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ABIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Details&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A class to define an exchange rate.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;/ccts:Component&amp;gt;
 * &lt;/pre&gt;
 * 
 * 
 * &lt;p&gt;Java class for ExchangeRateType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="ExchangeRateType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SourceCurrencyCode"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SourceCurrencyBaseRate" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TargetCurrencyCode"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TargetCurrencyBaseRate" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExchangeMarketID" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CalculationRate" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MathematicOperatorCode" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Date" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ForeignExchangeContract" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExchangeRateType", propOrder = {
    "sourceCurrencyCode",
    "sourceCurrencyBaseRate",
    "targetCurrencyCode",
    "targetCurrencyBaseRate",
    "exchangeMarketID",
    "calculationRate",
    "mathematicOperatorCode",
    "date",
    "foreignExchangeContract"
})
@CodingStyleguideUnaware
public class ExchangeRateType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SourceCurrencyCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private SourceCurrencyCodeType sourceCurrencyCode;
    @XmlElement(name = "SourceCurrencyBaseRate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SourceCurrencyBaseRateType sourceCurrencyBaseRate;
    @XmlElement(name = "TargetCurrencyCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private TargetCurrencyCodeType targetCurrencyCode;
    @XmlElement(name = "TargetCurrencyBaseRate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TargetCurrencyBaseRateType targetCurrencyBaseRate;
    @XmlElement(name = "ExchangeMarketID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExchangeMarketIDType exchangeMarketID;
    @XmlElement(name = "CalculationRate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CalculationRateType calculationRate;
    @XmlElement(name = "MathematicOperatorCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MathematicOperatorCodeType mathematicOperatorCode;
    @XmlElement(name = "Date", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DateType date;
    @XmlElement(name = "ForeignExchangeContract")
    private ContractType foreignExchangeContract;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ExchangeRateType() {
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Source_ Currency Code. Code&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The reference currency for this exchange rate; the currency from which the exchange is being made.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Source&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Currency Code&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Code&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataTypeQualifier&amp;gt;Currency&amp;lt;/ccts:DataTypeQualifier&amp;gt;&amp;lt;ccts:DataType&amp;gt;Currency_ Code. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link SourceCurrencyCodeType }
     *     
     */
    @Nullable
    public SourceCurrencyCodeType getSourceCurrencyCode() {
        return sourceCurrencyCode;
    }

    /**
     * Sets the value of the sourceCurrencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SourceCurrencyCodeType }
     *     
     */
    public void setSourceCurrencyCode(
        @Nullable
        SourceCurrencyCodeType value) {
        this.sourceCurrencyCode = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Source_ Currency Base Rate. Rate&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;In the case of a source currency with denominations of small value, the unit base.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Source&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Currency Base Rate&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Rate&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Rate. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link SourceCurrencyBaseRateType }
     *     
     */
    @Nullable
    public SourceCurrencyBaseRateType getSourceCurrencyBaseRate() {
        return sourceCurrencyBaseRate;
    }

    /**
     * Sets the value of the sourceCurrencyBaseRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link SourceCurrencyBaseRateType }
     *     
     */
    public void setSourceCurrencyBaseRate(
        @Nullable
        SourceCurrencyBaseRateType value) {
        this.sourceCurrencyBaseRate = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Target_ Currency Code. Code&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The target currency for this exchange rate; the currency to which the exchange is being made.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Target&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Currency Code&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Code&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataTypeQualifier&amp;gt;Currency&amp;lt;/ccts:DataTypeQualifier&amp;gt;&amp;lt;ccts:DataType&amp;gt;Currency_ Code. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link TargetCurrencyCodeType }
     *     
     */
    @Nullable
    public TargetCurrencyCodeType getTargetCurrencyCode() {
        return targetCurrencyCode;
    }

    /**
     * Sets the value of the targetCurrencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TargetCurrencyCodeType }
     *     
     */
    public void setTargetCurrencyCode(
        @Nullable
        TargetCurrencyCodeType value) {
        this.targetCurrencyCode = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Target_ Currency Base Rate. Rate&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;In the case of a target currency with denominations of small value, the unit base.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Target&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Currency Base Rate&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Rate&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Rate. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link TargetCurrencyBaseRateType }
     *     
     */
    @Nullable
    public TargetCurrencyBaseRateType getTargetCurrencyBaseRate() {
        return targetCurrencyBaseRate;
    }

    /**
     * Sets the value of the targetCurrencyBaseRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link TargetCurrencyBaseRateType }
     *     
     */
    public void setTargetCurrencyBaseRate(
        @Nullable
        TargetCurrencyBaseRateType value) {
        this.targetCurrencyBaseRate = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Exchange Market Identifier. Identifier&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;An identifier for the currency exchange market used as the source of this exchange rate.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Exchange Market Identifier&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Identifier&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Identifier. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link ExchangeMarketIDType }
     *     
     */
    @Nullable
    public ExchangeMarketIDType getExchangeMarketID() {
        return exchangeMarketID;
    }

    /**
     * Sets the value of the exchangeMarketID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExchangeMarketIDType }
     *     
     */
    public void setExchangeMarketID(
        @Nullable
        ExchangeMarketIDType value) {
        this.exchangeMarketID = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Calculation Rate. Rate&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The factor applied to the source currency to calculate the target currency.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Calculation Rate&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Rate&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Rate. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link CalculationRateType }
     *     
     */
    @Nullable
    public CalculationRateType getCalculationRate() {
        return calculationRate;
    }

    /**
     * Sets the value of the calculationRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CalculationRateType }
     *     
     */
    public void setCalculationRate(
        @Nullable
        CalculationRateType value) {
        this.calculationRate = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Mathematic Operator Code. Code&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A code signifying whether the calculation rate is a multiplier or a divisor.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Mathematic Operator Code&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Code&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataTypeQualifier&amp;gt;Operator&amp;lt;/ccts:DataTypeQualifier&amp;gt;&amp;lt;ccts:DataType&amp;gt;Operator_ Code. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link MathematicOperatorCodeType }
     *     
     */
    @Nullable
    public MathematicOperatorCodeType getMathematicOperatorCode() {
        return mathematicOperatorCode;
    }

    /**
     * Sets the value of the mathematicOperatorCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MathematicOperatorCodeType }
     *     
     */
    public void setMathematicOperatorCode(
        @Nullable
        MathematicOperatorCodeType value) {
        this.mathematicOperatorCode = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Date&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The date on which the exchange rate was established.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Date&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Date&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Date. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link DateType }
     *     
     */
    @Nullable
    public DateType getDate() {
        return date;
    }

    /**
     * Sets the value of the date property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateType }
     *     
     */
    public void setDate(
        @Nullable
        DateType value) {
        this.date = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Exchange Rate. Foreign Exchange_ Contract. Contract&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A contract for foreign exchange.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Exchange Rate&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Foreign Exchange&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Contract&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Contract&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Contract&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link ContractType }
     *     
     */
    @Nullable
    public ContractType getForeignExchangeContract() {
        return foreignExchangeContract;
    }

    /**
     * Sets the value of the foreignExchangeContract property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContractType }
     *     
     */
    public void setForeignExchangeContract(
        @Nullable
        ContractType value) {
        this.foreignExchangeContract = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ExchangeRateType rhs = ((ExchangeRateType) o);
        if (!EqualsHelper.equals(calculationRate, rhs.calculationRate)) {
            return false;
        }
        if (!EqualsHelper.equals(date, rhs.date)) {
            return false;
        }
        if (!EqualsHelper.equals(exchangeMarketID, rhs.exchangeMarketID)) {
            return false;
        }
        if (!EqualsHelper.equals(foreignExchangeContract, rhs.foreignExchangeContract)) {
            return false;
        }
        if (!EqualsHelper.equals(mathematicOperatorCode, rhs.mathematicOperatorCode)) {
            return false;
        }
        if (!EqualsHelper.equals(sourceCurrencyBaseRate, rhs.sourceCurrencyBaseRate)) {
            return false;
        }
        if (!EqualsHelper.equals(sourceCurrencyCode, rhs.sourceCurrencyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(targetCurrencyBaseRate, rhs.targetCurrencyBaseRate)) {
            return false;
        }
        if (!EqualsHelper.equals(targetCurrencyCode, rhs.targetCurrencyCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(calculationRate).append(date).append(exchangeMarketID).append(foreignExchangeContract).append(mathematicOperatorCode).append(sourceCurrencyBaseRate).append(sourceCurrencyCode).append(targetCurrencyBaseRate).append(targetCurrencyCode).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("calculationRate", calculationRate).append("date", date).append("exchangeMarketID", exchangeMarketID).append("foreignExchangeContract", foreignExchangeContract).append("mathematicOperatorCode", mathematicOperatorCode).append("sourceCurrencyBaseRate", sourceCurrencyBaseRate).append("sourceCurrencyCode", sourceCurrencyCode).append("targetCurrencyBaseRate", targetCurrencyBaseRate).append("targetCurrencyCode", targetCurrencyCode).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        ExchangeRateType ret) {
        ret.calculationRate = ((calculationRate == null)?null:calculationRate.clone());
        ret.date = ((date == null)?null:date.clone());
        ret.exchangeMarketID = ((exchangeMarketID == null)?null:exchangeMarketID.clone());
        ret.foreignExchangeContract = ((foreignExchangeContract == null)?null:foreignExchangeContract.clone());
        ret.mathematicOperatorCode = ((mathematicOperatorCode == null)?null:mathematicOperatorCode.clone());
        ret.sourceCurrencyBaseRate = ((sourceCurrencyBaseRate == null)?null:sourceCurrencyBaseRate.clone());
        ret.sourceCurrencyCode = ((sourceCurrencyCode == null)?null:sourceCurrencyCode.clone());
        ret.targetCurrencyBaseRate = ((targetCurrencyBaseRate == null)?null:targetCurrencyBaseRate.clone());
        ret.targetCurrencyCode = ((targetCurrencyCode == null)?null:targetCurrencyCode.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ExchangeRateType clone() {
        ExchangeRateType ret = new ExchangeRateType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type SourceCurrencyCodeType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public SourceCurrencyCodeType setSourceCurrencyCode(
        @Nullable
        final String valueParam) {
        SourceCurrencyCodeType aObj = getSourceCurrencyCode();
        if (aObj == null) {
            aObj = new SourceCurrencyCodeType(valueParam);
            setSourceCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type TargetCurrencyCodeType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public TargetCurrencyCodeType setTargetCurrencyCode(
        @Nullable
        final String valueParam) {
        TargetCurrencyCodeType aObj = getTargetCurrencyCode();
        if (aObj == null) {
            aObj = new TargetCurrencyCodeType(valueParam);
            setTargetCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type MathematicOperatorCodeType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public MathematicOperatorCodeType setMathematicOperatorCode(
        @Nullable
        final String valueParam) {
        MathematicOperatorCodeType aObj = getMathematicOperatorCode();
        if (aObj == null) {
            aObj = new MathematicOperatorCodeType(valueParam);
            setMathematicOperatorCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type DateType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public DateType setDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        DateType aObj = getDate();
        if (aObj == null) {
            aObj = new DateType(valueParam);
            setDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type DateType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public DateType setDate(
        @Nullable
        final LocalDate valueParam) {
        DateType aObj = getDate();
        if (aObj == null) {
            aObj = new DateType(valueParam);
            setDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type ExchangeMarketIDType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public ExchangeMarketIDType setExchangeMarketID(
        @Nullable
        final String valueParam) {
        ExchangeMarketIDType aObj = getExchangeMarketID();
        if (aObj == null) {
            aObj = new ExchangeMarketIDType(valueParam);
            setExchangeMarketID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type SourceCurrencyBaseRateType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public SourceCurrencyBaseRateType setSourceCurrencyBaseRate(
        @Nullable
        final BigDecimal valueParam) {
        SourceCurrencyBaseRateType aObj = getSourceCurrencyBaseRate();
        if (aObj == null) {
            aObj = new SourceCurrencyBaseRateType(valueParam);
            setSourceCurrencyBaseRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type TargetCurrencyBaseRateType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public TargetCurrencyBaseRateType setTargetCurrencyBaseRate(
        @Nullable
        final BigDecimal valueParam) {
        TargetCurrencyBaseRateType aObj = getTargetCurrencyBaseRate();
        if (aObj == null) {
            aObj = new TargetCurrencyBaseRateType(valueParam);
            setTargetCurrencyBaseRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type CalculationRateType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public CalculationRateType setCalculationRate(
        @Nullable
        final BigDecimal valueParam) {
        CalculationRateType aObj = getCalculationRate();
        if (aObj == null) {
            aObj = new CalculationRateType(valueParam);
            setCalculationRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained SourceCurrencyCodeType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SourceCurrencyCodeType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getSourceCurrencyCodeValue() {
        SourceCurrencyCodeType aObj = getSourceCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SourceCurrencyBaseRateType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SourceCurrencyBaseRateType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getSourceCurrencyBaseRateValue() {
        SourceCurrencyBaseRateType aObj = getSourceCurrencyBaseRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TargetCurrencyCodeType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TargetCurrencyCodeType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getTargetCurrencyCodeValue() {
        TargetCurrencyCodeType aObj = getTargetCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TargetCurrencyBaseRateType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TargetCurrencyBaseRateType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getTargetCurrencyBaseRateValue() {
        TargetCurrencyBaseRateType aObj = getTargetCurrencyBaseRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExchangeMarketIDType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExchangeMarketIDType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getExchangeMarketIDValue() {
        ExchangeMarketIDType aObj = getExchangeMarketID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CalculationRateType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CalculationRateType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getCalculationRateValue() {
        CalculationRateType aObj = getCalculationRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MathematicOperatorCodeType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MathematicOperatorCodeType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getMathematicOperatorCodeValue() {
        MathematicOperatorCodeType aObj = getMathematicOperatorCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DateType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DateType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public XMLOffsetDate getDateValue() {
        DateType aObj = getDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DateType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DateType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public LocalDate getDateValueLocal() {
        DateType aObj = getDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
