
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PerformanceMetricTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PerformanceValueQuantityType;


/**
 * 
 * &lt;pre&gt;
 * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ABIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Performance Data Line. Details&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A class to define a line in a Performance History.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Performance Data Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;/ccts:Component&amp;gt;
 * &lt;/pre&gt;
 * 
 * 
 * &lt;p&gt;Java class for PerformanceDataLineType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="PerformanceDataLineType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PerformanceValueQuantity"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PerformanceMetricTypeCode"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Period" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Item" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PerformanceDataLineType", propOrder = {
    "id",
    "note",
    "performanceValueQuantity",
    "performanceMetricTypeCode",
    "period",
    "item"
})
@CodingStyleguideUnaware
public class PerformanceDataLineType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "PerformanceValueQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private PerformanceValueQuantityType performanceValueQuantity;
    @XmlElement(name = "PerformanceMetricTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private PerformanceMetricTypeCodeType performanceMetricTypeCode;
    @XmlElement(name = "Period")
    private PeriodType period;
    @XmlElement(name = "Item")
    private ItemType item;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public PerformanceDataLineType() {
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Performance Data Line. Identifier&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;An identifier for this performance data line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Performance Data Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Identifier&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Identifier&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Identifier. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Performance Data Line. Note. Text&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;Free-form text conveying information that is not contained explicitly in other structures.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Performance Data Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Note&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Text&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Text. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the note property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the note property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getNote().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<NoteType>();
        }
        return this.note;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Performance Data Line. Performance Value. Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The value of the reported attribute.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Performance Data Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Performance Value&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Quantity. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link PerformanceValueQuantityType }
     *     
     */
    @Nullable
    public PerformanceValueQuantityType getPerformanceValueQuantity() {
        return performanceValueQuantity;
    }

    /**
     * Sets the value of the performanceValueQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link PerformanceValueQuantityType }
     *     
     */
    public void setPerformanceValueQuantity(
        @Nullable
        PerformanceValueQuantityType value) {
        this.performanceValueQuantity = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Performance Data Line. Performance Metric Type Code. Code&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A code signifying the measure of performance applicable to the reported attribute.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Performance Data Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Performance Metric Type Code&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Code&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Code. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link PerformanceMetricTypeCodeType }
     *     
     */
    @Nullable
    public PerformanceMetricTypeCodeType getPerformanceMetricTypeCode() {
        return performanceMetricTypeCode;
    }

    /**
     * Sets the value of the performanceMetricTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PerformanceMetricTypeCodeType }
     *     
     */
    public void setPerformanceMetricTypeCode(
        @Nullable
        PerformanceMetricTypeCodeType value) {
        this.performanceMetricTypeCode = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Performance Data Line. Period&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The period to which this performance data line applies.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Performance Data Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Period&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Period&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Period&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getPeriod() {
        return period;
    }

    /**
     * Sets the value of the period property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setPeriod(
        @Nullable
        PeriodType value) {
        this.period = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Performance Data Line. Item&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The item whose performance is reported in this data line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Performance Data Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Item&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Item&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Item&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link ItemType }
     *     
     */
    @Nullable
    public ItemType getItem() {
        return item;
    }

    /**
     * Sets the value of the item property.
     * 
     * @param value
     *     allowed object is
     *     {@link ItemType }
     *     
     */
    public void setItem(
        @Nullable
        ItemType value) {
        this.item = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PerformanceDataLineType rhs = ((PerformanceDataLineType) o);
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(item, rhs.item)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equals(performanceMetricTypeCode, rhs.performanceMetricTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(performanceValueQuantity, rhs.performanceValueQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(period, rhs.period)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(id).append(item).append(note).append(performanceMetricTypeCode).append(performanceValueQuantity).append(period).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("id", id).append("item", item).append("note", note).append("performanceMetricTypeCode", performanceMetricTypeCode).append("performanceValueQuantity", performanceValueQuantity).append("period", period).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        PerformanceDataLineType ret) {
        ret.id = ((id == null)?null:id.clone());
        ret.item = ((item == null)?null:item.clone());
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<NoteType>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        ret.performanceMetricTypeCode = ((performanceMetricTypeCode == null)?null:performanceMetricTypeCode.clone());
        ret.performanceValueQuantity = ((performanceValueQuantity == null)?null:performanceValueQuantity.clone());
        ret.period = ((period == null)?null:period.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PerformanceDataLineType clone() {
        PerformanceDataLineType ret = new PerformanceDataLineType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type PerformanceMetricTypeCodeType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public PerformanceMetricTypeCodeType setPerformanceMetricTypeCode(
        @Nullable
        final String valueParam) {
        PerformanceMetricTypeCodeType aObj = getPerformanceMetricTypeCode();
        if (aObj == null) {
            aObj = new PerformanceMetricTypeCodeType(valueParam);
            setPerformanceMetricTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type IDType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type PerformanceValueQuantityType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public PerformanceValueQuantityType setPerformanceValueQuantity(
        @Nullable
        final BigDecimal valueParam) {
        PerformanceValueQuantityType aObj = getPerformanceValueQuantity();
        if (aObj == null) {
            aObj = new PerformanceValueQuantityType(valueParam);
            setPerformanceValueQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PerformanceValueQuantityType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PerformanceValueQuantityType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getPerformanceValueQuantityValue() {
        PerformanceValueQuantityType aObj = getPerformanceValueQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PerformanceMetricTypeCodeType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PerformanceMetricTypeCodeType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getPerformanceMetricTypeCodeValue() {
        PerformanceMetricTypeCodeType aObj = getPerformanceMetricTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
