
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ContentUnitQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MaximumOrderQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MinimumOrderQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.OrderQuantityIncrementNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.OrderableUnitType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PackLevelCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.QuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TotalTaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.WarrantyInformationType;


/**
 * 
 * &lt;pre&gt;
 * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ABIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Details&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A class to define a line in a Tender.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;/ccts:Component&amp;gt;
 * &lt;/pre&gt;
 * 
 * 
 * &lt;p&gt;Java class for TenderLineType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="TenderLineType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Quantity" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LineExtensionAmount" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalTaxAmount" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OrderableUnit" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ContentUnitQuantity" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OrderQuantityIncrementNumeric" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumOrderQuantity" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumOrderQuantity" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WarrantyInformation" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PackLevelCode" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentReference" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Item" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OfferedItemLocationQuantity" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReplacementRelatedItem" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}WarrantyParty" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}WarrantyValidityPeriod" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SubTenderLine" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CallForTendersLineReference" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CallForTendersDocumentReference" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TenderLineType", propOrder = {
    "id",
    "note",
    "quantity",
    "lineExtensionAmount",
    "totalTaxAmount",
    "orderableUnit",
    "contentUnitQuantity",
    "orderQuantityIncrementNumeric",
    "minimumOrderQuantity",
    "maximumOrderQuantity",
    "warrantyInformation",
    "packLevelCode",
    "documentReference",
    "item",
    "offeredItemLocationQuantity",
    "replacementRelatedItem",
    "warrantyParty",
    "warrantyValidityPeriod",
    "subTenderLine",
    "callForTendersLineReference",
    "callForTendersDocumentReference"
})
@CodingStyleguideUnaware
public class TenderLineType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "Quantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private QuantityType quantity;
    @XmlElement(name = "LineExtensionAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LineExtensionAmountType lineExtensionAmount;
    @XmlElement(name = "TotalTaxAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalTaxAmountType totalTaxAmount;
    @XmlElement(name = "OrderableUnit", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OrderableUnitType orderableUnit;
    @XmlElement(name = "ContentUnitQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ContentUnitQuantityType contentUnitQuantity;
    @XmlElement(name = "OrderQuantityIncrementNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OrderQuantityIncrementNumericType orderQuantityIncrementNumeric;
    @XmlElement(name = "MinimumOrderQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MinimumOrderQuantityType minimumOrderQuantity;
    @XmlElement(name = "MaximumOrderQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumOrderQuantityType maximumOrderQuantity;
    @XmlElement(name = "WarrantyInformation", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<WarrantyInformationType> warrantyInformation;
    @XmlElement(name = "PackLevelCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PackLevelCodeType packLevelCode;
    @XmlElement(name = "DocumentReference")
    private List<DocumentReferenceType> documentReference;
    @XmlElement(name = "Item")
    private ItemType item;
    @XmlElement(name = "OfferedItemLocationQuantity")
    private List<ItemLocationQuantityType> offeredItemLocationQuantity;
    @XmlElement(name = "ReplacementRelatedItem")
    private List<RelatedItemType> replacementRelatedItem;
    @XmlElement(name = "WarrantyParty")
    private PartyType warrantyParty;
    @XmlElement(name = "WarrantyValidityPeriod")
    private PeriodType warrantyValidityPeriod;
    @XmlElement(name = "SubTenderLine")
    private List<TenderLineType> subTenderLine;
    @XmlElement(name = "CallForTendersLineReference")
    private LineReferenceType callForTendersLineReference;
    @XmlElement(name = "CallForTendersDocumentReference")
    private DocumentReferenceType callForTendersDocumentReference;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public TenderLineType() {
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Identifier&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;An identifier for this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Identifier&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Identifier&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Identifier. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Note. Text&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;Free-form text conveying information that is not contained explicitly in other structures.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Note&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Text&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Text. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the note property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the note property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getNote().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<NoteType>();
        }
        return this.note;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The quantity of the item quoted in this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Quantity&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Quantity. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getQuantity() {
        return quantity;
    }

    /**
     * Sets the value of the quantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setQuantity(
        @Nullable
        QuantityType value) {
        this.quantity = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Line Extension Amount. Amount&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The total amount for this tender line, including allowance charges but net of taxes.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Line Extension Amount&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Amount&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Amount. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link LineExtensionAmountType }
     *     
     */
    @Nullable
    public LineExtensionAmountType getLineExtensionAmount() {
        return lineExtensionAmount;
    }

    /**
     * Sets the value of the lineExtensionAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineExtensionAmountType }
     *     
     */
    public void setLineExtensionAmount(
        @Nullable
        LineExtensionAmountType value) {
        this.lineExtensionAmount = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Total_ Tax Amount. Amount&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The total tax amount for this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Total&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Tax Amount&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Amount&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Amount. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link TotalTaxAmountType }
     *     
     */
    @Nullable
    public TotalTaxAmountType getTotalTaxAmount() {
        return totalTaxAmount;
    }

    /**
     * Sets the value of the totalTaxAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalTaxAmountType }
     *     
     */
    public void setTotalTaxAmount(
        @Nullable
        TotalTaxAmountType value) {
        this.totalTaxAmount = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Orderable_ Unit. Text&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;Text describing a unit in which the item described in this tender line can be ordered.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Orderable&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Unit&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Text&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Text. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link OrderableUnitType }
     *     
     */
    @Nullable
    public OrderableUnitType getOrderableUnit() {
        return orderableUnit;
    }

    /**
     * Sets the value of the orderableUnit property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrderableUnitType }
     *     
     */
    public void setOrderableUnit(
        @Nullable
        OrderableUnitType value) {
        this.orderableUnit = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Content Unit. Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The unit of measure and quantity of the orderable unit.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Content Unit&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Quantity. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;ccts:Examples&amp;gt;If order unit measure identifier is each , then content unit quantity is 1 .&amp;lt;/ccts:Examples&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link ContentUnitQuantityType }
     *     
     */
    @Nullable
    public ContentUnitQuantityType getContentUnitQuantity() {
        return contentUnitQuantity;
    }

    /**
     * Sets the value of the contentUnitQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContentUnitQuantityType }
     *     
     */
    public void setContentUnitQuantity(
        @Nullable
        ContentUnitQuantityType value) {
        this.contentUnitQuantity = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Order Quantity Increment. Numeric&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The number of items that can set the order quantity increments.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Order Quantity Increment&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Numeric&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Numeric. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link OrderQuantityIncrementNumericType }
     *     
     */
    @Nullable
    public OrderQuantityIncrementNumericType getOrderQuantityIncrementNumeric() {
        return orderQuantityIncrementNumeric;
    }

    /**
     * Sets the value of the orderQuantityIncrementNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrderQuantityIncrementNumericType }
     *     
     */
    public void setOrderQuantityIncrementNumeric(
        @Nullable
        OrderQuantityIncrementNumericType value) {
        this.orderQuantityIncrementNumeric = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Minimum_ Order Quantity. Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The minimum number of items described in this tender line that can be ordered.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Minimum&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Order Quantity&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Quantity. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;ccts:Examples&amp;gt;10 boxes &amp;lt;/ccts:Examples&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link MinimumOrderQuantityType }
     *     
     */
    @Nullable
    public MinimumOrderQuantityType getMinimumOrderQuantity() {
        return minimumOrderQuantity;
    }

    /**
     * Sets the value of the minimumOrderQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link MinimumOrderQuantityType }
     *     
     */
    public void setMinimumOrderQuantity(
        @Nullable
        MinimumOrderQuantityType value) {
        this.minimumOrderQuantity = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Maximum_ Order Quantity. Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The maximum number of items described in this tender line that can be ordered.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Maximum&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Order Quantity&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Quantity. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;ccts:Examples&amp;gt;1 tonne &amp;lt;/ccts:Examples&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link MaximumOrderQuantityType }
     *     
     */
    @Nullable
    public MaximumOrderQuantityType getMaximumOrderQuantity() {
        return maximumOrderQuantity;
    }

    /**
     * Sets the value of the maximumOrderQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumOrderQuantityType }
     *     
     */
    public void setMaximumOrderQuantity(
        @Nullable
        MaximumOrderQuantityType value) {
        this.maximumOrderQuantity = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Warranty_ Information. Text&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;Text about a warranty (provided by WarrantyParty) for the good or service described in this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Warranty&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Information&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Text&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Text. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;ccts:Examples&amp;gt;Unless specified otherwise and in addition to any rights the Customer may have under statute, Dell warrants to the Customer that Dell branded Products (excluding third party products and software), will be free from defects in materials and workmanship affecting normal use for a period of one year from invoice date ( Standard Warranty ). &amp;lt;/ccts:Examples&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the warrantyInformation property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the warrantyInformation property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getWarrantyInformation().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link WarrantyInformationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WarrantyInformationType> getWarrantyInformation() {
        if (warrantyInformation == null) {
            warrantyInformation = new ArrayList<WarrantyInformationType>();
        }
        return this.warrantyInformation;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;BBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Pack Level Code. Code&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A mutually agreed code signifying the level of packaging associated with the item described in this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Pack Level Code&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Code&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;ccts:DataType&amp;gt;Code. Type&amp;lt;/ccts:DataType&amp;gt;&amp;lt;ccts:AlternativeBusinessTerms&amp;gt;Consumer Unit, Trading Unit&amp;lt;/ccts:AlternativeBusinessTerms&amp;gt;&amp;lt;ccts:Examples&amp;gt;level 2 , Group 4 &amp;lt;/ccts:Examples&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link PackLevelCodeType }
     *     
     */
    @Nullable
    public PackLevelCodeType getPackLevelCode() {
        return packLevelCode;
    }

    /**
     * Sets the value of the packLevelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PackLevelCodeType }
     *     
     */
    public void setPackLevelCode(
        @Nullable
        PackLevelCodeType value) {
        this.packLevelCode = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Document Reference&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A reference to a document associated with this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Document Reference&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Document Reference&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Document Reference&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the documentReference property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the documentReference property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDocumentReference().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getDocumentReference() {
        if (documentReference == null) {
            documentReference = new ArrayList<DocumentReferenceType>();
        }
        return this.documentReference;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Item&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The item associated with this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Item&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Item&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Item&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link ItemType }
     *     
     */
    @Nullable
    public ItemType getItem() {
        return item;
    }

    /**
     * Sets the value of the item property.
     * 
     * @param value
     *     allowed object is
     *     {@link ItemType }
     *     
     */
    public void setItem(
        @Nullable
        ItemType value) {
        this.item = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Offered_ Item Location Quantity. Item Location Quantity&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A set of location-specific properties (e.g., price, quantity, lead time) associated with the item described in this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Offered&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Item Location Quantity&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Item Location Quantity&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Item Location Quantity&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the offeredItemLocationQuantity property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the offeredItemLocationQuantity property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getOfferedItemLocationQuantity().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link ItemLocationQuantityType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemLocationQuantityType> getOfferedItemLocationQuantity() {
        if (offeredItemLocationQuantity == null) {
            offeredItemLocationQuantity = new ArrayList<ItemLocationQuantityType>();
        }
        return this.offeredItemLocationQuantity;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Replacement_ Related Item. Related Item&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A catalogue item that may be a replacement for the item described in this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Replacement&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Related Item&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Related Item&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Related Item&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the replacementRelatedItem property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the replacementRelatedItem property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getReplacementRelatedItem().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link RelatedItemType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RelatedItemType> getReplacementRelatedItem() {
        if (replacementRelatedItem == null) {
            replacementRelatedItem = new ArrayList<RelatedItemType>();
        }
        return this.replacementRelatedItem;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Warranty_ Party. Party&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The party responsible for any warranty described in this tender line.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Warranty&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Party&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Party&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Party&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getWarrantyParty() {
        return warrantyParty;
    }

    /**
     * Sets the value of the warrantyParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setWarrantyParty(
        @Nullable
        PartyType value) {
        this.warrantyParty = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Warranty Validity_ Period. Period&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;The period for which a warranty associated with the item described in this tender line is valid.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Warranty Validity&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Period&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Period&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Period&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getWarrantyValidityPeriod() {
        return warrantyValidityPeriod;
    }

    /**
     * Sets the value of the warrantyValidityPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setWarrantyValidityPeriod(
        @Nullable
        PeriodType value) {
        this.warrantyValidityPeriod = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Sub_ Tender Line. Tender Line&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;An association to a Sub Tender Line&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..n&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Sub&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Tender Line&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Tender Line&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Tender Line&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * Gets the value of the subTenderLine property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the subTenderLine property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getSubTenderLine().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link TenderLineType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TenderLineType> getSubTenderLine() {
        if (subTenderLine == null) {
            subTenderLine = new ArrayList<TenderLineType>();
        }
        return this.subTenderLine;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Call For Tenders_ Line Reference. Line Reference&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;Reference to a Line on a Call For Tenders document.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Call For Tenders&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Line Reference&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Line Reference&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Line Reference&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link LineReferenceType }
     *     
     */
    @Nullable
    public LineReferenceType getCallForTendersLineReference() {
        return callForTendersLineReference;
    }

    /**
     * Sets the value of the callForTendersLineReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineReferenceType }
     *     
     */
    public void setCallForTendersLineReference(
        @Nullable
        LineReferenceType value) {
        this.callForTendersLineReference = value;
    }

    /**
     * 
     * &lt;pre&gt;
     * &amp;lt;?xml version="1.0" encoding="UTF-8"?&amp;gt;&amp;lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p255846_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p657430_="http://java.sun.com/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&amp;gt;&amp;lt;ccts:ComponentType&amp;gt;ASBIE&amp;lt;/ccts:ComponentType&amp;gt;&amp;lt;ccts:DictionaryEntryName&amp;gt;Tender Line. Call For Tenders_ Document Reference. Document Reference&amp;lt;/ccts:DictionaryEntryName&amp;gt;&amp;lt;ccts:Definition&amp;gt;A class defining references to a Call For Tenders document.&amp;lt;/ccts:Definition&amp;gt;&amp;lt;ccts:Cardinality&amp;gt;0..1&amp;lt;/ccts:Cardinality&amp;gt;&amp;lt;ccts:ObjectClass&amp;gt;Tender Line&amp;lt;/ccts:ObjectClass&amp;gt;&amp;lt;ccts:PropertyTermQualifier&amp;gt;Call For Tenders&amp;lt;/ccts:PropertyTermQualifier&amp;gt;&amp;lt;ccts:PropertyTerm&amp;gt;Document Reference&amp;lt;/ccts:PropertyTerm&amp;gt;&amp;lt;ccts:AssociatedObjectClass&amp;gt;Document Reference&amp;lt;/ccts:AssociatedObjectClass&amp;gt;&amp;lt;ccts:RepresentationTerm&amp;gt;Document Reference&amp;lt;/ccts:RepresentationTerm&amp;gt;&amp;lt;/ccts:Component&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     * @return
     *     possible object is
     *     {@link DocumentReferenceType }
     *     
     */
    @Nullable
    public DocumentReferenceType getCallForTendersDocumentReference() {
        return callForTendersDocumentReference;
    }

    /**
     * Sets the value of the callForTendersDocumentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentReferenceType }
     *     
     */
    public void setCallForTendersDocumentReference(
        @Nullable
        DocumentReferenceType value) {
        this.callForTendersDocumentReference = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TenderLineType rhs = ((TenderLineType) o);
        if (!EqualsHelper.equals(callForTendersDocumentReference, rhs.callForTendersDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(callForTendersLineReference, rhs.callForTendersLineReference)) {
            return false;
        }
        if (!EqualsHelper.equals(contentUnitQuantity, rhs.contentUnitQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(documentReference, rhs.documentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(item, rhs.item)) {
            return false;
        }
        if (!EqualsHelper.equals(lineExtensionAmount, rhs.lineExtensionAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumOrderQuantity, rhs.maximumOrderQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumOrderQuantity, rhs.minimumOrderQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(offeredItemLocationQuantity, rhs.offeredItemLocationQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(orderQuantityIncrementNumeric, rhs.orderQuantityIncrementNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(orderableUnit, rhs.orderableUnit)) {
            return false;
        }
        if (!EqualsHelper.equals(packLevelCode, rhs.packLevelCode)) {
            return false;
        }
        if (!EqualsHelper.equals(quantity, rhs.quantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(replacementRelatedItem, rhs.replacementRelatedItem)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(subTenderLine, rhs.subTenderLine)) {
            return false;
        }
        if (!EqualsHelper.equals(totalTaxAmount, rhs.totalTaxAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(warrantyInformation, rhs.warrantyInformation)) {
            return false;
        }
        if (!EqualsHelper.equals(warrantyParty, rhs.warrantyParty)) {
            return false;
        }
        if (!EqualsHelper.equals(warrantyValidityPeriod, rhs.warrantyValidityPeriod)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(callForTendersDocumentReference).append(callForTendersLineReference).append(contentUnitQuantity).append(documentReference).append(id).append(item).append(lineExtensionAmount).append(maximumOrderQuantity).append(minimumOrderQuantity).append(note).append(offeredItemLocationQuantity).append(orderQuantityIncrementNumeric).append(orderableUnit).append(packLevelCode).append(quantity).append(replacementRelatedItem).append(subTenderLine).append(totalTaxAmount).append(warrantyInformation).append(warrantyParty).append(warrantyValidityPeriod).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("callForTendersDocumentReference", callForTendersDocumentReference).append("callForTendersLineReference", callForTendersLineReference).append("contentUnitQuantity", contentUnitQuantity).append("documentReference", documentReference).append("id", id).append("item", item).append("lineExtensionAmount", lineExtensionAmount).append("maximumOrderQuantity", maximumOrderQuantity).append("minimumOrderQuantity", minimumOrderQuantity).append("note", note).append("offeredItemLocationQuantity", offeredItemLocationQuantity).append("orderQuantityIncrementNumeric", orderQuantityIncrementNumeric).append("orderableUnit", orderableUnit).append("packLevelCode", packLevelCode).append("quantity", quantity).append("replacementRelatedItem", replacementRelatedItem).append("subTenderLine", subTenderLine).append("totalTaxAmount", totalTaxAmount).append("warrantyInformation", warrantyInformation).append("warrantyParty", warrantyParty).append("warrantyValidityPeriod", warrantyValidityPeriod).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setWarrantyInformation(
        @Nullable
        final List<WarrantyInformationType> aList) {
        warrantyInformation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        documentReference = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setOfferedItemLocationQuantity(
        @Nullable
        final List<ItemLocationQuantityType> aList) {
        offeredItemLocationQuantity = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setReplacementRelatedItem(
        @Nullable
        final List<RelatedItemType> aList) {
        replacementRelatedItem = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setSubTenderLine(
        @Nullable
        final List<TenderLineType> aList) {
        subTenderLine = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasWarrantyInformationEntries() {
        return (!getWarrantyInformation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoWarrantyInformationEntries() {
        return getWarrantyInformation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getWarrantyInformationCount() {
        return getWarrantyInformation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WarrantyInformationType getWarrantyInformationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWarrantyInformation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addWarrantyInformation(
        @Nonnull
        final WarrantyInformationType elem) {
        getWarrantyInformation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDocumentReferenceEntries() {
        return (!getDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDocumentReferenceEntries() {
        return getDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDocumentReferenceCount() {
        return getDocumentReference().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasOfferedItemLocationQuantityEntries() {
        return (!getOfferedItemLocationQuantity().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoOfferedItemLocationQuantityEntries() {
        return getOfferedItemLocationQuantity().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getOfferedItemLocationQuantityCount() {
        return getOfferedItemLocationQuantity().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemLocationQuantityType getOfferedItemLocationQuantityAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getOfferedItemLocationQuantity().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addOfferedItemLocationQuantity(
        @Nonnull
        final ItemLocationQuantityType elem) {
        getOfferedItemLocationQuantity().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasReplacementRelatedItemEntries() {
        return (!getReplacementRelatedItem().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoReplacementRelatedItemEntries() {
        return getReplacementRelatedItem().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getReplacementRelatedItemCount() {
        return getReplacementRelatedItem().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RelatedItemType getReplacementRelatedItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReplacementRelatedItem().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addReplacementRelatedItem(
        @Nonnull
        final RelatedItemType elem) {
        getReplacementRelatedItem().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasSubTenderLineEntries() {
        return (!getSubTenderLine().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoSubTenderLineEntries() {
        return getSubTenderLine().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getSubTenderLineCount() {
        return getSubTenderLine().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TenderLineType getSubTenderLineAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSubTenderLine().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addSubTenderLine(
        @Nonnull
        final TenderLineType elem) {
        getSubTenderLine().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        TenderLineType ret) {
        ret.callForTendersDocumentReference = ((callForTendersDocumentReference == null)?null:callForTendersDocumentReference.clone());
        ret.callForTendersLineReference = ((callForTendersLineReference == null)?null:callForTendersLineReference.clone());
        ret.contentUnitQuantity = ((contentUnitQuantity == null)?null:contentUnitQuantity.clone());
        if (documentReference == null) {
            ret.documentReference = null;
        } else {
            List<DocumentReferenceType> retDocumentReference = new ArrayList<DocumentReferenceType>();
            for (DocumentReferenceType aItem: getDocumentReference()) {
                retDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.documentReference = retDocumentReference;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.item = ((item == null)?null:item.clone());
        ret.lineExtensionAmount = ((lineExtensionAmount == null)?null:lineExtensionAmount.clone());
        ret.maximumOrderQuantity = ((maximumOrderQuantity == null)?null:maximumOrderQuantity.clone());
        ret.minimumOrderQuantity = ((minimumOrderQuantity == null)?null:minimumOrderQuantity.clone());
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<NoteType>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        if (offeredItemLocationQuantity == null) {
            ret.offeredItemLocationQuantity = null;
        } else {
            List<ItemLocationQuantityType> retOfferedItemLocationQuantity = new ArrayList<ItemLocationQuantityType>();
            for (ItemLocationQuantityType aItem: getOfferedItemLocationQuantity()) {
                retOfferedItemLocationQuantity.add(((aItem == null)?null:aItem.clone()));
            }
            ret.offeredItemLocationQuantity = retOfferedItemLocationQuantity;
        }
        ret.orderQuantityIncrementNumeric = ((orderQuantityIncrementNumeric == null)?null:orderQuantityIncrementNumeric.clone());
        ret.orderableUnit = ((orderableUnit == null)?null:orderableUnit.clone());
        ret.packLevelCode = ((packLevelCode == null)?null:packLevelCode.clone());
        ret.quantity = ((quantity == null)?null:quantity.clone());
        if (replacementRelatedItem == null) {
            ret.replacementRelatedItem = null;
        } else {
            List<RelatedItemType> retReplacementRelatedItem = new ArrayList<RelatedItemType>();
            for (RelatedItemType aItem: getReplacementRelatedItem()) {
                retReplacementRelatedItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.replacementRelatedItem = retReplacementRelatedItem;
        }
        if (subTenderLine == null) {
            ret.subTenderLine = null;
        } else {
            List<TenderLineType> retSubTenderLine = new ArrayList<TenderLineType>();
            for (TenderLineType aItem: getSubTenderLine()) {
                retSubTenderLine.add(((aItem == null)?null:aItem.clone()));
            }
            ret.subTenderLine = retSubTenderLine;
        }
        ret.totalTaxAmount = ((totalTaxAmount == null)?null:totalTaxAmount.clone());
        if (warrantyInformation == null) {
            ret.warrantyInformation = null;
        } else {
            List<WarrantyInformationType> retWarrantyInformation = new ArrayList<WarrantyInformationType>();
            for (WarrantyInformationType aItem: getWarrantyInformation()) {
                retWarrantyInformation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.warrantyInformation = retWarrantyInformation;
        }
        ret.warrantyParty = ((warrantyParty == null)?null:warrantyParty.clone());
        ret.warrantyValidityPeriod = ((warrantyValidityPeriod == null)?null:warrantyValidityPeriod.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TenderLineType clone() {
        TenderLineType ret = new TenderLineType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type LineExtensionAmountType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public LineExtensionAmountType setLineExtensionAmount(
        @Nullable
        final BigDecimal valueParam) {
        LineExtensionAmountType aObj = getLineExtensionAmount();
        if (aObj == null) {
            aObj = new LineExtensionAmountType(valueParam);
            setLineExtensionAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type TotalTaxAmountType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public TotalTaxAmountType setTotalTaxAmount(
        @Nullable
        final BigDecimal valueParam) {
        TotalTaxAmountType aObj = getTotalTaxAmount();
        if (aObj == null) {
            aObj = new TotalTaxAmountType(valueParam);
            setTotalTaxAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type PackLevelCodeType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public PackLevelCodeType setPackLevelCode(
        @Nullable
        final String valueParam) {
        PackLevelCodeType aObj = getPackLevelCode();
        if (aObj == null) {
            aObj = new PackLevelCodeType(valueParam);
            setPackLevelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type IDType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type OrderQuantityIncrementNumericType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public OrderQuantityIncrementNumericType setOrderQuantityIncrementNumeric(
        @Nullable
        final BigDecimal valueParam) {
        OrderQuantityIncrementNumericType aObj = getOrderQuantityIncrementNumeric();
        if (aObj == null) {
            aObj = new OrderQuantityIncrementNumericType(valueParam);
            setOrderQuantityIncrementNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type QuantityType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public QuantityType setQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type ContentUnitQuantityType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public ContentUnitQuantityType setContentUnitQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ContentUnitQuantityType aObj = getContentUnitQuantity();
        if (aObj == null) {
            aObj = new ContentUnitQuantityType(valueParam);
            setContentUnitQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type MinimumOrderQuantityType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public MinimumOrderQuantityType setMinimumOrderQuantity(
        @Nullable
        final BigDecimal valueParam) {
        MinimumOrderQuantityType aObj = getMinimumOrderQuantity();
        if (aObj == null) {
            aObj = new MinimumOrderQuantityType(valueParam);
            setMinimumOrderQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type MaximumOrderQuantityType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public MaximumOrderQuantityType setMaximumOrderQuantity(
        @Nullable
        final BigDecimal valueParam) {
        MaximumOrderQuantityType aObj = getMaximumOrderQuantity();
        if (aObj == null) {
            aObj = new MaximumOrderQuantityType(valueParam);
            setMaximumOrderQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type OrderableUnitType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public OrderableUnitType setOrderableUnit(
        @Nullable
        final String valueParam) {
        OrderableUnitType aObj = getOrderableUnit();
        if (aObj == null) {
            aObj = new OrderableUnitType(valueParam);
            setOrderableUnit(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getQuantityValue() {
        QuantityType aObj = getQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LineExtensionAmountType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LineExtensionAmountType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getLineExtensionAmountValue() {
        LineExtensionAmountType aObj = getLineExtensionAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TotalTaxAmountType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalTaxAmountType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getTotalTaxAmountValue() {
        TotalTaxAmountType aObj = getTotalTaxAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OrderableUnitType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OrderableUnitType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getOrderableUnitValue() {
        OrderableUnitType aObj = getOrderableUnit();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ContentUnitQuantityType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ContentUnitQuantityType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getContentUnitQuantityValue() {
        ContentUnitQuantityType aObj = getContentUnitQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OrderQuantityIncrementNumericType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OrderQuantityIncrementNumericType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getOrderQuantityIncrementNumericValue() {
        OrderQuantityIncrementNumericType aObj = getOrderQuantityIncrementNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MinimumOrderQuantityType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MinimumOrderQuantityType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getMinimumOrderQuantityValue() {
        MinimumOrderQuantityType aObj = getMinimumOrderQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumOrderQuantityType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumOrderQuantityType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getMaximumOrderQuantityValue() {
        MaximumOrderQuantityType aObj = getMaximumOrderQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PackLevelCodeType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PackLevelCodeType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getPackLevelCodeValue() {
        PackLevelCodeType aObj = getPackLevelCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
