
package oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_21;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NameType;


/**
 * A single extension for private use.
 * 
 * <p>Java class for UBLExtensionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="UBLExtensionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Name" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}ExtensionAgencyID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}ExtensionAgencyName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}ExtensionVersionID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}ExtensionAgencyURI" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}ExtensionURI" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}ExtensionReasonCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}ExtensionReason" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}ExtensionContent"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "UBLExtensionType", propOrder = {
    "id",
    "name",
    "extensionAgencyID",
    "extensionAgencyName",
    "extensionVersionID",
    "extensionAgencyURI",
    "extensionURI",
    "extensionReasonCode",
    "extensionReason",
    "extensionContent"
})
@CodingStyleguideUnaware
public class UBLExtensionType implements Serializable, IExplicitlyCloneable
{

    /**
     * An identifier for the Extension assigned by the creator of the extension.
     * 
     */
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    /**
     * A name for the Extension assigned by the creator of the extension.
     * 
     */
    @XmlElement(name = "Name", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NameType name;
    /**
     * An agency that maintains one or more Extensions.
     * 
     */
    @XmlElement(name = "ExtensionAgencyID")
    private ExtensionAgencyIDType extensionAgencyID;
    /**
     * The name of the agency that maintains the Extension.
     * 
     */
    @XmlElement(name = "ExtensionAgencyName")
    private ExtensionAgencyNameType extensionAgencyName;
    /**
     * The version of the Extension.
     * 
     */
    @XmlElement(name = "ExtensionVersionID")
    private ExtensionVersionIDType extensionVersionID;
    /**
     * A URI for the Agency that maintains the Extension.
     * 
     */
    @XmlElement(name = "ExtensionAgencyURI")
    private ExtensionAgencyURIType extensionAgencyURI;
    /**
     * A URI for the Extension.
     * 
     */
    @XmlElement(name = "ExtensionURI")
    private ExtensionURIType extensionURI;
    /**
     * A code for reason the Extension is being included.
     * 
     */
    @XmlElement(name = "ExtensionReasonCode")
    private ExtensionReasonCodeType extensionReasonCode;
    /**
     * A description of the reason for the Extension.
     * 
     */
    @XmlElement(name = "ExtensionReason")
    private ExtensionReasonType extensionReason;
    /**
     * The definition of the extension content.
     * 
     */
    @XmlElement(name = "ExtensionContent", required = true)
    private ExtensionContentType extensionContent;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public UBLExtensionType() {
    }

    /**
     * An identifier for the Extension assigned by the creator of the extension.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     * @see #getID()
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * A name for the Extension assigned by the creator of the extension.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     * @see #getName()
     */
    public void setName(
        @Nullable
        NameType value) {
        this.name = value;
    }

    /**
     * An agency that maintains one or more Extensions.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionAgencyIDType }
     *     
     */
    @Nullable
    public ExtensionAgencyIDType getExtensionAgencyID() {
        return extensionAgencyID;
    }

    /**
     * Sets the value of the extensionAgencyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionAgencyIDType }
     *     
     * @see #getExtensionAgencyID()
     */
    public void setExtensionAgencyID(
        @Nullable
        ExtensionAgencyIDType value) {
        this.extensionAgencyID = value;
    }

    /**
     * The name of the agency that maintains the Extension.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionAgencyNameType }
     *     
     */
    @Nullable
    public ExtensionAgencyNameType getExtensionAgencyName() {
        return extensionAgencyName;
    }

    /**
     * Sets the value of the extensionAgencyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionAgencyNameType }
     *     
     * @see #getExtensionAgencyName()
     */
    public void setExtensionAgencyName(
        @Nullable
        ExtensionAgencyNameType value) {
        this.extensionAgencyName = value;
    }

    /**
     * The version of the Extension.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionVersionIDType }
     *     
     */
    @Nullable
    public ExtensionVersionIDType getExtensionVersionID() {
        return extensionVersionID;
    }

    /**
     * Sets the value of the extensionVersionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionVersionIDType }
     *     
     * @see #getExtensionVersionID()
     */
    public void setExtensionVersionID(
        @Nullable
        ExtensionVersionIDType value) {
        this.extensionVersionID = value;
    }

    /**
     * A URI for the Agency that maintains the Extension.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionAgencyURIType }
     *     
     */
    @Nullable
    public ExtensionAgencyURIType getExtensionAgencyURI() {
        return extensionAgencyURI;
    }

    /**
     * Sets the value of the extensionAgencyURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionAgencyURIType }
     *     
     * @see #getExtensionAgencyURI()
     */
    public void setExtensionAgencyURI(
        @Nullable
        ExtensionAgencyURIType value) {
        this.extensionAgencyURI = value;
    }

    /**
     * A URI for the Extension.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionURIType }
     *     
     */
    @Nullable
    public ExtensionURIType getExtensionURI() {
        return extensionURI;
    }

    /**
     * Sets the value of the extensionURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionURIType }
     *     
     * @see #getExtensionURI()
     */
    public void setExtensionURI(
        @Nullable
        ExtensionURIType value) {
        this.extensionURI = value;
    }

    /**
     * A code for reason the Extension is being included.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionReasonCodeType }
     *     
     */
    @Nullable
    public ExtensionReasonCodeType getExtensionReasonCode() {
        return extensionReasonCode;
    }

    /**
     * Sets the value of the extensionReasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionReasonCodeType }
     *     
     * @see #getExtensionReasonCode()
     */
    public void setExtensionReasonCode(
        @Nullable
        ExtensionReasonCodeType value) {
        this.extensionReasonCode = value;
    }

    /**
     * A description of the reason for the Extension.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionReasonType }
     *     
     */
    @Nullable
    public ExtensionReasonType getExtensionReason() {
        return extensionReason;
    }

    /**
     * Sets the value of the extensionReason property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionReasonType }
     *     
     * @see #getExtensionReason()
     */
    public void setExtensionReason(
        @Nullable
        ExtensionReasonType value) {
        this.extensionReason = value;
    }

    /**
     * The definition of the extension content.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionContentType }
     *     
     */
    @Nullable
    public ExtensionContentType getExtensionContent() {
        return extensionContent;
    }

    /**
     * Sets the value of the extensionContent property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionContentType }
     *     
     * @see #getExtensionContent()
     */
    public void setExtensionContent(
        @Nullable
        ExtensionContentType value) {
        this.extensionContent = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final UBLExtensionType rhs = ((UBLExtensionType) o);
        if (!EqualsHelper.equals(extensionAgencyID, rhs.extensionAgencyID)) {
            return false;
        }
        if (!EqualsHelper.equals(extensionAgencyName, rhs.extensionAgencyName)) {
            return false;
        }
        if (!EqualsHelper.equals(extensionAgencyURI, rhs.extensionAgencyURI)) {
            return false;
        }
        if (!EqualsHelper.equals(extensionContent, rhs.extensionContent)) {
            return false;
        }
        if (!EqualsHelper.equals(extensionReason, rhs.extensionReason)) {
            return false;
        }
        if (!EqualsHelper.equals(extensionReasonCode, rhs.extensionReasonCode)) {
            return false;
        }
        if (!EqualsHelper.equals(extensionURI, rhs.extensionURI)) {
            return false;
        }
        if (!EqualsHelper.equals(extensionVersionID, rhs.extensionVersionID)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(extensionAgencyID).append(extensionAgencyName).append(extensionAgencyURI).append(extensionContent).append(extensionReason).append(extensionReasonCode).append(extensionURI).append(extensionVersionID).append(id).append(name).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("extensionAgencyID", extensionAgencyID).append("extensionAgencyName", extensionAgencyName).append("extensionAgencyURI", extensionAgencyURI).append("extensionContent", extensionContent).append("extensionReason", extensionReason).append("extensionReasonCode", extensionReasonCode).append("extensionURI", extensionURI).append("extensionVersionID", extensionVersionID).append("id", id).append("name", name).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        UBLExtensionType ret) {
        ret.extensionAgencyID = ((extensionAgencyID == null)?null:extensionAgencyID.clone());
        ret.extensionAgencyName = ((extensionAgencyName == null)?null:extensionAgencyName.clone());
        ret.extensionAgencyURI = ((extensionAgencyURI == null)?null:extensionAgencyURI.clone());
        ret.extensionContent = ((extensionContent == null)?null:extensionContent.clone());
        ret.extensionReason = ((extensionReason == null)?null:extensionReason.clone());
        ret.extensionReasonCode = ((extensionReasonCode == null)?null:extensionReasonCode.clone());
        ret.extensionURI = ((extensionURI == null)?null:extensionURI.clone());
        ret.extensionVersionID = ((extensionVersionID == null)?null:extensionVersionID.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.name = ((name == null)?null:name.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public UBLExtensionType clone() {
        UBLExtensionType ret = new UBLExtensionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setName(
        @Nullable
        final String valueParam) {
        NameType aObj = getName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExtensionAgencyIDType and never <code>null</code>
     */
    @Nonnull
    public ExtensionAgencyIDType setExtensionAgencyID(
        @Nullable
        final String valueParam) {
        ExtensionAgencyIDType aObj = getExtensionAgencyID();
        if (aObj == null) {
            aObj = new ExtensionAgencyIDType(valueParam);
            setExtensionAgencyID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExtensionAgencyNameType and never <code>null</code>
     */
    @Nonnull
    public ExtensionAgencyNameType setExtensionAgencyName(
        @Nullable
        final String valueParam) {
        ExtensionAgencyNameType aObj = getExtensionAgencyName();
        if (aObj == null) {
            aObj = new ExtensionAgencyNameType(valueParam);
            setExtensionAgencyName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExtensionVersionIDType and never <code>null</code>
     */
    @Nonnull
    public ExtensionVersionIDType setExtensionVersionID(
        @Nullable
        final String valueParam) {
        ExtensionVersionIDType aObj = getExtensionVersionID();
        if (aObj == null) {
            aObj = new ExtensionVersionIDType(valueParam);
            setExtensionVersionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExtensionAgencyURIType and never <code>null</code>
     */
    @Nonnull
    public ExtensionAgencyURIType setExtensionAgencyURI(
        @Nullable
        final String valueParam) {
        ExtensionAgencyURIType aObj = getExtensionAgencyURI();
        if (aObj == null) {
            aObj = new ExtensionAgencyURIType(valueParam);
            setExtensionAgencyURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExtensionURIType and never <code>null</code>
     */
    @Nonnull
    public ExtensionURIType setExtensionURI(
        @Nullable
        final String valueParam) {
        ExtensionURIType aObj = getExtensionURI();
        if (aObj == null) {
            aObj = new ExtensionURIType(valueParam);
            setExtensionURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExtensionReasonCodeType and never <code>null</code>
     */
    @Nonnull
    public ExtensionReasonCodeType setExtensionReasonCode(
        @Nullable
        final String valueParam) {
        ExtensionReasonCodeType aObj = getExtensionReasonCode();
        if (aObj == null) {
            aObj = new ExtensionReasonCodeType(valueParam);
            setExtensionReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExtensionReasonType and never <code>null</code>
     */
    @Nonnull
    public ExtensionReasonType setExtensionReason(
        @Nullable
        final String valueParam) {
        ExtensionReasonType aObj = getExtensionReason();
        if (aObj == null) {
            aObj = new ExtensionReasonType(valueParam);
            setExtensionReason(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        NameType aObj = getName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExtensionAgencyIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExtensionAgencyIDType object or <code>null</code>
     */
    @Nullable
    public String getExtensionAgencyIDValue() {
        ExtensionAgencyIDType aObj = getExtensionAgencyID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExtensionAgencyNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExtensionAgencyNameType object or <code>null</code>
     */
    @Nullable
    public String getExtensionAgencyNameValue() {
        ExtensionAgencyNameType aObj = getExtensionAgencyName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExtensionVersionIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExtensionVersionIDType object or <code>null</code>
     */
    @Nullable
    public String getExtensionVersionIDValue() {
        ExtensionVersionIDType aObj = getExtensionVersionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExtensionAgencyURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExtensionAgencyURIType object or <code>null</code>
     */
    @Nullable
    public String getExtensionAgencyURIValue() {
        ExtensionAgencyURIType aObj = getExtensionAgencyURI();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExtensionURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExtensionURIType object or <code>null</code>
     */
    @Nullable
    public String getExtensionURIValue() {
        ExtensionURIType aObj = getExtensionURI();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExtensionReasonCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExtensionReasonCodeType object or <code>null</code>
     */
    @Nullable
    public String getExtensionReasonCodeValue() {
        ExtensionReasonCodeType aObj = getExtensionReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExtensionReasonType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExtensionReasonType object or <code>null</code>
     */
    @Nullable
    public String getExtensionReasonValue() {
        ExtensionReasonType aObj = getExtensionReason();
        return (aObj == null)?null:aObj.getValue();
    }

}
