
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EmbeddedDocumentBinaryObjectType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EmbeddedDocumentType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for AttachmentType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="AttachmentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EmbeddedDocumentBinaryObject" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EmbeddedDocument" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ExternalReference" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AttachmentType", propOrder = {
    "ublExtensions",
    "embeddedDocumentBinaryObject",
    "embeddedDocument",
    "externalReference"
})
@CodingStyleguideUnaware
public class AttachmentType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "EmbeddedDocumentBinaryObject", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EmbeddedDocumentBinaryObjectType embeddedDocumentBinaryObject;
    @XmlElement(name = "EmbeddedDocument", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EmbeddedDocumentType embeddedDocument;
    @XmlElement(name = "ExternalReference")
    private ExternalReferenceType externalReference;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public AttachmentType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the embeddedDocumentBinaryObject property.
     * 
     * @return
     *     possible object is
     *     {@link EmbeddedDocumentBinaryObjectType }
     *     
     */
    @Nullable
    public EmbeddedDocumentBinaryObjectType getEmbeddedDocumentBinaryObject() {
        return embeddedDocumentBinaryObject;
    }

    /**
     * Sets the value of the embeddedDocumentBinaryObject property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmbeddedDocumentBinaryObjectType }
     *     
     */
    public void setEmbeddedDocumentBinaryObject(
        @Nullable
        EmbeddedDocumentBinaryObjectType value) {
        this.embeddedDocumentBinaryObject = value;
    }

    /**
     * Gets the value of the embeddedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link EmbeddedDocumentType }
     *     
     */
    @Nullable
    public EmbeddedDocumentType getEmbeddedDocument() {
        return embeddedDocument;
    }

    /**
     * Sets the value of the embeddedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmbeddedDocumentType }
     *     
     */
    public void setEmbeddedDocument(
        @Nullable
        EmbeddedDocumentType value) {
        this.embeddedDocument = value;
    }

    /**
     * Gets the value of the externalReference property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalReferenceType }
     *     
     */
    @Nullable
    public ExternalReferenceType getExternalReference() {
        return externalReference;
    }

    /**
     * Sets the value of the externalReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalReferenceType }
     *     
     */
    public void setExternalReference(
        @Nullable
        ExternalReferenceType value) {
        this.externalReference = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AttachmentType rhs = ((AttachmentType) o);
        if (!EqualsHelper.equals(embeddedDocument, rhs.embeddedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(embeddedDocumentBinaryObject, rhs.embeddedDocumentBinaryObject)) {
            return false;
        }
        if (!EqualsHelper.equals(externalReference, rhs.externalReference)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(embeddedDocument).append(embeddedDocumentBinaryObject).append(externalReference).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("embeddedDocument", embeddedDocument).append("embeddedDocumentBinaryObject", embeddedDocumentBinaryObject).append("externalReference", externalReference).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        AttachmentType ret) {
        ret.embeddedDocument = ((embeddedDocument == null)?null:embeddedDocument.clone());
        ret.embeddedDocumentBinaryObject = ((embeddedDocumentBinaryObject == null)?null:embeddedDocumentBinaryObject.clone());
        ret.externalReference = ((externalReference == null)?null:externalReference.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AttachmentType clone() {
        AttachmentType ret = new AttachmentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EmbeddedDocumentBinaryObjectType and never <code>null</code>
     */
    @Nonnull
    public EmbeddedDocumentBinaryObjectType setEmbeddedDocumentBinaryObject(
        @Nullable
        final byte[] valueParam) {
        EmbeddedDocumentBinaryObjectType aObj = getEmbeddedDocumentBinaryObject();
        if (aObj == null) {
            aObj = new EmbeddedDocumentBinaryObjectType(valueParam);
            setEmbeddedDocumentBinaryObject(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EmbeddedDocumentType and never <code>null</code>
     */
    @Nonnull
    public EmbeddedDocumentType setEmbeddedDocument(
        @Nullable
        final String valueParam) {
        EmbeddedDocumentType aObj = getEmbeddedDocument();
        if (aObj == null) {
            aObj = new EmbeddedDocumentType(valueParam);
            setEmbeddedDocument(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained EmbeddedDocumentBinaryObjectType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EmbeddedDocumentBinaryObjectType object or <code>null</code>
     */
    @Nullable
    public byte[] getEmbeddedDocumentBinaryObjectValue() {
        EmbeddedDocumentBinaryObjectType aObj = getEmbeddedDocumentBinaryObject();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EmbeddedDocumentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EmbeddedDocumentType object or <code>null</code>
     */
    @Nullable
    public String getEmbeddedDocumentValue() {
        EmbeddedDocumentType aObj = getEmbeddedDocument();
        return (aObj == null)?null:aObj.getValue();
    }

}
