
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CV2IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CardChipCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CardTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ChipApplicationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ExpiryDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.HolderNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IssueNumberIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IssuerIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NetworkIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PrimaryAccountNumberIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RoleCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ValidityStartDateType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for CardAccountType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="CardAccountType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PrimaryAccountNumberID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NetworkID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CardTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ValidityStartDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExpiryDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}IssuerID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}IssueNumberID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CV2ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CardChipCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ChipApplicationID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HolderName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RoleCode" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CardAccountType", propOrder = {
    "ublExtensions",
    "primaryAccountNumberID",
    "networkID",
    "cardTypeCode",
    "validityStartDate",
    "expiryDate",
    "issuerID",
    "issueNumberID",
    "cv2ID",
    "cardChipCode",
    "chipApplicationID",
    "holderName",
    "roleCode"
})
@CodingStyleguideUnaware
public class CardAccountType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "PrimaryAccountNumberID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private PrimaryAccountNumberIDType primaryAccountNumberID;
    @XmlElement(name = "NetworkID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private NetworkIDType networkID;
    @XmlElement(name = "CardTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CardTypeCodeType cardTypeCode;
    @XmlElement(name = "ValidityStartDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ValidityStartDateType validityStartDate;
    @XmlElement(name = "ExpiryDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExpiryDateType expiryDate;
    @XmlElement(name = "IssuerID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IssuerIDType issuerID;
    @XmlElement(name = "IssueNumberID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IssueNumberIDType issueNumberID;
    @XmlElement(name = "CV2ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CV2IDType cv2ID;
    @XmlElement(name = "CardChipCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CardChipCodeType cardChipCode;
    @XmlElement(name = "ChipApplicationID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ChipApplicationIDType chipApplicationID;
    @XmlElement(name = "HolderName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HolderNameType holderName;
    @XmlElement(name = "RoleCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RoleCodeType roleCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public CardAccountType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the primaryAccountNumberID property.
     * 
     * @return
     *     possible object is
     *     {@link PrimaryAccountNumberIDType }
     *     
     */
    @Nullable
    public PrimaryAccountNumberIDType getPrimaryAccountNumberID() {
        return primaryAccountNumberID;
    }

    /**
     * Sets the value of the primaryAccountNumberID property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrimaryAccountNumberIDType }
     *     
     */
    public void setPrimaryAccountNumberID(
        @Nullable
        PrimaryAccountNumberIDType value) {
        this.primaryAccountNumberID = value;
    }

    /**
     * Gets the value of the networkID property.
     * 
     * @return
     *     possible object is
     *     {@link NetworkIDType }
     *     
     */
    @Nullable
    public NetworkIDType getNetworkID() {
        return networkID;
    }

    /**
     * Sets the value of the networkID property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetworkIDType }
     *     
     */
    public void setNetworkID(
        @Nullable
        NetworkIDType value) {
        this.networkID = value;
    }

    /**
     * Gets the value of the cardTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CardTypeCodeType }
     *     
     */
    @Nullable
    public CardTypeCodeType getCardTypeCode() {
        return cardTypeCode;
    }

    /**
     * Sets the value of the cardTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CardTypeCodeType }
     *     
     */
    public void setCardTypeCode(
        @Nullable
        CardTypeCodeType value) {
        this.cardTypeCode = value;
    }

    /**
     * Gets the value of the validityStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link ValidityStartDateType }
     *     
     */
    @Nullable
    public ValidityStartDateType getValidityStartDate() {
        return validityStartDate;
    }

    /**
     * Sets the value of the validityStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValidityStartDateType }
     *     
     */
    public void setValidityStartDate(
        @Nullable
        ValidityStartDateType value) {
        this.validityStartDate = value;
    }

    /**
     * Gets the value of the expiryDate property.
     * 
     * @return
     *     possible object is
     *     {@link ExpiryDateType }
     *     
     */
    @Nullable
    public ExpiryDateType getExpiryDate() {
        return expiryDate;
    }

    /**
     * Sets the value of the expiryDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExpiryDateType }
     *     
     */
    public void setExpiryDate(
        @Nullable
        ExpiryDateType value) {
        this.expiryDate = value;
    }

    /**
     * Gets the value of the issuerID property.
     * 
     * @return
     *     possible object is
     *     {@link IssuerIDType }
     *     
     */
    @Nullable
    public IssuerIDType getIssuerID() {
        return issuerID;
    }

    /**
     * Sets the value of the issuerID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IssuerIDType }
     *     
     */
    public void setIssuerID(
        @Nullable
        IssuerIDType value) {
        this.issuerID = value;
    }

    /**
     * Gets the value of the issueNumberID property.
     * 
     * @return
     *     possible object is
     *     {@link IssueNumberIDType }
     *     
     */
    @Nullable
    public IssueNumberIDType getIssueNumberID() {
        return issueNumberID;
    }

    /**
     * Sets the value of the issueNumberID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IssueNumberIDType }
     *     
     */
    public void setIssueNumberID(
        @Nullable
        IssueNumberIDType value) {
        this.issueNumberID = value;
    }

    /**
     * Gets the value of the cv2ID property.
     * 
     * @return
     *     possible object is
     *     {@link CV2IDType }
     *     
     */
    @Nullable
    public CV2IDType getCV2ID() {
        return cv2ID;
    }

    /**
     * Sets the value of the cv2ID property.
     * 
     * @param value
     *     allowed object is
     *     {@link CV2IDType }
     *     
     */
    public void setCV2ID(
        @Nullable
        CV2IDType value) {
        this.cv2ID = value;
    }

    /**
     * Gets the value of the cardChipCode property.
     * 
     * @return
     *     possible object is
     *     {@link CardChipCodeType }
     *     
     */
    @Nullable
    public CardChipCodeType getCardChipCode() {
        return cardChipCode;
    }

    /**
     * Sets the value of the cardChipCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CardChipCodeType }
     *     
     */
    public void setCardChipCode(
        @Nullable
        CardChipCodeType value) {
        this.cardChipCode = value;
    }

    /**
     * Gets the value of the chipApplicationID property.
     * 
     * @return
     *     possible object is
     *     {@link ChipApplicationIDType }
     *     
     */
    @Nullable
    public ChipApplicationIDType getChipApplicationID() {
        return chipApplicationID;
    }

    /**
     * Sets the value of the chipApplicationID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChipApplicationIDType }
     *     
     */
    public void setChipApplicationID(
        @Nullable
        ChipApplicationIDType value) {
        this.chipApplicationID = value;
    }

    /**
     * Gets the value of the holderName property.
     * 
     * @return
     *     possible object is
     *     {@link HolderNameType }
     *     
     */
    @Nullable
    public HolderNameType getHolderName() {
        return holderName;
    }

    /**
     * Sets the value of the holderName property.
     * 
     * @param value
     *     allowed object is
     *     {@link HolderNameType }
     *     
     */
    public void setHolderName(
        @Nullable
        HolderNameType value) {
        this.holderName = value;
    }

    /**
     * Gets the value of the roleCode property.
     * 
     * @return
     *     possible object is
     *     {@link RoleCodeType }
     *     
     */
    @Nullable
    public RoleCodeType getRoleCode() {
        return roleCode;
    }

    /**
     * Sets the value of the roleCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link RoleCodeType }
     *     
     */
    public void setRoleCode(
        @Nullable
        RoleCodeType value) {
        this.roleCode = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CardAccountType rhs = ((CardAccountType) o);
        if (!EqualsHelper.equals(cardChipCode, rhs.cardChipCode)) {
            return false;
        }
        if (!EqualsHelper.equals(cardTypeCode, rhs.cardTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(chipApplicationID, rhs.chipApplicationID)) {
            return false;
        }
        if (!EqualsHelper.equals(cv2ID, rhs.cv2ID)) {
            return false;
        }
        if (!EqualsHelper.equals(expiryDate, rhs.expiryDate)) {
            return false;
        }
        if (!EqualsHelper.equals(holderName, rhs.holderName)) {
            return false;
        }
        if (!EqualsHelper.equals(issueNumberID, rhs.issueNumberID)) {
            return false;
        }
        if (!EqualsHelper.equals(issuerID, rhs.issuerID)) {
            return false;
        }
        if (!EqualsHelper.equals(networkID, rhs.networkID)) {
            return false;
        }
        if (!EqualsHelper.equals(primaryAccountNumberID, rhs.primaryAccountNumberID)) {
            return false;
        }
        if (!EqualsHelper.equals(roleCode, rhs.roleCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(validityStartDate, rhs.validityStartDate)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(cardChipCode).append(cardTypeCode).append(chipApplicationID).append(cv2ID).append(expiryDate).append(holderName).append(issueNumberID).append(issuerID).append(networkID).append(primaryAccountNumberID).append(roleCode).append(ublExtensions).append(validityStartDate).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("cardChipCode", cardChipCode).append("cardTypeCode", cardTypeCode).append("chipApplicationID", chipApplicationID).append("cv2ID", cv2ID).append("expiryDate", expiryDate).append("holderName", holderName).append("issueNumberID", issueNumberID).append("issuerID", issuerID).append("networkID", networkID).append("primaryAccountNumberID", primaryAccountNumberID).append("roleCode", roleCode).append("ublExtensions", ublExtensions).append("validityStartDate", validityStartDate).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CardAccountType ret) {
        ret.cardChipCode = ((cardChipCode == null)?null:cardChipCode.clone());
        ret.cardTypeCode = ((cardTypeCode == null)?null:cardTypeCode.clone());
        ret.chipApplicationID = ((chipApplicationID == null)?null:chipApplicationID.clone());
        ret.cv2ID = ((cv2ID == null)?null:cv2ID.clone());
        ret.expiryDate = ((expiryDate == null)?null:expiryDate.clone());
        ret.holderName = ((holderName == null)?null:holderName.clone());
        ret.issueNumberID = ((issueNumberID == null)?null:issueNumberID.clone());
        ret.issuerID = ((issuerID == null)?null:issuerID.clone());
        ret.networkID = ((networkID == null)?null:networkID.clone());
        ret.primaryAccountNumberID = ((primaryAccountNumberID == null)?null:primaryAccountNumberID.clone());
        ret.roleCode = ((roleCode == null)?null:roleCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.validityStartDate = ((validityStartDate == null)?null:validityStartDate.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CardAccountType clone() {
        CardAccountType ret = new CardAccountType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PrimaryAccountNumberIDType and never <code>null</code>
     */
    @Nonnull
    public PrimaryAccountNumberIDType setPrimaryAccountNumberID(
        @Nullable
        final String valueParam) {
        PrimaryAccountNumberIDType aObj = getPrimaryAccountNumberID();
        if (aObj == null) {
            aObj = new PrimaryAccountNumberIDType(valueParam);
            setPrimaryAccountNumberID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NetworkIDType and never <code>null</code>
     */
    @Nonnull
    public NetworkIDType setNetworkID(
        @Nullable
        final String valueParam) {
        NetworkIDType aObj = getNetworkID();
        if (aObj == null) {
            aObj = new NetworkIDType(valueParam);
            setNetworkID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CardTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public CardTypeCodeType setCardTypeCode(
        @Nullable
        final String valueParam) {
        CardTypeCodeType aObj = getCardTypeCode();
        if (aObj == null) {
            aObj = new CardTypeCodeType(valueParam);
            setCardTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ValidityStartDateType and never <code>null</code>
     */
    @Nonnull
    public ValidityStartDateType setValidityStartDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ValidityStartDateType aObj = getValidityStartDate();
        if (aObj == null) {
            aObj = new ValidityStartDateType(valueParam);
            setValidityStartDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ValidityStartDateType and never <code>null</code>
     */
    @Nonnull
    public ValidityStartDateType setValidityStartDate(
        @Nullable
        final LocalDate valueParam) {
        ValidityStartDateType aObj = getValidityStartDate();
        if (aObj == null) {
            aObj = new ValidityStartDateType(valueParam);
            setValidityStartDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExpiryDateType and never <code>null</code>
     */
    @Nonnull
    public ExpiryDateType setExpiryDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ExpiryDateType aObj = getExpiryDate();
        if (aObj == null) {
            aObj = new ExpiryDateType(valueParam);
            setExpiryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExpiryDateType and never <code>null</code>
     */
    @Nonnull
    public ExpiryDateType setExpiryDate(
        @Nullable
        final LocalDate valueParam) {
        ExpiryDateType aObj = getExpiryDate();
        if (aObj == null) {
            aObj = new ExpiryDateType(valueParam);
            setExpiryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssuerIDType and never <code>null</code>
     */
    @Nonnull
    public IssuerIDType setIssuerID(
        @Nullable
        final String valueParam) {
        IssuerIDType aObj = getIssuerID();
        if (aObj == null) {
            aObj = new IssuerIDType(valueParam);
            setIssuerID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueNumberIDType and never <code>null</code>
     */
    @Nonnull
    public IssueNumberIDType setIssueNumberID(
        @Nullable
        final String valueParam) {
        IssueNumberIDType aObj = getIssueNumberID();
        if (aObj == null) {
            aObj = new IssueNumberIDType(valueParam);
            setIssueNumberID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CV2IDType and never <code>null</code>
     */
    @Nonnull
    public CV2IDType setCV2ID(
        @Nullable
        final String valueParam) {
        CV2IDType aObj = getCV2ID();
        if (aObj == null) {
            aObj = new CV2IDType(valueParam);
            setCV2ID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CardChipCodeType and never <code>null</code>
     */
    @Nonnull
    public CardChipCodeType setCardChipCode(
        @Nullable
        final String valueParam) {
        CardChipCodeType aObj = getCardChipCode();
        if (aObj == null) {
            aObj = new CardChipCodeType(valueParam);
            setCardChipCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChipApplicationIDType and never <code>null</code>
     */
    @Nonnull
    public ChipApplicationIDType setChipApplicationID(
        @Nullable
        final String valueParam) {
        ChipApplicationIDType aObj = getChipApplicationID();
        if (aObj == null) {
            aObj = new ChipApplicationIDType(valueParam);
            setChipApplicationID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type HolderNameType and never <code>null</code>
     */
    @Nonnull
    public HolderNameType setHolderName(
        @Nullable
        final String valueParam) {
        HolderNameType aObj = getHolderName();
        if (aObj == null) {
            aObj = new HolderNameType(valueParam);
            setHolderName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RoleCodeType and never <code>null</code>
     */
    @Nonnull
    public RoleCodeType setRoleCode(
        @Nullable
        final String valueParam) {
        RoleCodeType aObj = getRoleCode();
        if (aObj == null) {
            aObj = new RoleCodeType(valueParam);
            setRoleCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained PrimaryAccountNumberIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PrimaryAccountNumberIDType object or <code>null</code>
     */
    @Nullable
    public String getPrimaryAccountNumberIDValue() {
        PrimaryAccountNumberIDType aObj = getPrimaryAccountNumberID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NetworkIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NetworkIDType object or <code>null</code>
     */
    @Nullable
    public String getNetworkIDValue() {
        NetworkIDType aObj = getNetworkID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CardTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CardTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getCardTypeCodeValue() {
        CardTypeCodeType aObj = getCardTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ValidityStartDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ValidityStartDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getValidityStartDateValue() {
        ValidityStartDateType aObj = getValidityStartDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ValidityStartDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ValidityStartDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getValidityStartDateValueLocal() {
        ValidityStartDateType aObj = getValidityStartDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ExpiryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExpiryDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getExpiryDateValue() {
        ExpiryDateType aObj = getExpiryDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExpiryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExpiryDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getExpiryDateValueLocal() {
        ExpiryDateType aObj = getExpiryDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained IssuerIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssuerIDType object or <code>null</code>
     */
    @Nullable
    public String getIssuerIDValue() {
        IssuerIDType aObj = getIssuerID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IssueNumberIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueNumberIDType object or <code>null</code>
     */
    @Nullable
    public String getIssueNumberIDValue() {
        IssueNumberIDType aObj = getIssueNumberID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CV2IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CV2IDType object or <code>null</code>
     */
    @Nullable
    public String getCV2IDValue() {
        CV2IDType aObj = getCV2ID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CardChipCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CardChipCodeType object or <code>null</code>
     */
    @Nullable
    public String getCardChipCodeValue() {
        CardChipCodeType aObj = getCardChipCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ChipApplicationIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChipApplicationIDType object or <code>null</code>
     */
    @Nullable
    public String getChipApplicationIDValue() {
        ChipApplicationIDType aObj = getChipApplicationID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HolderNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained HolderNameType object or <code>null</code>
     */
    @Nullable
    public String getHolderNameValue() {
        HolderNameType aObj = getHolderName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RoleCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RoleCodeType object or <code>null</code>
     */
    @Nullable
    public String getRoleCodeValue() {
        RoleCodeType aObj = getRoleCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
