
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ActualTemperatureReductionQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ConsumptionEnergyQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ConsumptionWaterQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CorrectionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CorrectionTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CorrectionTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CorrectionUnitAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DifferenceTemperatureReductionQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.GasPressureQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MeterNumberType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NormalTemperatureReductionQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for ConsumptionCorrectionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ConsumptionCorrectionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CorrectionType" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CorrectionTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MeterNumber" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GasPressureQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ActualTemperatureReductionQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NormalTemperatureReductionQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DifferenceTemperatureReductionQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CorrectionUnitAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ConsumptionEnergyQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ConsumptionWaterQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CorrectionAmount" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConsumptionCorrectionType", propOrder = {
    "ublExtensions",
    "correctionType",
    "correctionTypeCode",
    "meterNumber",
    "gasPressureQuantity",
    "actualTemperatureReductionQuantity",
    "normalTemperatureReductionQuantity",
    "differenceTemperatureReductionQuantity",
    "description",
    "correctionUnitAmount",
    "consumptionEnergyQuantity",
    "consumptionWaterQuantity",
    "correctionAmount"
})
@CodingStyleguideUnaware
public class ConsumptionCorrectionType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "CorrectionType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CorrectionTypeType correctionType;
    @XmlElement(name = "CorrectionTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CorrectionTypeCodeType correctionTypeCode;
    @XmlElement(name = "MeterNumber", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MeterNumberType meterNumber;
    @XmlElement(name = "GasPressureQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GasPressureQuantityType gasPressureQuantity;
    @XmlElement(name = "ActualTemperatureReductionQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ActualTemperatureReductionQuantityType actualTemperatureReductionQuantity;
    @XmlElement(name = "NormalTemperatureReductionQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NormalTemperatureReductionQuantityType normalTemperatureReductionQuantity;
    @XmlElement(name = "DifferenceTemperatureReductionQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DifferenceTemperatureReductionQuantityType differenceTemperatureReductionQuantity;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "CorrectionUnitAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CorrectionUnitAmountType correctionUnitAmount;
    @XmlElement(name = "ConsumptionEnergyQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ConsumptionEnergyQuantityType consumptionEnergyQuantity;
    @XmlElement(name = "ConsumptionWaterQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ConsumptionWaterQuantityType consumptionWaterQuantity;
    @XmlElement(name = "CorrectionAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CorrectionAmountType correctionAmount;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ConsumptionCorrectionType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the correctionType property.
     * 
     * @return
     *     possible object is
     *     {@link CorrectionTypeType }
     *     
     */
    @Nullable
    public CorrectionTypeType getCorrectionType() {
        return correctionType;
    }

    /**
     * Sets the value of the correctionType property.
     * 
     * @param value
     *     allowed object is
     *     {@link CorrectionTypeType }
     *     
     */
    public void setCorrectionType(
        @Nullable
        CorrectionTypeType value) {
        this.correctionType = value;
    }

    /**
     * Gets the value of the correctionTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CorrectionTypeCodeType }
     *     
     */
    @Nullable
    public CorrectionTypeCodeType getCorrectionTypeCode() {
        return correctionTypeCode;
    }

    /**
     * Sets the value of the correctionTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CorrectionTypeCodeType }
     *     
     */
    public void setCorrectionTypeCode(
        @Nullable
        CorrectionTypeCodeType value) {
        this.correctionTypeCode = value;
    }

    /**
     * Gets the value of the meterNumber property.
     * 
     * @return
     *     possible object is
     *     {@link MeterNumberType }
     *     
     */
    @Nullable
    public MeterNumberType getMeterNumber() {
        return meterNumber;
    }

    /**
     * Sets the value of the meterNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeterNumberType }
     *     
     */
    public void setMeterNumber(
        @Nullable
        MeterNumberType value) {
        this.meterNumber = value;
    }

    /**
     * Gets the value of the gasPressureQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link GasPressureQuantityType }
     *     
     */
    @Nullable
    public GasPressureQuantityType getGasPressureQuantity() {
        return gasPressureQuantity;
    }

    /**
     * Sets the value of the gasPressureQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link GasPressureQuantityType }
     *     
     */
    public void setGasPressureQuantity(
        @Nullable
        GasPressureQuantityType value) {
        this.gasPressureQuantity = value;
    }

    /**
     * Gets the value of the actualTemperatureReductionQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ActualTemperatureReductionQuantityType }
     *     
     */
    @Nullable
    public ActualTemperatureReductionQuantityType getActualTemperatureReductionQuantity() {
        return actualTemperatureReductionQuantity;
    }

    /**
     * Sets the value of the actualTemperatureReductionQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActualTemperatureReductionQuantityType }
     *     
     */
    public void setActualTemperatureReductionQuantity(
        @Nullable
        ActualTemperatureReductionQuantityType value) {
        this.actualTemperatureReductionQuantity = value;
    }

    /**
     * Gets the value of the normalTemperatureReductionQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link NormalTemperatureReductionQuantityType }
     *     
     */
    @Nullable
    public NormalTemperatureReductionQuantityType getNormalTemperatureReductionQuantity() {
        return normalTemperatureReductionQuantity;
    }

    /**
     * Sets the value of the normalTemperatureReductionQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link NormalTemperatureReductionQuantityType }
     *     
     */
    public void setNormalTemperatureReductionQuantity(
        @Nullable
        NormalTemperatureReductionQuantityType value) {
        this.normalTemperatureReductionQuantity = value;
    }

    /**
     * Gets the value of the differenceTemperatureReductionQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link DifferenceTemperatureReductionQuantityType }
     *     
     */
    @Nullable
    public DifferenceTemperatureReductionQuantityType getDifferenceTemperatureReductionQuantity() {
        return differenceTemperatureReductionQuantity;
    }

    /**
     * Sets the value of the differenceTemperatureReductionQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link DifferenceTemperatureReductionQuantityType }
     *     
     */
    public void setDifferenceTemperatureReductionQuantity(
        @Nullable
        DifferenceTemperatureReductionQuantityType value) {
        this.differenceTemperatureReductionQuantity = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the correctionUnitAmount property.
     * 
     * @return
     *     possible object is
     *     {@link CorrectionUnitAmountType }
     *     
     */
    @Nullable
    public CorrectionUnitAmountType getCorrectionUnitAmount() {
        return correctionUnitAmount;
    }

    /**
     * Sets the value of the correctionUnitAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link CorrectionUnitAmountType }
     *     
     */
    public void setCorrectionUnitAmount(
        @Nullable
        CorrectionUnitAmountType value) {
        this.correctionUnitAmount = value;
    }

    /**
     * Gets the value of the consumptionEnergyQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ConsumptionEnergyQuantityType }
     *     
     */
    @Nullable
    public ConsumptionEnergyQuantityType getConsumptionEnergyQuantity() {
        return consumptionEnergyQuantity;
    }

    /**
     * Sets the value of the consumptionEnergyQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConsumptionEnergyQuantityType }
     *     
     */
    public void setConsumptionEnergyQuantity(
        @Nullable
        ConsumptionEnergyQuantityType value) {
        this.consumptionEnergyQuantity = value;
    }

    /**
     * Gets the value of the consumptionWaterQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ConsumptionWaterQuantityType }
     *     
     */
    @Nullable
    public ConsumptionWaterQuantityType getConsumptionWaterQuantity() {
        return consumptionWaterQuantity;
    }

    /**
     * Sets the value of the consumptionWaterQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConsumptionWaterQuantityType }
     *     
     */
    public void setConsumptionWaterQuantity(
        @Nullable
        ConsumptionWaterQuantityType value) {
        this.consumptionWaterQuantity = value;
    }

    /**
     * Gets the value of the correctionAmount property.
     * 
     * @return
     *     possible object is
     *     {@link CorrectionAmountType }
     *     
     */
    @Nullable
    public CorrectionAmountType getCorrectionAmount() {
        return correctionAmount;
    }

    /**
     * Sets the value of the correctionAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link CorrectionAmountType }
     *     
     */
    public void setCorrectionAmount(
        @Nullable
        CorrectionAmountType value) {
        this.correctionAmount = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ConsumptionCorrectionType rhs = ((ConsumptionCorrectionType) o);
        if (!EqualsHelper.equals(actualTemperatureReductionQuantity, rhs.actualTemperatureReductionQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(consumptionEnergyQuantity, rhs.consumptionEnergyQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(consumptionWaterQuantity, rhs.consumptionWaterQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(correctionAmount, rhs.correctionAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(correctionType, rhs.correctionType)) {
            return false;
        }
        if (!EqualsHelper.equals(correctionTypeCode, rhs.correctionTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(correctionUnitAmount, rhs.correctionUnitAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(differenceTemperatureReductionQuantity, rhs.differenceTemperatureReductionQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(gasPressureQuantity, rhs.gasPressureQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(meterNumber, rhs.meterNumber)) {
            return false;
        }
        if (!EqualsHelper.equals(normalTemperatureReductionQuantity, rhs.normalTemperatureReductionQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualTemperatureReductionQuantity).append(consumptionEnergyQuantity).append(consumptionWaterQuantity).append(correctionAmount).append(correctionType).append(correctionTypeCode).append(correctionUnitAmount).append(description).append(differenceTemperatureReductionQuantity).append(gasPressureQuantity).append(meterNumber).append(normalTemperatureReductionQuantity).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualTemperatureReductionQuantity", actualTemperatureReductionQuantity).append("consumptionEnergyQuantity", consumptionEnergyQuantity).append("consumptionWaterQuantity", consumptionWaterQuantity).append("correctionAmount", correctionAmount).append("correctionType", correctionType).append("correctionTypeCode", correctionTypeCode).append("correctionUnitAmount", correctionUnitAmount).append("description", description).append("differenceTemperatureReductionQuantity", differenceTemperatureReductionQuantity).append("gasPressureQuantity", gasPressureQuantity).append("meterNumber", meterNumber).append("normalTemperatureReductionQuantity", normalTemperatureReductionQuantity).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ConsumptionCorrectionType ret) {
        ret.actualTemperatureReductionQuantity = ((actualTemperatureReductionQuantity == null)?null:actualTemperatureReductionQuantity.clone());
        ret.consumptionEnergyQuantity = ((consumptionEnergyQuantity == null)?null:consumptionEnergyQuantity.clone());
        ret.consumptionWaterQuantity = ((consumptionWaterQuantity == null)?null:consumptionWaterQuantity.clone());
        ret.correctionAmount = ((correctionAmount == null)?null:correctionAmount.clone());
        ret.correctionType = ((correctionType == null)?null:correctionType.clone());
        ret.correctionTypeCode = ((correctionTypeCode == null)?null:correctionTypeCode.clone());
        ret.correctionUnitAmount = ((correctionUnitAmount == null)?null:correctionUnitAmount.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.differenceTemperatureReductionQuantity = ((differenceTemperatureReductionQuantity == null)?null:differenceTemperatureReductionQuantity.clone());
        ret.gasPressureQuantity = ((gasPressureQuantity == null)?null:gasPressureQuantity.clone());
        ret.meterNumber = ((meterNumber == null)?null:meterNumber.clone());
        ret.normalTemperatureReductionQuantity = ((normalTemperatureReductionQuantity == null)?null:normalTemperatureReductionQuantity.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ConsumptionCorrectionType clone() {
        ConsumptionCorrectionType ret = new ConsumptionCorrectionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CorrectionTypeType and never <code>null</code>
     */
    @Nonnull
    public CorrectionTypeType setCorrectionType(
        @Nullable
        final String valueParam) {
        CorrectionTypeType aObj = getCorrectionType();
        if (aObj == null) {
            aObj = new CorrectionTypeType(valueParam);
            setCorrectionType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CorrectionTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public CorrectionTypeCodeType setCorrectionTypeCode(
        @Nullable
        final String valueParam) {
        CorrectionTypeCodeType aObj = getCorrectionTypeCode();
        if (aObj == null) {
            aObj = new CorrectionTypeCodeType(valueParam);
            setCorrectionTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeterNumberType and never <code>null</code>
     */
    @Nonnull
    public MeterNumberType setMeterNumber(
        @Nullable
        final String valueParam) {
        MeterNumberType aObj = getMeterNumber();
        if (aObj == null) {
            aObj = new MeterNumberType(valueParam);
            setMeterNumber(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GasPressureQuantityType and never <code>null</code>
     */
    @Nonnull
    public GasPressureQuantityType setGasPressureQuantity(
        @Nullable
        final BigDecimal valueParam) {
        GasPressureQuantityType aObj = getGasPressureQuantity();
        if (aObj == null) {
            aObj = new GasPressureQuantityType(valueParam);
            setGasPressureQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualTemperatureReductionQuantityType and never <code>null</code>
     */
    @Nonnull
    public ActualTemperatureReductionQuantityType setActualTemperatureReductionQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ActualTemperatureReductionQuantityType aObj = getActualTemperatureReductionQuantity();
        if (aObj == null) {
            aObj = new ActualTemperatureReductionQuantityType(valueParam);
            setActualTemperatureReductionQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NormalTemperatureReductionQuantityType and never <code>null</code>
     */
    @Nonnull
    public NormalTemperatureReductionQuantityType setNormalTemperatureReductionQuantity(
        @Nullable
        final BigDecimal valueParam) {
        NormalTemperatureReductionQuantityType aObj = getNormalTemperatureReductionQuantity();
        if (aObj == null) {
            aObj = new NormalTemperatureReductionQuantityType(valueParam);
            setNormalTemperatureReductionQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DifferenceTemperatureReductionQuantityType and never <code>null</code>
     */
    @Nonnull
    public DifferenceTemperatureReductionQuantityType setDifferenceTemperatureReductionQuantity(
        @Nullable
        final BigDecimal valueParam) {
        DifferenceTemperatureReductionQuantityType aObj = getDifferenceTemperatureReductionQuantity();
        if (aObj == null) {
            aObj = new DifferenceTemperatureReductionQuantityType(valueParam);
            setDifferenceTemperatureReductionQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CorrectionUnitAmountType and never <code>null</code>
     */
    @Nonnull
    public CorrectionUnitAmountType setCorrectionUnitAmount(
        @Nullable
        final BigDecimal valueParam) {
        CorrectionUnitAmountType aObj = getCorrectionUnitAmount();
        if (aObj == null) {
            aObj = new CorrectionUnitAmountType(valueParam);
            setCorrectionUnitAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ConsumptionEnergyQuantityType and never <code>null</code>
     */
    @Nonnull
    public ConsumptionEnergyQuantityType setConsumptionEnergyQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ConsumptionEnergyQuantityType aObj = getConsumptionEnergyQuantity();
        if (aObj == null) {
            aObj = new ConsumptionEnergyQuantityType(valueParam);
            setConsumptionEnergyQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ConsumptionWaterQuantityType and never <code>null</code>
     */
    @Nonnull
    public ConsumptionWaterQuantityType setConsumptionWaterQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ConsumptionWaterQuantityType aObj = getConsumptionWaterQuantity();
        if (aObj == null) {
            aObj = new ConsumptionWaterQuantityType(valueParam);
            setConsumptionWaterQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CorrectionAmountType and never <code>null</code>
     */
    @Nonnull
    public CorrectionAmountType setCorrectionAmount(
        @Nullable
        final BigDecimal valueParam) {
        CorrectionAmountType aObj = getCorrectionAmount();
        if (aObj == null) {
            aObj = new CorrectionAmountType(valueParam);
            setCorrectionAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CorrectionTypeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CorrectionTypeType object or <code>null</code>
     */
    @Nullable
    public String getCorrectionTypeValue() {
        CorrectionTypeType aObj = getCorrectionType();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CorrectionTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CorrectionTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getCorrectionTypeCodeValue() {
        CorrectionTypeCodeType aObj = getCorrectionTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeterNumberType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeterNumberType object or <code>null</code>
     */
    @Nullable
    public String getMeterNumberValue() {
        MeterNumberType aObj = getMeterNumber();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GasPressureQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GasPressureQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGasPressureQuantityValue() {
        GasPressureQuantityType aObj = getGasPressureQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ActualTemperatureReductionQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualTemperatureReductionQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getActualTemperatureReductionQuantityValue() {
        ActualTemperatureReductionQuantityType aObj = getActualTemperatureReductionQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NormalTemperatureReductionQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NormalTemperatureReductionQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNormalTemperatureReductionQuantityValue() {
        NormalTemperatureReductionQuantityType aObj = getNormalTemperatureReductionQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DifferenceTemperatureReductionQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DifferenceTemperatureReductionQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDifferenceTemperatureReductionQuantityValue() {
        DifferenceTemperatureReductionQuantityType aObj = getDifferenceTemperatureReductionQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CorrectionUnitAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CorrectionUnitAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCorrectionUnitAmountValue() {
        CorrectionUnitAmountType aObj = getCorrectionUnitAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ConsumptionEnergyQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ConsumptionEnergyQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getConsumptionEnergyQuantityValue() {
        ConsumptionEnergyQuantityType aObj = getConsumptionEnergyQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ConsumptionWaterQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ConsumptionWaterQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getConsumptionWaterQuantityValue() {
        ConsumptionWaterQuantityType aObj = getConsumptionWaterQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CorrectionAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CorrectionAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCorrectionAmountValue() {
        CorrectionAmountType aObj = getCorrectionAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
