
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.BasicConsumedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ConsumersEnergyLevelCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ConsumersEnergyLevelType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ConsumptionTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ConsumptionTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.HeatingTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.HeatingTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResidenceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResidenceTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResidentOccupantsNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TotalConsumedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for ConsumptionReportType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ConsumptionReportType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ConsumptionType" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ConsumptionTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalConsumedQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BasicConsumedQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResidentOccupantsNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ConsumersEnergyLevelCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ConsumersEnergyLevel" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResidenceType" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResidenceTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HeatingType" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HeatingTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Period" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}GuidanceDocumentReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ConsumptionReportReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ConsumptionHistory" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConsumptionReportType", propOrder = {
    "ublExtensions",
    "id",
    "consumptionType",
    "consumptionTypeCode",
    "description",
    "totalConsumedQuantity",
    "basicConsumedQuantity",
    "residentOccupantsNumeric",
    "consumersEnergyLevelCode",
    "consumersEnergyLevel",
    "residenceType",
    "residenceTypeCode",
    "heatingType",
    "heatingTypeCode",
    "period",
    "guidanceDocumentReference",
    "documentReference",
    "consumptionReportReference",
    "consumptionHistory"
})
@CodingStyleguideUnaware
public class ConsumptionReportType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "ConsumptionType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ConsumptionTypeType consumptionType;
    @XmlElement(name = "ConsumptionTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ConsumptionTypeCodeType consumptionTypeCode;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "TotalConsumedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalConsumedQuantityType totalConsumedQuantity;
    @XmlElement(name = "BasicConsumedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private BasicConsumedQuantityType basicConsumedQuantity;
    @XmlElement(name = "ResidentOccupantsNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResidentOccupantsNumericType residentOccupantsNumeric;
    @XmlElement(name = "ConsumersEnergyLevelCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ConsumersEnergyLevelCodeType consumersEnergyLevelCode;
    @XmlElement(name = "ConsumersEnergyLevel", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ConsumersEnergyLevelType consumersEnergyLevel;
    @XmlElement(name = "ResidenceType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResidenceTypeType residenceType;
    @XmlElement(name = "ResidenceTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResidenceTypeCodeType residenceTypeCode;
    @XmlElement(name = "HeatingType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HeatingTypeType heatingType;
    @XmlElement(name = "HeatingTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HeatingTypeCodeType heatingTypeCode;
    @XmlElement(name = "Period")
    private PeriodType period;
    @XmlElement(name = "GuidanceDocumentReference")
    private DocumentReferenceType guidanceDocumentReference;
    @XmlElement(name = "DocumentReference")
    private DocumentReferenceType documentReference;
    @XmlElement(name = "ConsumptionReportReference")
    private List<ConsumptionReportReferenceType> consumptionReportReference;
    @XmlElement(name = "ConsumptionHistory")
    private List<ConsumptionHistoryType> consumptionHistory;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ConsumptionReportType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the consumptionType property.
     * 
     * @return
     *     possible object is
     *     {@link ConsumptionTypeType }
     *     
     */
    @Nullable
    public ConsumptionTypeType getConsumptionType() {
        return consumptionType;
    }

    /**
     * Sets the value of the consumptionType property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConsumptionTypeType }
     *     
     */
    public void setConsumptionType(
        @Nullable
        ConsumptionTypeType value) {
        this.consumptionType = value;
    }

    /**
     * Gets the value of the consumptionTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link ConsumptionTypeCodeType }
     *     
     */
    @Nullable
    public ConsumptionTypeCodeType getConsumptionTypeCode() {
        return consumptionTypeCode;
    }

    /**
     * Sets the value of the consumptionTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConsumptionTypeCodeType }
     *     
     */
    public void setConsumptionTypeCode(
        @Nullable
        ConsumptionTypeCodeType value) {
        this.consumptionTypeCode = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the totalConsumedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link TotalConsumedQuantityType }
     *     
     */
    @Nullable
    public TotalConsumedQuantityType getTotalConsumedQuantity() {
        return totalConsumedQuantity;
    }

    /**
     * Sets the value of the totalConsumedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalConsumedQuantityType }
     *     
     */
    public void setTotalConsumedQuantity(
        @Nullable
        TotalConsumedQuantityType value) {
        this.totalConsumedQuantity = value;
    }

    /**
     * Gets the value of the basicConsumedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link BasicConsumedQuantityType }
     *     
     */
    @Nullable
    public BasicConsumedQuantityType getBasicConsumedQuantity() {
        return basicConsumedQuantity;
    }

    /**
     * Sets the value of the basicConsumedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link BasicConsumedQuantityType }
     *     
     */
    public void setBasicConsumedQuantity(
        @Nullable
        BasicConsumedQuantityType value) {
        this.basicConsumedQuantity = value;
    }

    /**
     * Gets the value of the residentOccupantsNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link ResidentOccupantsNumericType }
     *     
     */
    @Nullable
    public ResidentOccupantsNumericType getResidentOccupantsNumeric() {
        return residentOccupantsNumeric;
    }

    /**
     * Sets the value of the residentOccupantsNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResidentOccupantsNumericType }
     *     
     */
    public void setResidentOccupantsNumeric(
        @Nullable
        ResidentOccupantsNumericType value) {
        this.residentOccupantsNumeric = value;
    }

    /**
     * Gets the value of the consumersEnergyLevelCode property.
     * 
     * @return
     *     possible object is
     *     {@link ConsumersEnergyLevelCodeType }
     *     
     */
    @Nullable
    public ConsumersEnergyLevelCodeType getConsumersEnergyLevelCode() {
        return consumersEnergyLevelCode;
    }

    /**
     * Sets the value of the consumersEnergyLevelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConsumersEnergyLevelCodeType }
     *     
     */
    public void setConsumersEnergyLevelCode(
        @Nullable
        ConsumersEnergyLevelCodeType value) {
        this.consumersEnergyLevelCode = value;
    }

    /**
     * Gets the value of the consumersEnergyLevel property.
     * 
     * @return
     *     possible object is
     *     {@link ConsumersEnergyLevelType }
     *     
     */
    @Nullable
    public ConsumersEnergyLevelType getConsumersEnergyLevel() {
        return consumersEnergyLevel;
    }

    /**
     * Sets the value of the consumersEnergyLevel property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConsumersEnergyLevelType }
     *     
     */
    public void setConsumersEnergyLevel(
        @Nullable
        ConsumersEnergyLevelType value) {
        this.consumersEnergyLevel = value;
    }

    /**
     * Gets the value of the residenceType property.
     * 
     * @return
     *     possible object is
     *     {@link ResidenceTypeType }
     *     
     */
    @Nullable
    public ResidenceTypeType getResidenceType() {
        return residenceType;
    }

    /**
     * Sets the value of the residenceType property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResidenceTypeType }
     *     
     */
    public void setResidenceType(
        @Nullable
        ResidenceTypeType value) {
        this.residenceType = value;
    }

    /**
     * Gets the value of the residenceTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link ResidenceTypeCodeType }
     *     
     */
    @Nullable
    public ResidenceTypeCodeType getResidenceTypeCode() {
        return residenceTypeCode;
    }

    /**
     * Sets the value of the residenceTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResidenceTypeCodeType }
     *     
     */
    public void setResidenceTypeCode(
        @Nullable
        ResidenceTypeCodeType value) {
        this.residenceTypeCode = value;
    }

    /**
     * Gets the value of the heatingType property.
     * 
     * @return
     *     possible object is
     *     {@link HeatingTypeType }
     *     
     */
    @Nullable
    public HeatingTypeType getHeatingType() {
        return heatingType;
    }

    /**
     * Sets the value of the heatingType property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeatingTypeType }
     *     
     */
    public void setHeatingType(
        @Nullable
        HeatingTypeType value) {
        this.heatingType = value;
    }

    /**
     * Gets the value of the heatingTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link HeatingTypeCodeType }
     *     
     */
    @Nullable
    public HeatingTypeCodeType getHeatingTypeCode() {
        return heatingTypeCode;
    }

    /**
     * Sets the value of the heatingTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeatingTypeCodeType }
     *     
     */
    public void setHeatingTypeCode(
        @Nullable
        HeatingTypeCodeType value) {
        this.heatingTypeCode = value;
    }

    /**
     * Gets the value of the period property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getPeriod() {
        return period;
    }

    /**
     * Sets the value of the period property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setPeriod(
        @Nullable
        PeriodType value) {
        this.period = value;
    }

    /**
     * Gets the value of the guidanceDocumentReference property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentReferenceType }
     *     
     */
    @Nullable
    public DocumentReferenceType getGuidanceDocumentReference() {
        return guidanceDocumentReference;
    }

    /**
     * Sets the value of the guidanceDocumentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentReferenceType }
     *     
     */
    public void setGuidanceDocumentReference(
        @Nullable
        DocumentReferenceType value) {
        this.guidanceDocumentReference = value;
    }

    /**
     * Gets the value of the documentReference property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentReferenceType }
     *     
     */
    @Nullable
    public DocumentReferenceType getDocumentReference() {
        return documentReference;
    }

    /**
     * Sets the value of the documentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentReferenceType }
     *     
     */
    public void setDocumentReference(
        @Nullable
        DocumentReferenceType value) {
        this.documentReference = value;
    }

    /**
     * Gets the value of the consumptionReportReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the consumptionReportReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getConsumptionReportReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConsumptionReportReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the consumptionReportReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ConsumptionReportReferenceType> getConsumptionReportReference() {
        if (consumptionReportReference == null) {
            consumptionReportReference = new ArrayList<>();
        }
        return this.consumptionReportReference;
    }

    /**
     * Gets the value of the consumptionHistory property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the consumptionHistory property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getConsumptionHistory().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConsumptionHistoryType }
     * </p>
     * 
     * 
     * @return
     *     The value of the consumptionHistory property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ConsumptionHistoryType> getConsumptionHistory() {
        if (consumptionHistory == null) {
            consumptionHistory = new ArrayList<>();
        }
        return this.consumptionHistory;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ConsumptionReportType rhs = ((ConsumptionReportType) o);
        if (!EqualsHelper.equals(basicConsumedQuantity, rhs.basicConsumedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(consumersEnergyLevel, rhs.consumersEnergyLevel)) {
            return false;
        }
        if (!EqualsHelper.equals(consumersEnergyLevelCode, rhs.consumersEnergyLevelCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(consumptionHistory, rhs.consumptionHistory)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(consumptionReportReference, rhs.consumptionReportReference)) {
            return false;
        }
        if (!EqualsHelper.equals(consumptionType, rhs.consumptionType)) {
            return false;
        }
        if (!EqualsHelper.equals(consumptionTypeCode, rhs.consumptionTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(documentReference, rhs.documentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(guidanceDocumentReference, rhs.guidanceDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(heatingType, rhs.heatingType)) {
            return false;
        }
        if (!EqualsHelper.equals(heatingTypeCode, rhs.heatingTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(period, rhs.period)) {
            return false;
        }
        if (!EqualsHelper.equals(residenceType, rhs.residenceType)) {
            return false;
        }
        if (!EqualsHelper.equals(residenceTypeCode, rhs.residenceTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(residentOccupantsNumeric, rhs.residentOccupantsNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(totalConsumedQuantity, rhs.totalConsumedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(basicConsumedQuantity).append(consumersEnergyLevel).append(consumersEnergyLevelCode).append(consumptionHistory).append(consumptionReportReference).append(consumptionType).append(consumptionTypeCode).append(description).append(documentReference).append(guidanceDocumentReference).append(heatingType).append(heatingTypeCode).append(id).append(period).append(residenceType).append(residenceTypeCode).append(residentOccupantsNumeric).append(totalConsumedQuantity).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("basicConsumedQuantity", basicConsumedQuantity).append("consumersEnergyLevel", consumersEnergyLevel).append("consumersEnergyLevelCode", consumersEnergyLevelCode).append("consumptionHistory", consumptionHistory).append("consumptionReportReference", consumptionReportReference).append("consumptionType", consumptionType).append("consumptionTypeCode", consumptionTypeCode).append("description", description).append("documentReference", documentReference).append("guidanceDocumentReference", guidanceDocumentReference).append("heatingType", heatingType).append("heatingTypeCode", heatingTypeCode).append("id", id).append("period", period).append("residenceType", residenceType).append("residenceTypeCode", residenceTypeCode).append("residentOccupantsNumeric", residentOccupantsNumeric).append("totalConsumedQuantity", totalConsumedQuantity).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConsumptionReportReference(
        @Nullable
        final List<ConsumptionReportReferenceType> aList) {
        consumptionReportReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConsumptionHistory(
        @Nullable
        final List<ConsumptionHistoryType> aList) {
        consumptionHistory = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConsumptionReportReferenceEntries() {
        return (!getConsumptionReportReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConsumptionReportReferenceEntries() {
        return getConsumptionReportReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConsumptionReportReferenceCount() {
        return getConsumptionReportReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ConsumptionReportReferenceType getConsumptionReportReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConsumptionReportReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConsumptionReportReference(
        @Nonnull
        final ConsumptionReportReferenceType elem) {
        getConsumptionReportReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConsumptionHistoryEntries() {
        return (!getConsumptionHistory().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConsumptionHistoryEntries() {
        return getConsumptionHistory().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConsumptionHistoryCount() {
        return getConsumptionHistory().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ConsumptionHistoryType getConsumptionHistoryAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConsumptionHistory().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConsumptionHistory(
        @Nonnull
        final ConsumptionHistoryType elem) {
        getConsumptionHistory().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ConsumptionReportType ret) {
        ret.basicConsumedQuantity = ((basicConsumedQuantity == null)?null:basicConsumedQuantity.clone());
        ret.consumersEnergyLevel = ((consumersEnergyLevel == null)?null:consumersEnergyLevel.clone());
        ret.consumersEnergyLevelCode = ((consumersEnergyLevelCode == null)?null:consumersEnergyLevelCode.clone());
        if (consumptionHistory == null) {
            ret.consumptionHistory = null;
        } else {
            List<ConsumptionHistoryType> retConsumptionHistory = new ArrayList<>();
            for (ConsumptionHistoryType aItem: getConsumptionHistory()) {
                retConsumptionHistory.add(((aItem == null)?null:aItem.clone()));
            }
            ret.consumptionHistory = retConsumptionHistory;
        }
        if (consumptionReportReference == null) {
            ret.consumptionReportReference = null;
        } else {
            List<ConsumptionReportReferenceType> retConsumptionReportReference = new ArrayList<>();
            for (ConsumptionReportReferenceType aItem: getConsumptionReportReference()) {
                retConsumptionReportReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.consumptionReportReference = retConsumptionReportReference;
        }
        ret.consumptionType = ((consumptionType == null)?null:consumptionType.clone());
        ret.consumptionTypeCode = ((consumptionTypeCode == null)?null:consumptionTypeCode.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.documentReference = ((documentReference == null)?null:documentReference.clone());
        ret.guidanceDocumentReference = ((guidanceDocumentReference == null)?null:guidanceDocumentReference.clone());
        ret.heatingType = ((heatingType == null)?null:heatingType.clone());
        ret.heatingTypeCode = ((heatingTypeCode == null)?null:heatingTypeCode.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.period = ((period == null)?null:period.clone());
        ret.residenceType = ((residenceType == null)?null:residenceType.clone());
        ret.residenceTypeCode = ((residenceTypeCode == null)?null:residenceTypeCode.clone());
        ret.residentOccupantsNumeric = ((residentOccupantsNumeric == null)?null:residentOccupantsNumeric.clone());
        ret.totalConsumedQuantity = ((totalConsumedQuantity == null)?null:totalConsumedQuantity.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ConsumptionReportType clone() {
        ConsumptionReportType ret = new ConsumptionReportType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ConsumptionTypeType and never <code>null</code>
     */
    @Nonnull
    public ConsumptionTypeType setConsumptionType(
        @Nullable
        final String valueParam) {
        ConsumptionTypeType aObj = getConsumptionType();
        if (aObj == null) {
            aObj = new ConsumptionTypeType(valueParam);
            setConsumptionType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ConsumptionTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public ConsumptionTypeCodeType setConsumptionTypeCode(
        @Nullable
        final String valueParam) {
        ConsumptionTypeCodeType aObj = getConsumptionTypeCode();
        if (aObj == null) {
            aObj = new ConsumptionTypeCodeType(valueParam);
            setConsumptionTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TotalConsumedQuantityType and never <code>null</code>
     */
    @Nonnull
    public TotalConsumedQuantityType setTotalConsumedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        TotalConsumedQuantityType aObj = getTotalConsumedQuantity();
        if (aObj == null) {
            aObj = new TotalConsumedQuantityType(valueParam);
            setTotalConsumedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BasicConsumedQuantityType and never <code>null</code>
     */
    @Nonnull
    public BasicConsumedQuantityType setBasicConsumedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        BasicConsumedQuantityType aObj = getBasicConsumedQuantity();
        if (aObj == null) {
            aObj = new BasicConsumedQuantityType(valueParam);
            setBasicConsumedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResidentOccupantsNumericType and never <code>null</code>
     */
    @Nonnull
    public ResidentOccupantsNumericType setResidentOccupantsNumeric(
        @Nullable
        final BigDecimal valueParam) {
        ResidentOccupantsNumericType aObj = getResidentOccupantsNumeric();
        if (aObj == null) {
            aObj = new ResidentOccupantsNumericType(valueParam);
            setResidentOccupantsNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ConsumersEnergyLevelCodeType and never <code>null</code>
     */
    @Nonnull
    public ConsumersEnergyLevelCodeType setConsumersEnergyLevelCode(
        @Nullable
        final String valueParam) {
        ConsumersEnergyLevelCodeType aObj = getConsumersEnergyLevelCode();
        if (aObj == null) {
            aObj = new ConsumersEnergyLevelCodeType(valueParam);
            setConsumersEnergyLevelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ConsumersEnergyLevelType and never <code>null</code>
     */
    @Nonnull
    public ConsumersEnergyLevelType setConsumersEnergyLevel(
        @Nullable
        final String valueParam) {
        ConsumersEnergyLevelType aObj = getConsumersEnergyLevel();
        if (aObj == null) {
            aObj = new ConsumersEnergyLevelType(valueParam);
            setConsumersEnergyLevel(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResidenceTypeType and never <code>null</code>
     */
    @Nonnull
    public ResidenceTypeType setResidenceType(
        @Nullable
        final String valueParam) {
        ResidenceTypeType aObj = getResidenceType();
        if (aObj == null) {
            aObj = new ResidenceTypeType(valueParam);
            setResidenceType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResidenceTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public ResidenceTypeCodeType setResidenceTypeCode(
        @Nullable
        final String valueParam) {
        ResidenceTypeCodeType aObj = getResidenceTypeCode();
        if (aObj == null) {
            aObj = new ResidenceTypeCodeType(valueParam);
            setResidenceTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type HeatingTypeType and never <code>null</code>
     */
    @Nonnull
    public HeatingTypeType setHeatingType(
        @Nullable
        final String valueParam) {
        HeatingTypeType aObj = getHeatingType();
        if (aObj == null) {
            aObj = new HeatingTypeType(valueParam);
            setHeatingType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type HeatingTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public HeatingTypeCodeType setHeatingTypeCode(
        @Nullable
        final String valueParam) {
        HeatingTypeCodeType aObj = getHeatingTypeCode();
        if (aObj == null) {
            aObj = new HeatingTypeCodeType(valueParam);
            setHeatingTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ConsumptionTypeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ConsumptionTypeType object or <code>null</code>
     */
    @Nullable
    public String getConsumptionTypeValue() {
        ConsumptionTypeType aObj = getConsumptionType();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ConsumptionTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ConsumptionTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getConsumptionTypeCodeValue() {
        ConsumptionTypeCodeType aObj = getConsumptionTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TotalConsumedQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalConsumedQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalConsumedQuantityValue() {
        TotalConsumedQuantityType aObj = getTotalConsumedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained BasicConsumedQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BasicConsumedQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBasicConsumedQuantityValue() {
        BasicConsumedQuantityType aObj = getBasicConsumedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResidentOccupantsNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResidentOccupantsNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getResidentOccupantsNumericValue() {
        ResidentOccupantsNumericType aObj = getResidentOccupantsNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ConsumersEnergyLevelCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ConsumersEnergyLevelCodeType object or <code>null</code>
     */
    @Nullable
    public String getConsumersEnergyLevelCodeValue() {
        ConsumersEnergyLevelCodeType aObj = getConsumersEnergyLevelCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ConsumersEnergyLevelType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ConsumersEnergyLevelType object or <code>null</code>
     */
    @Nullable
    public String getConsumersEnergyLevelValue() {
        ConsumersEnergyLevelType aObj = getConsumersEnergyLevel();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResidenceTypeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResidenceTypeType object or <code>null</code>
     */
    @Nullable
    public String getResidenceTypeValue() {
        ResidenceTypeType aObj = getResidenceType();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResidenceTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResidenceTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getResidenceTypeCodeValue() {
        ResidenceTypeCodeType aObj = getResidenceTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HeatingTypeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained HeatingTypeType object or <code>null</code>
     */
    @Nullable
    public String getHeatingTypeValue() {
        HeatingTypeType aObj = getHeatingType();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HeatingTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained HeatingTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getHeatingTypeCodeValue() {
        HeatingTypeCodeType aObj = getHeatingTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
