
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for CustomsDeclarationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="CustomsDeclarationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ValidityPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ApplicableTerritoryAddress" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Shipment" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CustomsExitOfficeLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}IssuerParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ConsignorParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ConsigneeParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FreightForwarderParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CustomsParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PreviousCustomsDeclaration" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CustomsDeclarationType", propOrder = {
    "ublExtensions",
    "id",
    "validityPeriod",
    "applicableTerritoryAddress",
    "shipment",
    "customsExitOfficeLocation",
    "issuerParty",
    "consignorParty",
    "consigneeParty",
    "freightForwarderParty",
    "customsParty",
    "previousCustomsDeclaration",
    "additionalDocumentReference"
})
@CodingStyleguideUnaware
public class CustomsDeclarationType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "ValidityPeriod")
    private PeriodType validityPeriod;
    @XmlElement(name = "ApplicableTerritoryAddress")
    private AddressType applicableTerritoryAddress;
    @XmlElement(name = "Shipment")
    private ShipmentType shipment;
    @XmlElement(name = "CustomsExitOfficeLocation")
    private LocationType customsExitOfficeLocation;
    @XmlElement(name = "IssuerParty")
    private PartyType issuerParty;
    @XmlElement(name = "ConsignorParty")
    private PartyType consignorParty;
    @XmlElement(name = "ConsigneeParty")
    private PartyType consigneeParty;
    @XmlElement(name = "FreightForwarderParty")
    private PartyType freightForwarderParty;
    @XmlElement(name = "CustomsParty")
    private PartyType customsParty;
    @XmlElement(name = "PreviousCustomsDeclaration")
    private CustomsDeclarationType previousCustomsDeclaration;
    @XmlElement(name = "AdditionalDocumentReference")
    private List<DocumentReferenceType> additionalDocumentReference;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public CustomsDeclarationType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the validityPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getValidityPeriod() {
        return validityPeriod;
    }

    /**
     * Sets the value of the validityPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setValidityPeriod(
        @Nullable
        PeriodType value) {
        this.validityPeriod = value;
    }

    /**
     * Gets the value of the applicableTerritoryAddress property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getApplicableTerritoryAddress() {
        return applicableTerritoryAddress;
    }

    /**
     * Sets the value of the applicableTerritoryAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setApplicableTerritoryAddress(
        @Nullable
        AddressType value) {
        this.applicableTerritoryAddress = value;
    }

    /**
     * Gets the value of the shipment property.
     * 
     * @return
     *     possible object is
     *     {@link ShipmentType }
     *     
     */
    @Nullable
    public ShipmentType getShipment() {
        return shipment;
    }

    /**
     * Sets the value of the shipment property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShipmentType }
     *     
     */
    public void setShipment(
        @Nullable
        ShipmentType value) {
        this.shipment = value;
    }

    /**
     * Gets the value of the customsExitOfficeLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getCustomsExitOfficeLocation() {
        return customsExitOfficeLocation;
    }

    /**
     * Sets the value of the customsExitOfficeLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setCustomsExitOfficeLocation(
        @Nullable
        LocationType value) {
        this.customsExitOfficeLocation = value;
    }

    /**
     * Gets the value of the issuerParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getIssuerParty() {
        return issuerParty;
    }

    /**
     * Sets the value of the issuerParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setIssuerParty(
        @Nullable
        PartyType value) {
        this.issuerParty = value;
    }

    /**
     * Gets the value of the consignorParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getConsignorParty() {
        return consignorParty;
    }

    /**
     * Sets the value of the consignorParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setConsignorParty(
        @Nullable
        PartyType value) {
        this.consignorParty = value;
    }

    /**
     * Gets the value of the consigneeParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getConsigneeParty() {
        return consigneeParty;
    }

    /**
     * Sets the value of the consigneeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setConsigneeParty(
        @Nullable
        PartyType value) {
        this.consigneeParty = value;
    }

    /**
     * Gets the value of the freightForwarderParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getFreightForwarderParty() {
        return freightForwarderParty;
    }

    /**
     * Sets the value of the freightForwarderParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setFreightForwarderParty(
        @Nullable
        PartyType value) {
        this.freightForwarderParty = value;
    }

    /**
     * Gets the value of the customsParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getCustomsParty() {
        return customsParty;
    }

    /**
     * Sets the value of the customsParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setCustomsParty(
        @Nullable
        PartyType value) {
        this.customsParty = value;
    }

    /**
     * Gets the value of the previousCustomsDeclaration property.
     * 
     * @return
     *     possible object is
     *     {@link CustomsDeclarationType }
     *     
     */
    @Nullable
    public CustomsDeclarationType getPreviousCustomsDeclaration() {
        return previousCustomsDeclaration;
    }

    /**
     * Sets the value of the previousCustomsDeclaration property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomsDeclarationType }
     *     
     */
    public void setPreviousCustomsDeclaration(
        @Nullable
        CustomsDeclarationType value) {
        this.previousCustomsDeclaration = value;
    }

    /**
     * Gets the value of the additionalDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getAdditionalDocumentReference() {
        if (additionalDocumentReference == null) {
            additionalDocumentReference = new ArrayList<>();
        }
        return this.additionalDocumentReference;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CustomsDeclarationType rhs = ((CustomsDeclarationType) o);
        if (!EqualsHelper.equalsCollection(additionalDocumentReference, rhs.additionalDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(applicableTerritoryAddress, rhs.applicableTerritoryAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(consigneeParty, rhs.consigneeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(consignorParty, rhs.consignorParty)) {
            return false;
        }
        if (!EqualsHelper.equals(customsExitOfficeLocation, rhs.customsExitOfficeLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(customsParty, rhs.customsParty)) {
            return false;
        }
        if (!EqualsHelper.equals(freightForwarderParty, rhs.freightForwarderParty)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(issuerParty, rhs.issuerParty)) {
            return false;
        }
        if (!EqualsHelper.equals(previousCustomsDeclaration, rhs.previousCustomsDeclaration)) {
            return false;
        }
        if (!EqualsHelper.equals(shipment, rhs.shipment)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(validityPeriod, rhs.validityPeriod)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalDocumentReference).append(applicableTerritoryAddress).append(consigneeParty).append(consignorParty).append(customsExitOfficeLocation).append(customsParty).append(freightForwarderParty).append(id).append(issuerParty).append(previousCustomsDeclaration).append(shipment).append(ublExtensions).append(validityPeriod).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalDocumentReference", additionalDocumentReference).append("applicableTerritoryAddress", applicableTerritoryAddress).append("consigneeParty", consigneeParty).append("consignorParty", consignorParty).append("customsExitOfficeLocation", customsExitOfficeLocation).append("customsParty", customsParty).append("freightForwarderParty", freightForwarderParty).append("id", id).append("issuerParty", issuerParty).append("previousCustomsDeclaration", previousCustomsDeclaration).append("shipment", shipment).append("ublExtensions", ublExtensions).append("validityPeriod", validityPeriod).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        additionalDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalDocumentReferenceEntries() {
        return (!getAdditionalDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalDocumentReferenceEntries() {
        return getAdditionalDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalDocumentReferenceCount() {
        return getAdditionalDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getAdditionalDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getAdditionalDocumentReference().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CustomsDeclarationType ret) {
        if (additionalDocumentReference == null) {
            ret.additionalDocumentReference = null;
        } else {
            List<DocumentReferenceType> retAdditionalDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getAdditionalDocumentReference()) {
                retAdditionalDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalDocumentReference = retAdditionalDocumentReference;
        }
        ret.applicableTerritoryAddress = ((applicableTerritoryAddress == null)?null:applicableTerritoryAddress.clone());
        ret.consigneeParty = ((consigneeParty == null)?null:consigneeParty.clone());
        ret.consignorParty = ((consignorParty == null)?null:consignorParty.clone());
        ret.customsExitOfficeLocation = ((customsExitOfficeLocation == null)?null:customsExitOfficeLocation.clone());
        ret.customsParty = ((customsParty == null)?null:customsParty.clone());
        ret.freightForwarderParty = ((freightForwarderParty == null)?null:freightForwarderParty.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.issuerParty = ((issuerParty == null)?null:issuerParty.clone());
        ret.previousCustomsDeclaration = ((previousCustomsDeclaration == null)?null:previousCustomsDeclaration.clone());
        ret.shipment = ((shipment == null)?null:shipment.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.validityPeriod = ((validityPeriod == null)?null:validityPeriod.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CustomsDeclarationType clone() {
        CustomsDeclarationType ret = new CustomsDeclarationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

}
