
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ActualDespatchDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ActualDespatchTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EstimatedDespatchDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EstimatedDespatchTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.GuaranteedDespatchDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.GuaranteedDespatchTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.InstructionsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ReleaseIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RequestedDespatchDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RequestedDespatchTimeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for DespatchType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DespatchType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RequestedDespatchDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RequestedDespatchTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedDespatchDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedDespatchTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ActualDespatchDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ActualDespatchTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GuaranteedDespatchDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GuaranteedDespatchTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReleaseID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Instructions" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DespatchAddress" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DespatchLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DespatchParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CarrierParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}NotifyParty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Contact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EstimatedDespatchPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RequestedDespatchPeriod" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DespatchType", propOrder = {
    "ublExtensions",
    "id",
    "requestedDespatchDate",
    "requestedDespatchTime",
    "estimatedDespatchDate",
    "estimatedDespatchTime",
    "actualDespatchDate",
    "actualDespatchTime",
    "guaranteedDespatchDate",
    "guaranteedDespatchTime",
    "releaseID",
    "instructions",
    "despatchAddress",
    "despatchLocation",
    "despatchParty",
    "carrierParty",
    "notifyParty",
    "contact",
    "estimatedDespatchPeriod",
    "requestedDespatchPeriod"
})
@CodingStyleguideUnaware
public class DespatchType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "RequestedDespatchDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RequestedDespatchDateType requestedDespatchDate;
    @XmlElement(name = "RequestedDespatchTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RequestedDespatchTimeType requestedDespatchTime;
    @XmlElement(name = "EstimatedDespatchDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EstimatedDespatchDateType estimatedDespatchDate;
    @XmlElement(name = "EstimatedDespatchTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EstimatedDespatchTimeType estimatedDespatchTime;
    @XmlElement(name = "ActualDespatchDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ActualDespatchDateType actualDespatchDate;
    @XmlElement(name = "ActualDespatchTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ActualDespatchTimeType actualDespatchTime;
    @XmlElement(name = "GuaranteedDespatchDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GuaranteedDespatchDateType guaranteedDespatchDate;
    @XmlElement(name = "GuaranteedDespatchTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GuaranteedDespatchTimeType guaranteedDespatchTime;
    @XmlElement(name = "ReleaseID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReleaseIDType releaseID;
    @XmlElement(name = "Instructions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<InstructionsType> instructions;
    @XmlElement(name = "DespatchAddress")
    private AddressType despatchAddress;
    @XmlElement(name = "DespatchLocation")
    private LocationType despatchLocation;
    @XmlElement(name = "DespatchParty")
    private PartyType despatchParty;
    @XmlElement(name = "CarrierParty")
    private PartyType carrierParty;
    @XmlElement(name = "NotifyParty")
    private List<PartyType> notifyParty;
    @XmlElement(name = "Contact")
    private ContactType contact;
    @XmlElement(name = "EstimatedDespatchPeriod")
    private PeriodType estimatedDespatchPeriod;
    @XmlElement(name = "RequestedDespatchPeriod")
    private PeriodType requestedDespatchPeriod;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public DespatchType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the requestedDespatchDate property.
     * 
     * @return
     *     possible object is
     *     {@link RequestedDespatchDateType }
     *     
     */
    @Nullable
    public RequestedDespatchDateType getRequestedDespatchDate() {
        return requestedDespatchDate;
    }

    /**
     * Sets the value of the requestedDespatchDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestedDespatchDateType }
     *     
     */
    public void setRequestedDespatchDate(
        @Nullable
        RequestedDespatchDateType value) {
        this.requestedDespatchDate = value;
    }

    /**
     * Gets the value of the requestedDespatchTime property.
     * 
     * @return
     *     possible object is
     *     {@link RequestedDespatchTimeType }
     *     
     */
    @Nullable
    public RequestedDespatchTimeType getRequestedDespatchTime() {
        return requestedDespatchTime;
    }

    /**
     * Sets the value of the requestedDespatchTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestedDespatchTimeType }
     *     
     */
    public void setRequestedDespatchTime(
        @Nullable
        RequestedDespatchTimeType value) {
        this.requestedDespatchTime = value;
    }

    /**
     * Gets the value of the estimatedDespatchDate property.
     * 
     * @return
     *     possible object is
     *     {@link EstimatedDespatchDateType }
     *     
     */
    @Nullable
    public EstimatedDespatchDateType getEstimatedDespatchDate() {
        return estimatedDespatchDate;
    }

    /**
     * Sets the value of the estimatedDespatchDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link EstimatedDespatchDateType }
     *     
     */
    public void setEstimatedDespatchDate(
        @Nullable
        EstimatedDespatchDateType value) {
        this.estimatedDespatchDate = value;
    }

    /**
     * Gets the value of the estimatedDespatchTime property.
     * 
     * @return
     *     possible object is
     *     {@link EstimatedDespatchTimeType }
     *     
     */
    @Nullable
    public EstimatedDespatchTimeType getEstimatedDespatchTime() {
        return estimatedDespatchTime;
    }

    /**
     * Sets the value of the estimatedDespatchTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link EstimatedDespatchTimeType }
     *     
     */
    public void setEstimatedDespatchTime(
        @Nullable
        EstimatedDespatchTimeType value) {
        this.estimatedDespatchTime = value;
    }

    /**
     * Gets the value of the actualDespatchDate property.
     * 
     * @return
     *     possible object is
     *     {@link ActualDespatchDateType }
     *     
     */
    @Nullable
    public ActualDespatchDateType getActualDespatchDate() {
        return actualDespatchDate;
    }

    /**
     * Sets the value of the actualDespatchDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActualDespatchDateType }
     *     
     */
    public void setActualDespatchDate(
        @Nullable
        ActualDespatchDateType value) {
        this.actualDespatchDate = value;
    }

    /**
     * Gets the value of the actualDespatchTime property.
     * 
     * @return
     *     possible object is
     *     {@link ActualDespatchTimeType }
     *     
     */
    @Nullable
    public ActualDespatchTimeType getActualDespatchTime() {
        return actualDespatchTime;
    }

    /**
     * Sets the value of the actualDespatchTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActualDespatchTimeType }
     *     
     */
    public void setActualDespatchTime(
        @Nullable
        ActualDespatchTimeType value) {
        this.actualDespatchTime = value;
    }

    /**
     * Gets the value of the guaranteedDespatchDate property.
     * 
     * @return
     *     possible object is
     *     {@link GuaranteedDespatchDateType }
     *     
     */
    @Nullable
    public GuaranteedDespatchDateType getGuaranteedDespatchDate() {
        return guaranteedDespatchDate;
    }

    /**
     * Sets the value of the guaranteedDespatchDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link GuaranteedDespatchDateType }
     *     
     */
    public void setGuaranteedDespatchDate(
        @Nullable
        GuaranteedDespatchDateType value) {
        this.guaranteedDespatchDate = value;
    }

    /**
     * Gets the value of the guaranteedDespatchTime property.
     * 
     * @return
     *     possible object is
     *     {@link GuaranteedDespatchTimeType }
     *     
     */
    @Nullable
    public GuaranteedDespatchTimeType getGuaranteedDespatchTime() {
        return guaranteedDespatchTime;
    }

    /**
     * Sets the value of the guaranteedDespatchTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link GuaranteedDespatchTimeType }
     *     
     */
    public void setGuaranteedDespatchTime(
        @Nullable
        GuaranteedDespatchTimeType value) {
        this.guaranteedDespatchTime = value;
    }

    /**
     * Gets the value of the releaseID property.
     * 
     * @return
     *     possible object is
     *     {@link ReleaseIDType }
     *     
     */
    @Nullable
    public ReleaseIDType getReleaseID() {
        return releaseID;
    }

    /**
     * Sets the value of the releaseID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReleaseIDType }
     *     
     */
    public void setReleaseID(
        @Nullable
        ReleaseIDType value) {
        this.releaseID = value;
    }

    /**
     * Gets the value of the instructions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the instructions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getInstructions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InstructionsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the instructions property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<InstructionsType> getInstructions() {
        if (instructions == null) {
            instructions = new ArrayList<>();
        }
        return this.instructions;
    }

    /**
     * Gets the value of the despatchAddress property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getDespatchAddress() {
        return despatchAddress;
    }

    /**
     * Sets the value of the despatchAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setDespatchAddress(
        @Nullable
        AddressType value) {
        this.despatchAddress = value;
    }

    /**
     * Gets the value of the despatchLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getDespatchLocation() {
        return despatchLocation;
    }

    /**
     * Sets the value of the despatchLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setDespatchLocation(
        @Nullable
        LocationType value) {
        this.despatchLocation = value;
    }

    /**
     * Gets the value of the despatchParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getDespatchParty() {
        return despatchParty;
    }

    /**
     * Sets the value of the despatchParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setDespatchParty(
        @Nullable
        PartyType value) {
        this.despatchParty = value;
    }

    /**
     * Gets the value of the carrierParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getCarrierParty() {
        return carrierParty;
    }

    /**
     * Sets the value of the carrierParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setCarrierParty(
        @Nullable
        PartyType value) {
        this.carrierParty = value;
    }

    /**
     * Gets the value of the notifyParty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the notifyParty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNotifyParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the notifyParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyType> getNotifyParty() {
        if (notifyParty == null) {
            notifyParty = new ArrayList<>();
        }
        return this.notifyParty;
    }

    /**
     * Gets the value of the contact property.
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getContact() {
        return contact;
    }

    /**
     * Sets the value of the contact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     */
    public void setContact(
        @Nullable
        ContactType value) {
        this.contact = value;
    }

    /**
     * Gets the value of the estimatedDespatchPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getEstimatedDespatchPeriod() {
        return estimatedDespatchPeriod;
    }

    /**
     * Sets the value of the estimatedDespatchPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setEstimatedDespatchPeriod(
        @Nullable
        PeriodType value) {
        this.estimatedDespatchPeriod = value;
    }

    /**
     * Gets the value of the requestedDespatchPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getRequestedDespatchPeriod() {
        return requestedDespatchPeriod;
    }

    /**
     * Sets the value of the requestedDespatchPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setRequestedDespatchPeriod(
        @Nullable
        PeriodType value) {
        this.requestedDespatchPeriod = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DespatchType rhs = ((DespatchType) o);
        if (!EqualsHelper.equals(actualDespatchDate, rhs.actualDespatchDate)) {
            return false;
        }
        if (!EqualsHelper.equals(actualDespatchTime, rhs.actualDespatchTime)) {
            return false;
        }
        if (!EqualsHelper.equals(carrierParty, rhs.carrierParty)) {
            return false;
        }
        if (!EqualsHelper.equals(contact, rhs.contact)) {
            return false;
        }
        if (!EqualsHelper.equals(despatchAddress, rhs.despatchAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(despatchLocation, rhs.despatchLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(despatchParty, rhs.despatchParty)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedDespatchDate, rhs.estimatedDespatchDate)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedDespatchPeriod, rhs.estimatedDespatchPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedDespatchTime, rhs.estimatedDespatchTime)) {
            return false;
        }
        if (!EqualsHelper.equals(guaranteedDespatchDate, rhs.guaranteedDespatchDate)) {
            return false;
        }
        if (!EqualsHelper.equals(guaranteedDespatchTime, rhs.guaranteedDespatchTime)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(instructions, rhs.instructions)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(notifyParty, rhs.notifyParty)) {
            return false;
        }
        if (!EqualsHelper.equals(releaseID, rhs.releaseID)) {
            return false;
        }
        if (!EqualsHelper.equals(requestedDespatchDate, rhs.requestedDespatchDate)) {
            return false;
        }
        if (!EqualsHelper.equals(requestedDespatchPeriod, rhs.requestedDespatchPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(requestedDespatchTime, rhs.requestedDespatchTime)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualDespatchDate).append(actualDespatchTime).append(carrierParty).append(contact).append(despatchAddress).append(despatchLocation).append(despatchParty).append(estimatedDespatchDate).append(estimatedDespatchPeriod).append(estimatedDespatchTime).append(guaranteedDespatchDate).append(guaranteedDespatchTime).append(id).append(instructions).append(notifyParty).append(releaseID).append(requestedDespatchDate).append(requestedDespatchPeriod).append(requestedDespatchTime).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualDespatchDate", actualDespatchDate).append("actualDespatchTime", actualDespatchTime).append("carrierParty", carrierParty).append("contact", contact).append("despatchAddress", despatchAddress).append("despatchLocation", despatchLocation).append("despatchParty", despatchParty).append("estimatedDespatchDate", estimatedDespatchDate).append("estimatedDespatchPeriod", estimatedDespatchPeriod).append("estimatedDespatchTime", estimatedDespatchTime).append("guaranteedDespatchDate", guaranteedDespatchDate).append("guaranteedDespatchTime", guaranteedDespatchTime).append("id", id).append("instructions", instructions).append("notifyParty", notifyParty).append("releaseID", releaseID).append("requestedDespatchDate", requestedDespatchDate).append("requestedDespatchPeriod", requestedDespatchPeriod).append("requestedDespatchTime", requestedDespatchTime).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInstructions(
        @Nullable
        final List<InstructionsType> aList) {
        instructions = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNotifyParty(
        @Nullable
        final List<PartyType> aList) {
        notifyParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInstructionsEntries() {
        return (!getInstructions().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInstructionsEntries() {
        return getInstructions().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInstructionsCount() {
        return getInstructions().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public InstructionsType getInstructionsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInstructions().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInstructions(
        @Nonnull
        final InstructionsType elem) {
        getInstructions().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNotifyPartyEntries() {
        return (!getNotifyParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNotifyPartyEntries() {
        return getNotifyParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNotifyPartyCount() {
        return getNotifyParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyType getNotifyPartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNotifyParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNotifyParty(
        @Nonnull
        final PartyType elem) {
        getNotifyParty().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DespatchType ret) {
        ret.actualDespatchDate = ((actualDespatchDate == null)?null:actualDespatchDate.clone());
        ret.actualDespatchTime = ((actualDespatchTime == null)?null:actualDespatchTime.clone());
        ret.carrierParty = ((carrierParty == null)?null:carrierParty.clone());
        ret.contact = ((contact == null)?null:contact.clone());
        ret.despatchAddress = ((despatchAddress == null)?null:despatchAddress.clone());
        ret.despatchLocation = ((despatchLocation == null)?null:despatchLocation.clone());
        ret.despatchParty = ((despatchParty == null)?null:despatchParty.clone());
        ret.estimatedDespatchDate = ((estimatedDespatchDate == null)?null:estimatedDespatchDate.clone());
        ret.estimatedDespatchPeriod = ((estimatedDespatchPeriod == null)?null:estimatedDespatchPeriod.clone());
        ret.estimatedDespatchTime = ((estimatedDespatchTime == null)?null:estimatedDespatchTime.clone());
        ret.guaranteedDespatchDate = ((guaranteedDespatchDate == null)?null:guaranteedDespatchDate.clone());
        ret.guaranteedDespatchTime = ((guaranteedDespatchTime == null)?null:guaranteedDespatchTime.clone());
        ret.id = ((id == null)?null:id.clone());
        if (instructions == null) {
            ret.instructions = null;
        } else {
            List<InstructionsType> retInstructions = new ArrayList<>();
            for (InstructionsType aItem: getInstructions()) {
                retInstructions.add(((aItem == null)?null:aItem.clone()));
            }
            ret.instructions = retInstructions;
        }
        if (notifyParty == null) {
            ret.notifyParty = null;
        } else {
            List<PartyType> retNotifyParty = new ArrayList<>();
            for (PartyType aItem: getNotifyParty()) {
                retNotifyParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.notifyParty = retNotifyParty;
        }
        ret.releaseID = ((releaseID == null)?null:releaseID.clone());
        ret.requestedDespatchDate = ((requestedDespatchDate == null)?null:requestedDespatchDate.clone());
        ret.requestedDespatchPeriod = ((requestedDespatchPeriod == null)?null:requestedDespatchPeriod.clone());
        ret.requestedDespatchTime = ((requestedDespatchTime == null)?null:requestedDespatchTime.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DespatchType clone() {
        DespatchType ret = new DespatchType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequestedDespatchDateType and never <code>null</code>
     */
    @Nonnull
    public RequestedDespatchDateType setRequestedDespatchDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        RequestedDespatchDateType aObj = getRequestedDespatchDate();
        if (aObj == null) {
            aObj = new RequestedDespatchDateType(valueParam);
            setRequestedDespatchDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequestedDespatchDateType and never <code>null</code>
     */
    @Nonnull
    public RequestedDespatchDateType setRequestedDespatchDate(
        @Nullable
        final LocalDate valueParam) {
        RequestedDespatchDateType aObj = getRequestedDespatchDate();
        if (aObj == null) {
            aObj = new RequestedDespatchDateType(valueParam);
            setRequestedDespatchDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequestedDespatchTimeType and never <code>null</code>
     */
    @Nonnull
    public RequestedDespatchTimeType setRequestedDespatchTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        RequestedDespatchTimeType aObj = getRequestedDespatchTime();
        if (aObj == null) {
            aObj = new RequestedDespatchTimeType(valueParam);
            setRequestedDespatchTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequestedDespatchTimeType and never <code>null</code>
     */
    @Nonnull
    public RequestedDespatchTimeType setRequestedDespatchTime(
        @Nullable
        final LocalTime valueParam) {
        RequestedDespatchTimeType aObj = getRequestedDespatchTime();
        if (aObj == null) {
            aObj = new RequestedDespatchTimeType(valueParam);
            setRequestedDespatchTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedDespatchDateType and never <code>null</code>
     */
    @Nonnull
    public EstimatedDespatchDateType setEstimatedDespatchDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        EstimatedDespatchDateType aObj = getEstimatedDespatchDate();
        if (aObj == null) {
            aObj = new EstimatedDespatchDateType(valueParam);
            setEstimatedDespatchDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedDespatchDateType and never <code>null</code>
     */
    @Nonnull
    public EstimatedDespatchDateType setEstimatedDespatchDate(
        @Nullable
        final LocalDate valueParam) {
        EstimatedDespatchDateType aObj = getEstimatedDespatchDate();
        if (aObj == null) {
            aObj = new EstimatedDespatchDateType(valueParam);
            setEstimatedDespatchDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedDespatchTimeType and never <code>null</code>
     */
    @Nonnull
    public EstimatedDespatchTimeType setEstimatedDespatchTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        EstimatedDespatchTimeType aObj = getEstimatedDespatchTime();
        if (aObj == null) {
            aObj = new EstimatedDespatchTimeType(valueParam);
            setEstimatedDespatchTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedDespatchTimeType and never <code>null</code>
     */
    @Nonnull
    public EstimatedDespatchTimeType setEstimatedDespatchTime(
        @Nullable
        final LocalTime valueParam) {
        EstimatedDespatchTimeType aObj = getEstimatedDespatchTime();
        if (aObj == null) {
            aObj = new EstimatedDespatchTimeType(valueParam);
            setEstimatedDespatchTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualDespatchDateType and never <code>null</code>
     */
    @Nonnull
    public ActualDespatchDateType setActualDespatchDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ActualDespatchDateType aObj = getActualDespatchDate();
        if (aObj == null) {
            aObj = new ActualDespatchDateType(valueParam);
            setActualDespatchDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualDespatchDateType and never <code>null</code>
     */
    @Nonnull
    public ActualDespatchDateType setActualDespatchDate(
        @Nullable
        final LocalDate valueParam) {
        ActualDespatchDateType aObj = getActualDespatchDate();
        if (aObj == null) {
            aObj = new ActualDespatchDateType(valueParam);
            setActualDespatchDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualDespatchTimeType and never <code>null</code>
     */
    @Nonnull
    public ActualDespatchTimeType setActualDespatchTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        ActualDespatchTimeType aObj = getActualDespatchTime();
        if (aObj == null) {
            aObj = new ActualDespatchTimeType(valueParam);
            setActualDespatchTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualDespatchTimeType and never <code>null</code>
     */
    @Nonnull
    public ActualDespatchTimeType setActualDespatchTime(
        @Nullable
        final LocalTime valueParam) {
        ActualDespatchTimeType aObj = getActualDespatchTime();
        if (aObj == null) {
            aObj = new ActualDespatchTimeType(valueParam);
            setActualDespatchTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GuaranteedDespatchDateType and never <code>null</code>
     */
    @Nonnull
    public GuaranteedDespatchDateType setGuaranteedDespatchDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        GuaranteedDespatchDateType aObj = getGuaranteedDespatchDate();
        if (aObj == null) {
            aObj = new GuaranteedDespatchDateType(valueParam);
            setGuaranteedDespatchDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GuaranteedDespatchDateType and never <code>null</code>
     */
    @Nonnull
    public GuaranteedDespatchDateType setGuaranteedDespatchDate(
        @Nullable
        final LocalDate valueParam) {
        GuaranteedDespatchDateType aObj = getGuaranteedDespatchDate();
        if (aObj == null) {
            aObj = new GuaranteedDespatchDateType(valueParam);
            setGuaranteedDespatchDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GuaranteedDespatchTimeType and never <code>null</code>
     */
    @Nonnull
    public GuaranteedDespatchTimeType setGuaranteedDespatchTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        GuaranteedDespatchTimeType aObj = getGuaranteedDespatchTime();
        if (aObj == null) {
            aObj = new GuaranteedDespatchTimeType(valueParam);
            setGuaranteedDespatchTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GuaranteedDespatchTimeType and never <code>null</code>
     */
    @Nonnull
    public GuaranteedDespatchTimeType setGuaranteedDespatchTime(
        @Nullable
        final LocalTime valueParam) {
        GuaranteedDespatchTimeType aObj = getGuaranteedDespatchTime();
        if (aObj == null) {
            aObj = new GuaranteedDespatchTimeType(valueParam);
            setGuaranteedDespatchTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReleaseIDType and never <code>null</code>
     */
    @Nonnull
    public ReleaseIDType setReleaseID(
        @Nullable
        final String valueParam) {
        ReleaseIDType aObj = getReleaseID();
        if (aObj == null) {
            aObj = new ReleaseIDType(valueParam);
            setReleaseID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RequestedDespatchDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequestedDespatchDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getRequestedDespatchDateValue() {
        RequestedDespatchDateType aObj = getRequestedDespatchDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RequestedDespatchDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequestedDespatchDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getRequestedDespatchDateValueLocal() {
        RequestedDespatchDateType aObj = getRequestedDespatchDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained RequestedDespatchTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequestedDespatchTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getRequestedDespatchTimeValue() {
        RequestedDespatchTimeType aObj = getRequestedDespatchTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RequestedDespatchTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequestedDespatchTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getRequestedDespatchTimeValueLocal() {
        RequestedDespatchTimeType aObj = getRequestedDespatchTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained EstimatedDespatchDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedDespatchDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getEstimatedDespatchDateValue() {
        EstimatedDespatchDateType aObj = getEstimatedDespatchDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EstimatedDespatchDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedDespatchDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getEstimatedDespatchDateValueLocal() {
        EstimatedDespatchDateType aObj = getEstimatedDespatchDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained EstimatedDespatchTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedDespatchTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getEstimatedDespatchTimeValue() {
        EstimatedDespatchTimeType aObj = getEstimatedDespatchTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EstimatedDespatchTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedDespatchTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getEstimatedDespatchTimeValueLocal() {
        EstimatedDespatchTimeType aObj = getEstimatedDespatchTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ActualDespatchDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualDespatchDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getActualDespatchDateValue() {
        ActualDespatchDateType aObj = getActualDespatchDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ActualDespatchDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualDespatchDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getActualDespatchDateValueLocal() {
        ActualDespatchDateType aObj = getActualDespatchDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ActualDespatchTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualDespatchTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getActualDespatchTimeValue() {
        ActualDespatchTimeType aObj = getActualDespatchTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ActualDespatchTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualDespatchTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getActualDespatchTimeValueLocal() {
        ActualDespatchTimeType aObj = getActualDespatchTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained GuaranteedDespatchDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GuaranteedDespatchDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getGuaranteedDespatchDateValue() {
        GuaranteedDespatchDateType aObj = getGuaranteedDespatchDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GuaranteedDespatchDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GuaranteedDespatchDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getGuaranteedDespatchDateValueLocal() {
        GuaranteedDespatchDateType aObj = getGuaranteedDespatchDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained GuaranteedDespatchTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GuaranteedDespatchTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getGuaranteedDespatchTimeValue() {
        GuaranteedDespatchTimeType aObj = getGuaranteedDespatchTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GuaranteedDespatchTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GuaranteedDespatchTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getGuaranteedDespatchTimeValueLocal() {
        GuaranteedDespatchTimeType aObj = getGuaranteedDespatchTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ReleaseIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReleaseIDType object or <code>null</code>
     */
    @Nullable
    public String getReleaseIDValue() {
        ReleaseIDType aObj = getReleaseID();
        return (aObj == null)?null:aObj.getValue();
    }

}
