
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CollaborationPriorityCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ExceptionResolutionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ExceptionStatusCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PerformanceMetricTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.SupplyChainActivityTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ThresholdQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ThresholdValueComparisonCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for ExceptionCriteriaLineType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ExceptionCriteriaLineType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ThresholdValueComparisonCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ThresholdQuantity"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExceptionStatusCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CollaborationPriorityCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExceptionResolutionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SupplyChainActivityTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PerformanceMetricTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EffectivePeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SupplyItem" maxOccurs="unbounded"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ForecastExceptionCriterionLine" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExceptionCriteriaLineType", propOrder = {
    "ublExtensions",
    "id",
    "note",
    "thresholdValueComparisonCode",
    "thresholdQuantity",
    "exceptionStatusCode",
    "collaborationPriorityCode",
    "exceptionResolutionCode",
    "supplyChainActivityTypeCode",
    "performanceMetricTypeCode",
    "effectivePeriod",
    "supplyItem",
    "forecastExceptionCriterionLine"
})
@CodingStyleguideUnaware
public class ExceptionCriteriaLineType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "ThresholdValueComparisonCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private ThresholdValueComparisonCodeType thresholdValueComparisonCode;
    @XmlElement(name = "ThresholdQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private ThresholdQuantityType thresholdQuantity;
    @XmlElement(name = "ExceptionStatusCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExceptionStatusCodeType exceptionStatusCode;
    @XmlElement(name = "CollaborationPriorityCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CollaborationPriorityCodeType collaborationPriorityCode;
    @XmlElement(name = "ExceptionResolutionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExceptionResolutionCodeType exceptionResolutionCode;
    @XmlElement(name = "SupplyChainActivityTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SupplyChainActivityTypeCodeType supplyChainActivityTypeCode;
    @XmlElement(name = "PerformanceMetricTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PerformanceMetricTypeCodeType performanceMetricTypeCode;
    @XmlElement(name = "EffectivePeriod")
    private PeriodType effectivePeriod;
    @XmlElement(name = "SupplyItem", required = true)
    private List<ItemType> supplyItem;
    @XmlElement(name = "ForecastExceptionCriterionLine")
    private ForecastExceptionCriterionLineType forecastExceptionCriterionLine;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ExceptionCriteriaLineType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the note property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the note property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the note property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<>();
        }
        return this.note;
    }

    /**
     * Gets the value of the thresholdValueComparisonCode property.
     * 
     * @return
     *     possible object is
     *     {@link ThresholdValueComparisonCodeType }
     *     
     */
    @Nullable
    public ThresholdValueComparisonCodeType getThresholdValueComparisonCode() {
        return thresholdValueComparisonCode;
    }

    /**
     * Sets the value of the thresholdValueComparisonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ThresholdValueComparisonCodeType }
     *     
     */
    public void setThresholdValueComparisonCode(
        @Nullable
        ThresholdValueComparisonCodeType value) {
        this.thresholdValueComparisonCode = value;
    }

    /**
     * Gets the value of the thresholdQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ThresholdQuantityType }
     *     
     */
    @Nullable
    public ThresholdQuantityType getThresholdQuantity() {
        return thresholdQuantity;
    }

    /**
     * Sets the value of the thresholdQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ThresholdQuantityType }
     *     
     */
    public void setThresholdQuantity(
        @Nullable
        ThresholdQuantityType value) {
        this.thresholdQuantity = value;
    }

    /**
     * Gets the value of the exceptionStatusCode property.
     * 
     * @return
     *     possible object is
     *     {@link ExceptionStatusCodeType }
     *     
     */
    @Nullable
    public ExceptionStatusCodeType getExceptionStatusCode() {
        return exceptionStatusCode;
    }

    /**
     * Sets the value of the exceptionStatusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExceptionStatusCodeType }
     *     
     */
    public void setExceptionStatusCode(
        @Nullable
        ExceptionStatusCodeType value) {
        this.exceptionStatusCode = value;
    }

    /**
     * Gets the value of the collaborationPriorityCode property.
     * 
     * @return
     *     possible object is
     *     {@link CollaborationPriorityCodeType }
     *     
     */
    @Nullable
    public CollaborationPriorityCodeType getCollaborationPriorityCode() {
        return collaborationPriorityCode;
    }

    /**
     * Sets the value of the collaborationPriorityCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CollaborationPriorityCodeType }
     *     
     */
    public void setCollaborationPriorityCode(
        @Nullable
        CollaborationPriorityCodeType value) {
        this.collaborationPriorityCode = value;
    }

    /**
     * Gets the value of the exceptionResolutionCode property.
     * 
     * @return
     *     possible object is
     *     {@link ExceptionResolutionCodeType }
     *     
     */
    @Nullable
    public ExceptionResolutionCodeType getExceptionResolutionCode() {
        return exceptionResolutionCode;
    }

    /**
     * Sets the value of the exceptionResolutionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExceptionResolutionCodeType }
     *     
     */
    public void setExceptionResolutionCode(
        @Nullable
        ExceptionResolutionCodeType value) {
        this.exceptionResolutionCode = value;
    }

    /**
     * Gets the value of the supplyChainActivityTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link SupplyChainActivityTypeCodeType }
     *     
     */
    @Nullable
    public SupplyChainActivityTypeCodeType getSupplyChainActivityTypeCode() {
        return supplyChainActivityTypeCode;
    }

    /**
     * Sets the value of the supplyChainActivityTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplyChainActivityTypeCodeType }
     *     
     */
    public void setSupplyChainActivityTypeCode(
        @Nullable
        SupplyChainActivityTypeCodeType value) {
        this.supplyChainActivityTypeCode = value;
    }

    /**
     * Gets the value of the performanceMetricTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link PerformanceMetricTypeCodeType }
     *     
     */
    @Nullable
    public PerformanceMetricTypeCodeType getPerformanceMetricTypeCode() {
        return performanceMetricTypeCode;
    }

    /**
     * Sets the value of the performanceMetricTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PerformanceMetricTypeCodeType }
     *     
     */
    public void setPerformanceMetricTypeCode(
        @Nullable
        PerformanceMetricTypeCodeType value) {
        this.performanceMetricTypeCode = value;
    }

    /**
     * Gets the value of the effectivePeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getEffectivePeriod() {
        return effectivePeriod;
    }

    /**
     * Sets the value of the effectivePeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setEffectivePeriod(
        @Nullable
        PeriodType value) {
        this.effectivePeriod = value;
    }

    /**
     * Gets the value of the supplyItem property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supplyItem property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSupplyItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemType }
     * </p>
     * 
     * 
     * @return
     *     The value of the supplyItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemType> getSupplyItem() {
        if (supplyItem == null) {
            supplyItem = new ArrayList<>();
        }
        return this.supplyItem;
    }

    /**
     * Gets the value of the forecastExceptionCriterionLine property.
     * 
     * @return
     *     possible object is
     *     {@link ForecastExceptionCriterionLineType }
     *     
     */
    @Nullable
    public ForecastExceptionCriterionLineType getForecastExceptionCriterionLine() {
        return forecastExceptionCriterionLine;
    }

    /**
     * Sets the value of the forecastExceptionCriterionLine property.
     * 
     * @param value
     *     allowed object is
     *     {@link ForecastExceptionCriterionLineType }
     *     
     */
    public void setForecastExceptionCriterionLine(
        @Nullable
        ForecastExceptionCriterionLineType value) {
        this.forecastExceptionCriterionLine = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ExceptionCriteriaLineType rhs = ((ExceptionCriteriaLineType) o);
        if (!EqualsHelper.equals(collaborationPriorityCode, rhs.collaborationPriorityCode)) {
            return false;
        }
        if (!EqualsHelper.equals(effectivePeriod, rhs.effectivePeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(exceptionResolutionCode, rhs.exceptionResolutionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(exceptionStatusCode, rhs.exceptionStatusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(forecastExceptionCriterionLine, rhs.forecastExceptionCriterionLine)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equals(performanceMetricTypeCode, rhs.performanceMetricTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(supplyChainActivityTypeCode, rhs.supplyChainActivityTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(supplyItem, rhs.supplyItem)) {
            return false;
        }
        if (!EqualsHelper.equals(thresholdQuantity, rhs.thresholdQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(thresholdValueComparisonCode, rhs.thresholdValueComparisonCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(collaborationPriorityCode).append(effectivePeriod).append(exceptionResolutionCode).append(exceptionStatusCode).append(forecastExceptionCriterionLine).append(id).append(note).append(performanceMetricTypeCode).append(supplyChainActivityTypeCode).append(supplyItem).append(thresholdQuantity).append(thresholdValueComparisonCode).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("collaborationPriorityCode", collaborationPriorityCode).append("effectivePeriod", effectivePeriod).append("exceptionResolutionCode", exceptionResolutionCode).append("exceptionStatusCode", exceptionStatusCode).append("forecastExceptionCriterionLine", forecastExceptionCriterionLine).append("id", id).append("note", note).append("performanceMetricTypeCode", performanceMetricTypeCode).append("supplyChainActivityTypeCode", supplyChainActivityTypeCode).append("supplyItem", supplyItem).append("thresholdQuantity", thresholdQuantity).append("thresholdValueComparisonCode", thresholdValueComparisonCode).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSupplyItem(
        @Nullable
        final List<ItemType> aList) {
        supplyItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSupplyItemEntries() {
        return (!getSupplyItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSupplyItemEntries() {
        return getSupplyItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSupplyItemCount() {
        return getSupplyItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemType getSupplyItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSupplyItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSupplyItem(
        @Nonnull
        final ItemType elem) {
        getSupplyItem().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ExceptionCriteriaLineType ret) {
        ret.collaborationPriorityCode = ((collaborationPriorityCode == null)?null:collaborationPriorityCode.clone());
        ret.effectivePeriod = ((effectivePeriod == null)?null:effectivePeriod.clone());
        ret.exceptionResolutionCode = ((exceptionResolutionCode == null)?null:exceptionResolutionCode.clone());
        ret.exceptionStatusCode = ((exceptionStatusCode == null)?null:exceptionStatusCode.clone());
        ret.forecastExceptionCriterionLine = ((forecastExceptionCriterionLine == null)?null:forecastExceptionCriterionLine.clone());
        ret.id = ((id == null)?null:id.clone());
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        ret.performanceMetricTypeCode = ((performanceMetricTypeCode == null)?null:performanceMetricTypeCode.clone());
        ret.supplyChainActivityTypeCode = ((supplyChainActivityTypeCode == null)?null:supplyChainActivityTypeCode.clone());
        if (supplyItem == null) {
            ret.supplyItem = null;
        } else {
            List<ItemType> retSupplyItem = new ArrayList<>();
            for (ItemType aItem: getSupplyItem()) {
                retSupplyItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.supplyItem = retSupplyItem;
        }
        ret.thresholdQuantity = ((thresholdQuantity == null)?null:thresholdQuantity.clone());
        ret.thresholdValueComparisonCode = ((thresholdValueComparisonCode == null)?null:thresholdValueComparisonCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ExceptionCriteriaLineType clone() {
        ExceptionCriteriaLineType ret = new ExceptionCriteriaLineType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ThresholdValueComparisonCodeType and never <code>null</code>
     */
    @Nonnull
    public ThresholdValueComparisonCodeType setThresholdValueComparisonCode(
        @Nullable
        final String valueParam) {
        ThresholdValueComparisonCodeType aObj = getThresholdValueComparisonCode();
        if (aObj == null) {
            aObj = new ThresholdValueComparisonCodeType(valueParam);
            setThresholdValueComparisonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ThresholdQuantityType and never <code>null</code>
     */
    @Nonnull
    public ThresholdQuantityType setThresholdQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ThresholdQuantityType aObj = getThresholdQuantity();
        if (aObj == null) {
            aObj = new ThresholdQuantityType(valueParam);
            setThresholdQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExceptionStatusCodeType and never <code>null</code>
     */
    @Nonnull
    public ExceptionStatusCodeType setExceptionStatusCode(
        @Nullable
        final String valueParam) {
        ExceptionStatusCodeType aObj = getExceptionStatusCode();
        if (aObj == null) {
            aObj = new ExceptionStatusCodeType(valueParam);
            setExceptionStatusCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CollaborationPriorityCodeType and never <code>null</code>
     */
    @Nonnull
    public CollaborationPriorityCodeType setCollaborationPriorityCode(
        @Nullable
        final String valueParam) {
        CollaborationPriorityCodeType aObj = getCollaborationPriorityCode();
        if (aObj == null) {
            aObj = new CollaborationPriorityCodeType(valueParam);
            setCollaborationPriorityCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExceptionResolutionCodeType and never <code>null</code>
     */
    @Nonnull
    public ExceptionResolutionCodeType setExceptionResolutionCode(
        @Nullable
        final String valueParam) {
        ExceptionResolutionCodeType aObj = getExceptionResolutionCode();
        if (aObj == null) {
            aObj = new ExceptionResolutionCodeType(valueParam);
            setExceptionResolutionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SupplyChainActivityTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public SupplyChainActivityTypeCodeType setSupplyChainActivityTypeCode(
        @Nullable
        final String valueParam) {
        SupplyChainActivityTypeCodeType aObj = getSupplyChainActivityTypeCode();
        if (aObj == null) {
            aObj = new SupplyChainActivityTypeCodeType(valueParam);
            setSupplyChainActivityTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PerformanceMetricTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public PerformanceMetricTypeCodeType setPerformanceMetricTypeCode(
        @Nullable
        final String valueParam) {
        PerformanceMetricTypeCodeType aObj = getPerformanceMetricTypeCode();
        if (aObj == null) {
            aObj = new PerformanceMetricTypeCodeType(valueParam);
            setPerformanceMetricTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ThresholdValueComparisonCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ThresholdValueComparisonCodeType object or <code>null</code>
     */
    @Nullable
    public String getThresholdValueComparisonCodeValue() {
        ThresholdValueComparisonCodeType aObj = getThresholdValueComparisonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ThresholdQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ThresholdQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getThresholdQuantityValue() {
        ThresholdQuantityType aObj = getThresholdQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExceptionStatusCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExceptionStatusCodeType object or <code>null</code>
     */
    @Nullable
    public String getExceptionStatusCodeValue() {
        ExceptionStatusCodeType aObj = getExceptionStatusCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CollaborationPriorityCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CollaborationPriorityCodeType object or <code>null</code>
     */
    @Nullable
    public String getCollaborationPriorityCodeValue() {
        CollaborationPriorityCodeType aObj = getCollaborationPriorityCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExceptionResolutionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExceptionResolutionCodeType object or <code>null</code>
     */
    @Nullable
    public String getExceptionResolutionCodeValue() {
        ExceptionResolutionCodeType aObj = getExceptionResolutionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SupplyChainActivityTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SupplyChainActivityTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getSupplyChainActivityTypeCodeValue() {
        SupplyChainActivityTypeCodeType aObj = getSupplyChainActivityTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PerformanceMetricTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PerformanceMetricTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getPerformanceMetricTypeCodeValue() {
        PerformanceMetricTypeCodeType aObj = getPerformanceMetricTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
