
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CalculationRateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ExchangeMarketIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MathematicOperatorCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.SourceCurrencyBaseRateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.SourceCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TargetCurrencyBaseRateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TargetCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for ExchangeRateType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ExchangeRateType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SourceCurrencyCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SourceCurrencyBaseRate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TargetCurrencyCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TargetCurrencyBaseRate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExchangeMarketID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CalculationRate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MathematicOperatorCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Date" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ForeignExchangeContract" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExchangeRateType", propOrder = {
    "ublExtensions",
    "sourceCurrencyCode",
    "sourceCurrencyBaseRate",
    "targetCurrencyCode",
    "targetCurrencyBaseRate",
    "exchangeMarketID",
    "calculationRate",
    "mathematicOperatorCode",
    "date",
    "foreignExchangeContract"
})
@CodingStyleguideUnaware
public class ExchangeRateType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "SourceCurrencyCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private SourceCurrencyCodeType sourceCurrencyCode;
    @XmlElement(name = "SourceCurrencyBaseRate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SourceCurrencyBaseRateType sourceCurrencyBaseRate;
    @XmlElement(name = "TargetCurrencyCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private TargetCurrencyCodeType targetCurrencyCode;
    @XmlElement(name = "TargetCurrencyBaseRate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TargetCurrencyBaseRateType targetCurrencyBaseRate;
    @XmlElement(name = "ExchangeMarketID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExchangeMarketIDType exchangeMarketID;
    @XmlElement(name = "CalculationRate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CalculationRateType calculationRate;
    @XmlElement(name = "MathematicOperatorCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MathematicOperatorCodeType mathematicOperatorCode;
    @XmlElement(name = "Date", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DateType date;
    @XmlElement(name = "ForeignExchangeContract")
    private ContractType foreignExchangeContract;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ExchangeRateType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the sourceCurrencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link SourceCurrencyCodeType }
     *     
     */
    @Nullable
    public SourceCurrencyCodeType getSourceCurrencyCode() {
        return sourceCurrencyCode;
    }

    /**
     * Sets the value of the sourceCurrencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SourceCurrencyCodeType }
     *     
     */
    public void setSourceCurrencyCode(
        @Nullable
        SourceCurrencyCodeType value) {
        this.sourceCurrencyCode = value;
    }

    /**
     * Gets the value of the sourceCurrencyBaseRate property.
     * 
     * @return
     *     possible object is
     *     {@link SourceCurrencyBaseRateType }
     *     
     */
    @Nullable
    public SourceCurrencyBaseRateType getSourceCurrencyBaseRate() {
        return sourceCurrencyBaseRate;
    }

    /**
     * Sets the value of the sourceCurrencyBaseRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link SourceCurrencyBaseRateType }
     *     
     */
    public void setSourceCurrencyBaseRate(
        @Nullable
        SourceCurrencyBaseRateType value) {
        this.sourceCurrencyBaseRate = value;
    }

    /**
     * Gets the value of the targetCurrencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link TargetCurrencyCodeType }
     *     
     */
    @Nullable
    public TargetCurrencyCodeType getTargetCurrencyCode() {
        return targetCurrencyCode;
    }

    /**
     * Sets the value of the targetCurrencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TargetCurrencyCodeType }
     *     
     */
    public void setTargetCurrencyCode(
        @Nullable
        TargetCurrencyCodeType value) {
        this.targetCurrencyCode = value;
    }

    /**
     * Gets the value of the targetCurrencyBaseRate property.
     * 
     * @return
     *     possible object is
     *     {@link TargetCurrencyBaseRateType }
     *     
     */
    @Nullable
    public TargetCurrencyBaseRateType getTargetCurrencyBaseRate() {
        return targetCurrencyBaseRate;
    }

    /**
     * Sets the value of the targetCurrencyBaseRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link TargetCurrencyBaseRateType }
     *     
     */
    public void setTargetCurrencyBaseRate(
        @Nullable
        TargetCurrencyBaseRateType value) {
        this.targetCurrencyBaseRate = value;
    }

    /**
     * Gets the value of the exchangeMarketID property.
     * 
     * @return
     *     possible object is
     *     {@link ExchangeMarketIDType }
     *     
     */
    @Nullable
    public ExchangeMarketIDType getExchangeMarketID() {
        return exchangeMarketID;
    }

    /**
     * Sets the value of the exchangeMarketID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExchangeMarketIDType }
     *     
     */
    public void setExchangeMarketID(
        @Nullable
        ExchangeMarketIDType value) {
        this.exchangeMarketID = value;
    }

    /**
     * Gets the value of the calculationRate property.
     * 
     * @return
     *     possible object is
     *     {@link CalculationRateType }
     *     
     */
    @Nullable
    public CalculationRateType getCalculationRate() {
        return calculationRate;
    }

    /**
     * Sets the value of the calculationRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CalculationRateType }
     *     
     */
    public void setCalculationRate(
        @Nullable
        CalculationRateType value) {
        this.calculationRate = value;
    }

    /**
     * Gets the value of the mathematicOperatorCode property.
     * 
     * @return
     *     possible object is
     *     {@link MathematicOperatorCodeType }
     *     
     */
    @Nullable
    public MathematicOperatorCodeType getMathematicOperatorCode() {
        return mathematicOperatorCode;
    }

    /**
     * Sets the value of the mathematicOperatorCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MathematicOperatorCodeType }
     *     
     */
    public void setMathematicOperatorCode(
        @Nullable
        MathematicOperatorCodeType value) {
        this.mathematicOperatorCode = value;
    }

    /**
     * Gets the value of the date property.
     * 
     * @return
     *     possible object is
     *     {@link DateType }
     *     
     */
    @Nullable
    public DateType getDate() {
        return date;
    }

    /**
     * Sets the value of the date property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateType }
     *     
     */
    public void setDate(
        @Nullable
        DateType value) {
        this.date = value;
    }

    /**
     * Gets the value of the foreignExchangeContract property.
     * 
     * @return
     *     possible object is
     *     {@link ContractType }
     *     
     */
    @Nullable
    public ContractType getForeignExchangeContract() {
        return foreignExchangeContract;
    }

    /**
     * Sets the value of the foreignExchangeContract property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContractType }
     *     
     */
    public void setForeignExchangeContract(
        @Nullable
        ContractType value) {
        this.foreignExchangeContract = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ExchangeRateType rhs = ((ExchangeRateType) o);
        if (!EqualsHelper.equals(calculationRate, rhs.calculationRate)) {
            return false;
        }
        if (!EqualsHelper.equals(date, rhs.date)) {
            return false;
        }
        if (!EqualsHelper.equals(exchangeMarketID, rhs.exchangeMarketID)) {
            return false;
        }
        if (!EqualsHelper.equals(foreignExchangeContract, rhs.foreignExchangeContract)) {
            return false;
        }
        if (!EqualsHelper.equals(mathematicOperatorCode, rhs.mathematicOperatorCode)) {
            return false;
        }
        if (!EqualsHelper.equals(sourceCurrencyBaseRate, rhs.sourceCurrencyBaseRate)) {
            return false;
        }
        if (!EqualsHelper.equals(sourceCurrencyCode, rhs.sourceCurrencyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(targetCurrencyBaseRate, rhs.targetCurrencyBaseRate)) {
            return false;
        }
        if (!EqualsHelper.equals(targetCurrencyCode, rhs.targetCurrencyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(calculationRate).append(date).append(exchangeMarketID).append(foreignExchangeContract).append(mathematicOperatorCode).append(sourceCurrencyBaseRate).append(sourceCurrencyCode).append(targetCurrencyBaseRate).append(targetCurrencyCode).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("calculationRate", calculationRate).append("date", date).append("exchangeMarketID", exchangeMarketID).append("foreignExchangeContract", foreignExchangeContract).append("mathematicOperatorCode", mathematicOperatorCode).append("sourceCurrencyBaseRate", sourceCurrencyBaseRate).append("sourceCurrencyCode", sourceCurrencyCode).append("targetCurrencyBaseRate", targetCurrencyBaseRate).append("targetCurrencyCode", targetCurrencyCode).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ExchangeRateType ret) {
        ret.calculationRate = ((calculationRate == null)?null:calculationRate.clone());
        ret.date = ((date == null)?null:date.clone());
        ret.exchangeMarketID = ((exchangeMarketID == null)?null:exchangeMarketID.clone());
        ret.foreignExchangeContract = ((foreignExchangeContract == null)?null:foreignExchangeContract.clone());
        ret.mathematicOperatorCode = ((mathematicOperatorCode == null)?null:mathematicOperatorCode.clone());
        ret.sourceCurrencyBaseRate = ((sourceCurrencyBaseRate == null)?null:sourceCurrencyBaseRate.clone());
        ret.sourceCurrencyCode = ((sourceCurrencyCode == null)?null:sourceCurrencyCode.clone());
        ret.targetCurrencyBaseRate = ((targetCurrencyBaseRate == null)?null:targetCurrencyBaseRate.clone());
        ret.targetCurrencyCode = ((targetCurrencyCode == null)?null:targetCurrencyCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ExchangeRateType clone() {
        ExchangeRateType ret = new ExchangeRateType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SourceCurrencyCodeType and never <code>null</code>
     */
    @Nonnull
    public SourceCurrencyCodeType setSourceCurrencyCode(
        @Nullable
        final String valueParam) {
        SourceCurrencyCodeType aObj = getSourceCurrencyCode();
        if (aObj == null) {
            aObj = new SourceCurrencyCodeType(valueParam);
            setSourceCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SourceCurrencyBaseRateType and never <code>null</code>
     */
    @Nonnull
    public SourceCurrencyBaseRateType setSourceCurrencyBaseRate(
        @Nullable
        final BigDecimal valueParam) {
        SourceCurrencyBaseRateType aObj = getSourceCurrencyBaseRate();
        if (aObj == null) {
            aObj = new SourceCurrencyBaseRateType(valueParam);
            setSourceCurrencyBaseRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TargetCurrencyCodeType and never <code>null</code>
     */
    @Nonnull
    public TargetCurrencyCodeType setTargetCurrencyCode(
        @Nullable
        final String valueParam) {
        TargetCurrencyCodeType aObj = getTargetCurrencyCode();
        if (aObj == null) {
            aObj = new TargetCurrencyCodeType(valueParam);
            setTargetCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TargetCurrencyBaseRateType and never <code>null</code>
     */
    @Nonnull
    public TargetCurrencyBaseRateType setTargetCurrencyBaseRate(
        @Nullable
        final BigDecimal valueParam) {
        TargetCurrencyBaseRateType aObj = getTargetCurrencyBaseRate();
        if (aObj == null) {
            aObj = new TargetCurrencyBaseRateType(valueParam);
            setTargetCurrencyBaseRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExchangeMarketIDType and never <code>null</code>
     */
    @Nonnull
    public ExchangeMarketIDType setExchangeMarketID(
        @Nullable
        final String valueParam) {
        ExchangeMarketIDType aObj = getExchangeMarketID();
        if (aObj == null) {
            aObj = new ExchangeMarketIDType(valueParam);
            setExchangeMarketID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CalculationRateType and never <code>null</code>
     */
    @Nonnull
    public CalculationRateType setCalculationRate(
        @Nullable
        final BigDecimal valueParam) {
        CalculationRateType aObj = getCalculationRate();
        if (aObj == null) {
            aObj = new CalculationRateType(valueParam);
            setCalculationRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MathematicOperatorCodeType and never <code>null</code>
     */
    @Nonnull
    public MathematicOperatorCodeType setMathematicOperatorCode(
        @Nullable
        final String valueParam) {
        MathematicOperatorCodeType aObj = getMathematicOperatorCode();
        if (aObj == null) {
            aObj = new MathematicOperatorCodeType(valueParam);
            setMathematicOperatorCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DateType and never <code>null</code>
     */
    @Nonnull
    public DateType setDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        DateType aObj = getDate();
        if (aObj == null) {
            aObj = new DateType(valueParam);
            setDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DateType and never <code>null</code>
     */
    @Nonnull
    public DateType setDate(
        @Nullable
        final LocalDate valueParam) {
        DateType aObj = getDate();
        if (aObj == null) {
            aObj = new DateType(valueParam);
            setDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained SourceCurrencyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SourceCurrencyCodeType object or <code>null</code>
     */
    @Nullable
    public String getSourceCurrencyCodeValue() {
        SourceCurrencyCodeType aObj = getSourceCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SourceCurrencyBaseRateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SourceCurrencyBaseRateType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSourceCurrencyBaseRateValue() {
        SourceCurrencyBaseRateType aObj = getSourceCurrencyBaseRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TargetCurrencyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TargetCurrencyCodeType object or <code>null</code>
     */
    @Nullable
    public String getTargetCurrencyCodeValue() {
        TargetCurrencyCodeType aObj = getTargetCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TargetCurrencyBaseRateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TargetCurrencyBaseRateType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTargetCurrencyBaseRateValue() {
        TargetCurrencyBaseRateType aObj = getTargetCurrencyBaseRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExchangeMarketIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExchangeMarketIDType object or <code>null</code>
     */
    @Nullable
    public String getExchangeMarketIDValue() {
        ExchangeMarketIDType aObj = getExchangeMarketID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CalculationRateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CalculationRateType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCalculationRateValue() {
        CalculationRateType aObj = getCalculationRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MathematicOperatorCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MathematicOperatorCodeType object or <code>null</code>
     */
    @Nullable
    public String getMathematicOperatorCodeValue() {
        MathematicOperatorCodeType aObj = getMathematicOperatorCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getDateValue() {
        DateType aObj = getDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getDateValueLocal() {
        DateType aObj = getDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
