
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ComparisonDataSourceCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DataSourceCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ForecastPurposeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ForecastTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TimeDeltaDaysQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for ForecastExceptionCriterionLineType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ForecastExceptionCriterionLineType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ForecastPurposeCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ForecastTypeCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ComparisonDataSourceCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DataSourceCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TimeDeltaDaysQuantity" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ForecastExceptionCriterionLineType", propOrder = {
    "ublExtensions",
    "forecastPurposeCode",
    "forecastTypeCode",
    "comparisonDataSourceCode",
    "dataSourceCode",
    "timeDeltaDaysQuantity"
})
@CodingStyleguideUnaware
public class ForecastExceptionCriterionLineType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ForecastPurposeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private ForecastPurposeCodeType forecastPurposeCode;
    @XmlElement(name = "ForecastTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private ForecastTypeCodeType forecastTypeCode;
    @XmlElement(name = "ComparisonDataSourceCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ComparisonDataSourceCodeType comparisonDataSourceCode;
    @XmlElement(name = "DataSourceCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private DataSourceCodeType dataSourceCode;
    @XmlElement(name = "TimeDeltaDaysQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TimeDeltaDaysQuantityType timeDeltaDaysQuantity;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ForecastExceptionCriterionLineType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the forecastPurposeCode property.
     * 
     * @return
     *     possible object is
     *     {@link ForecastPurposeCodeType }
     *     
     */
    @Nullable
    public ForecastPurposeCodeType getForecastPurposeCode() {
        return forecastPurposeCode;
    }

    /**
     * Sets the value of the forecastPurposeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ForecastPurposeCodeType }
     *     
     */
    public void setForecastPurposeCode(
        @Nullable
        ForecastPurposeCodeType value) {
        this.forecastPurposeCode = value;
    }

    /**
     * Gets the value of the forecastTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link ForecastTypeCodeType }
     *     
     */
    @Nullable
    public ForecastTypeCodeType getForecastTypeCode() {
        return forecastTypeCode;
    }

    /**
     * Sets the value of the forecastTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ForecastTypeCodeType }
     *     
     */
    public void setForecastTypeCode(
        @Nullable
        ForecastTypeCodeType value) {
        this.forecastTypeCode = value;
    }

    /**
     * Gets the value of the comparisonDataSourceCode property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonDataSourceCodeType }
     *     
     */
    @Nullable
    public ComparisonDataSourceCodeType getComparisonDataSourceCode() {
        return comparisonDataSourceCode;
    }

    /**
     * Sets the value of the comparisonDataSourceCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ComparisonDataSourceCodeType }
     *     
     */
    public void setComparisonDataSourceCode(
        @Nullable
        ComparisonDataSourceCodeType value) {
        this.comparisonDataSourceCode = value;
    }

    /**
     * Gets the value of the dataSourceCode property.
     * 
     * @return
     *     possible object is
     *     {@link DataSourceCodeType }
     *     
     */
    @Nullable
    public DataSourceCodeType getDataSourceCode() {
        return dataSourceCode;
    }

    /**
     * Sets the value of the dataSourceCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataSourceCodeType }
     *     
     */
    public void setDataSourceCode(
        @Nullable
        DataSourceCodeType value) {
        this.dataSourceCode = value;
    }

    /**
     * Gets the value of the timeDeltaDaysQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link TimeDeltaDaysQuantityType }
     *     
     */
    @Nullable
    public TimeDeltaDaysQuantityType getTimeDeltaDaysQuantity() {
        return timeDeltaDaysQuantity;
    }

    /**
     * Sets the value of the timeDeltaDaysQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeDeltaDaysQuantityType }
     *     
     */
    public void setTimeDeltaDaysQuantity(
        @Nullable
        TimeDeltaDaysQuantityType value) {
        this.timeDeltaDaysQuantity = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ForecastExceptionCriterionLineType rhs = ((ForecastExceptionCriterionLineType) o);
        if (!EqualsHelper.equals(comparisonDataSourceCode, rhs.comparisonDataSourceCode)) {
            return false;
        }
        if (!EqualsHelper.equals(dataSourceCode, rhs.dataSourceCode)) {
            return false;
        }
        if (!EqualsHelper.equals(forecastPurposeCode, rhs.forecastPurposeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(forecastTypeCode, rhs.forecastTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(timeDeltaDaysQuantity, rhs.timeDeltaDaysQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(comparisonDataSourceCode).append(dataSourceCode).append(forecastPurposeCode).append(forecastTypeCode).append(timeDeltaDaysQuantity).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("comparisonDataSourceCode", comparisonDataSourceCode).append("dataSourceCode", dataSourceCode).append("forecastPurposeCode", forecastPurposeCode).append("forecastTypeCode", forecastTypeCode).append("timeDeltaDaysQuantity", timeDeltaDaysQuantity).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ForecastExceptionCriterionLineType ret) {
        ret.comparisonDataSourceCode = ((comparisonDataSourceCode == null)?null:comparisonDataSourceCode.clone());
        ret.dataSourceCode = ((dataSourceCode == null)?null:dataSourceCode.clone());
        ret.forecastPurposeCode = ((forecastPurposeCode == null)?null:forecastPurposeCode.clone());
        ret.forecastTypeCode = ((forecastTypeCode == null)?null:forecastTypeCode.clone());
        ret.timeDeltaDaysQuantity = ((timeDeltaDaysQuantity == null)?null:timeDeltaDaysQuantity.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ForecastExceptionCriterionLineType clone() {
        ForecastExceptionCriterionLineType ret = new ForecastExceptionCriterionLineType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ForecastPurposeCodeType and never <code>null</code>
     */
    @Nonnull
    public ForecastPurposeCodeType setForecastPurposeCode(
        @Nullable
        final String valueParam) {
        ForecastPurposeCodeType aObj = getForecastPurposeCode();
        if (aObj == null) {
            aObj = new ForecastPurposeCodeType(valueParam);
            setForecastPurposeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ForecastTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public ForecastTypeCodeType setForecastTypeCode(
        @Nullable
        final String valueParam) {
        ForecastTypeCodeType aObj = getForecastTypeCode();
        if (aObj == null) {
            aObj = new ForecastTypeCodeType(valueParam);
            setForecastTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ComparisonDataSourceCodeType and never <code>null</code>
     */
    @Nonnull
    public ComparisonDataSourceCodeType setComparisonDataSourceCode(
        @Nullable
        final String valueParam) {
        ComparisonDataSourceCodeType aObj = getComparisonDataSourceCode();
        if (aObj == null) {
            aObj = new ComparisonDataSourceCodeType(valueParam);
            setComparisonDataSourceCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DataSourceCodeType and never <code>null</code>
     */
    @Nonnull
    public DataSourceCodeType setDataSourceCode(
        @Nullable
        final String valueParam) {
        DataSourceCodeType aObj = getDataSourceCode();
        if (aObj == null) {
            aObj = new DataSourceCodeType(valueParam);
            setDataSourceCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TimeDeltaDaysQuantityType and never <code>null</code>
     */
    @Nonnull
    public TimeDeltaDaysQuantityType setTimeDeltaDaysQuantity(
        @Nullable
        final BigDecimal valueParam) {
        TimeDeltaDaysQuantityType aObj = getTimeDeltaDaysQuantity();
        if (aObj == null) {
            aObj = new TimeDeltaDaysQuantityType(valueParam);
            setTimeDeltaDaysQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ForecastPurposeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ForecastPurposeCodeType object or <code>null</code>
     */
    @Nullable
    public String getForecastPurposeCodeValue() {
        ForecastPurposeCodeType aObj = getForecastPurposeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ForecastTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ForecastTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getForecastTypeCodeValue() {
        ForecastTypeCodeType aObj = getForecastTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ComparisonDataSourceCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ComparisonDataSourceCodeType object or <code>null</code>
     */
    @Nullable
    public String getComparisonDataSourceCodeValue() {
        ComparisonDataSourceCodeType aObj = getComparisonDataSourceCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DataSourceCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DataSourceCodeType object or <code>null</code>
     */
    @Nullable
    public String getDataSourceCodeValue() {
        DataSourceCodeType aObj = getDataSourceCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TimeDeltaDaysQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TimeDeltaDaysQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTimeDeltaDaysQuantityValue() {
        TimeDeltaDaysQuantityType aObj = getTimeDeltaDaysQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
