
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.AdditionalInformationType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CategoryNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EmergencyProceduresCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.HazardClassIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.HazardousCategoryCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LowerOrangeHazardPlacardIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MaritimePollutantCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MarkingIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MedicalFirstAidGuideCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NetVolumeMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NetWeightMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PlacardEndorsementType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PlacardNotationType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.QuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TechnicalNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TunnelRestrictionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.UNDGCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.UNPackingGroupCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.UNPackingGroupType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.UpperOrangeHazardPlacardIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for HazardousItemType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="HazardousItemType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PlacardNotation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PlacardEndorsement" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AdditionalInformation" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UNDGCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UNPackingGroupCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UNPackingGroup" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EmergencyProceduresCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MedicalFirstAidGuideCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TunnelRestrictionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaritimePollutantCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TechnicalName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CategoryName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HazardousCategoryCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UpperOrangeHazardPlacardID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LowerOrangeHazardPlacardID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MarkingID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HazardClassID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NetWeightMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NetVolumeMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Quantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContactParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SecondaryHazard" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}HazardousGoodsTransit" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EmergencyTemperature" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FlashpointTemperature" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalTemperature" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PositionOnBoardStowage" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "HazardousItemType", propOrder = {
    "ublExtensions",
    "id",
    "placardNotation",
    "placardEndorsement",
    "additionalInformation",
    "undgCode",
    "unPackingGroupCode",
    "unPackingGroup",
    "emergencyProceduresCode",
    "medicalFirstAidGuideCode",
    "tunnelRestrictionCode",
    "maritimePollutantCode",
    "technicalName",
    "categoryName",
    "hazardousCategoryCode",
    "upperOrangeHazardPlacardID",
    "lowerOrangeHazardPlacardID",
    "markingID",
    "hazardClassID",
    "netWeightMeasure",
    "netVolumeMeasure",
    "quantity",
    "contactParty",
    "secondaryHazard",
    "hazardousGoodsTransit",
    "emergencyTemperature",
    "flashpointTemperature",
    "additionalTemperature",
    "positionOnBoardStowage"
})
@CodingStyleguideUnaware
public class HazardousItemType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "PlacardNotation", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PlacardNotationType placardNotation;
    @XmlElement(name = "PlacardEndorsement", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PlacardEndorsementType placardEndorsement;
    @XmlElement(name = "AdditionalInformation", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<AdditionalInformationType> additionalInformation;
    @XmlElement(name = "UNDGCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UNDGCodeType undgCode;
    @XmlElement(name = "UNPackingGroupCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UNPackingGroupCodeType unPackingGroupCode;
    @XmlElement(name = "UNPackingGroup", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<UNPackingGroupType> unPackingGroup;
    @XmlElement(name = "EmergencyProceduresCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EmergencyProceduresCodeType emergencyProceduresCode;
    @XmlElement(name = "MedicalFirstAidGuideCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MedicalFirstAidGuideCodeType medicalFirstAidGuideCode;
    @XmlElement(name = "TunnelRestrictionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TunnelRestrictionCodeType tunnelRestrictionCode;
    @XmlElement(name = "MaritimePollutantCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaritimePollutantCodeType maritimePollutantCode;
    @XmlElement(name = "TechnicalName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TechnicalNameType technicalName;
    @XmlElement(name = "CategoryName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CategoryNameType categoryName;
    @XmlElement(name = "HazardousCategoryCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HazardousCategoryCodeType hazardousCategoryCode;
    @XmlElement(name = "UpperOrangeHazardPlacardID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UpperOrangeHazardPlacardIDType upperOrangeHazardPlacardID;
    @XmlElement(name = "LowerOrangeHazardPlacardID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LowerOrangeHazardPlacardIDType lowerOrangeHazardPlacardID;
    @XmlElement(name = "MarkingID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MarkingIDType markingID;
    @XmlElement(name = "HazardClassID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HazardClassIDType hazardClassID;
    @XmlElement(name = "NetWeightMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NetWeightMeasureType netWeightMeasure;
    @XmlElement(name = "NetVolumeMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NetVolumeMeasureType netVolumeMeasure;
    @XmlElement(name = "Quantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private QuantityType quantity;
    @XmlElement(name = "ContactParty")
    private PartyType contactParty;
    @XmlElement(name = "SecondaryHazard")
    private List<SecondaryHazardType> secondaryHazard;
    @XmlElement(name = "HazardousGoodsTransit")
    private List<HazardousGoodsTransitType> hazardousGoodsTransit;
    @XmlElement(name = "EmergencyTemperature")
    private TemperatureType emergencyTemperature;
    @XmlElement(name = "FlashpointTemperature")
    private TemperatureType flashpointTemperature;
    @XmlElement(name = "AdditionalTemperature")
    private List<TemperatureType> additionalTemperature;
    @XmlElement(name = "PositionOnBoardStowage")
    private StowageType positionOnBoardStowage;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public HazardousItemType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the placardNotation property.
     * 
     * @return
     *     possible object is
     *     {@link PlacardNotationType }
     *     
     */
    @Nullable
    public PlacardNotationType getPlacardNotation() {
        return placardNotation;
    }

    /**
     * Sets the value of the placardNotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link PlacardNotationType }
     *     
     */
    public void setPlacardNotation(
        @Nullable
        PlacardNotationType value) {
        this.placardNotation = value;
    }

    /**
     * Gets the value of the placardEndorsement property.
     * 
     * @return
     *     possible object is
     *     {@link PlacardEndorsementType }
     *     
     */
    @Nullable
    public PlacardEndorsementType getPlacardEndorsement() {
        return placardEndorsement;
    }

    /**
     * Sets the value of the placardEndorsement property.
     * 
     * @param value
     *     allowed object is
     *     {@link PlacardEndorsementType }
     *     
     */
    public void setPlacardEndorsement(
        @Nullable
        PlacardEndorsementType value) {
        this.placardEndorsement = value;
    }

    /**
     * Gets the value of the additionalInformation property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalInformation property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalInformation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AdditionalInformationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalInformation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AdditionalInformationType> getAdditionalInformation() {
        if (additionalInformation == null) {
            additionalInformation = new ArrayList<>();
        }
        return this.additionalInformation;
    }

    /**
     * Gets the value of the undgCode property.
     * 
     * @return
     *     possible object is
     *     {@link UNDGCodeType }
     *     
     */
    @Nullable
    public UNDGCodeType getUNDGCode() {
        return undgCode;
    }

    /**
     * Sets the value of the undgCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link UNDGCodeType }
     *     
     */
    public void setUNDGCode(
        @Nullable
        UNDGCodeType value) {
        this.undgCode = value;
    }

    /**
     * Gets the value of the unPackingGroupCode property.
     * 
     * @return
     *     possible object is
     *     {@link UNPackingGroupCodeType }
     *     
     */
    @Nullable
    public UNPackingGroupCodeType getUNPackingGroupCode() {
        return unPackingGroupCode;
    }

    /**
     * Sets the value of the unPackingGroupCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link UNPackingGroupCodeType }
     *     
     */
    public void setUNPackingGroupCode(
        @Nullable
        UNPackingGroupCodeType value) {
        this.unPackingGroupCode = value;
    }

    /**
     * Gets the value of the unPackingGroup property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the unPackingGroup property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getUNPackingGroup().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UNPackingGroupType }
     * </p>
     * 
     * 
     * @return
     *     The value of the unPackingGroup property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<UNPackingGroupType> getUNPackingGroup() {
        if (unPackingGroup == null) {
            unPackingGroup = new ArrayList<>();
        }
        return this.unPackingGroup;
    }

    /**
     * Gets the value of the emergencyProceduresCode property.
     * 
     * @return
     *     possible object is
     *     {@link EmergencyProceduresCodeType }
     *     
     */
    @Nullable
    public EmergencyProceduresCodeType getEmergencyProceduresCode() {
        return emergencyProceduresCode;
    }

    /**
     * Sets the value of the emergencyProceduresCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmergencyProceduresCodeType }
     *     
     */
    public void setEmergencyProceduresCode(
        @Nullable
        EmergencyProceduresCodeType value) {
        this.emergencyProceduresCode = value;
    }

    /**
     * Gets the value of the medicalFirstAidGuideCode property.
     * 
     * @return
     *     possible object is
     *     {@link MedicalFirstAidGuideCodeType }
     *     
     */
    @Nullable
    public MedicalFirstAidGuideCodeType getMedicalFirstAidGuideCode() {
        return medicalFirstAidGuideCode;
    }

    /**
     * Sets the value of the medicalFirstAidGuideCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MedicalFirstAidGuideCodeType }
     *     
     */
    public void setMedicalFirstAidGuideCode(
        @Nullable
        MedicalFirstAidGuideCodeType value) {
        this.medicalFirstAidGuideCode = value;
    }

    /**
     * Gets the value of the tunnelRestrictionCode property.
     * 
     * @return
     *     possible object is
     *     {@link TunnelRestrictionCodeType }
     *     
     */
    @Nullable
    public TunnelRestrictionCodeType getTunnelRestrictionCode() {
        return tunnelRestrictionCode;
    }

    /**
     * Sets the value of the tunnelRestrictionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TunnelRestrictionCodeType }
     *     
     */
    public void setTunnelRestrictionCode(
        @Nullable
        TunnelRestrictionCodeType value) {
        this.tunnelRestrictionCode = value;
    }

    /**
     * Gets the value of the maritimePollutantCode property.
     * 
     * @return
     *     possible object is
     *     {@link MaritimePollutantCodeType }
     *     
     */
    @Nullable
    public MaritimePollutantCodeType getMaritimePollutantCode() {
        return maritimePollutantCode;
    }

    /**
     * Sets the value of the maritimePollutantCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaritimePollutantCodeType }
     *     
     */
    public void setMaritimePollutantCode(
        @Nullable
        MaritimePollutantCodeType value) {
        this.maritimePollutantCode = value;
    }

    /**
     * Gets the value of the technicalName property.
     * 
     * @return
     *     possible object is
     *     {@link TechnicalNameType }
     *     
     */
    @Nullable
    public TechnicalNameType getTechnicalName() {
        return technicalName;
    }

    /**
     * Sets the value of the technicalName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TechnicalNameType }
     *     
     */
    public void setTechnicalName(
        @Nullable
        TechnicalNameType value) {
        this.technicalName = value;
    }

    /**
     * Gets the value of the categoryName property.
     * 
     * @return
     *     possible object is
     *     {@link CategoryNameType }
     *     
     */
    @Nullable
    public CategoryNameType getCategoryName() {
        return categoryName;
    }

    /**
     * Sets the value of the categoryName property.
     * 
     * @param value
     *     allowed object is
     *     {@link CategoryNameType }
     *     
     */
    public void setCategoryName(
        @Nullable
        CategoryNameType value) {
        this.categoryName = value;
    }

    /**
     * Gets the value of the hazardousCategoryCode property.
     * 
     * @return
     *     possible object is
     *     {@link HazardousCategoryCodeType }
     *     
     */
    @Nullable
    public HazardousCategoryCodeType getHazardousCategoryCode() {
        return hazardousCategoryCode;
    }

    /**
     * Sets the value of the hazardousCategoryCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link HazardousCategoryCodeType }
     *     
     */
    public void setHazardousCategoryCode(
        @Nullable
        HazardousCategoryCodeType value) {
        this.hazardousCategoryCode = value;
    }

    /**
     * Gets the value of the upperOrangeHazardPlacardID property.
     * 
     * @return
     *     possible object is
     *     {@link UpperOrangeHazardPlacardIDType }
     *     
     */
    @Nullable
    public UpperOrangeHazardPlacardIDType getUpperOrangeHazardPlacardID() {
        return upperOrangeHazardPlacardID;
    }

    /**
     * Sets the value of the upperOrangeHazardPlacardID property.
     * 
     * @param value
     *     allowed object is
     *     {@link UpperOrangeHazardPlacardIDType }
     *     
     */
    public void setUpperOrangeHazardPlacardID(
        @Nullable
        UpperOrangeHazardPlacardIDType value) {
        this.upperOrangeHazardPlacardID = value;
    }

    /**
     * Gets the value of the lowerOrangeHazardPlacardID property.
     * 
     * @return
     *     possible object is
     *     {@link LowerOrangeHazardPlacardIDType }
     *     
     */
    @Nullable
    public LowerOrangeHazardPlacardIDType getLowerOrangeHazardPlacardID() {
        return lowerOrangeHazardPlacardID;
    }

    /**
     * Sets the value of the lowerOrangeHazardPlacardID property.
     * 
     * @param value
     *     allowed object is
     *     {@link LowerOrangeHazardPlacardIDType }
     *     
     */
    public void setLowerOrangeHazardPlacardID(
        @Nullable
        LowerOrangeHazardPlacardIDType value) {
        this.lowerOrangeHazardPlacardID = value;
    }

    /**
     * Gets the value of the markingID property.
     * 
     * @return
     *     possible object is
     *     {@link MarkingIDType }
     *     
     */
    @Nullable
    public MarkingIDType getMarkingID() {
        return markingID;
    }

    /**
     * Sets the value of the markingID property.
     * 
     * @param value
     *     allowed object is
     *     {@link MarkingIDType }
     *     
     */
    public void setMarkingID(
        @Nullable
        MarkingIDType value) {
        this.markingID = value;
    }

    /**
     * Gets the value of the hazardClassID property.
     * 
     * @return
     *     possible object is
     *     {@link HazardClassIDType }
     *     
     */
    @Nullable
    public HazardClassIDType getHazardClassID() {
        return hazardClassID;
    }

    /**
     * Sets the value of the hazardClassID property.
     * 
     * @param value
     *     allowed object is
     *     {@link HazardClassIDType }
     *     
     */
    public void setHazardClassID(
        @Nullable
        HazardClassIDType value) {
        this.hazardClassID = value;
    }

    /**
     * Gets the value of the netWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link NetWeightMeasureType }
     *     
     */
    @Nullable
    public NetWeightMeasureType getNetWeightMeasure() {
        return netWeightMeasure;
    }

    /**
     * Sets the value of the netWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetWeightMeasureType }
     *     
     */
    public void setNetWeightMeasure(
        @Nullable
        NetWeightMeasureType value) {
        this.netWeightMeasure = value;
    }

    /**
     * Gets the value of the netVolumeMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link NetVolumeMeasureType }
     *     
     */
    @Nullable
    public NetVolumeMeasureType getNetVolumeMeasure() {
        return netVolumeMeasure;
    }

    /**
     * Sets the value of the netVolumeMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetVolumeMeasureType }
     *     
     */
    public void setNetVolumeMeasure(
        @Nullable
        NetVolumeMeasureType value) {
        this.netVolumeMeasure = value;
    }

    /**
     * Gets the value of the quantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getQuantity() {
        return quantity;
    }

    /**
     * Sets the value of the quantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setQuantity(
        @Nullable
        QuantityType value) {
        this.quantity = value;
    }

    /**
     * Gets the value of the contactParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getContactParty() {
        return contactParty;
    }

    /**
     * Sets the value of the contactParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setContactParty(
        @Nullable
        PartyType value) {
        this.contactParty = value;
    }

    /**
     * Gets the value of the secondaryHazard property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the secondaryHazard property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSecondaryHazard().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SecondaryHazardType }
     * </p>
     * 
     * 
     * @return
     *     The value of the secondaryHazard property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SecondaryHazardType> getSecondaryHazard() {
        if (secondaryHazard == null) {
            secondaryHazard = new ArrayList<>();
        }
        return this.secondaryHazard;
    }

    /**
     * Gets the value of the hazardousGoodsTransit property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the hazardousGoodsTransit property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getHazardousGoodsTransit().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link HazardousGoodsTransitType }
     * </p>
     * 
     * 
     * @return
     *     The value of the hazardousGoodsTransit property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<HazardousGoodsTransitType> getHazardousGoodsTransit() {
        if (hazardousGoodsTransit == null) {
            hazardousGoodsTransit = new ArrayList<>();
        }
        return this.hazardousGoodsTransit;
    }

    /**
     * Gets the value of the emergencyTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getEmergencyTemperature() {
        return emergencyTemperature;
    }

    /**
     * Sets the value of the emergencyTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setEmergencyTemperature(
        @Nullable
        TemperatureType value) {
        this.emergencyTemperature = value;
    }

    /**
     * Gets the value of the flashpointTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getFlashpointTemperature() {
        return flashpointTemperature;
    }

    /**
     * Sets the value of the flashpointTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setFlashpointTemperature(
        @Nullable
        TemperatureType value) {
        this.flashpointTemperature = value;
    }

    /**
     * Gets the value of the additionalTemperature property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalTemperature property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalTemperature().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TemperatureType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalTemperature property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TemperatureType> getAdditionalTemperature() {
        if (additionalTemperature == null) {
            additionalTemperature = new ArrayList<>();
        }
        return this.additionalTemperature;
    }

    /**
     * Gets the value of the positionOnBoardStowage property.
     * 
     * @return
     *     possible object is
     *     {@link StowageType }
     *     
     */
    @Nullable
    public StowageType getPositionOnBoardStowage() {
        return positionOnBoardStowage;
    }

    /**
     * Sets the value of the positionOnBoardStowage property.
     * 
     * @param value
     *     allowed object is
     *     {@link StowageType }
     *     
     */
    public void setPositionOnBoardStowage(
        @Nullable
        StowageType value) {
        this.positionOnBoardStowage = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final HazardousItemType rhs = ((HazardousItemType) o);
        if (!EqualsHelper.equalsCollection(additionalInformation, rhs.additionalInformation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(additionalTemperature, rhs.additionalTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(categoryName, rhs.categoryName)) {
            return false;
        }
        if (!EqualsHelper.equals(contactParty, rhs.contactParty)) {
            return false;
        }
        if (!EqualsHelper.equals(emergencyProceduresCode, rhs.emergencyProceduresCode)) {
            return false;
        }
        if (!EqualsHelper.equals(emergencyTemperature, rhs.emergencyTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(flashpointTemperature, rhs.flashpointTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(hazardClassID, rhs.hazardClassID)) {
            return false;
        }
        if (!EqualsHelper.equals(hazardousCategoryCode, rhs.hazardousCategoryCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hazardousGoodsTransit, rhs.hazardousGoodsTransit)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(lowerOrangeHazardPlacardID, rhs.lowerOrangeHazardPlacardID)) {
            return false;
        }
        if (!EqualsHelper.equals(maritimePollutantCode, rhs.maritimePollutantCode)) {
            return false;
        }
        if (!EqualsHelper.equals(markingID, rhs.markingID)) {
            return false;
        }
        if (!EqualsHelper.equals(medicalFirstAidGuideCode, rhs.medicalFirstAidGuideCode)) {
            return false;
        }
        if (!EqualsHelper.equals(netVolumeMeasure, rhs.netVolumeMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(netWeightMeasure, rhs.netWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(placardEndorsement, rhs.placardEndorsement)) {
            return false;
        }
        if (!EqualsHelper.equals(placardNotation, rhs.placardNotation)) {
            return false;
        }
        if (!EqualsHelper.equals(positionOnBoardStowage, rhs.positionOnBoardStowage)) {
            return false;
        }
        if (!EqualsHelper.equals(quantity, rhs.quantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(secondaryHazard, rhs.secondaryHazard)) {
            return false;
        }
        if (!EqualsHelper.equals(technicalName, rhs.technicalName)) {
            return false;
        }
        if (!EqualsHelper.equals(tunnelRestrictionCode, rhs.tunnelRestrictionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(unPackingGroup, rhs.unPackingGroup)) {
            return false;
        }
        if (!EqualsHelper.equals(unPackingGroupCode, rhs.unPackingGroupCode)) {
            return false;
        }
        if (!EqualsHelper.equals(undgCode, rhs.undgCode)) {
            return false;
        }
        if (!EqualsHelper.equals(upperOrangeHazardPlacardID, rhs.upperOrangeHazardPlacardID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalInformation).append(additionalTemperature).append(categoryName).append(contactParty).append(emergencyProceduresCode).append(emergencyTemperature).append(flashpointTemperature).append(hazardClassID).append(hazardousCategoryCode).append(hazardousGoodsTransit).append(id).append(lowerOrangeHazardPlacardID).append(maritimePollutantCode).append(markingID).append(medicalFirstAidGuideCode).append(netVolumeMeasure).append(netWeightMeasure).append(placardEndorsement).append(placardNotation).append(positionOnBoardStowage).append(quantity).append(secondaryHazard).append(technicalName).append(tunnelRestrictionCode).append(ublExtensions).append(unPackingGroup).append(unPackingGroupCode).append(undgCode).append(upperOrangeHazardPlacardID).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalInformation", additionalInformation).append("additionalTemperature", additionalTemperature).append("categoryName", categoryName).append("contactParty", contactParty).append("emergencyProceduresCode", emergencyProceduresCode).append("emergencyTemperature", emergencyTemperature).append("flashpointTemperature", flashpointTemperature).append("hazardClassID", hazardClassID).append("hazardousCategoryCode", hazardousCategoryCode).append("hazardousGoodsTransit", hazardousGoodsTransit).append("id", id).append("lowerOrangeHazardPlacardID", lowerOrangeHazardPlacardID).append("maritimePollutantCode", maritimePollutantCode).append("markingID", markingID).append("medicalFirstAidGuideCode", medicalFirstAidGuideCode).append("netVolumeMeasure", netVolumeMeasure).append("netWeightMeasure", netWeightMeasure).append("placardEndorsement", placardEndorsement).append("placardNotation", placardNotation).append("positionOnBoardStowage", positionOnBoardStowage).append("quantity", quantity).append("secondaryHazard", secondaryHazard).append("technicalName", technicalName).append("tunnelRestrictionCode", tunnelRestrictionCode).append("ublExtensions", ublExtensions).append("unPackingGroup", unPackingGroup).append("unPackingGroupCode", unPackingGroupCode).append("undgCode", undgCode).append("upperOrangeHazardPlacardID", upperOrangeHazardPlacardID).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalInformation(
        @Nullable
        final List<AdditionalInformationType> aList) {
        additionalInformation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUNPackingGroup(
        @Nullable
        final List<UNPackingGroupType> aList) {
        unPackingGroup = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSecondaryHazard(
        @Nullable
        final List<SecondaryHazardType> aList) {
        secondaryHazard = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setHazardousGoodsTransit(
        @Nullable
        final List<HazardousGoodsTransitType> aList) {
        hazardousGoodsTransit = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalTemperature(
        @Nullable
        final List<TemperatureType> aList) {
        additionalTemperature = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalInformationEntries() {
        return (!getAdditionalInformation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalInformationEntries() {
        return getAdditionalInformation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalInformationCount() {
        return getAdditionalInformation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AdditionalInformationType getAdditionalInformationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalInformation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalInformation(
        @Nonnull
        final AdditionalInformationType elem) {
        getAdditionalInformation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUNPackingGroupEntries() {
        return (!getUNPackingGroup().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUNPackingGroupEntries() {
        return getUNPackingGroup().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUNPackingGroupCount() {
        return getUNPackingGroup().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public UNPackingGroupType getUNPackingGroupAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUNPackingGroup().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUNPackingGroup(
        @Nonnull
        final UNPackingGroupType elem) {
        getUNPackingGroup().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSecondaryHazardEntries() {
        return (!getSecondaryHazard().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSecondaryHazardEntries() {
        return getSecondaryHazard().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSecondaryHazardCount() {
        return getSecondaryHazard().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SecondaryHazardType getSecondaryHazardAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSecondaryHazard().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSecondaryHazard(
        @Nonnull
        final SecondaryHazardType elem) {
        getSecondaryHazard().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasHazardousGoodsTransitEntries() {
        return (!getHazardousGoodsTransit().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoHazardousGoodsTransitEntries() {
        return getHazardousGoodsTransit().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getHazardousGoodsTransitCount() {
        return getHazardousGoodsTransit().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public HazardousGoodsTransitType getHazardousGoodsTransitAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHazardousGoodsTransit().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addHazardousGoodsTransit(
        @Nonnull
        final HazardousGoodsTransitType elem) {
        getHazardousGoodsTransit().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalTemperatureEntries() {
        return (!getAdditionalTemperature().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalTemperatureEntries() {
        return getAdditionalTemperature().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalTemperatureCount() {
        return getAdditionalTemperature().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TemperatureType getAdditionalTemperatureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalTemperature().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalTemperature(
        @Nonnull
        final TemperatureType elem) {
        getAdditionalTemperature().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        HazardousItemType ret) {
        if (additionalInformation == null) {
            ret.additionalInformation = null;
        } else {
            List<AdditionalInformationType> retAdditionalInformation = new ArrayList<>();
            for (AdditionalInformationType aItem: getAdditionalInformation()) {
                retAdditionalInformation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalInformation = retAdditionalInformation;
        }
        if (additionalTemperature == null) {
            ret.additionalTemperature = null;
        } else {
            List<TemperatureType> retAdditionalTemperature = new ArrayList<>();
            for (TemperatureType aItem: getAdditionalTemperature()) {
                retAdditionalTemperature.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalTemperature = retAdditionalTemperature;
        }
        ret.categoryName = ((categoryName == null)?null:categoryName.clone());
        ret.contactParty = ((contactParty == null)?null:contactParty.clone());
        ret.emergencyProceduresCode = ((emergencyProceduresCode == null)?null:emergencyProceduresCode.clone());
        ret.emergencyTemperature = ((emergencyTemperature == null)?null:emergencyTemperature.clone());
        ret.flashpointTemperature = ((flashpointTemperature == null)?null:flashpointTemperature.clone());
        ret.hazardClassID = ((hazardClassID == null)?null:hazardClassID.clone());
        ret.hazardousCategoryCode = ((hazardousCategoryCode == null)?null:hazardousCategoryCode.clone());
        if (hazardousGoodsTransit == null) {
            ret.hazardousGoodsTransit = null;
        } else {
            List<HazardousGoodsTransitType> retHazardousGoodsTransit = new ArrayList<>();
            for (HazardousGoodsTransitType aItem: getHazardousGoodsTransit()) {
                retHazardousGoodsTransit.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hazardousGoodsTransit = retHazardousGoodsTransit;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.lowerOrangeHazardPlacardID = ((lowerOrangeHazardPlacardID == null)?null:lowerOrangeHazardPlacardID.clone());
        ret.maritimePollutantCode = ((maritimePollutantCode == null)?null:maritimePollutantCode.clone());
        ret.markingID = ((markingID == null)?null:markingID.clone());
        ret.medicalFirstAidGuideCode = ((medicalFirstAidGuideCode == null)?null:medicalFirstAidGuideCode.clone());
        ret.netVolumeMeasure = ((netVolumeMeasure == null)?null:netVolumeMeasure.clone());
        ret.netWeightMeasure = ((netWeightMeasure == null)?null:netWeightMeasure.clone());
        ret.placardEndorsement = ((placardEndorsement == null)?null:placardEndorsement.clone());
        ret.placardNotation = ((placardNotation == null)?null:placardNotation.clone());
        ret.positionOnBoardStowage = ((positionOnBoardStowage == null)?null:positionOnBoardStowage.clone());
        ret.quantity = ((quantity == null)?null:quantity.clone());
        if (secondaryHazard == null) {
            ret.secondaryHazard = null;
        } else {
            List<SecondaryHazardType> retSecondaryHazard = new ArrayList<>();
            for (SecondaryHazardType aItem: getSecondaryHazard()) {
                retSecondaryHazard.add(((aItem == null)?null:aItem.clone()));
            }
            ret.secondaryHazard = retSecondaryHazard;
        }
        ret.technicalName = ((technicalName == null)?null:technicalName.clone());
        ret.tunnelRestrictionCode = ((tunnelRestrictionCode == null)?null:tunnelRestrictionCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        if (unPackingGroup == null) {
            ret.unPackingGroup = null;
        } else {
            List<UNPackingGroupType> retUNPackingGroup = new ArrayList<>();
            for (UNPackingGroupType aItem: getUNPackingGroup()) {
                retUNPackingGroup.add(((aItem == null)?null:aItem.clone()));
            }
            ret.unPackingGroup = retUNPackingGroup;
        }
        ret.unPackingGroupCode = ((unPackingGroupCode == null)?null:unPackingGroupCode.clone());
        ret.undgCode = ((undgCode == null)?null:undgCode.clone());
        ret.upperOrangeHazardPlacardID = ((upperOrangeHazardPlacardID == null)?null:upperOrangeHazardPlacardID.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public HazardousItemType clone() {
        HazardousItemType ret = new HazardousItemType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PlacardNotationType and never <code>null</code>
     */
    @Nonnull
    public PlacardNotationType setPlacardNotation(
        @Nullable
        final String valueParam) {
        PlacardNotationType aObj = getPlacardNotation();
        if (aObj == null) {
            aObj = new PlacardNotationType(valueParam);
            setPlacardNotation(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PlacardEndorsementType and never <code>null</code>
     */
    @Nonnull
    public PlacardEndorsementType setPlacardEndorsement(
        @Nullable
        final String valueParam) {
        PlacardEndorsementType aObj = getPlacardEndorsement();
        if (aObj == null) {
            aObj = new PlacardEndorsementType(valueParam);
            setPlacardEndorsement(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UNDGCodeType and never <code>null</code>
     */
    @Nonnull
    public UNDGCodeType setUNDGCode(
        @Nullable
        final String valueParam) {
        UNDGCodeType aObj = getUNDGCode();
        if (aObj == null) {
            aObj = new UNDGCodeType(valueParam);
            setUNDGCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UNPackingGroupCodeType and never <code>null</code>
     */
    @Nonnull
    public UNPackingGroupCodeType setUNPackingGroupCode(
        @Nullable
        final String valueParam) {
        UNPackingGroupCodeType aObj = getUNPackingGroupCode();
        if (aObj == null) {
            aObj = new UNPackingGroupCodeType(valueParam);
            setUNPackingGroupCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EmergencyProceduresCodeType and never <code>null</code>
     */
    @Nonnull
    public EmergencyProceduresCodeType setEmergencyProceduresCode(
        @Nullable
        final String valueParam) {
        EmergencyProceduresCodeType aObj = getEmergencyProceduresCode();
        if (aObj == null) {
            aObj = new EmergencyProceduresCodeType(valueParam);
            setEmergencyProceduresCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MedicalFirstAidGuideCodeType and never <code>null</code>
     */
    @Nonnull
    public MedicalFirstAidGuideCodeType setMedicalFirstAidGuideCode(
        @Nullable
        final String valueParam) {
        MedicalFirstAidGuideCodeType aObj = getMedicalFirstAidGuideCode();
        if (aObj == null) {
            aObj = new MedicalFirstAidGuideCodeType(valueParam);
            setMedicalFirstAidGuideCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TunnelRestrictionCodeType and never <code>null</code>
     */
    @Nonnull
    public TunnelRestrictionCodeType setTunnelRestrictionCode(
        @Nullable
        final String valueParam) {
        TunnelRestrictionCodeType aObj = getTunnelRestrictionCode();
        if (aObj == null) {
            aObj = new TunnelRestrictionCodeType(valueParam);
            setTunnelRestrictionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaritimePollutantCodeType and never <code>null</code>
     */
    @Nonnull
    public MaritimePollutantCodeType setMaritimePollutantCode(
        @Nullable
        final String valueParam) {
        MaritimePollutantCodeType aObj = getMaritimePollutantCode();
        if (aObj == null) {
            aObj = new MaritimePollutantCodeType(valueParam);
            setMaritimePollutantCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TechnicalNameType and never <code>null</code>
     */
    @Nonnull
    public TechnicalNameType setTechnicalName(
        @Nullable
        final String valueParam) {
        TechnicalNameType aObj = getTechnicalName();
        if (aObj == null) {
            aObj = new TechnicalNameType(valueParam);
            setTechnicalName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CategoryNameType and never <code>null</code>
     */
    @Nonnull
    public CategoryNameType setCategoryName(
        @Nullable
        final String valueParam) {
        CategoryNameType aObj = getCategoryName();
        if (aObj == null) {
            aObj = new CategoryNameType(valueParam);
            setCategoryName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type HazardousCategoryCodeType and never <code>null</code>
     */
    @Nonnull
    public HazardousCategoryCodeType setHazardousCategoryCode(
        @Nullable
        final String valueParam) {
        HazardousCategoryCodeType aObj = getHazardousCategoryCode();
        if (aObj == null) {
            aObj = new HazardousCategoryCodeType(valueParam);
            setHazardousCategoryCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UpperOrangeHazardPlacardIDType and never <code>null</code>
     */
    @Nonnull
    public UpperOrangeHazardPlacardIDType setUpperOrangeHazardPlacardID(
        @Nullable
        final String valueParam) {
        UpperOrangeHazardPlacardIDType aObj = getUpperOrangeHazardPlacardID();
        if (aObj == null) {
            aObj = new UpperOrangeHazardPlacardIDType(valueParam);
            setUpperOrangeHazardPlacardID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LowerOrangeHazardPlacardIDType and never <code>null</code>
     */
    @Nonnull
    public LowerOrangeHazardPlacardIDType setLowerOrangeHazardPlacardID(
        @Nullable
        final String valueParam) {
        LowerOrangeHazardPlacardIDType aObj = getLowerOrangeHazardPlacardID();
        if (aObj == null) {
            aObj = new LowerOrangeHazardPlacardIDType(valueParam);
            setLowerOrangeHazardPlacardID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MarkingIDType and never <code>null</code>
     */
    @Nonnull
    public MarkingIDType setMarkingID(
        @Nullable
        final String valueParam) {
        MarkingIDType aObj = getMarkingID();
        if (aObj == null) {
            aObj = new MarkingIDType(valueParam);
            setMarkingID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type HazardClassIDType and never <code>null</code>
     */
    @Nonnull
    public HazardClassIDType setHazardClassID(
        @Nullable
        final String valueParam) {
        HazardClassIDType aObj = getHazardClassID();
        if (aObj == null) {
            aObj = new HazardClassIDType(valueParam);
            setHazardClassID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NetWeightMeasureType and never <code>null</code>
     */
    @Nonnull
    public NetWeightMeasureType setNetWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        NetWeightMeasureType aObj = getNetWeightMeasure();
        if (aObj == null) {
            aObj = new NetWeightMeasureType(valueParam);
            setNetWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NetVolumeMeasureType and never <code>null</code>
     */
    @Nonnull
    public NetVolumeMeasureType setNetVolumeMeasure(
        @Nullable
        final BigDecimal valueParam) {
        NetVolumeMeasureType aObj = getNetVolumeMeasure();
        if (aObj == null) {
            aObj = new NetVolumeMeasureType(valueParam);
            setNetVolumeMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PlacardNotationType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PlacardNotationType object or <code>null</code>
     */
    @Nullable
    public String getPlacardNotationValue() {
        PlacardNotationType aObj = getPlacardNotation();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PlacardEndorsementType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PlacardEndorsementType object or <code>null</code>
     */
    @Nullable
    public String getPlacardEndorsementValue() {
        PlacardEndorsementType aObj = getPlacardEndorsement();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained UNDGCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UNDGCodeType object or <code>null</code>
     */
    @Nullable
    public String getUNDGCodeValue() {
        UNDGCodeType aObj = getUNDGCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained UNPackingGroupCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UNPackingGroupCodeType object or <code>null</code>
     */
    @Nullable
    public String getUNPackingGroupCodeValue() {
        UNPackingGroupCodeType aObj = getUNPackingGroupCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EmergencyProceduresCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EmergencyProceduresCodeType object or <code>null</code>
     */
    @Nullable
    public String getEmergencyProceduresCodeValue() {
        EmergencyProceduresCodeType aObj = getEmergencyProceduresCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MedicalFirstAidGuideCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MedicalFirstAidGuideCodeType object or <code>null</code>
     */
    @Nullable
    public String getMedicalFirstAidGuideCodeValue() {
        MedicalFirstAidGuideCodeType aObj = getMedicalFirstAidGuideCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TunnelRestrictionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TunnelRestrictionCodeType object or <code>null</code>
     */
    @Nullable
    public String getTunnelRestrictionCodeValue() {
        TunnelRestrictionCodeType aObj = getTunnelRestrictionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaritimePollutantCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaritimePollutantCodeType object or <code>null</code>
     */
    @Nullable
    public String getMaritimePollutantCodeValue() {
        MaritimePollutantCodeType aObj = getMaritimePollutantCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TechnicalNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TechnicalNameType object or <code>null</code>
     */
    @Nullable
    public String getTechnicalNameValue() {
        TechnicalNameType aObj = getTechnicalName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CategoryNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CategoryNameType object or <code>null</code>
     */
    @Nullable
    public String getCategoryNameValue() {
        CategoryNameType aObj = getCategoryName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HazardousCategoryCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained HazardousCategoryCodeType object or <code>null</code>
     */
    @Nullable
    public String getHazardousCategoryCodeValue() {
        HazardousCategoryCodeType aObj = getHazardousCategoryCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained UpperOrangeHazardPlacardIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UpperOrangeHazardPlacardIDType object or <code>null</code>
     */
    @Nullable
    public String getUpperOrangeHazardPlacardIDValue() {
        UpperOrangeHazardPlacardIDType aObj = getUpperOrangeHazardPlacardID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LowerOrangeHazardPlacardIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LowerOrangeHazardPlacardIDType object or <code>null</code>
     */
    @Nullable
    public String getLowerOrangeHazardPlacardIDValue() {
        LowerOrangeHazardPlacardIDType aObj = getLowerOrangeHazardPlacardID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MarkingIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MarkingIDType object or <code>null</code>
     */
    @Nullable
    public String getMarkingIDValue() {
        MarkingIDType aObj = getMarkingID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HazardClassIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained HazardClassIDType object or <code>null</code>
     */
    @Nullable
    public String getHazardClassIDValue() {
        HazardClassIDType aObj = getHazardClassID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NetWeightMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NetWeightMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetWeightMeasureValue() {
        NetWeightMeasureType aObj = getNetWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NetVolumeMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NetVolumeMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetVolumeMeasureValue() {
        NetVolumeMeasureType aObj = getNetVolumeMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getQuantityValue() {
        QuantityType aObj = getQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
