
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.AdditionalMattersDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CurrentOperatingSecurityLevelCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ISSCAbsenceReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ISSCExpiryDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.SSPOnBoardIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.SSPSecurityMeasuresAppliedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ValidISSCIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for ISPSRequirementsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ISPSRequirementsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ValidISSCIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ISSCAbsenceReason" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ISSCExpiryDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SSPOnBoardIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SSPSecurityMeasuresAppliedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CurrentOperatingSecurityLevelCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AdditionalMattersDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalSecurityMeasure" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PortCallRecord" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipToShipActivityRecord" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReportLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ISSCIssuerParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SecurityOfficerPerson" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ISPSRequirementsType", propOrder = {
    "ublExtensions",
    "id",
    "validISSCIndicator",
    "isscAbsenceReason",
    "isscExpiryDate",
    "sspOnBoardIndicator",
    "sspSecurityMeasuresAppliedIndicator",
    "currentOperatingSecurityLevelCode",
    "additionalMattersDescription",
    "additionalSecurityMeasure",
    "portCallRecord",
    "shipToShipActivityRecord",
    "reportLocation",
    "isscIssuerParty",
    "securityOfficerPerson"
})
@CodingStyleguideUnaware
public class ISPSRequirementsType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "ValidISSCIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ValidISSCIndicatorType validISSCIndicator;
    @XmlElement(name = "ISSCAbsenceReason", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ISSCAbsenceReasonType> isscAbsenceReason;
    @XmlElement(name = "ISSCExpiryDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ISSCExpiryDateType isscExpiryDate;
    @XmlElement(name = "SSPOnBoardIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SSPOnBoardIndicatorType sspOnBoardIndicator;
    @XmlElement(name = "SSPSecurityMeasuresAppliedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SSPSecurityMeasuresAppliedIndicatorType sspSecurityMeasuresAppliedIndicator;
    @XmlElement(name = "CurrentOperatingSecurityLevelCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CurrentOperatingSecurityLevelCodeType currentOperatingSecurityLevelCode;
    @XmlElement(name = "AdditionalMattersDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<AdditionalMattersDescriptionType> additionalMattersDescription;
    @XmlElement(name = "AdditionalSecurityMeasure")
    private List<SecurityMeasureType> additionalSecurityMeasure;
    @XmlElement(name = "PortCallRecord")
    private List<PortCallRecordType> portCallRecord;
    @XmlElement(name = "ShipToShipActivityRecord")
    private List<ShipToShipActivityRecordType> shipToShipActivityRecord;
    @XmlElement(name = "ReportLocation")
    private LocationType reportLocation;
    @XmlElement(name = "ISSCIssuerParty")
    private PartyType isscIssuerParty;
    @XmlElement(name = "SecurityOfficerPerson")
    private PersonType securityOfficerPerson;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ISPSRequirementsType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the validISSCIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ValidISSCIndicatorType }
     *     
     */
    @Nullable
    public ValidISSCIndicatorType getValidISSCIndicator() {
        return validISSCIndicator;
    }

    /**
     * Sets the value of the validISSCIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValidISSCIndicatorType }
     *     
     */
    public void setValidISSCIndicator(
        @Nullable
        ValidISSCIndicatorType value) {
        this.validISSCIndicator = value;
    }

    /**
     * Gets the value of the isscAbsenceReason property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the isscAbsenceReason property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getISSCAbsenceReason().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ISSCAbsenceReasonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the isscAbsenceReason property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ISSCAbsenceReasonType> getISSCAbsenceReason() {
        if (isscAbsenceReason == null) {
            isscAbsenceReason = new ArrayList<>();
        }
        return this.isscAbsenceReason;
    }

    /**
     * Gets the value of the isscExpiryDate property.
     * 
     * @return
     *     possible object is
     *     {@link ISSCExpiryDateType }
     *     
     */
    @Nullable
    public ISSCExpiryDateType getISSCExpiryDate() {
        return isscExpiryDate;
    }

    /**
     * Sets the value of the isscExpiryDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ISSCExpiryDateType }
     *     
     */
    public void setISSCExpiryDate(
        @Nullable
        ISSCExpiryDateType value) {
        this.isscExpiryDate = value;
    }

    /**
     * Gets the value of the sspOnBoardIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link SSPOnBoardIndicatorType }
     *     
     */
    @Nullable
    public SSPOnBoardIndicatorType getSSPOnBoardIndicator() {
        return sspOnBoardIndicator;
    }

    /**
     * Sets the value of the sspOnBoardIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link SSPOnBoardIndicatorType }
     *     
     */
    public void setSSPOnBoardIndicator(
        @Nullable
        SSPOnBoardIndicatorType value) {
        this.sspOnBoardIndicator = value;
    }

    /**
     * Gets the value of the sspSecurityMeasuresAppliedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link SSPSecurityMeasuresAppliedIndicatorType }
     *     
     */
    @Nullable
    public SSPSecurityMeasuresAppliedIndicatorType getSSPSecurityMeasuresAppliedIndicator() {
        return sspSecurityMeasuresAppliedIndicator;
    }

    /**
     * Sets the value of the sspSecurityMeasuresAppliedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link SSPSecurityMeasuresAppliedIndicatorType }
     *     
     */
    public void setSSPSecurityMeasuresAppliedIndicator(
        @Nullable
        SSPSecurityMeasuresAppliedIndicatorType value) {
        this.sspSecurityMeasuresAppliedIndicator = value;
    }

    /**
     * Gets the value of the currentOperatingSecurityLevelCode property.
     * 
     * @return
     *     possible object is
     *     {@link CurrentOperatingSecurityLevelCodeType }
     *     
     */
    @Nullable
    public CurrentOperatingSecurityLevelCodeType getCurrentOperatingSecurityLevelCode() {
        return currentOperatingSecurityLevelCode;
    }

    /**
     * Sets the value of the currentOperatingSecurityLevelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrentOperatingSecurityLevelCodeType }
     *     
     */
    public void setCurrentOperatingSecurityLevelCode(
        @Nullable
        CurrentOperatingSecurityLevelCodeType value) {
        this.currentOperatingSecurityLevelCode = value;
    }

    /**
     * Gets the value of the additionalMattersDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalMattersDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalMattersDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AdditionalMattersDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalMattersDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AdditionalMattersDescriptionType> getAdditionalMattersDescription() {
        if (additionalMattersDescription == null) {
            additionalMattersDescription = new ArrayList<>();
        }
        return this.additionalMattersDescription;
    }

    /**
     * Gets the value of the additionalSecurityMeasure property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalSecurityMeasure property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalSecurityMeasure().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SecurityMeasureType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalSecurityMeasure property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SecurityMeasureType> getAdditionalSecurityMeasure() {
        if (additionalSecurityMeasure == null) {
            additionalSecurityMeasure = new ArrayList<>();
        }
        return this.additionalSecurityMeasure;
    }

    /**
     * Gets the value of the portCallRecord property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the portCallRecord property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPortCallRecord().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PortCallRecordType }
     * </p>
     * 
     * 
     * @return
     *     The value of the portCallRecord property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PortCallRecordType> getPortCallRecord() {
        if (portCallRecord == null) {
            portCallRecord = new ArrayList<>();
        }
        return this.portCallRecord;
    }

    /**
     * Gets the value of the shipToShipActivityRecord property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipToShipActivityRecord property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipToShipActivityRecord().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipToShipActivityRecordType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipToShipActivityRecord property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipToShipActivityRecordType> getShipToShipActivityRecord() {
        if (shipToShipActivityRecord == null) {
            shipToShipActivityRecord = new ArrayList<>();
        }
        return this.shipToShipActivityRecord;
    }

    /**
     * Gets the value of the reportLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getReportLocation() {
        return reportLocation;
    }

    /**
     * Sets the value of the reportLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setReportLocation(
        @Nullable
        LocationType value) {
        this.reportLocation = value;
    }

    /**
     * Gets the value of the isscIssuerParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getISSCIssuerParty() {
        return isscIssuerParty;
    }

    /**
     * Sets the value of the isscIssuerParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setISSCIssuerParty(
        @Nullable
        PartyType value) {
        this.isscIssuerParty = value;
    }

    /**
     * Gets the value of the securityOfficerPerson property.
     * 
     * @return
     *     possible object is
     *     {@link PersonType }
     *     
     */
    @Nullable
    public PersonType getSecurityOfficerPerson() {
        return securityOfficerPerson;
    }

    /**
     * Sets the value of the securityOfficerPerson property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonType }
     *     
     */
    public void setSecurityOfficerPerson(
        @Nullable
        PersonType value) {
        this.securityOfficerPerson = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ISPSRequirementsType rhs = ((ISPSRequirementsType) o);
        if (!EqualsHelper.equalsCollection(additionalMattersDescription, rhs.additionalMattersDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(additionalSecurityMeasure, rhs.additionalSecurityMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(currentOperatingSecurityLevelCode, rhs.currentOperatingSecurityLevelCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(isscAbsenceReason, rhs.isscAbsenceReason)) {
            return false;
        }
        if (!EqualsHelper.equals(isscExpiryDate, rhs.isscExpiryDate)) {
            return false;
        }
        if (!EqualsHelper.equals(isscIssuerParty, rhs.isscIssuerParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(portCallRecord, rhs.portCallRecord)) {
            return false;
        }
        if (!EqualsHelper.equals(reportLocation, rhs.reportLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(securityOfficerPerson, rhs.securityOfficerPerson)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipToShipActivityRecord, rhs.shipToShipActivityRecord)) {
            return false;
        }
        if (!EqualsHelper.equals(sspOnBoardIndicator, rhs.sspOnBoardIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(sspSecurityMeasuresAppliedIndicator, rhs.sspSecurityMeasuresAppliedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(validISSCIndicator, rhs.validISSCIndicator)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalMattersDescription).append(additionalSecurityMeasure).append(currentOperatingSecurityLevelCode).append(id).append(isscAbsenceReason).append(isscExpiryDate).append(isscIssuerParty).append(portCallRecord).append(reportLocation).append(securityOfficerPerson).append(shipToShipActivityRecord).append(sspOnBoardIndicator).append(sspSecurityMeasuresAppliedIndicator).append(ublExtensions).append(validISSCIndicator).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalMattersDescription", additionalMattersDescription).append("additionalSecurityMeasure", additionalSecurityMeasure).append("currentOperatingSecurityLevelCode", currentOperatingSecurityLevelCode).append("id", id).append("isscAbsenceReason", isscAbsenceReason).append("isscExpiryDate", isscExpiryDate).append("isscIssuerParty", isscIssuerParty).append("portCallRecord", portCallRecord).append("reportLocation", reportLocation).append("securityOfficerPerson", securityOfficerPerson).append("shipToShipActivityRecord", shipToShipActivityRecord).append("sspOnBoardIndicator", sspOnBoardIndicator).append("sspSecurityMeasuresAppliedIndicator", sspSecurityMeasuresAppliedIndicator).append("ublExtensions", ublExtensions).append("validISSCIndicator", validISSCIndicator).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setISSCAbsenceReason(
        @Nullable
        final List<ISSCAbsenceReasonType> aList) {
        isscAbsenceReason = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalMattersDescription(
        @Nullable
        final List<AdditionalMattersDescriptionType> aList) {
        additionalMattersDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalSecurityMeasure(
        @Nullable
        final List<SecurityMeasureType> aList) {
        additionalSecurityMeasure = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPortCallRecord(
        @Nullable
        final List<PortCallRecordType> aList) {
        portCallRecord = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipToShipActivityRecord(
        @Nullable
        final List<ShipToShipActivityRecordType> aList) {
        shipToShipActivityRecord = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasISSCAbsenceReasonEntries() {
        return (!getISSCAbsenceReason().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoISSCAbsenceReasonEntries() {
        return getISSCAbsenceReason().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getISSCAbsenceReasonCount() {
        return getISSCAbsenceReason().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ISSCAbsenceReasonType getISSCAbsenceReasonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getISSCAbsenceReason().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addISSCAbsenceReason(
        @Nonnull
        final ISSCAbsenceReasonType elem) {
        getISSCAbsenceReason().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalMattersDescriptionEntries() {
        return (!getAdditionalMattersDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalMattersDescriptionEntries() {
        return getAdditionalMattersDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalMattersDescriptionCount() {
        return getAdditionalMattersDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AdditionalMattersDescriptionType getAdditionalMattersDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalMattersDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalMattersDescription(
        @Nonnull
        final AdditionalMattersDescriptionType elem) {
        getAdditionalMattersDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalSecurityMeasureEntries() {
        return (!getAdditionalSecurityMeasure().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalSecurityMeasureEntries() {
        return getAdditionalSecurityMeasure().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalSecurityMeasureCount() {
        return getAdditionalSecurityMeasure().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SecurityMeasureType getAdditionalSecurityMeasureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalSecurityMeasure().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalSecurityMeasure(
        @Nonnull
        final SecurityMeasureType elem) {
        getAdditionalSecurityMeasure().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPortCallRecordEntries() {
        return (!getPortCallRecord().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPortCallRecordEntries() {
        return getPortCallRecord().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPortCallRecordCount() {
        return getPortCallRecord().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PortCallRecordType getPortCallRecordAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPortCallRecord().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPortCallRecord(
        @Nonnull
        final PortCallRecordType elem) {
        getPortCallRecord().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipToShipActivityRecordEntries() {
        return (!getShipToShipActivityRecord().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipToShipActivityRecordEntries() {
        return getShipToShipActivityRecord().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipToShipActivityRecordCount() {
        return getShipToShipActivityRecord().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipToShipActivityRecordType getShipToShipActivityRecordAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipToShipActivityRecord().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipToShipActivityRecord(
        @Nonnull
        final ShipToShipActivityRecordType elem) {
        getShipToShipActivityRecord().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ISPSRequirementsType ret) {
        if (additionalMattersDescription == null) {
            ret.additionalMattersDescription = null;
        } else {
            List<AdditionalMattersDescriptionType> retAdditionalMattersDescription = new ArrayList<>();
            for (AdditionalMattersDescriptionType aItem: getAdditionalMattersDescription()) {
                retAdditionalMattersDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalMattersDescription = retAdditionalMattersDescription;
        }
        if (additionalSecurityMeasure == null) {
            ret.additionalSecurityMeasure = null;
        } else {
            List<SecurityMeasureType> retAdditionalSecurityMeasure = new ArrayList<>();
            for (SecurityMeasureType aItem: getAdditionalSecurityMeasure()) {
                retAdditionalSecurityMeasure.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalSecurityMeasure = retAdditionalSecurityMeasure;
        }
        ret.currentOperatingSecurityLevelCode = ((currentOperatingSecurityLevelCode == null)?null:currentOperatingSecurityLevelCode.clone());
        ret.id = ((id == null)?null:id.clone());
        if (isscAbsenceReason == null) {
            ret.isscAbsenceReason = null;
        } else {
            List<ISSCAbsenceReasonType> retISSCAbsenceReason = new ArrayList<>();
            for (ISSCAbsenceReasonType aItem: getISSCAbsenceReason()) {
                retISSCAbsenceReason.add(((aItem == null)?null:aItem.clone()));
            }
            ret.isscAbsenceReason = retISSCAbsenceReason;
        }
        ret.isscExpiryDate = ((isscExpiryDate == null)?null:isscExpiryDate.clone());
        ret.isscIssuerParty = ((isscIssuerParty == null)?null:isscIssuerParty.clone());
        if (portCallRecord == null) {
            ret.portCallRecord = null;
        } else {
            List<PortCallRecordType> retPortCallRecord = new ArrayList<>();
            for (PortCallRecordType aItem: getPortCallRecord()) {
                retPortCallRecord.add(((aItem == null)?null:aItem.clone()));
            }
            ret.portCallRecord = retPortCallRecord;
        }
        ret.reportLocation = ((reportLocation == null)?null:reportLocation.clone());
        ret.securityOfficerPerson = ((securityOfficerPerson == null)?null:securityOfficerPerson.clone());
        if (shipToShipActivityRecord == null) {
            ret.shipToShipActivityRecord = null;
        } else {
            List<ShipToShipActivityRecordType> retShipToShipActivityRecord = new ArrayList<>();
            for (ShipToShipActivityRecordType aItem: getShipToShipActivityRecord()) {
                retShipToShipActivityRecord.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipToShipActivityRecord = retShipToShipActivityRecord;
        }
        ret.sspOnBoardIndicator = ((sspOnBoardIndicator == null)?null:sspOnBoardIndicator.clone());
        ret.sspSecurityMeasuresAppliedIndicator = ((sspSecurityMeasuresAppliedIndicator == null)?null:sspSecurityMeasuresAppliedIndicator.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.validISSCIndicator = ((validISSCIndicator == null)?null:validISSCIndicator.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ISPSRequirementsType clone() {
        ISPSRequirementsType ret = new ISPSRequirementsType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ValidISSCIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ValidISSCIndicatorType setValidISSCIndicator(final boolean valueParam) {
        ValidISSCIndicatorType aObj = getValidISSCIndicator();
        if (aObj == null) {
            aObj = new ValidISSCIndicatorType(valueParam);
            setValidISSCIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ISSCExpiryDateType and never <code>null</code>
     */
    @Nonnull
    public ISSCExpiryDateType setISSCExpiryDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ISSCExpiryDateType aObj = getISSCExpiryDate();
        if (aObj == null) {
            aObj = new ISSCExpiryDateType(valueParam);
            setISSCExpiryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ISSCExpiryDateType and never <code>null</code>
     */
    @Nonnull
    public ISSCExpiryDateType setISSCExpiryDate(
        @Nullable
        final LocalDate valueParam) {
        ISSCExpiryDateType aObj = getISSCExpiryDate();
        if (aObj == null) {
            aObj = new ISSCExpiryDateType(valueParam);
            setISSCExpiryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type SSPOnBoardIndicatorType and never <code>null</code>
     */
    @Nonnull
    public SSPOnBoardIndicatorType setSSPOnBoardIndicator(final boolean valueParam) {
        SSPOnBoardIndicatorType aObj = getSSPOnBoardIndicator();
        if (aObj == null) {
            aObj = new SSPOnBoardIndicatorType(valueParam);
            setSSPOnBoardIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type SSPSecurityMeasuresAppliedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public SSPSecurityMeasuresAppliedIndicatorType setSSPSecurityMeasuresAppliedIndicator(final boolean valueParam) {
        SSPSecurityMeasuresAppliedIndicatorType aObj = getSSPSecurityMeasuresAppliedIndicator();
        if (aObj == null) {
            aObj = new SSPSecurityMeasuresAppliedIndicatorType(valueParam);
            setSSPSecurityMeasuresAppliedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CurrentOperatingSecurityLevelCodeType and never <code>null</code>
     */
    @Nonnull
    public CurrentOperatingSecurityLevelCodeType setCurrentOperatingSecurityLevelCode(
        @Nullable
        final String valueParam) {
        CurrentOperatingSecurityLevelCodeType aObj = getCurrentOperatingSecurityLevelCode();
        if (aObj == null) {
            aObj = new CurrentOperatingSecurityLevelCodeType(valueParam);
            setCurrentOperatingSecurityLevelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ValidISSCIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ValidISSCIndicatorType object or the passed nullValue
     */
    public boolean isValidISSCIndicatorValue(final boolean nullValue) {
        ValidISSCIndicatorType aObj = getValidISSCIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ISSCExpiryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ISSCExpiryDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getISSCExpiryDateValue() {
        ISSCExpiryDateType aObj = getISSCExpiryDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ISSCExpiryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ISSCExpiryDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getISSCExpiryDateValueLocal() {
        ISSCExpiryDateType aObj = getISSCExpiryDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained SSPOnBoardIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained SSPOnBoardIndicatorType object or the passed nullValue
     */
    public boolean isSSPOnBoardIndicatorValue(final boolean nullValue) {
        SSPOnBoardIndicatorType aObj = getSSPOnBoardIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained SSPSecurityMeasuresAppliedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained SSPSecurityMeasuresAppliedIndicatorType object or the passed nullValue
     */
    public boolean isSSPSecurityMeasuresAppliedIndicatorValue(final boolean nullValue) {
        SSPSecurityMeasuresAppliedIndicatorType aObj = getSSPSecurityMeasuresAppliedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained CurrentOperatingSecurityLevelCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CurrentOperatingSecurityLevelCodeType object or <code>null</code>
     */
    @Nullable
    public String getCurrentOperatingSecurityLevelCodeValue() {
        CurrentOperatingSecurityLevelCodeType aObj = getCurrentOperatingSecurityLevelCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
