
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.AdditionalInformationType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.BrandNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CatalogueIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.HazardousRiskIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.KeywordType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ModelNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PackQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PackSizeNumericType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for ItemType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ItemType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PackQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PackSizeNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CatalogueIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Name" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HazardousRiskIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AdditionalInformation" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Keyword" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BrandName" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ModelName" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}BuyersItemIdentification" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SellersItemIdentification" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ManufacturersItemIdentification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}StandardItemIdentification" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CatalogueItemIdentification" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalItemIdentification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CatalogueDocumentReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ItemSpecificationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OriginCountry" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CommodityClassification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransactionConditions" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}HazardousItem" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ClassifiedTaxCategory" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalItemProperty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ManufacturerParty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}InformationContentProviderParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OriginAddress" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ItemInstance" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Certificate" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Dimension" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ItemType", propOrder = {
    "ublExtensions",
    "description",
    "packQuantity",
    "packSizeNumeric",
    "catalogueIndicator",
    "name",
    "hazardousRiskIndicator",
    "additionalInformation",
    "keyword",
    "brandName",
    "modelName",
    "buyersItemIdentification",
    "sellersItemIdentification",
    "manufacturersItemIdentification",
    "standardItemIdentification",
    "catalogueItemIdentification",
    "additionalItemIdentification",
    "catalogueDocumentReference",
    "itemSpecificationDocumentReference",
    "originCountry",
    "commodityClassification",
    "transactionConditions",
    "hazardousItem",
    "classifiedTaxCategory",
    "additionalItemProperty",
    "manufacturerParty",
    "informationContentProviderParty",
    "originAddress",
    "itemInstance",
    "certificate",
    "dimension"
})
@CodingStyleguideUnaware
public class ItemType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "PackQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PackQuantityType packQuantity;
    @XmlElement(name = "PackSizeNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PackSizeNumericType packSizeNumeric;
    @XmlElement(name = "CatalogueIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CatalogueIndicatorType catalogueIndicator;
    @XmlElement(name = "Name", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NameType name;
    @XmlElement(name = "HazardousRiskIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HazardousRiskIndicatorType hazardousRiskIndicator;
    @XmlElement(name = "AdditionalInformation", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<AdditionalInformationType> additionalInformation;
    @XmlElement(name = "Keyword", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<KeywordType> keyword;
    @XmlElement(name = "BrandName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<BrandNameType> brandName;
    @XmlElement(name = "ModelName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ModelNameType> modelName;
    @XmlElement(name = "BuyersItemIdentification")
    private ItemIdentificationType buyersItemIdentification;
    @XmlElement(name = "SellersItemIdentification")
    private ItemIdentificationType sellersItemIdentification;
    @XmlElement(name = "ManufacturersItemIdentification")
    private List<ItemIdentificationType> manufacturersItemIdentification;
    @XmlElement(name = "StandardItemIdentification")
    private ItemIdentificationType standardItemIdentification;
    @XmlElement(name = "CatalogueItemIdentification")
    private ItemIdentificationType catalogueItemIdentification;
    @XmlElement(name = "AdditionalItemIdentification")
    private List<ItemIdentificationType> additionalItemIdentification;
    @XmlElement(name = "CatalogueDocumentReference")
    private DocumentReferenceType catalogueDocumentReference;
    @XmlElement(name = "ItemSpecificationDocumentReference")
    private List<DocumentReferenceType> itemSpecificationDocumentReference;
    @XmlElement(name = "OriginCountry")
    private CountryType originCountry;
    @XmlElement(name = "CommodityClassification")
    private List<CommodityClassificationType> commodityClassification;
    @XmlElement(name = "TransactionConditions")
    private List<TransactionConditionsType> transactionConditions;
    @XmlElement(name = "HazardousItem")
    private List<HazardousItemType> hazardousItem;
    @XmlElement(name = "ClassifiedTaxCategory")
    private List<TaxCategoryType> classifiedTaxCategory;
    @XmlElement(name = "AdditionalItemProperty")
    private List<ItemPropertyType> additionalItemProperty;
    @XmlElement(name = "ManufacturerParty")
    private List<PartyType> manufacturerParty;
    @XmlElement(name = "InformationContentProviderParty")
    private PartyType informationContentProviderParty;
    @XmlElement(name = "OriginAddress")
    private List<AddressType> originAddress;
    @XmlElement(name = "ItemInstance")
    private List<ItemInstanceType> itemInstance;
    @XmlElement(name = "Certificate")
    private List<CertificateType> certificate;
    @XmlElement(name = "Dimension")
    private List<DimensionType> dimension;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ItemType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the packQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link PackQuantityType }
     *     
     */
    @Nullable
    public PackQuantityType getPackQuantity() {
        return packQuantity;
    }

    /**
     * Sets the value of the packQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link PackQuantityType }
     *     
     */
    public void setPackQuantity(
        @Nullable
        PackQuantityType value) {
        this.packQuantity = value;
    }

    /**
     * Gets the value of the packSizeNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link PackSizeNumericType }
     *     
     */
    @Nullable
    public PackSizeNumericType getPackSizeNumeric() {
        return packSizeNumeric;
    }

    /**
     * Sets the value of the packSizeNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link PackSizeNumericType }
     *     
     */
    public void setPackSizeNumeric(
        @Nullable
        PackSizeNumericType value) {
        this.packSizeNumeric = value;
    }

    /**
     * Gets the value of the catalogueIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link CatalogueIndicatorType }
     *     
     */
    @Nullable
    public CatalogueIndicatorType getCatalogueIndicator() {
        return catalogueIndicator;
    }

    /**
     * Sets the value of the catalogueIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link CatalogueIndicatorType }
     *     
     */
    public void setCatalogueIndicator(
        @Nullable
        CatalogueIndicatorType value) {
        this.catalogueIndicator = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setName(
        @Nullable
        NameType value) {
        this.name = value;
    }

    /**
     * Gets the value of the hazardousRiskIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link HazardousRiskIndicatorType }
     *     
     */
    @Nullable
    public HazardousRiskIndicatorType getHazardousRiskIndicator() {
        return hazardousRiskIndicator;
    }

    /**
     * Sets the value of the hazardousRiskIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link HazardousRiskIndicatorType }
     *     
     */
    public void setHazardousRiskIndicator(
        @Nullable
        HazardousRiskIndicatorType value) {
        this.hazardousRiskIndicator = value;
    }

    /**
     * Gets the value of the additionalInformation property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalInformation property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalInformation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AdditionalInformationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalInformation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AdditionalInformationType> getAdditionalInformation() {
        if (additionalInformation == null) {
            additionalInformation = new ArrayList<>();
        }
        return this.additionalInformation;
    }

    /**
     * Gets the value of the keyword property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the keyword property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getKeyword().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link KeywordType }
     * </p>
     * 
     * 
     * @return
     *     The value of the keyword property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<KeywordType> getKeyword() {
        if (keyword == null) {
            keyword = new ArrayList<>();
        }
        return this.keyword;
    }

    /**
     * Gets the value of the brandName property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the brandName property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getBrandName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BrandNameType }
     * </p>
     * 
     * 
     * @return
     *     The value of the brandName property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BrandNameType> getBrandName() {
        if (brandName == null) {
            brandName = new ArrayList<>();
        }
        return this.brandName;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the modelName property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getModelName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ModelNameType }
     * </p>
     * 
     * 
     * @return
     *     The value of the modelName property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ModelNameType> getModelName() {
        if (modelName == null) {
            modelName = new ArrayList<>();
        }
        return this.modelName;
    }

    /**
     * Gets the value of the buyersItemIdentification property.
     * 
     * @return
     *     possible object is
     *     {@link ItemIdentificationType }
     *     
     */
    @Nullable
    public ItemIdentificationType getBuyersItemIdentification() {
        return buyersItemIdentification;
    }

    /**
     * Sets the value of the buyersItemIdentification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ItemIdentificationType }
     *     
     */
    public void setBuyersItemIdentification(
        @Nullable
        ItemIdentificationType value) {
        this.buyersItemIdentification = value;
    }

    /**
     * Gets the value of the sellersItemIdentification property.
     * 
     * @return
     *     possible object is
     *     {@link ItemIdentificationType }
     *     
     */
    @Nullable
    public ItemIdentificationType getSellersItemIdentification() {
        return sellersItemIdentification;
    }

    /**
     * Sets the value of the sellersItemIdentification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ItemIdentificationType }
     *     
     */
    public void setSellersItemIdentification(
        @Nullable
        ItemIdentificationType value) {
        this.sellersItemIdentification = value;
    }

    /**
     * Gets the value of the manufacturersItemIdentification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the manufacturersItemIdentification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getManufacturersItemIdentification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemIdentificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the manufacturersItemIdentification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemIdentificationType> getManufacturersItemIdentification() {
        if (manufacturersItemIdentification == null) {
            manufacturersItemIdentification = new ArrayList<>();
        }
        return this.manufacturersItemIdentification;
    }

    /**
     * Gets the value of the standardItemIdentification property.
     * 
     * @return
     *     possible object is
     *     {@link ItemIdentificationType }
     *     
     */
    @Nullable
    public ItemIdentificationType getStandardItemIdentification() {
        return standardItemIdentification;
    }

    /**
     * Sets the value of the standardItemIdentification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ItemIdentificationType }
     *     
     */
    public void setStandardItemIdentification(
        @Nullable
        ItemIdentificationType value) {
        this.standardItemIdentification = value;
    }

    /**
     * Gets the value of the catalogueItemIdentification property.
     * 
     * @return
     *     possible object is
     *     {@link ItemIdentificationType }
     *     
     */
    @Nullable
    public ItemIdentificationType getCatalogueItemIdentification() {
        return catalogueItemIdentification;
    }

    /**
     * Sets the value of the catalogueItemIdentification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ItemIdentificationType }
     *     
     */
    public void setCatalogueItemIdentification(
        @Nullable
        ItemIdentificationType value) {
        this.catalogueItemIdentification = value;
    }

    /**
     * Gets the value of the additionalItemIdentification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalItemIdentification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalItemIdentification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemIdentificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalItemIdentification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemIdentificationType> getAdditionalItemIdentification() {
        if (additionalItemIdentification == null) {
            additionalItemIdentification = new ArrayList<>();
        }
        return this.additionalItemIdentification;
    }

    /**
     * Gets the value of the catalogueDocumentReference property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentReferenceType }
     *     
     */
    @Nullable
    public DocumentReferenceType getCatalogueDocumentReference() {
        return catalogueDocumentReference;
    }

    /**
     * Sets the value of the catalogueDocumentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentReferenceType }
     *     
     */
    public void setCatalogueDocumentReference(
        @Nullable
        DocumentReferenceType value) {
        this.catalogueDocumentReference = value;
    }

    /**
     * Gets the value of the itemSpecificationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the itemSpecificationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getItemSpecificationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the itemSpecificationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getItemSpecificationDocumentReference() {
        if (itemSpecificationDocumentReference == null) {
            itemSpecificationDocumentReference = new ArrayList<>();
        }
        return this.itemSpecificationDocumentReference;
    }

    /**
     * Gets the value of the originCountry property.
     * 
     * @return
     *     possible object is
     *     {@link CountryType }
     *     
     */
    @Nullable
    public CountryType getOriginCountry() {
        return originCountry;
    }

    /**
     * Sets the value of the originCountry property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryType }
     *     
     */
    public void setOriginCountry(
        @Nullable
        CountryType value) {
        this.originCountry = value;
    }

    /**
     * Gets the value of the commodityClassification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the commodityClassification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCommodityClassification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommodityClassificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the commodityClassification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommodityClassificationType> getCommodityClassification() {
        if (commodityClassification == null) {
            commodityClassification = new ArrayList<>();
        }
        return this.commodityClassification;
    }

    /**
     * Gets the value of the transactionConditions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transactionConditions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTransactionConditions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransactionConditionsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the transactionConditions property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransactionConditionsType> getTransactionConditions() {
        if (transactionConditions == null) {
            transactionConditions = new ArrayList<>();
        }
        return this.transactionConditions;
    }

    /**
     * Gets the value of the hazardousItem property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the hazardousItem property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getHazardousItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link HazardousItemType }
     * </p>
     * 
     * 
     * @return
     *     The value of the hazardousItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<HazardousItemType> getHazardousItem() {
        if (hazardousItem == null) {
            hazardousItem = new ArrayList<>();
        }
        return this.hazardousItem;
    }

    /**
     * Gets the value of the classifiedTaxCategory property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the classifiedTaxCategory property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getClassifiedTaxCategory().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TaxCategoryType }
     * </p>
     * 
     * 
     * @return
     *     The value of the classifiedTaxCategory property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TaxCategoryType> getClassifiedTaxCategory() {
        if (classifiedTaxCategory == null) {
            classifiedTaxCategory = new ArrayList<>();
        }
        return this.classifiedTaxCategory;
    }

    /**
     * Gets the value of the additionalItemProperty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalItemProperty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalItemProperty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemPropertyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalItemProperty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemPropertyType> getAdditionalItemProperty() {
        if (additionalItemProperty == null) {
            additionalItemProperty = new ArrayList<>();
        }
        return this.additionalItemProperty;
    }

    /**
     * Gets the value of the manufacturerParty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the manufacturerParty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getManufacturerParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the manufacturerParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyType> getManufacturerParty() {
        if (manufacturerParty == null) {
            manufacturerParty = new ArrayList<>();
        }
        return this.manufacturerParty;
    }

    /**
     * Gets the value of the informationContentProviderParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getInformationContentProviderParty() {
        return informationContentProviderParty;
    }

    /**
     * Sets the value of the informationContentProviderParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setInformationContentProviderParty(
        @Nullable
        PartyType value) {
        this.informationContentProviderParty = value;
    }

    /**
     * Gets the value of the originAddress property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the originAddress property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getOriginAddress().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AddressType }
     * </p>
     * 
     * 
     * @return
     *     The value of the originAddress property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressType> getOriginAddress() {
        if (originAddress == null) {
            originAddress = new ArrayList<>();
        }
        return this.originAddress;
    }

    /**
     * Gets the value of the itemInstance property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the itemInstance property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getItemInstance().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemInstanceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the itemInstance property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemInstanceType> getItemInstance() {
        if (itemInstance == null) {
            itemInstance = new ArrayList<>();
        }
        return this.itemInstance;
    }

    /**
     * Gets the value of the certificate property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the certificate property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCertificate().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CertificateType }
     * </p>
     * 
     * 
     * @return
     *     The value of the certificate property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CertificateType> getCertificate() {
        if (certificate == null) {
            certificate = new ArrayList<>();
        }
        return this.certificate;
    }

    /**
     * Gets the value of the dimension property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dimension property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDimension().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DimensionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the dimension property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DimensionType> getDimension() {
        if (dimension == null) {
            dimension = new ArrayList<>();
        }
        return this.dimension;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ItemType rhs = ((ItemType) o);
        if (!EqualsHelper.equalsCollection(additionalInformation, rhs.additionalInformation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(additionalItemIdentification, rhs.additionalItemIdentification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(additionalItemProperty, rhs.additionalItemProperty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(brandName, rhs.brandName)) {
            return false;
        }
        if (!EqualsHelper.equals(buyersItemIdentification, rhs.buyersItemIdentification)) {
            return false;
        }
        if (!EqualsHelper.equals(catalogueDocumentReference, rhs.catalogueDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(catalogueIndicator, rhs.catalogueIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(catalogueItemIdentification, rhs.catalogueItemIdentification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(certificate, rhs.certificate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(classifiedTaxCategory, rhs.classifiedTaxCategory)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(commodityClassification, rhs.commodityClassification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(dimension, rhs.dimension)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hazardousItem, rhs.hazardousItem)) {
            return false;
        }
        if (!EqualsHelper.equals(hazardousRiskIndicator, rhs.hazardousRiskIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(informationContentProviderParty, rhs.informationContentProviderParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(itemInstance, rhs.itemInstance)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(itemSpecificationDocumentReference, rhs.itemSpecificationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(keyword, rhs.keyword)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(manufacturerParty, rhs.manufacturerParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(manufacturersItemIdentification, rhs.manufacturersItemIdentification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(modelName, rhs.modelName)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(originAddress, rhs.originAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(originCountry, rhs.originCountry)) {
            return false;
        }
        if (!EqualsHelper.equals(packQuantity, rhs.packQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(packSizeNumeric, rhs.packSizeNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(sellersItemIdentification, rhs.sellersItemIdentification)) {
            return false;
        }
        if (!EqualsHelper.equals(standardItemIdentification, rhs.standardItemIdentification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(transactionConditions, rhs.transactionConditions)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalInformation).append(additionalItemIdentification).append(additionalItemProperty).append(brandName).append(buyersItemIdentification).append(catalogueDocumentReference).append(catalogueIndicator).append(catalogueItemIdentification).append(certificate).append(classifiedTaxCategory).append(commodityClassification).append(description).append(dimension).append(hazardousItem).append(hazardousRiskIndicator).append(informationContentProviderParty).append(itemInstance).append(itemSpecificationDocumentReference).append(keyword).append(manufacturerParty).append(manufacturersItemIdentification).append(modelName).append(name).append(originAddress).append(originCountry).append(packQuantity).append(packSizeNumeric).append(sellersItemIdentification).append(standardItemIdentification).append(transactionConditions).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalInformation", additionalInformation).append("additionalItemIdentification", additionalItemIdentification).append("additionalItemProperty", additionalItemProperty).append("brandName", brandName).append("buyersItemIdentification", buyersItemIdentification).append("catalogueDocumentReference", catalogueDocumentReference).append("catalogueIndicator", catalogueIndicator).append("catalogueItemIdentification", catalogueItemIdentification).append("certificate", certificate).append("classifiedTaxCategory", classifiedTaxCategory).append("commodityClassification", commodityClassification).append("description", description).append("dimension", dimension).append("hazardousItem", hazardousItem).append("hazardousRiskIndicator", hazardousRiskIndicator).append("informationContentProviderParty", informationContentProviderParty).append("itemInstance", itemInstance).append("itemSpecificationDocumentReference", itemSpecificationDocumentReference).append("keyword", keyword).append("manufacturerParty", manufacturerParty).append("manufacturersItemIdentification", manufacturersItemIdentification).append("modelName", modelName).append("name", name).append("originAddress", originAddress).append("originCountry", originCountry).append("packQuantity", packQuantity).append("packSizeNumeric", packSizeNumeric).append("sellersItemIdentification", sellersItemIdentification).append("standardItemIdentification", standardItemIdentification).append("transactionConditions", transactionConditions).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalInformation(
        @Nullable
        final List<AdditionalInformationType> aList) {
        additionalInformation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setKeyword(
        @Nullable
        final List<KeywordType> aList) {
        keyword = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBrandName(
        @Nullable
        final List<BrandNameType> aList) {
        brandName = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setModelName(
        @Nullable
        final List<ModelNameType> aList) {
        modelName = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setManufacturersItemIdentification(
        @Nullable
        final List<ItemIdentificationType> aList) {
        manufacturersItemIdentification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalItemIdentification(
        @Nullable
        final List<ItemIdentificationType> aList) {
        additionalItemIdentification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItemSpecificationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        itemSpecificationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCommodityClassification(
        @Nullable
        final List<CommodityClassificationType> aList) {
        commodityClassification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTransactionConditions(
        @Nullable
        final List<TransactionConditionsType> aList) {
        transactionConditions = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setHazardousItem(
        @Nullable
        final List<HazardousItemType> aList) {
        hazardousItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setClassifiedTaxCategory(
        @Nullable
        final List<TaxCategoryType> aList) {
        classifiedTaxCategory = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalItemProperty(
        @Nullable
        final List<ItemPropertyType> aList) {
        additionalItemProperty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setManufacturerParty(
        @Nullable
        final List<PartyType> aList) {
        manufacturerParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setOriginAddress(
        @Nullable
        final List<AddressType> aList) {
        originAddress = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItemInstance(
        @Nullable
        final List<ItemInstanceType> aList) {
        itemInstance = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCertificate(
        @Nullable
        final List<CertificateType> aList) {
        certificate = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDimension(
        @Nullable
        final List<DimensionType> aList) {
        dimension = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalInformationEntries() {
        return (!getAdditionalInformation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalInformationEntries() {
        return getAdditionalInformation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalInformationCount() {
        return getAdditionalInformation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AdditionalInformationType getAdditionalInformationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalInformation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalInformation(
        @Nonnull
        final AdditionalInformationType elem) {
        getAdditionalInformation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasKeywordEntries() {
        return (!getKeyword().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoKeywordEntries() {
        return getKeyword().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getKeywordCount() {
        return getKeyword().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public KeywordType getKeywordAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getKeyword().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addKeyword(
        @Nonnull
        final KeywordType elem) {
        getKeyword().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBrandNameEntries() {
        return (!getBrandName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBrandNameEntries() {
        return getBrandName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBrandNameCount() {
        return getBrandName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BrandNameType getBrandNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBrandName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBrandName(
        @Nonnull
        final BrandNameType elem) {
        getBrandName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasModelNameEntries() {
        return (!getModelName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoModelNameEntries() {
        return getModelName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getModelNameCount() {
        return getModelName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ModelNameType getModelNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getModelName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addModelName(
        @Nonnull
        final ModelNameType elem) {
        getModelName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasManufacturersItemIdentificationEntries() {
        return (!getManufacturersItemIdentification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoManufacturersItemIdentificationEntries() {
        return getManufacturersItemIdentification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getManufacturersItemIdentificationCount() {
        return getManufacturersItemIdentification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemIdentificationType getManufacturersItemIdentificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getManufacturersItemIdentification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addManufacturersItemIdentification(
        @Nonnull
        final ItemIdentificationType elem) {
        getManufacturersItemIdentification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalItemIdentificationEntries() {
        return (!getAdditionalItemIdentification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalItemIdentificationEntries() {
        return getAdditionalItemIdentification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalItemIdentificationCount() {
        return getAdditionalItemIdentification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemIdentificationType getAdditionalItemIdentificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalItemIdentification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalItemIdentification(
        @Nonnull
        final ItemIdentificationType elem) {
        getAdditionalItemIdentification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemSpecificationDocumentReferenceEntries() {
        return (!getItemSpecificationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemSpecificationDocumentReferenceEntries() {
        return getItemSpecificationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemSpecificationDocumentReferenceCount() {
        return getItemSpecificationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getItemSpecificationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItemSpecificationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItemSpecificationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getItemSpecificationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommodityClassificationEntries() {
        return (!getCommodityClassification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommodityClassificationEntries() {
        return getCommodityClassification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommodityClassificationCount() {
        return getCommodityClassification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommodityClassificationType getCommodityClassificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCommodityClassification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCommodityClassification(
        @Nonnull
        final CommodityClassificationType elem) {
        getCommodityClassification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTransactionConditionsEntries() {
        return (!getTransactionConditions().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTransactionConditionsEntries() {
        return getTransactionConditions().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTransactionConditionsCount() {
        return getTransactionConditions().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransactionConditionsType getTransactionConditionsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTransactionConditions().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTransactionConditions(
        @Nonnull
        final TransactionConditionsType elem) {
        getTransactionConditions().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasHazardousItemEntries() {
        return (!getHazardousItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoHazardousItemEntries() {
        return getHazardousItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getHazardousItemCount() {
        return getHazardousItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public HazardousItemType getHazardousItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHazardousItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addHazardousItem(
        @Nonnull
        final HazardousItemType elem) {
        getHazardousItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasClassifiedTaxCategoryEntries() {
        return (!getClassifiedTaxCategory().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoClassifiedTaxCategoryEntries() {
        return getClassifiedTaxCategory().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getClassifiedTaxCategoryCount() {
        return getClassifiedTaxCategory().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TaxCategoryType getClassifiedTaxCategoryAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getClassifiedTaxCategory().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addClassifiedTaxCategory(
        @Nonnull
        final TaxCategoryType elem) {
        getClassifiedTaxCategory().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalItemPropertyEntries() {
        return (!getAdditionalItemProperty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalItemPropertyEntries() {
        return getAdditionalItemProperty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalItemPropertyCount() {
        return getAdditionalItemProperty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemPropertyType getAdditionalItemPropertyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalItemProperty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalItemProperty(
        @Nonnull
        final ItemPropertyType elem) {
        getAdditionalItemProperty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasManufacturerPartyEntries() {
        return (!getManufacturerParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoManufacturerPartyEntries() {
        return getManufacturerParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getManufacturerPartyCount() {
        return getManufacturerParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyType getManufacturerPartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getManufacturerParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addManufacturerParty(
        @Nonnull
        final PartyType elem) {
        getManufacturerParty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasOriginAddressEntries() {
        return (!getOriginAddress().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoOriginAddressEntries() {
        return getOriginAddress().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getOriginAddressCount() {
        return getOriginAddress().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressType getOriginAddressAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getOriginAddress().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addOriginAddress(
        @Nonnull
        final AddressType elem) {
        getOriginAddress().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemInstanceEntries() {
        return (!getItemInstance().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemInstanceEntries() {
        return getItemInstance().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemInstanceCount() {
        return getItemInstance().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemInstanceType getItemInstanceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItemInstance().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItemInstance(
        @Nonnull
        final ItemInstanceType elem) {
        getItemInstance().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCertificateEntries() {
        return (!getCertificate().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCertificateEntries() {
        return getCertificate().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCertificateCount() {
        return getCertificate().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CertificateType getCertificateAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCertificate().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCertificate(
        @Nonnull
        final CertificateType elem) {
        getCertificate().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDimensionEntries() {
        return (!getDimension().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDimensionEntries() {
        return getDimension().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDimensionCount() {
        return getDimension().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DimensionType getDimensionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDimension().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDimension(
        @Nonnull
        final DimensionType elem) {
        getDimension().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ItemType ret) {
        if (additionalInformation == null) {
            ret.additionalInformation = null;
        } else {
            List<AdditionalInformationType> retAdditionalInformation = new ArrayList<>();
            for (AdditionalInformationType aItem: getAdditionalInformation()) {
                retAdditionalInformation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalInformation = retAdditionalInformation;
        }
        if (additionalItemIdentification == null) {
            ret.additionalItemIdentification = null;
        } else {
            List<ItemIdentificationType> retAdditionalItemIdentification = new ArrayList<>();
            for (ItemIdentificationType aItem: getAdditionalItemIdentification()) {
                retAdditionalItemIdentification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalItemIdentification = retAdditionalItemIdentification;
        }
        if (additionalItemProperty == null) {
            ret.additionalItemProperty = null;
        } else {
            List<ItemPropertyType> retAdditionalItemProperty = new ArrayList<>();
            for (ItemPropertyType aItem: getAdditionalItemProperty()) {
                retAdditionalItemProperty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalItemProperty = retAdditionalItemProperty;
        }
        if (brandName == null) {
            ret.brandName = null;
        } else {
            List<BrandNameType> retBrandName = new ArrayList<>();
            for (BrandNameType aItem: getBrandName()) {
                retBrandName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.brandName = retBrandName;
        }
        ret.buyersItemIdentification = ((buyersItemIdentification == null)?null:buyersItemIdentification.clone());
        ret.catalogueDocumentReference = ((catalogueDocumentReference == null)?null:catalogueDocumentReference.clone());
        ret.catalogueIndicator = ((catalogueIndicator == null)?null:catalogueIndicator.clone());
        ret.catalogueItemIdentification = ((catalogueItemIdentification == null)?null:catalogueItemIdentification.clone());
        if (certificate == null) {
            ret.certificate = null;
        } else {
            List<CertificateType> retCertificate = new ArrayList<>();
            for (CertificateType aItem: getCertificate()) {
                retCertificate.add(((aItem == null)?null:aItem.clone()));
            }
            ret.certificate = retCertificate;
        }
        if (classifiedTaxCategory == null) {
            ret.classifiedTaxCategory = null;
        } else {
            List<TaxCategoryType> retClassifiedTaxCategory = new ArrayList<>();
            for (TaxCategoryType aItem: getClassifiedTaxCategory()) {
                retClassifiedTaxCategory.add(((aItem == null)?null:aItem.clone()));
            }
            ret.classifiedTaxCategory = retClassifiedTaxCategory;
        }
        if (commodityClassification == null) {
            ret.commodityClassification = null;
        } else {
            List<CommodityClassificationType> retCommodityClassification = new ArrayList<>();
            for (CommodityClassificationType aItem: getCommodityClassification()) {
                retCommodityClassification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.commodityClassification = retCommodityClassification;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (dimension == null) {
            ret.dimension = null;
        } else {
            List<DimensionType> retDimension = new ArrayList<>();
            for (DimensionType aItem: getDimension()) {
                retDimension.add(((aItem == null)?null:aItem.clone()));
            }
            ret.dimension = retDimension;
        }
        if (hazardousItem == null) {
            ret.hazardousItem = null;
        } else {
            List<HazardousItemType> retHazardousItem = new ArrayList<>();
            for (HazardousItemType aItem: getHazardousItem()) {
                retHazardousItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hazardousItem = retHazardousItem;
        }
        ret.hazardousRiskIndicator = ((hazardousRiskIndicator == null)?null:hazardousRiskIndicator.clone());
        ret.informationContentProviderParty = ((informationContentProviderParty == null)?null:informationContentProviderParty.clone());
        if (itemInstance == null) {
            ret.itemInstance = null;
        } else {
            List<ItemInstanceType> retItemInstance = new ArrayList<>();
            for (ItemInstanceType aItem: getItemInstance()) {
                retItemInstance.add(((aItem == null)?null:aItem.clone()));
            }
            ret.itemInstance = retItemInstance;
        }
        if (itemSpecificationDocumentReference == null) {
            ret.itemSpecificationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retItemSpecificationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getItemSpecificationDocumentReference()) {
                retItemSpecificationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.itemSpecificationDocumentReference = retItemSpecificationDocumentReference;
        }
        if (keyword == null) {
            ret.keyword = null;
        } else {
            List<KeywordType> retKeyword = new ArrayList<>();
            for (KeywordType aItem: getKeyword()) {
                retKeyword.add(((aItem == null)?null:aItem.clone()));
            }
            ret.keyword = retKeyword;
        }
        if (manufacturerParty == null) {
            ret.manufacturerParty = null;
        } else {
            List<PartyType> retManufacturerParty = new ArrayList<>();
            for (PartyType aItem: getManufacturerParty()) {
                retManufacturerParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.manufacturerParty = retManufacturerParty;
        }
        if (manufacturersItemIdentification == null) {
            ret.manufacturersItemIdentification = null;
        } else {
            List<ItemIdentificationType> retManufacturersItemIdentification = new ArrayList<>();
            for (ItemIdentificationType aItem: getManufacturersItemIdentification()) {
                retManufacturersItemIdentification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.manufacturersItemIdentification = retManufacturersItemIdentification;
        }
        if (modelName == null) {
            ret.modelName = null;
        } else {
            List<ModelNameType> retModelName = new ArrayList<>();
            for (ModelNameType aItem: getModelName()) {
                retModelName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.modelName = retModelName;
        }
        ret.name = ((name == null)?null:name.clone());
        if (originAddress == null) {
            ret.originAddress = null;
        } else {
            List<AddressType> retOriginAddress = new ArrayList<>();
            for (AddressType aItem: getOriginAddress()) {
                retOriginAddress.add(((aItem == null)?null:aItem.clone()));
            }
            ret.originAddress = retOriginAddress;
        }
        ret.originCountry = ((originCountry == null)?null:originCountry.clone());
        ret.packQuantity = ((packQuantity == null)?null:packQuantity.clone());
        ret.packSizeNumeric = ((packSizeNumeric == null)?null:packSizeNumeric.clone());
        ret.sellersItemIdentification = ((sellersItemIdentification == null)?null:sellersItemIdentification.clone());
        ret.standardItemIdentification = ((standardItemIdentification == null)?null:standardItemIdentification.clone());
        if (transactionConditions == null) {
            ret.transactionConditions = null;
        } else {
            List<TransactionConditionsType> retTransactionConditions = new ArrayList<>();
            for (TransactionConditionsType aItem: getTransactionConditions()) {
                retTransactionConditions.add(((aItem == null)?null:aItem.clone()));
            }
            ret.transactionConditions = retTransactionConditions;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ItemType clone() {
        ItemType ret = new ItemType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PackQuantityType and never <code>null</code>
     */
    @Nonnull
    public PackQuantityType setPackQuantity(
        @Nullable
        final BigDecimal valueParam) {
        PackQuantityType aObj = getPackQuantity();
        if (aObj == null) {
            aObj = new PackQuantityType(valueParam);
            setPackQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PackSizeNumericType and never <code>null</code>
     */
    @Nonnull
    public PackSizeNumericType setPackSizeNumeric(
        @Nullable
        final BigDecimal valueParam) {
        PackSizeNumericType aObj = getPackSizeNumeric();
        if (aObj == null) {
            aObj = new PackSizeNumericType(valueParam);
            setPackSizeNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type CatalogueIndicatorType and never <code>null</code>
     */
    @Nonnull
    public CatalogueIndicatorType setCatalogueIndicator(final boolean valueParam) {
        CatalogueIndicatorType aObj = getCatalogueIndicator();
        if (aObj == null) {
            aObj = new CatalogueIndicatorType(valueParam);
            setCatalogueIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setName(
        @Nullable
        final String valueParam) {
        NameType aObj = getName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type HazardousRiskIndicatorType and never <code>null</code>
     */
    @Nonnull
    public HazardousRiskIndicatorType setHazardousRiskIndicator(final boolean valueParam) {
        HazardousRiskIndicatorType aObj = getHazardousRiskIndicator();
        if (aObj == null) {
            aObj = new HazardousRiskIndicatorType(valueParam);
            setHazardousRiskIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained PackQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PackQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPackQuantityValue() {
        PackQuantityType aObj = getPackQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PackSizeNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PackSizeNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPackSizeNumericValue() {
        PackSizeNumericType aObj = getPackSizeNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CatalogueIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained CatalogueIndicatorType object or the passed nullValue
     */
    public boolean isCatalogueIndicatorValue(final boolean nullValue) {
        CatalogueIndicatorType aObj = getCatalogueIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        NameType aObj = getName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HazardousRiskIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained HazardousRiskIndicatorType object or the passed nullValue
     */
    public boolean isHazardousRiskIndicatorValue(final boolean nullValue) {
        HazardousRiskIndicatorType aObj = getHazardousRiskIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
