
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LotsGroupIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for LotsGroupType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LotsGroupType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LotsGroupID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ProcurementProjectLotReference" maxOccurs="unbounded"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LotsGroupType", propOrder = {
    "ublExtensions",
    "lotsGroupID",
    "procurementProjectLotReference"
})
@CodingStyleguideUnaware
public class LotsGroupType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "LotsGroupID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private LotsGroupIDType lotsGroupID;
    @XmlElement(name = "ProcurementProjectLotReference", required = true)
    private List<ProcurementProjectLotReferenceType> procurementProjectLotReference;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LotsGroupType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the lotsGroupID property.
     * 
     * @return
     *     possible object is
     *     {@link LotsGroupIDType }
     *     
     */
    @Nullable
    public LotsGroupIDType getLotsGroupID() {
        return lotsGroupID;
    }

    /**
     * Sets the value of the lotsGroupID property.
     * 
     * @param value
     *     allowed object is
     *     {@link LotsGroupIDType }
     *     
     */
    public void setLotsGroupID(
        @Nullable
        LotsGroupIDType value) {
        this.lotsGroupID = value;
    }

    /**
     * Gets the value of the procurementProjectLotReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the procurementProjectLotReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getProcurementProjectLotReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProcurementProjectLotReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the procurementProjectLotReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ProcurementProjectLotReferenceType> getProcurementProjectLotReference() {
        if (procurementProjectLotReference == null) {
            procurementProjectLotReference = new ArrayList<>();
        }
        return this.procurementProjectLotReference;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LotsGroupType rhs = ((LotsGroupType) o);
        if (!EqualsHelper.equals(lotsGroupID, rhs.lotsGroupID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(procurementProjectLotReference, rhs.procurementProjectLotReference)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(lotsGroupID).append(procurementProjectLotReference).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("lotsGroupID", lotsGroupID).append("procurementProjectLotReference", procurementProjectLotReference).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProcurementProjectLotReference(
        @Nullable
        final List<ProcurementProjectLotReferenceType> aList) {
        procurementProjectLotReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProcurementProjectLotReferenceEntries() {
        return (!getProcurementProjectLotReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProcurementProjectLotReferenceEntries() {
        return getProcurementProjectLotReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProcurementProjectLotReferenceCount() {
        return getProcurementProjectLotReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ProcurementProjectLotReferenceType getProcurementProjectLotReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProcurementProjectLotReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProcurementProjectLotReference(
        @Nonnull
        final ProcurementProjectLotReferenceType elem) {
        getProcurementProjectLotReference().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LotsGroupType ret) {
        ret.lotsGroupID = ((lotsGroupID == null)?null:lotsGroupID.clone());
        if (procurementProjectLotReference == null) {
            ret.procurementProjectLotReference = null;
        } else {
            List<ProcurementProjectLotReferenceType> retProcurementProjectLotReference = new ArrayList<>();
            for (ProcurementProjectLotReferenceType aItem: getProcurementProjectLotReference()) {
                retProcurementProjectLotReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.procurementProjectLotReference = retProcurementProjectLotReference;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LotsGroupType clone() {
        LotsGroupType ret = new LotsGroupType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LotsGroupIDType and never <code>null</code>
     */
    @Nonnull
    public LotsGroupIDType setLotsGroupID(
        @Nullable
        final String valueParam) {
        LotsGroupIDType aObj = getLotsGroupID();
        if (aObj == null) {
            aObj = new LotsGroupIDType(valueParam);
            setLotsGroupID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained LotsGroupIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LotsGroupIDType object or <code>null</code>
     */
    @Nullable
    public String getLotsGroupIDValue() {
        LotsGroupIDType aObj = getLotsGroupID();
        return (aObj == null)?null:aObj.getValue();
    }

}
