
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EstimatedGeneratedUntilNextPortMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MaxDedicatedStorageCapacityMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RetainedOnBoardMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ToBeDeliveredMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.WasteTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for MaritimeWasteType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MaritimeWasteType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WasteTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ToBeDeliveredMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RetainedOnBoardMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaxDedicatedStorageCapacityMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedGeneratedUntilNextPortMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RemainingWasteDeliveryPortLocation" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MaritimeWasteType", propOrder = {
    "ublExtensions",
    "id",
    "description",
    "wasteTypeCode",
    "toBeDeliveredMeasure",
    "retainedOnBoardMeasure",
    "maxDedicatedStorageCapacityMeasure",
    "estimatedGeneratedUntilNextPortMeasure",
    "remainingWasteDeliveryPortLocation"
})
@CodingStyleguideUnaware
public class MaritimeWasteType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "WasteTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WasteTypeCodeType wasteTypeCode;
    @XmlElement(name = "ToBeDeliveredMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ToBeDeliveredMeasureType toBeDeliveredMeasure;
    @XmlElement(name = "RetainedOnBoardMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RetainedOnBoardMeasureType retainedOnBoardMeasure;
    @XmlElement(name = "MaxDedicatedStorageCapacityMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaxDedicatedStorageCapacityMeasureType maxDedicatedStorageCapacityMeasure;
    @XmlElement(name = "EstimatedGeneratedUntilNextPortMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EstimatedGeneratedUntilNextPortMeasureType estimatedGeneratedUntilNextPortMeasure;
    @XmlElement(name = "RemainingWasteDeliveryPortLocation")
    private List<LocationType> remainingWasteDeliveryPortLocation;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public MaritimeWasteType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the wasteTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link WasteTypeCodeType }
     *     
     */
    @Nullable
    public WasteTypeCodeType getWasteTypeCode() {
        return wasteTypeCode;
    }

    /**
     * Sets the value of the wasteTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link WasteTypeCodeType }
     *     
     */
    public void setWasteTypeCode(
        @Nullable
        WasteTypeCodeType value) {
        this.wasteTypeCode = value;
    }

    /**
     * Gets the value of the toBeDeliveredMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ToBeDeliveredMeasureType }
     *     
     */
    @Nullable
    public ToBeDeliveredMeasureType getToBeDeliveredMeasure() {
        return toBeDeliveredMeasure;
    }

    /**
     * Sets the value of the toBeDeliveredMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link ToBeDeliveredMeasureType }
     *     
     */
    public void setToBeDeliveredMeasure(
        @Nullable
        ToBeDeliveredMeasureType value) {
        this.toBeDeliveredMeasure = value;
    }

    /**
     * Gets the value of the retainedOnBoardMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link RetainedOnBoardMeasureType }
     *     
     */
    @Nullable
    public RetainedOnBoardMeasureType getRetainedOnBoardMeasure() {
        return retainedOnBoardMeasure;
    }

    /**
     * Sets the value of the retainedOnBoardMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link RetainedOnBoardMeasureType }
     *     
     */
    public void setRetainedOnBoardMeasure(
        @Nullable
        RetainedOnBoardMeasureType value) {
        this.retainedOnBoardMeasure = value;
    }

    /**
     * Gets the value of the maxDedicatedStorageCapacityMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MaxDedicatedStorageCapacityMeasureType }
     *     
     */
    @Nullable
    public MaxDedicatedStorageCapacityMeasureType getMaxDedicatedStorageCapacityMeasure() {
        return maxDedicatedStorageCapacityMeasure;
    }

    /**
     * Sets the value of the maxDedicatedStorageCapacityMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaxDedicatedStorageCapacityMeasureType }
     *     
     */
    public void setMaxDedicatedStorageCapacityMeasure(
        @Nullable
        MaxDedicatedStorageCapacityMeasureType value) {
        this.maxDedicatedStorageCapacityMeasure = value;
    }

    /**
     * Gets the value of the estimatedGeneratedUntilNextPortMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link EstimatedGeneratedUntilNextPortMeasureType }
     *     
     */
    @Nullable
    public EstimatedGeneratedUntilNextPortMeasureType getEstimatedGeneratedUntilNextPortMeasure() {
        return estimatedGeneratedUntilNextPortMeasure;
    }

    /**
     * Sets the value of the estimatedGeneratedUntilNextPortMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link EstimatedGeneratedUntilNextPortMeasureType }
     *     
     */
    public void setEstimatedGeneratedUntilNextPortMeasure(
        @Nullable
        EstimatedGeneratedUntilNextPortMeasureType value) {
        this.estimatedGeneratedUntilNextPortMeasure = value;
    }

    /**
     * Gets the value of the remainingWasteDeliveryPortLocation property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the remainingWasteDeliveryPortLocation property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRemainingWasteDeliveryPortLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LocationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the remainingWasteDeliveryPortLocation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LocationType> getRemainingWasteDeliveryPortLocation() {
        if (remainingWasteDeliveryPortLocation == null) {
            remainingWasteDeliveryPortLocation = new ArrayList<>();
        }
        return this.remainingWasteDeliveryPortLocation;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final MaritimeWasteType rhs = ((MaritimeWasteType) o);
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedGeneratedUntilNextPortMeasure, rhs.estimatedGeneratedUntilNextPortMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(maxDedicatedStorageCapacityMeasure, rhs.maxDedicatedStorageCapacityMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(remainingWasteDeliveryPortLocation, rhs.remainingWasteDeliveryPortLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(retainedOnBoardMeasure, rhs.retainedOnBoardMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(toBeDeliveredMeasure, rhs.toBeDeliveredMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(wasteTypeCode, rhs.wasteTypeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(description).append(estimatedGeneratedUntilNextPortMeasure).append(id).append(maxDedicatedStorageCapacityMeasure).append(remainingWasteDeliveryPortLocation).append(retainedOnBoardMeasure).append(toBeDeliveredMeasure).append(ublExtensions).append(wasteTypeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("description", description).append("estimatedGeneratedUntilNextPortMeasure", estimatedGeneratedUntilNextPortMeasure).append("id", id).append("maxDedicatedStorageCapacityMeasure", maxDedicatedStorageCapacityMeasure).append("remainingWasteDeliveryPortLocation", remainingWasteDeliveryPortLocation).append("retainedOnBoardMeasure", retainedOnBoardMeasure).append("toBeDeliveredMeasure", toBeDeliveredMeasure).append("ublExtensions", ublExtensions).append("wasteTypeCode", wasteTypeCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRemainingWasteDeliveryPortLocation(
        @Nullable
        final List<LocationType> aList) {
        remainingWasteDeliveryPortLocation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRemainingWasteDeliveryPortLocationEntries() {
        return (!getRemainingWasteDeliveryPortLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRemainingWasteDeliveryPortLocationEntries() {
        return getRemainingWasteDeliveryPortLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRemainingWasteDeliveryPortLocationCount() {
        return getRemainingWasteDeliveryPortLocation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LocationType getRemainingWasteDeliveryPortLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRemainingWasteDeliveryPortLocation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRemainingWasteDeliveryPortLocation(
        @Nonnull
        final LocationType elem) {
        getRemainingWasteDeliveryPortLocation().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        MaritimeWasteType ret) {
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.estimatedGeneratedUntilNextPortMeasure = ((estimatedGeneratedUntilNextPortMeasure == null)?null:estimatedGeneratedUntilNextPortMeasure.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.maxDedicatedStorageCapacityMeasure = ((maxDedicatedStorageCapacityMeasure == null)?null:maxDedicatedStorageCapacityMeasure.clone());
        if (remainingWasteDeliveryPortLocation == null) {
            ret.remainingWasteDeliveryPortLocation = null;
        } else {
            List<LocationType> retRemainingWasteDeliveryPortLocation = new ArrayList<>();
            for (LocationType aItem: getRemainingWasteDeliveryPortLocation()) {
                retRemainingWasteDeliveryPortLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.remainingWasteDeliveryPortLocation = retRemainingWasteDeliveryPortLocation;
        }
        ret.retainedOnBoardMeasure = ((retainedOnBoardMeasure == null)?null:retainedOnBoardMeasure.clone());
        ret.toBeDeliveredMeasure = ((toBeDeliveredMeasure == null)?null:toBeDeliveredMeasure.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.wasteTypeCode = ((wasteTypeCode == null)?null:wasteTypeCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public MaritimeWasteType clone() {
        MaritimeWasteType ret = new MaritimeWasteType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WasteTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public WasteTypeCodeType setWasteTypeCode(
        @Nullable
        final String valueParam) {
        WasteTypeCodeType aObj = getWasteTypeCode();
        if (aObj == null) {
            aObj = new WasteTypeCodeType(valueParam);
            setWasteTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ToBeDeliveredMeasureType and never <code>null</code>
     */
    @Nonnull
    public ToBeDeliveredMeasureType setToBeDeliveredMeasure(
        @Nullable
        final BigDecimal valueParam) {
        ToBeDeliveredMeasureType aObj = getToBeDeliveredMeasure();
        if (aObj == null) {
            aObj = new ToBeDeliveredMeasureType(valueParam);
            setToBeDeliveredMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RetainedOnBoardMeasureType and never <code>null</code>
     */
    @Nonnull
    public RetainedOnBoardMeasureType setRetainedOnBoardMeasure(
        @Nullable
        final BigDecimal valueParam) {
        RetainedOnBoardMeasureType aObj = getRetainedOnBoardMeasure();
        if (aObj == null) {
            aObj = new RetainedOnBoardMeasureType(valueParam);
            setRetainedOnBoardMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaxDedicatedStorageCapacityMeasureType and never <code>null</code>
     */
    @Nonnull
    public MaxDedicatedStorageCapacityMeasureType setMaxDedicatedStorageCapacityMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MaxDedicatedStorageCapacityMeasureType aObj = getMaxDedicatedStorageCapacityMeasure();
        if (aObj == null) {
            aObj = new MaxDedicatedStorageCapacityMeasureType(valueParam);
            setMaxDedicatedStorageCapacityMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedGeneratedUntilNextPortMeasureType and never <code>null</code>
     */
    @Nonnull
    public EstimatedGeneratedUntilNextPortMeasureType setEstimatedGeneratedUntilNextPortMeasure(
        @Nullable
        final BigDecimal valueParam) {
        EstimatedGeneratedUntilNextPortMeasureType aObj = getEstimatedGeneratedUntilNextPortMeasure();
        if (aObj == null) {
            aObj = new EstimatedGeneratedUntilNextPortMeasureType(valueParam);
            setEstimatedGeneratedUntilNextPortMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WasteTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WasteTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getWasteTypeCodeValue() {
        WasteTypeCodeType aObj = getWasteTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ToBeDeliveredMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ToBeDeliveredMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getToBeDeliveredMeasureValue() {
        ToBeDeliveredMeasureType aObj = getToBeDeliveredMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RetainedOnBoardMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RetainedOnBoardMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getRetainedOnBoardMeasureValue() {
        RetainedOnBoardMeasureType aObj = getRetainedOnBoardMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaxDedicatedStorageCapacityMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaxDedicatedStorageCapacityMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaxDedicatedStorageCapacityMeasureValue() {
        MaxDedicatedStorageCapacityMeasureType aObj = getMaxDedicatedStorageCapacityMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EstimatedGeneratedUntilNextPortMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedGeneratedUntilNextPortMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getEstimatedGeneratedUntilNextPortMeasureValue() {
        EstimatedGeneratedUntilNextPortMeasureType aObj = getEstimatedGeneratedUntilNextPortMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

}
