
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DeliveredQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LatestMeterQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LatestMeterReadingDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LatestMeterReadingMethodCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LatestMeterReadingMethodType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MeterReadingCommentsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MeterReadingTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MeterReadingTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PreviousMeterQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PreviousMeterReadingDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PreviousMeterReadingMethodCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PreviousMeterReadingMethodType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for MeterReadingType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MeterReadingType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MeterReadingType" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MeterReadingTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PreviousMeterReadingDate"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PreviousMeterQuantity"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatestMeterReadingDate"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatestMeterQuantity"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PreviousMeterReadingMethod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PreviousMeterReadingMethodCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatestMeterReadingMethod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatestMeterReadingMethodCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MeterReadingComments" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DeliveredQuantity"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MeterReadingType", propOrder = {
    "ublExtensions",
    "id",
    "meterReadingType",
    "meterReadingTypeCode",
    "previousMeterReadingDate",
    "previousMeterQuantity",
    "latestMeterReadingDate",
    "latestMeterQuantity",
    "previousMeterReadingMethod",
    "previousMeterReadingMethodCode",
    "latestMeterReadingMethod",
    "latestMeterReadingMethodCode",
    "meterReadingComments",
    "deliveredQuantity"
})
@CodingStyleguideUnaware
public class MeterReadingType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "MeterReadingType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MeterReadingTypeType meterReadingType;
    @XmlElement(name = "MeterReadingTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MeterReadingTypeCodeType meterReadingTypeCode;
    @XmlElement(name = "PreviousMeterReadingDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private PreviousMeterReadingDateType previousMeterReadingDate;
    @XmlElement(name = "PreviousMeterQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private PreviousMeterQuantityType previousMeterQuantity;
    @XmlElement(name = "LatestMeterReadingDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private LatestMeterReadingDateType latestMeterReadingDate;
    @XmlElement(name = "LatestMeterQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private LatestMeterQuantityType latestMeterQuantity;
    @XmlElement(name = "PreviousMeterReadingMethod", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PreviousMeterReadingMethodType previousMeterReadingMethod;
    @XmlElement(name = "PreviousMeterReadingMethodCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PreviousMeterReadingMethodCodeType previousMeterReadingMethodCode;
    @XmlElement(name = "LatestMeterReadingMethod", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatestMeterReadingMethodType latestMeterReadingMethod;
    @XmlElement(name = "LatestMeterReadingMethodCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatestMeterReadingMethodCodeType latestMeterReadingMethodCode;
    @XmlElement(name = "MeterReadingComments", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<MeterReadingCommentsType> meterReadingComments;
    @XmlElement(name = "DeliveredQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private DeliveredQuantityType deliveredQuantity;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public MeterReadingType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the meterReadingType property.
     * 
     * @return
     *     possible object is
     *     {@link MeterReadingTypeType }
     *     
     */
    @Nullable
    public MeterReadingTypeType getMeterReadingType() {
        return meterReadingType;
    }

    /**
     * Sets the value of the meterReadingType property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeterReadingTypeType }
     *     
     */
    public void setMeterReadingType(
        @Nullable
        MeterReadingTypeType value) {
        this.meterReadingType = value;
    }

    /**
     * Gets the value of the meterReadingTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link MeterReadingTypeCodeType }
     *     
     */
    @Nullable
    public MeterReadingTypeCodeType getMeterReadingTypeCode() {
        return meterReadingTypeCode;
    }

    /**
     * Sets the value of the meterReadingTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeterReadingTypeCodeType }
     *     
     */
    public void setMeterReadingTypeCode(
        @Nullable
        MeterReadingTypeCodeType value) {
        this.meterReadingTypeCode = value;
    }

    /**
     * Gets the value of the previousMeterReadingDate property.
     * 
     * @return
     *     possible object is
     *     {@link PreviousMeterReadingDateType }
     *     
     */
    @Nullable
    public PreviousMeterReadingDateType getPreviousMeterReadingDate() {
        return previousMeterReadingDate;
    }

    /**
     * Sets the value of the previousMeterReadingDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreviousMeterReadingDateType }
     *     
     */
    public void setPreviousMeterReadingDate(
        @Nullable
        PreviousMeterReadingDateType value) {
        this.previousMeterReadingDate = value;
    }

    /**
     * Gets the value of the previousMeterQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link PreviousMeterQuantityType }
     *     
     */
    @Nullable
    public PreviousMeterQuantityType getPreviousMeterQuantity() {
        return previousMeterQuantity;
    }

    /**
     * Sets the value of the previousMeterQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreviousMeterQuantityType }
     *     
     */
    public void setPreviousMeterQuantity(
        @Nullable
        PreviousMeterQuantityType value) {
        this.previousMeterQuantity = value;
    }

    /**
     * Gets the value of the latestMeterReadingDate property.
     * 
     * @return
     *     possible object is
     *     {@link LatestMeterReadingDateType }
     *     
     */
    @Nullable
    public LatestMeterReadingDateType getLatestMeterReadingDate() {
        return latestMeterReadingDate;
    }

    /**
     * Sets the value of the latestMeterReadingDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestMeterReadingDateType }
     *     
     */
    public void setLatestMeterReadingDate(
        @Nullable
        LatestMeterReadingDateType value) {
        this.latestMeterReadingDate = value;
    }

    /**
     * Gets the value of the latestMeterQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link LatestMeterQuantityType }
     *     
     */
    @Nullable
    public LatestMeterQuantityType getLatestMeterQuantity() {
        return latestMeterQuantity;
    }

    /**
     * Sets the value of the latestMeterQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestMeterQuantityType }
     *     
     */
    public void setLatestMeterQuantity(
        @Nullable
        LatestMeterQuantityType value) {
        this.latestMeterQuantity = value;
    }

    /**
     * Gets the value of the previousMeterReadingMethod property.
     * 
     * @return
     *     possible object is
     *     {@link PreviousMeterReadingMethodType }
     *     
     */
    @Nullable
    public PreviousMeterReadingMethodType getPreviousMeterReadingMethod() {
        return previousMeterReadingMethod;
    }

    /**
     * Sets the value of the previousMeterReadingMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreviousMeterReadingMethodType }
     *     
     */
    public void setPreviousMeterReadingMethod(
        @Nullable
        PreviousMeterReadingMethodType value) {
        this.previousMeterReadingMethod = value;
    }

    /**
     * Gets the value of the previousMeterReadingMethodCode property.
     * 
     * @return
     *     possible object is
     *     {@link PreviousMeterReadingMethodCodeType }
     *     
     */
    @Nullable
    public PreviousMeterReadingMethodCodeType getPreviousMeterReadingMethodCode() {
        return previousMeterReadingMethodCode;
    }

    /**
     * Sets the value of the previousMeterReadingMethodCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreviousMeterReadingMethodCodeType }
     *     
     */
    public void setPreviousMeterReadingMethodCode(
        @Nullable
        PreviousMeterReadingMethodCodeType value) {
        this.previousMeterReadingMethodCode = value;
    }

    /**
     * Gets the value of the latestMeterReadingMethod property.
     * 
     * @return
     *     possible object is
     *     {@link LatestMeterReadingMethodType }
     *     
     */
    @Nullable
    public LatestMeterReadingMethodType getLatestMeterReadingMethod() {
        return latestMeterReadingMethod;
    }

    /**
     * Sets the value of the latestMeterReadingMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestMeterReadingMethodType }
     *     
     */
    public void setLatestMeterReadingMethod(
        @Nullable
        LatestMeterReadingMethodType value) {
        this.latestMeterReadingMethod = value;
    }

    /**
     * Gets the value of the latestMeterReadingMethodCode property.
     * 
     * @return
     *     possible object is
     *     {@link LatestMeterReadingMethodCodeType }
     *     
     */
    @Nullable
    public LatestMeterReadingMethodCodeType getLatestMeterReadingMethodCode() {
        return latestMeterReadingMethodCode;
    }

    /**
     * Sets the value of the latestMeterReadingMethodCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestMeterReadingMethodCodeType }
     *     
     */
    public void setLatestMeterReadingMethodCode(
        @Nullable
        LatestMeterReadingMethodCodeType value) {
        this.latestMeterReadingMethodCode = value;
    }

    /**
     * Gets the value of the meterReadingComments property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the meterReadingComments property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMeterReadingComments().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MeterReadingCommentsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the meterReadingComments property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<MeterReadingCommentsType> getMeterReadingComments() {
        if (meterReadingComments == null) {
            meterReadingComments = new ArrayList<>();
        }
        return this.meterReadingComments;
    }

    /**
     * Gets the value of the deliveredQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link DeliveredQuantityType }
     *     
     */
    @Nullable
    public DeliveredQuantityType getDeliveredQuantity() {
        return deliveredQuantity;
    }

    /**
     * Sets the value of the deliveredQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link DeliveredQuantityType }
     *     
     */
    public void setDeliveredQuantity(
        @Nullable
        DeliveredQuantityType value) {
        this.deliveredQuantity = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final MeterReadingType rhs = ((MeterReadingType) o);
        if (!EqualsHelper.equals(deliveredQuantity, rhs.deliveredQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(latestMeterQuantity, rhs.latestMeterQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(latestMeterReadingDate, rhs.latestMeterReadingDate)) {
            return false;
        }
        if (!EqualsHelper.equals(latestMeterReadingMethod, rhs.latestMeterReadingMethod)) {
            return false;
        }
        if (!EqualsHelper.equals(latestMeterReadingMethodCode, rhs.latestMeterReadingMethodCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(meterReadingComments, rhs.meterReadingComments)) {
            return false;
        }
        if (!EqualsHelper.equals(meterReadingType, rhs.meterReadingType)) {
            return false;
        }
        if (!EqualsHelper.equals(meterReadingTypeCode, rhs.meterReadingTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(previousMeterQuantity, rhs.previousMeterQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(previousMeterReadingDate, rhs.previousMeterReadingDate)) {
            return false;
        }
        if (!EqualsHelper.equals(previousMeterReadingMethod, rhs.previousMeterReadingMethod)) {
            return false;
        }
        if (!EqualsHelper.equals(previousMeterReadingMethodCode, rhs.previousMeterReadingMethodCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(deliveredQuantity).append(id).append(latestMeterQuantity).append(latestMeterReadingDate).append(latestMeterReadingMethod).append(latestMeterReadingMethodCode).append(meterReadingComments).append(meterReadingType).append(meterReadingTypeCode).append(previousMeterQuantity).append(previousMeterReadingDate).append(previousMeterReadingMethod).append(previousMeterReadingMethodCode).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("deliveredQuantity", deliveredQuantity).append("id", id).append("latestMeterQuantity", latestMeterQuantity).append("latestMeterReadingDate", latestMeterReadingDate).append("latestMeterReadingMethod", latestMeterReadingMethod).append("latestMeterReadingMethodCode", latestMeterReadingMethodCode).append("meterReadingComments", meterReadingComments).append("meterReadingType", meterReadingType).append("meterReadingTypeCode", meterReadingTypeCode).append("previousMeterQuantity", previousMeterQuantity).append("previousMeterReadingDate", previousMeterReadingDate).append("previousMeterReadingMethod", previousMeterReadingMethod).append("previousMeterReadingMethodCode", previousMeterReadingMethodCode).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMeterReadingComments(
        @Nullable
        final List<MeterReadingCommentsType> aList) {
        meterReadingComments = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMeterReadingCommentsEntries() {
        return (!getMeterReadingComments().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMeterReadingCommentsEntries() {
        return getMeterReadingComments().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMeterReadingCommentsCount() {
        return getMeterReadingComments().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public MeterReadingCommentsType getMeterReadingCommentsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMeterReadingComments().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMeterReadingComments(
        @Nonnull
        final MeterReadingCommentsType elem) {
        getMeterReadingComments().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        MeterReadingType ret) {
        ret.deliveredQuantity = ((deliveredQuantity == null)?null:deliveredQuantity.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.latestMeterQuantity = ((latestMeterQuantity == null)?null:latestMeterQuantity.clone());
        ret.latestMeterReadingDate = ((latestMeterReadingDate == null)?null:latestMeterReadingDate.clone());
        ret.latestMeterReadingMethod = ((latestMeterReadingMethod == null)?null:latestMeterReadingMethod.clone());
        ret.latestMeterReadingMethodCode = ((latestMeterReadingMethodCode == null)?null:latestMeterReadingMethodCode.clone());
        if (meterReadingComments == null) {
            ret.meterReadingComments = null;
        } else {
            List<MeterReadingCommentsType> retMeterReadingComments = new ArrayList<>();
            for (MeterReadingCommentsType aItem: getMeterReadingComments()) {
                retMeterReadingComments.add(((aItem == null)?null:aItem.clone()));
            }
            ret.meterReadingComments = retMeterReadingComments;
        }
        ret.meterReadingType = ((meterReadingType == null)?null:meterReadingType.clone());
        ret.meterReadingTypeCode = ((meterReadingTypeCode == null)?null:meterReadingTypeCode.clone());
        ret.previousMeterQuantity = ((previousMeterQuantity == null)?null:previousMeterQuantity.clone());
        ret.previousMeterReadingDate = ((previousMeterReadingDate == null)?null:previousMeterReadingDate.clone());
        ret.previousMeterReadingMethod = ((previousMeterReadingMethod == null)?null:previousMeterReadingMethod.clone());
        ret.previousMeterReadingMethodCode = ((previousMeterReadingMethodCode == null)?null:previousMeterReadingMethodCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public MeterReadingType clone() {
        MeterReadingType ret = new MeterReadingType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeterReadingTypeType and never <code>null</code>
     */
    @Nonnull
    public MeterReadingTypeType setMeterReadingType(
        @Nullable
        final String valueParam) {
        MeterReadingTypeType aObj = getMeterReadingType();
        if (aObj == null) {
            aObj = new MeterReadingTypeType(valueParam);
            setMeterReadingType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeterReadingTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public MeterReadingTypeCodeType setMeterReadingTypeCode(
        @Nullable
        final String valueParam) {
        MeterReadingTypeCodeType aObj = getMeterReadingTypeCode();
        if (aObj == null) {
            aObj = new MeterReadingTypeCodeType(valueParam);
            setMeterReadingTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PreviousMeterReadingDateType and never <code>null</code>
     */
    @Nonnull
    public PreviousMeterReadingDateType setPreviousMeterReadingDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        PreviousMeterReadingDateType aObj = getPreviousMeterReadingDate();
        if (aObj == null) {
            aObj = new PreviousMeterReadingDateType(valueParam);
            setPreviousMeterReadingDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PreviousMeterReadingDateType and never <code>null</code>
     */
    @Nonnull
    public PreviousMeterReadingDateType setPreviousMeterReadingDate(
        @Nullable
        final LocalDate valueParam) {
        PreviousMeterReadingDateType aObj = getPreviousMeterReadingDate();
        if (aObj == null) {
            aObj = new PreviousMeterReadingDateType(valueParam);
            setPreviousMeterReadingDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PreviousMeterQuantityType and never <code>null</code>
     */
    @Nonnull
    public PreviousMeterQuantityType setPreviousMeterQuantity(
        @Nullable
        final BigDecimal valueParam) {
        PreviousMeterQuantityType aObj = getPreviousMeterQuantity();
        if (aObj == null) {
            aObj = new PreviousMeterQuantityType(valueParam);
            setPreviousMeterQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestMeterReadingDateType and never <code>null</code>
     */
    @Nonnull
    public LatestMeterReadingDateType setLatestMeterReadingDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        LatestMeterReadingDateType aObj = getLatestMeterReadingDate();
        if (aObj == null) {
            aObj = new LatestMeterReadingDateType(valueParam);
            setLatestMeterReadingDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestMeterReadingDateType and never <code>null</code>
     */
    @Nonnull
    public LatestMeterReadingDateType setLatestMeterReadingDate(
        @Nullable
        final LocalDate valueParam) {
        LatestMeterReadingDateType aObj = getLatestMeterReadingDate();
        if (aObj == null) {
            aObj = new LatestMeterReadingDateType(valueParam);
            setLatestMeterReadingDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestMeterQuantityType and never <code>null</code>
     */
    @Nonnull
    public LatestMeterQuantityType setLatestMeterQuantity(
        @Nullable
        final BigDecimal valueParam) {
        LatestMeterQuantityType aObj = getLatestMeterQuantity();
        if (aObj == null) {
            aObj = new LatestMeterQuantityType(valueParam);
            setLatestMeterQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PreviousMeterReadingMethodType and never <code>null</code>
     */
    @Nonnull
    public PreviousMeterReadingMethodType setPreviousMeterReadingMethod(
        @Nullable
        final String valueParam) {
        PreviousMeterReadingMethodType aObj = getPreviousMeterReadingMethod();
        if (aObj == null) {
            aObj = new PreviousMeterReadingMethodType(valueParam);
            setPreviousMeterReadingMethod(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PreviousMeterReadingMethodCodeType and never <code>null</code>
     */
    @Nonnull
    public PreviousMeterReadingMethodCodeType setPreviousMeterReadingMethodCode(
        @Nullable
        final String valueParam) {
        PreviousMeterReadingMethodCodeType aObj = getPreviousMeterReadingMethodCode();
        if (aObj == null) {
            aObj = new PreviousMeterReadingMethodCodeType(valueParam);
            setPreviousMeterReadingMethodCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestMeterReadingMethodType and never <code>null</code>
     */
    @Nonnull
    public LatestMeterReadingMethodType setLatestMeterReadingMethod(
        @Nullable
        final String valueParam) {
        LatestMeterReadingMethodType aObj = getLatestMeterReadingMethod();
        if (aObj == null) {
            aObj = new LatestMeterReadingMethodType(valueParam);
            setLatestMeterReadingMethod(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestMeterReadingMethodCodeType and never <code>null</code>
     */
    @Nonnull
    public LatestMeterReadingMethodCodeType setLatestMeterReadingMethodCode(
        @Nullable
        final String valueParam) {
        LatestMeterReadingMethodCodeType aObj = getLatestMeterReadingMethodCode();
        if (aObj == null) {
            aObj = new LatestMeterReadingMethodCodeType(valueParam);
            setLatestMeterReadingMethodCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DeliveredQuantityType and never <code>null</code>
     */
    @Nonnull
    public DeliveredQuantityType setDeliveredQuantity(
        @Nullable
        final BigDecimal valueParam) {
        DeliveredQuantityType aObj = getDeliveredQuantity();
        if (aObj == null) {
            aObj = new DeliveredQuantityType(valueParam);
            setDeliveredQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeterReadingTypeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeterReadingTypeType object or <code>null</code>
     */
    @Nullable
    public String getMeterReadingTypeValue() {
        MeterReadingTypeType aObj = getMeterReadingType();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeterReadingTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeterReadingTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getMeterReadingTypeCodeValue() {
        MeterReadingTypeCodeType aObj = getMeterReadingTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PreviousMeterReadingDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PreviousMeterReadingDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getPreviousMeterReadingDateValue() {
        PreviousMeterReadingDateType aObj = getPreviousMeterReadingDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PreviousMeterReadingDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PreviousMeterReadingDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getPreviousMeterReadingDateValueLocal() {
        PreviousMeterReadingDateType aObj = getPreviousMeterReadingDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained PreviousMeterQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PreviousMeterQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPreviousMeterQuantityValue() {
        PreviousMeterQuantityType aObj = getPreviousMeterQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatestMeterReadingDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestMeterReadingDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getLatestMeterReadingDateValue() {
        LatestMeterReadingDateType aObj = getLatestMeterReadingDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatestMeterReadingDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestMeterReadingDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getLatestMeterReadingDateValueLocal() {
        LatestMeterReadingDateType aObj = getLatestMeterReadingDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained LatestMeterQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestMeterQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getLatestMeterQuantityValue() {
        LatestMeterQuantityType aObj = getLatestMeterQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PreviousMeterReadingMethodType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PreviousMeterReadingMethodType object or <code>null</code>
     */
    @Nullable
    public String getPreviousMeterReadingMethodValue() {
        PreviousMeterReadingMethodType aObj = getPreviousMeterReadingMethod();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PreviousMeterReadingMethodCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PreviousMeterReadingMethodCodeType object or <code>null</code>
     */
    @Nullable
    public String getPreviousMeterReadingMethodCodeValue() {
        PreviousMeterReadingMethodCodeType aObj = getPreviousMeterReadingMethodCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatestMeterReadingMethodType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestMeterReadingMethodType object or <code>null</code>
     */
    @Nullable
    public String getLatestMeterReadingMethodValue() {
        LatestMeterReadingMethodType aObj = getLatestMeterReadingMethod();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatestMeterReadingMethodCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestMeterReadingMethodCodeType object or <code>null</code>
     */
    @Nullable
    public String getLatestMeterReadingMethodCodeValue() {
        LatestMeterReadingMethodCodeType aObj = getLatestMeterReadingMethodCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DeliveredQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DeliveredQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDeliveredQuantityValue() {
        DeliveredQuantityType aObj = getDeliveredQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
