
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PackageLevelCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PackagingTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PackagingTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PackingMaterialType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.QuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ReturnableMaterialIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TraceIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for PackageType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PackageType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Quantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReturnableMaterialIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PackageLevelCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PackagingTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PackagingType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PackingMaterial" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TraceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContainedPackage" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContainingTransportEquipment" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}GoodsItem" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MeasurementDimension" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DeliveryUnit" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Delivery" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Pickup" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Despatch" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PackageType", propOrder = {
    "ublExtensions",
    "id",
    "quantity",
    "returnableMaterialIndicator",
    "packageLevelCode",
    "packagingTypeCode",
    "packagingType",
    "packingMaterial",
    "traceID",
    "containedPackage",
    "containingTransportEquipment",
    "goodsItem",
    "measurementDimension",
    "deliveryUnit",
    "delivery",
    "pickup",
    "despatch"
})
@CodingStyleguideUnaware
public class PackageType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "Quantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private QuantityType quantity;
    @XmlElement(name = "ReturnableMaterialIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReturnableMaterialIndicatorType returnableMaterialIndicator;
    @XmlElement(name = "PackageLevelCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PackageLevelCodeType packageLevelCode;
    @XmlElement(name = "PackagingTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PackagingTypeCodeType packagingTypeCode;
    @XmlElement(name = "PackagingType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PackagingTypeType> packagingType;
    @XmlElement(name = "PackingMaterial", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PackingMaterialType> packingMaterial;
    @XmlElement(name = "TraceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TraceIDType traceID;
    @XmlElement(name = "ContainedPackage")
    private List<PackageType> containedPackage;
    @XmlElement(name = "ContainingTransportEquipment")
    private TransportEquipmentType containingTransportEquipment;
    @XmlElement(name = "GoodsItem")
    private List<GoodsItemType> goodsItem;
    @XmlElement(name = "MeasurementDimension")
    private List<DimensionType> measurementDimension;
    @XmlElement(name = "DeliveryUnit")
    private List<DeliveryUnitType> deliveryUnit;
    @XmlElement(name = "Delivery")
    private DeliveryType delivery;
    @XmlElement(name = "Pickup")
    private PickupType pickup;
    @XmlElement(name = "Despatch")
    private DespatchType despatch;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PackageType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the quantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getQuantity() {
        return quantity;
    }

    /**
     * Sets the value of the quantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setQuantity(
        @Nullable
        QuantityType value) {
        this.quantity = value;
    }

    /**
     * Gets the value of the returnableMaterialIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ReturnableMaterialIndicatorType }
     *     
     */
    @Nullable
    public ReturnableMaterialIndicatorType getReturnableMaterialIndicator() {
        return returnableMaterialIndicator;
    }

    /**
     * Sets the value of the returnableMaterialIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReturnableMaterialIndicatorType }
     *     
     */
    public void setReturnableMaterialIndicator(
        @Nullable
        ReturnableMaterialIndicatorType value) {
        this.returnableMaterialIndicator = value;
    }

    /**
     * Gets the value of the packageLevelCode property.
     * 
     * @return
     *     possible object is
     *     {@link PackageLevelCodeType }
     *     
     */
    @Nullable
    public PackageLevelCodeType getPackageLevelCode() {
        return packageLevelCode;
    }

    /**
     * Sets the value of the packageLevelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PackageLevelCodeType }
     *     
     */
    public void setPackageLevelCode(
        @Nullable
        PackageLevelCodeType value) {
        this.packageLevelCode = value;
    }

    /**
     * Gets the value of the packagingTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link PackagingTypeCodeType }
     *     
     */
    @Nullable
    public PackagingTypeCodeType getPackagingTypeCode() {
        return packagingTypeCode;
    }

    /**
     * Sets the value of the packagingTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PackagingTypeCodeType }
     *     
     */
    public void setPackagingTypeCode(
        @Nullable
        PackagingTypeCodeType value) {
        this.packagingTypeCode = value;
    }

    /**
     * Gets the value of the packagingType property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the packagingType property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPackagingType().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PackagingTypeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the packagingType property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PackagingTypeType> getPackagingType() {
        if (packagingType == null) {
            packagingType = new ArrayList<>();
        }
        return this.packagingType;
    }

    /**
     * Gets the value of the packingMaterial property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the packingMaterial property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPackingMaterial().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PackingMaterialType }
     * </p>
     * 
     * 
     * @return
     *     The value of the packingMaterial property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PackingMaterialType> getPackingMaterial() {
        if (packingMaterial == null) {
            packingMaterial = new ArrayList<>();
        }
        return this.packingMaterial;
    }

    /**
     * Gets the value of the traceID property.
     * 
     * @return
     *     possible object is
     *     {@link TraceIDType }
     *     
     */
    @Nullable
    public TraceIDType getTraceID() {
        return traceID;
    }

    /**
     * Sets the value of the traceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TraceIDType }
     *     
     */
    public void setTraceID(
        @Nullable
        TraceIDType value) {
        this.traceID = value;
    }

    /**
     * Gets the value of the containedPackage property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the containedPackage property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getContainedPackage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PackageType }
     * </p>
     * 
     * 
     * @return
     *     The value of the containedPackage property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PackageType> getContainedPackage() {
        if (containedPackage == null) {
            containedPackage = new ArrayList<>();
        }
        return this.containedPackage;
    }

    /**
     * Gets the value of the containingTransportEquipment property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEquipmentType }
     *     
     */
    @Nullable
    public TransportEquipmentType getContainingTransportEquipment() {
        return containingTransportEquipment;
    }

    /**
     * Sets the value of the containingTransportEquipment property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEquipmentType }
     *     
     */
    public void setContainingTransportEquipment(
        @Nullable
        TransportEquipmentType value) {
        this.containingTransportEquipment = value;
    }

    /**
     * Gets the value of the goodsItem property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the goodsItem property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getGoodsItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GoodsItemType }
     * </p>
     * 
     * 
     * @return
     *     The value of the goodsItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GoodsItemType> getGoodsItem() {
        if (goodsItem == null) {
            goodsItem = new ArrayList<>();
        }
        return this.goodsItem;
    }

    /**
     * Gets the value of the measurementDimension property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the measurementDimension property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMeasurementDimension().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DimensionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the measurementDimension property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DimensionType> getMeasurementDimension() {
        if (measurementDimension == null) {
            measurementDimension = new ArrayList<>();
        }
        return this.measurementDimension;
    }

    /**
     * Gets the value of the deliveryUnit property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the deliveryUnit property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDeliveryUnit().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DeliveryUnitType }
     * </p>
     * 
     * 
     * @return
     *     The value of the deliveryUnit property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DeliveryUnitType> getDeliveryUnit() {
        if (deliveryUnit == null) {
            deliveryUnit = new ArrayList<>();
        }
        return this.deliveryUnit;
    }

    /**
     * Gets the value of the delivery property.
     * 
     * @return
     *     possible object is
     *     {@link DeliveryType }
     *     
     */
    @Nullable
    public DeliveryType getDelivery() {
        return delivery;
    }

    /**
     * Sets the value of the delivery property.
     * 
     * @param value
     *     allowed object is
     *     {@link DeliveryType }
     *     
     */
    public void setDelivery(
        @Nullable
        DeliveryType value) {
        this.delivery = value;
    }

    /**
     * Gets the value of the pickup property.
     * 
     * @return
     *     possible object is
     *     {@link PickupType }
     *     
     */
    @Nullable
    public PickupType getPickup() {
        return pickup;
    }

    /**
     * Sets the value of the pickup property.
     * 
     * @param value
     *     allowed object is
     *     {@link PickupType }
     *     
     */
    public void setPickup(
        @Nullable
        PickupType value) {
        this.pickup = value;
    }

    /**
     * Gets the value of the despatch property.
     * 
     * @return
     *     possible object is
     *     {@link DespatchType }
     *     
     */
    @Nullable
    public DespatchType getDespatch() {
        return despatch;
    }

    /**
     * Sets the value of the despatch property.
     * 
     * @param value
     *     allowed object is
     *     {@link DespatchType }
     *     
     */
    public void setDespatch(
        @Nullable
        DespatchType value) {
        this.despatch = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PackageType rhs = ((PackageType) o);
        if (!EqualsHelper.equalsCollection(containedPackage, rhs.containedPackage)) {
            return false;
        }
        if (!EqualsHelper.equals(containingTransportEquipment, rhs.containingTransportEquipment)) {
            return false;
        }
        if (!EqualsHelper.equals(delivery, rhs.delivery)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(deliveryUnit, rhs.deliveryUnit)) {
            return false;
        }
        if (!EqualsHelper.equals(despatch, rhs.despatch)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(goodsItem, rhs.goodsItem)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(measurementDimension, rhs.measurementDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(packageLevelCode, rhs.packageLevelCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(packagingType, rhs.packagingType)) {
            return false;
        }
        if (!EqualsHelper.equals(packagingTypeCode, rhs.packagingTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(packingMaterial, rhs.packingMaterial)) {
            return false;
        }
        if (!EqualsHelper.equals(pickup, rhs.pickup)) {
            return false;
        }
        if (!EqualsHelper.equals(quantity, rhs.quantity)) {
            return false;
        }
        if (!EqualsHelper.equals(returnableMaterialIndicator, rhs.returnableMaterialIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(traceID, rhs.traceID)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(containedPackage).append(containingTransportEquipment).append(delivery).append(deliveryUnit).append(despatch).append(goodsItem).append(id).append(measurementDimension).append(packageLevelCode).append(packagingType).append(packagingTypeCode).append(packingMaterial).append(pickup).append(quantity).append(returnableMaterialIndicator).append(traceID).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("containedPackage", containedPackage).append("containingTransportEquipment", containingTransportEquipment).append("delivery", delivery).append("deliveryUnit", deliveryUnit).append("despatch", despatch).append("goodsItem", goodsItem).append("id", id).append("measurementDimension", measurementDimension).append("packageLevelCode", packageLevelCode).append("packagingType", packagingType).append("packagingTypeCode", packagingTypeCode).append("packingMaterial", packingMaterial).append("pickup", pickup).append("quantity", quantity).append("returnableMaterialIndicator", returnableMaterialIndicator).append("traceID", traceID).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPackagingType(
        @Nullable
        final List<PackagingTypeType> aList) {
        packagingType = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPackingMaterial(
        @Nullable
        final List<PackingMaterialType> aList) {
        packingMaterial = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContainedPackage(
        @Nullable
        final List<PackageType> aList) {
        containedPackage = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGoodsItem(
        @Nullable
        final List<GoodsItemType> aList) {
        goodsItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMeasurementDimension(
        @Nullable
        final List<DimensionType> aList) {
        measurementDimension = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDeliveryUnit(
        @Nullable
        final List<DeliveryUnitType> aList) {
        deliveryUnit = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPackagingTypeEntries() {
        return (!getPackagingType().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPackagingTypeEntries() {
        return getPackagingType().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPackagingTypeCount() {
        return getPackagingType().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PackagingTypeType getPackagingTypeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPackagingType().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPackagingType(
        @Nonnull
        final PackagingTypeType elem) {
        getPackagingType().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPackingMaterialEntries() {
        return (!getPackingMaterial().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPackingMaterialEntries() {
        return getPackingMaterial().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPackingMaterialCount() {
        return getPackingMaterial().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PackingMaterialType getPackingMaterialAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPackingMaterial().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPackingMaterial(
        @Nonnull
        final PackingMaterialType elem) {
        getPackingMaterial().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContainedPackageEntries() {
        return (!getContainedPackage().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContainedPackageEntries() {
        return getContainedPackage().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContainedPackageCount() {
        return getContainedPackage().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PackageType getContainedPackageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContainedPackage().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContainedPackage(
        @Nonnull
        final PackageType elem) {
        getContainedPackage().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGoodsItemEntries() {
        return (!getGoodsItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGoodsItemEntries() {
        return getGoodsItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGoodsItemCount() {
        return getGoodsItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GoodsItemType getGoodsItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGoodsItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGoodsItem(
        @Nonnull
        final GoodsItemType elem) {
        getGoodsItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMeasurementDimensionEntries() {
        return (!getMeasurementDimension().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMeasurementDimensionEntries() {
        return getMeasurementDimension().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMeasurementDimensionCount() {
        return getMeasurementDimension().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DimensionType getMeasurementDimensionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMeasurementDimension().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMeasurementDimension(
        @Nonnull
        final DimensionType elem) {
        getMeasurementDimension().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDeliveryUnitEntries() {
        return (!getDeliveryUnit().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDeliveryUnitEntries() {
        return getDeliveryUnit().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDeliveryUnitCount() {
        return getDeliveryUnit().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DeliveryUnitType getDeliveryUnitAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDeliveryUnit().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDeliveryUnit(
        @Nonnull
        final DeliveryUnitType elem) {
        getDeliveryUnit().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PackageType ret) {
        if (containedPackage == null) {
            ret.containedPackage = null;
        } else {
            List<PackageType> retContainedPackage = new ArrayList<>();
            for (PackageType aItem: getContainedPackage()) {
                retContainedPackage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.containedPackage = retContainedPackage;
        }
        ret.containingTransportEquipment = ((containingTransportEquipment == null)?null:containingTransportEquipment.clone());
        ret.delivery = ((delivery == null)?null:delivery.clone());
        if (deliveryUnit == null) {
            ret.deliveryUnit = null;
        } else {
            List<DeliveryUnitType> retDeliveryUnit = new ArrayList<>();
            for (DeliveryUnitType aItem: getDeliveryUnit()) {
                retDeliveryUnit.add(((aItem == null)?null:aItem.clone()));
            }
            ret.deliveryUnit = retDeliveryUnit;
        }
        ret.despatch = ((despatch == null)?null:despatch.clone());
        if (goodsItem == null) {
            ret.goodsItem = null;
        } else {
            List<GoodsItemType> retGoodsItem = new ArrayList<>();
            for (GoodsItemType aItem: getGoodsItem()) {
                retGoodsItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.goodsItem = retGoodsItem;
        }
        ret.id = ((id == null)?null:id.clone());
        if (measurementDimension == null) {
            ret.measurementDimension = null;
        } else {
            List<DimensionType> retMeasurementDimension = new ArrayList<>();
            for (DimensionType aItem: getMeasurementDimension()) {
                retMeasurementDimension.add(((aItem == null)?null:aItem.clone()));
            }
            ret.measurementDimension = retMeasurementDimension;
        }
        ret.packageLevelCode = ((packageLevelCode == null)?null:packageLevelCode.clone());
        if (packagingType == null) {
            ret.packagingType = null;
        } else {
            List<PackagingTypeType> retPackagingType = new ArrayList<>();
            for (PackagingTypeType aItem: getPackagingType()) {
                retPackagingType.add(((aItem == null)?null:aItem.clone()));
            }
            ret.packagingType = retPackagingType;
        }
        ret.packagingTypeCode = ((packagingTypeCode == null)?null:packagingTypeCode.clone());
        if (packingMaterial == null) {
            ret.packingMaterial = null;
        } else {
            List<PackingMaterialType> retPackingMaterial = new ArrayList<>();
            for (PackingMaterialType aItem: getPackingMaterial()) {
                retPackingMaterial.add(((aItem == null)?null:aItem.clone()));
            }
            ret.packingMaterial = retPackingMaterial;
        }
        ret.pickup = ((pickup == null)?null:pickup.clone());
        ret.quantity = ((quantity == null)?null:quantity.clone());
        ret.returnableMaterialIndicator = ((returnableMaterialIndicator == null)?null:returnableMaterialIndicator.clone());
        ret.traceID = ((traceID == null)?null:traceID.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PackageType clone() {
        PackageType ret = new PackageType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ReturnableMaterialIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ReturnableMaterialIndicatorType setReturnableMaterialIndicator(final boolean valueParam) {
        ReturnableMaterialIndicatorType aObj = getReturnableMaterialIndicator();
        if (aObj == null) {
            aObj = new ReturnableMaterialIndicatorType(valueParam);
            setReturnableMaterialIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PackageLevelCodeType and never <code>null</code>
     */
    @Nonnull
    public PackageLevelCodeType setPackageLevelCode(
        @Nullable
        final String valueParam) {
        PackageLevelCodeType aObj = getPackageLevelCode();
        if (aObj == null) {
            aObj = new PackageLevelCodeType(valueParam);
            setPackageLevelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PackagingTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public PackagingTypeCodeType setPackagingTypeCode(
        @Nullable
        final String valueParam) {
        PackagingTypeCodeType aObj = getPackagingTypeCode();
        if (aObj == null) {
            aObj = new PackagingTypeCodeType(valueParam);
            setPackagingTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TraceIDType and never <code>null</code>
     */
    @Nonnull
    public TraceIDType setTraceID(
        @Nullable
        final String valueParam) {
        TraceIDType aObj = getTraceID();
        if (aObj == null) {
            aObj = new TraceIDType(valueParam);
            setTraceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getQuantityValue() {
        QuantityType aObj = getQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReturnableMaterialIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ReturnableMaterialIndicatorType object or the passed nullValue
     */
    public boolean isReturnableMaterialIndicatorValue(final boolean nullValue) {
        ReturnableMaterialIndicatorType aObj = getReturnableMaterialIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained PackageLevelCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PackageLevelCodeType object or <code>null</code>
     */
    @Nullable
    public String getPackageLevelCodeValue() {
        PackageLevelCodeType aObj = getPackageLevelCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PackagingTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PackagingTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getPackagingTypeCodeValue() {
        PackagingTypeCodeType aObj = getPackagingTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TraceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TraceIDType object or <code>null</code>
     */
    @Nullable
    public String getTraceIDValue() {
        TraceIDType aObj = getTraceID();
        return (aObj == null)?null:aObj.getValue();
    }

}
