
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CompanyIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ExemptionReasonCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ExemptionReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RegistrationNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TaxLevelCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for PartyTaxSchemeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PartyTaxSchemeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RegistrationName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CompanyID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TaxLevelCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExemptionReasonCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExemptionReason" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RegistrationAddress" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TaxScheme"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PartyTaxSchemeType", propOrder = {
    "ublExtensions",
    "registrationName",
    "companyID",
    "taxLevelCode",
    "exemptionReasonCode",
    "exemptionReason",
    "registrationAddress",
    "taxScheme"
})
@CodingStyleguideUnaware
public class PartyTaxSchemeType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "RegistrationName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RegistrationNameType registrationName;
    @XmlElement(name = "CompanyID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CompanyIDType companyID;
    @XmlElement(name = "TaxLevelCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TaxLevelCodeType taxLevelCode;
    @XmlElement(name = "ExemptionReasonCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExemptionReasonCodeType exemptionReasonCode;
    @XmlElement(name = "ExemptionReason", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ExemptionReasonType> exemptionReason;
    @XmlElement(name = "RegistrationAddress")
    private AddressType registrationAddress;
    @XmlElement(name = "TaxScheme", required = true)
    private TaxSchemeType taxScheme;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PartyTaxSchemeType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the registrationName property.
     * 
     * @return
     *     possible object is
     *     {@link RegistrationNameType }
     *     
     */
    @Nullable
    public RegistrationNameType getRegistrationName() {
        return registrationName;
    }

    /**
     * Sets the value of the registrationName property.
     * 
     * @param value
     *     allowed object is
     *     {@link RegistrationNameType }
     *     
     */
    public void setRegistrationName(
        @Nullable
        RegistrationNameType value) {
        this.registrationName = value;
    }

    /**
     * Gets the value of the companyID property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyIDType }
     *     
     */
    @Nullable
    public CompanyIDType getCompanyID() {
        return companyID;
    }

    /**
     * Sets the value of the companyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyIDType }
     *     
     */
    public void setCompanyID(
        @Nullable
        CompanyIDType value) {
        this.companyID = value;
    }

    /**
     * Gets the value of the taxLevelCode property.
     * 
     * @return
     *     possible object is
     *     {@link TaxLevelCodeType }
     *     
     */
    @Nullable
    public TaxLevelCodeType getTaxLevelCode() {
        return taxLevelCode;
    }

    /**
     * Sets the value of the taxLevelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxLevelCodeType }
     *     
     */
    public void setTaxLevelCode(
        @Nullable
        TaxLevelCodeType value) {
        this.taxLevelCode = value;
    }

    /**
     * Gets the value of the exemptionReasonCode property.
     * 
     * @return
     *     possible object is
     *     {@link ExemptionReasonCodeType }
     *     
     */
    @Nullable
    public ExemptionReasonCodeType getExemptionReasonCode() {
        return exemptionReasonCode;
    }

    /**
     * Sets the value of the exemptionReasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExemptionReasonCodeType }
     *     
     */
    public void setExemptionReasonCode(
        @Nullable
        ExemptionReasonCodeType value) {
        this.exemptionReasonCode = value;
    }

    /**
     * Gets the value of the exemptionReason property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the exemptionReason property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getExemptionReason().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExemptionReasonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the exemptionReason property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ExemptionReasonType> getExemptionReason() {
        if (exemptionReason == null) {
            exemptionReason = new ArrayList<>();
        }
        return this.exemptionReason;
    }

    /**
     * Gets the value of the registrationAddress property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getRegistrationAddress() {
        return registrationAddress;
    }

    /**
     * Sets the value of the registrationAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setRegistrationAddress(
        @Nullable
        AddressType value) {
        this.registrationAddress = value;
    }

    /**
     * Gets the value of the taxScheme property.
     * 
     * @return
     *     possible object is
     *     {@link TaxSchemeType }
     *     
     */
    @Nullable
    public TaxSchemeType getTaxScheme() {
        return taxScheme;
    }

    /**
     * Sets the value of the taxScheme property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxSchemeType }
     *     
     */
    public void setTaxScheme(
        @Nullable
        TaxSchemeType value) {
        this.taxScheme = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PartyTaxSchemeType rhs = ((PartyTaxSchemeType) o);
        if (!EqualsHelper.equals(companyID, rhs.companyID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(exemptionReason, rhs.exemptionReason)) {
            return false;
        }
        if (!EqualsHelper.equals(exemptionReasonCode, rhs.exemptionReasonCode)) {
            return false;
        }
        if (!EqualsHelper.equals(registrationAddress, rhs.registrationAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(registrationName, rhs.registrationName)) {
            return false;
        }
        if (!EqualsHelper.equals(taxLevelCode, rhs.taxLevelCode)) {
            return false;
        }
        if (!EqualsHelper.equals(taxScheme, rhs.taxScheme)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(companyID).append(exemptionReason).append(exemptionReasonCode).append(registrationAddress).append(registrationName).append(taxLevelCode).append(taxScheme).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("companyID", companyID).append("exemptionReason", exemptionReason).append("exemptionReasonCode", exemptionReasonCode).append("registrationAddress", registrationAddress).append("registrationName", registrationName).append("taxLevelCode", taxLevelCode).append("taxScheme", taxScheme).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExemptionReason(
        @Nullable
        final List<ExemptionReasonType> aList) {
        exemptionReason = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExemptionReasonEntries() {
        return (!getExemptionReason().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExemptionReasonEntries() {
        return getExemptionReason().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExemptionReasonCount() {
        return getExemptionReason().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ExemptionReasonType getExemptionReasonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExemptionReason().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExemptionReason(
        @Nonnull
        final ExemptionReasonType elem) {
        getExemptionReason().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PartyTaxSchemeType ret) {
        ret.companyID = ((companyID == null)?null:companyID.clone());
        if (exemptionReason == null) {
            ret.exemptionReason = null;
        } else {
            List<ExemptionReasonType> retExemptionReason = new ArrayList<>();
            for (ExemptionReasonType aItem: getExemptionReason()) {
                retExemptionReason.add(((aItem == null)?null:aItem.clone()));
            }
            ret.exemptionReason = retExemptionReason;
        }
        ret.exemptionReasonCode = ((exemptionReasonCode == null)?null:exemptionReasonCode.clone());
        ret.registrationAddress = ((registrationAddress == null)?null:registrationAddress.clone());
        ret.registrationName = ((registrationName == null)?null:registrationName.clone());
        ret.taxLevelCode = ((taxLevelCode == null)?null:taxLevelCode.clone());
        ret.taxScheme = ((taxScheme == null)?null:taxScheme.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PartyTaxSchemeType clone() {
        PartyTaxSchemeType ret = new PartyTaxSchemeType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RegistrationNameType and never <code>null</code>
     */
    @Nonnull
    public RegistrationNameType setRegistrationName(
        @Nullable
        final String valueParam) {
        RegistrationNameType aObj = getRegistrationName();
        if (aObj == null) {
            aObj = new RegistrationNameType(valueParam);
            setRegistrationName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CompanyIDType and never <code>null</code>
     */
    @Nonnull
    public CompanyIDType setCompanyID(
        @Nullable
        final String valueParam) {
        CompanyIDType aObj = getCompanyID();
        if (aObj == null) {
            aObj = new CompanyIDType(valueParam);
            setCompanyID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TaxLevelCodeType and never <code>null</code>
     */
    @Nonnull
    public TaxLevelCodeType setTaxLevelCode(
        @Nullable
        final String valueParam) {
        TaxLevelCodeType aObj = getTaxLevelCode();
        if (aObj == null) {
            aObj = new TaxLevelCodeType(valueParam);
            setTaxLevelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExemptionReasonCodeType and never <code>null</code>
     */
    @Nonnull
    public ExemptionReasonCodeType setExemptionReasonCode(
        @Nullable
        final String valueParam) {
        ExemptionReasonCodeType aObj = getExemptionReasonCode();
        if (aObj == null) {
            aObj = new ExemptionReasonCodeType(valueParam);
            setExemptionReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained RegistrationNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RegistrationNameType object or <code>null</code>
     */
    @Nullable
    public String getRegistrationNameValue() {
        RegistrationNameType aObj = getRegistrationName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CompanyIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CompanyIDType object or <code>null</code>
     */
    @Nullable
    public String getCompanyIDValue() {
        CompanyIDType aObj = getCompanyID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TaxLevelCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TaxLevelCodeType object or <code>null</code>
     */
    @Nullable
    public String getTaxLevelCodeValue() {
        TaxLevelCodeType aObj = getTaxLevelCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExemptionReasonCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExemptionReasonCodeType object or <code>null</code>
     */
    @Nullable
    public String getExemptionReasonCodeValue() {
        ExemptionReasonCodeType aObj = getExemptionReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
