
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ChargeBearerCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.InstructionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.InstructionNoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PaymentChannelCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PaymentDueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PaymentIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PaymentMeansCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ServiceLevelCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for PaymentMeansType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PaymentMeansType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaymentMeansCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaymentDueDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaymentChannelCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InstructionID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InstructionNote" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaymentID" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ChargeBearerCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ServiceLevelCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CardAccount" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PayerFinancialAccount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PayeeFinancialAccount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CreditAccount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PaymentMandate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TradeFinancing" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RemittanceDocumentDistribution" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PaymentMeansType", propOrder = {
    "ublExtensions",
    "id",
    "paymentMeansCode",
    "paymentDueDate",
    "paymentChannelCode",
    "instructionID",
    "instructionNote",
    "paymentID",
    "chargeBearerCode",
    "serviceLevelCode",
    "cardAccount",
    "payerFinancialAccount",
    "payeeFinancialAccount",
    "creditAccount",
    "paymentMandate",
    "tradeFinancing",
    "remittanceDocumentDistribution"
})
@CodingStyleguideUnaware
public class PaymentMeansType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "PaymentMeansCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private PaymentMeansCodeType paymentMeansCode;
    @XmlElement(name = "PaymentDueDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PaymentDueDateType paymentDueDate;
    @XmlElement(name = "PaymentChannelCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PaymentChannelCodeType paymentChannelCode;
    @XmlElement(name = "InstructionID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private InstructionIDType instructionID;
    @XmlElement(name = "InstructionNote", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<InstructionNoteType> instructionNote;
    @XmlElement(name = "PaymentID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PaymentIDType> paymentID;
    @XmlElement(name = "ChargeBearerCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ChargeBearerCodeType chargeBearerCode;
    @XmlElement(name = "ServiceLevelCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ServiceLevelCodeType serviceLevelCode;
    @XmlElement(name = "CardAccount")
    private List<CardAccountType> cardAccount;
    @XmlElement(name = "PayerFinancialAccount")
    private FinancialAccountType payerFinancialAccount;
    @XmlElement(name = "PayeeFinancialAccount")
    private FinancialAccountType payeeFinancialAccount;
    @XmlElement(name = "CreditAccount")
    private CreditAccountType creditAccount;
    @XmlElement(name = "PaymentMandate")
    private PaymentMandateType paymentMandate;
    @XmlElement(name = "TradeFinancing")
    private TradeFinancingType tradeFinancing;
    @XmlElement(name = "RemittanceDocumentDistribution")
    private List<DocumentDistributionType> remittanceDocumentDistribution;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PaymentMeansType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the paymentMeansCode property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentMeansCodeType }
     *     
     */
    @Nullable
    public PaymentMeansCodeType getPaymentMeansCode() {
        return paymentMeansCode;
    }

    /**
     * Sets the value of the paymentMeansCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentMeansCodeType }
     *     
     */
    public void setPaymentMeansCode(
        @Nullable
        PaymentMeansCodeType value) {
        this.paymentMeansCode = value;
    }

    /**
     * Gets the value of the paymentDueDate property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentDueDateType }
     *     
     */
    @Nullable
    public PaymentDueDateType getPaymentDueDate() {
        return paymentDueDate;
    }

    /**
     * Sets the value of the paymentDueDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentDueDateType }
     *     
     */
    public void setPaymentDueDate(
        @Nullable
        PaymentDueDateType value) {
        this.paymentDueDate = value;
    }

    /**
     * Gets the value of the paymentChannelCode property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentChannelCodeType }
     *     
     */
    @Nullable
    public PaymentChannelCodeType getPaymentChannelCode() {
        return paymentChannelCode;
    }

    /**
     * Sets the value of the paymentChannelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentChannelCodeType }
     *     
     */
    public void setPaymentChannelCode(
        @Nullable
        PaymentChannelCodeType value) {
        this.paymentChannelCode = value;
    }

    /**
     * Gets the value of the instructionID property.
     * 
     * @return
     *     possible object is
     *     {@link InstructionIDType }
     *     
     */
    @Nullable
    public InstructionIDType getInstructionID() {
        return instructionID;
    }

    /**
     * Sets the value of the instructionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link InstructionIDType }
     *     
     */
    public void setInstructionID(
        @Nullable
        InstructionIDType value) {
        this.instructionID = value;
    }

    /**
     * Gets the value of the instructionNote property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the instructionNote property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getInstructionNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InstructionNoteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the instructionNote property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<InstructionNoteType> getInstructionNote() {
        if (instructionNote == null) {
            instructionNote = new ArrayList<>();
        }
        return this.instructionNote;
    }

    /**
     * Gets the value of the paymentID property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentID property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPaymentID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentIDType }
     * </p>
     * 
     * 
     * @return
     *     The value of the paymentID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PaymentIDType> getPaymentID() {
        if (paymentID == null) {
            paymentID = new ArrayList<>();
        }
        return this.paymentID;
    }

    /**
     * Gets the value of the chargeBearerCode property.
     * 
     * @return
     *     possible object is
     *     {@link ChargeBearerCodeType }
     *     
     */
    @Nullable
    public ChargeBearerCodeType getChargeBearerCode() {
        return chargeBearerCode;
    }

    /**
     * Sets the value of the chargeBearerCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChargeBearerCodeType }
     *     
     */
    public void setChargeBearerCode(
        @Nullable
        ChargeBearerCodeType value) {
        this.chargeBearerCode = value;
    }

    /**
     * Gets the value of the serviceLevelCode property.
     * 
     * @return
     *     possible object is
     *     {@link ServiceLevelCodeType }
     *     
     */
    @Nullable
    public ServiceLevelCodeType getServiceLevelCode() {
        return serviceLevelCode;
    }

    /**
     * Sets the value of the serviceLevelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ServiceLevelCodeType }
     *     
     */
    public void setServiceLevelCode(
        @Nullable
        ServiceLevelCodeType value) {
        this.serviceLevelCode = value;
    }

    /**
     * Gets the value of the cardAccount property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the cardAccount property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCardAccount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CardAccountType }
     * </p>
     * 
     * 
     * @return
     *     The value of the cardAccount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CardAccountType> getCardAccount() {
        if (cardAccount == null) {
            cardAccount = new ArrayList<>();
        }
        return this.cardAccount;
    }

    /**
     * Gets the value of the payerFinancialAccount property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialAccountType }
     *     
     */
    @Nullable
    public FinancialAccountType getPayerFinancialAccount() {
        return payerFinancialAccount;
    }

    /**
     * Sets the value of the payerFinancialAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialAccountType }
     *     
     */
    public void setPayerFinancialAccount(
        @Nullable
        FinancialAccountType value) {
        this.payerFinancialAccount = value;
    }

    /**
     * Gets the value of the payeeFinancialAccount property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialAccountType }
     *     
     */
    @Nullable
    public FinancialAccountType getPayeeFinancialAccount() {
        return payeeFinancialAccount;
    }

    /**
     * Sets the value of the payeeFinancialAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialAccountType }
     *     
     */
    public void setPayeeFinancialAccount(
        @Nullable
        FinancialAccountType value) {
        this.payeeFinancialAccount = value;
    }

    /**
     * Gets the value of the creditAccount property.
     * 
     * @return
     *     possible object is
     *     {@link CreditAccountType }
     *     
     */
    @Nullable
    public CreditAccountType getCreditAccount() {
        return creditAccount;
    }

    /**
     * Sets the value of the creditAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreditAccountType }
     *     
     */
    public void setCreditAccount(
        @Nullable
        CreditAccountType value) {
        this.creditAccount = value;
    }

    /**
     * Gets the value of the paymentMandate property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentMandateType }
     *     
     */
    @Nullable
    public PaymentMandateType getPaymentMandate() {
        return paymentMandate;
    }

    /**
     * Sets the value of the paymentMandate property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentMandateType }
     *     
     */
    public void setPaymentMandate(
        @Nullable
        PaymentMandateType value) {
        this.paymentMandate = value;
    }

    /**
     * Gets the value of the tradeFinancing property.
     * 
     * @return
     *     possible object is
     *     {@link TradeFinancingType }
     *     
     */
    @Nullable
    public TradeFinancingType getTradeFinancing() {
        return tradeFinancing;
    }

    /**
     * Sets the value of the tradeFinancing property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeFinancingType }
     *     
     */
    public void setTradeFinancing(
        @Nullable
        TradeFinancingType value) {
        this.tradeFinancing = value;
    }

    /**
     * Gets the value of the remittanceDocumentDistribution property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the remittanceDocumentDistribution property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRemittanceDocumentDistribution().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentDistributionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the remittanceDocumentDistribution property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentDistributionType> getRemittanceDocumentDistribution() {
        if (remittanceDocumentDistribution == null) {
            remittanceDocumentDistribution = new ArrayList<>();
        }
        return this.remittanceDocumentDistribution;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PaymentMeansType rhs = ((PaymentMeansType) o);
        if (!EqualsHelper.equalsCollection(cardAccount, rhs.cardAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeBearerCode, rhs.chargeBearerCode)) {
            return false;
        }
        if (!EqualsHelper.equals(creditAccount, rhs.creditAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(instructionID, rhs.instructionID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(instructionNote, rhs.instructionNote)) {
            return false;
        }
        if (!EqualsHelper.equals(payeeFinancialAccount, rhs.payeeFinancialAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(payerFinancialAccount, rhs.payerFinancialAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(paymentChannelCode, rhs.paymentChannelCode)) {
            return false;
        }
        if (!EqualsHelper.equals(paymentDueDate, rhs.paymentDueDate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(paymentID, rhs.paymentID)) {
            return false;
        }
        if (!EqualsHelper.equals(paymentMandate, rhs.paymentMandate)) {
            return false;
        }
        if (!EqualsHelper.equals(paymentMeansCode, rhs.paymentMeansCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(remittanceDocumentDistribution, rhs.remittanceDocumentDistribution)) {
            return false;
        }
        if (!EqualsHelper.equals(serviceLevelCode, rhs.serviceLevelCode)) {
            return false;
        }
        if (!EqualsHelper.equals(tradeFinancing, rhs.tradeFinancing)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(cardAccount).append(chargeBearerCode).append(creditAccount).append(id).append(instructionID).append(instructionNote).append(payeeFinancialAccount).append(payerFinancialAccount).append(paymentChannelCode).append(paymentDueDate).append(paymentID).append(paymentMandate).append(paymentMeansCode).append(remittanceDocumentDistribution).append(serviceLevelCode).append(tradeFinancing).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("cardAccount", cardAccount).append("chargeBearerCode", chargeBearerCode).append("creditAccount", creditAccount).append("id", id).append("instructionID", instructionID).append("instructionNote", instructionNote).append("payeeFinancialAccount", payeeFinancialAccount).append("payerFinancialAccount", payerFinancialAccount).append("paymentChannelCode", paymentChannelCode).append("paymentDueDate", paymentDueDate).append("paymentID", paymentID).append("paymentMandate", paymentMandate).append("paymentMeansCode", paymentMeansCode).append("remittanceDocumentDistribution", remittanceDocumentDistribution).append("serviceLevelCode", serviceLevelCode).append("tradeFinancing", tradeFinancing).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInstructionNote(
        @Nullable
        final List<InstructionNoteType> aList) {
        instructionNote = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPaymentID(
        @Nullable
        final List<PaymentIDType> aList) {
        paymentID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCardAccount(
        @Nullable
        final List<CardAccountType> aList) {
        cardAccount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRemittanceDocumentDistribution(
        @Nullable
        final List<DocumentDistributionType> aList) {
        remittanceDocumentDistribution = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInstructionNoteEntries() {
        return (!getInstructionNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInstructionNoteEntries() {
        return getInstructionNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInstructionNoteCount() {
        return getInstructionNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public InstructionNoteType getInstructionNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInstructionNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInstructionNote(
        @Nonnull
        final InstructionNoteType elem) {
        getInstructionNote().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPaymentIDEntries() {
        return (!getPaymentID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPaymentIDEntries() {
        return getPaymentID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPaymentIDCount() {
        return getPaymentID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PaymentIDType getPaymentIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPaymentID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPaymentID(
        @Nonnull
        final PaymentIDType elem) {
        getPaymentID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCardAccountEntries() {
        return (!getCardAccount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCardAccountEntries() {
        return getCardAccount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCardAccountCount() {
        return getCardAccount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CardAccountType getCardAccountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCardAccount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCardAccount(
        @Nonnull
        final CardAccountType elem) {
        getCardAccount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRemittanceDocumentDistributionEntries() {
        return (!getRemittanceDocumentDistribution().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRemittanceDocumentDistributionEntries() {
        return getRemittanceDocumentDistribution().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRemittanceDocumentDistributionCount() {
        return getRemittanceDocumentDistribution().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentDistributionType getRemittanceDocumentDistributionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRemittanceDocumentDistribution().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRemittanceDocumentDistribution(
        @Nonnull
        final DocumentDistributionType elem) {
        getRemittanceDocumentDistribution().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PaymentMeansType ret) {
        if (cardAccount == null) {
            ret.cardAccount = null;
        } else {
            List<CardAccountType> retCardAccount = new ArrayList<>();
            for (CardAccountType aItem: getCardAccount()) {
                retCardAccount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.cardAccount = retCardAccount;
        }
        ret.chargeBearerCode = ((chargeBearerCode == null)?null:chargeBearerCode.clone());
        ret.creditAccount = ((creditAccount == null)?null:creditAccount.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.instructionID = ((instructionID == null)?null:instructionID.clone());
        if (instructionNote == null) {
            ret.instructionNote = null;
        } else {
            List<InstructionNoteType> retInstructionNote = new ArrayList<>();
            for (InstructionNoteType aItem: getInstructionNote()) {
                retInstructionNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.instructionNote = retInstructionNote;
        }
        ret.payeeFinancialAccount = ((payeeFinancialAccount == null)?null:payeeFinancialAccount.clone());
        ret.payerFinancialAccount = ((payerFinancialAccount == null)?null:payerFinancialAccount.clone());
        ret.paymentChannelCode = ((paymentChannelCode == null)?null:paymentChannelCode.clone());
        ret.paymentDueDate = ((paymentDueDate == null)?null:paymentDueDate.clone());
        if (paymentID == null) {
            ret.paymentID = null;
        } else {
            List<PaymentIDType> retPaymentID = new ArrayList<>();
            for (PaymentIDType aItem: getPaymentID()) {
                retPaymentID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.paymentID = retPaymentID;
        }
        ret.paymentMandate = ((paymentMandate == null)?null:paymentMandate.clone());
        ret.paymentMeansCode = ((paymentMeansCode == null)?null:paymentMeansCode.clone());
        if (remittanceDocumentDistribution == null) {
            ret.remittanceDocumentDistribution = null;
        } else {
            List<DocumentDistributionType> retRemittanceDocumentDistribution = new ArrayList<>();
            for (DocumentDistributionType aItem: getRemittanceDocumentDistribution()) {
                retRemittanceDocumentDistribution.add(((aItem == null)?null:aItem.clone()));
            }
            ret.remittanceDocumentDistribution = retRemittanceDocumentDistribution;
        }
        ret.serviceLevelCode = ((serviceLevelCode == null)?null:serviceLevelCode.clone());
        ret.tradeFinancing = ((tradeFinancing == null)?null:tradeFinancing.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PaymentMeansType clone() {
        PaymentMeansType ret = new PaymentMeansType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentMeansCodeType and never <code>null</code>
     */
    @Nonnull
    public PaymentMeansCodeType setPaymentMeansCode(
        @Nullable
        final String valueParam) {
        PaymentMeansCodeType aObj = getPaymentMeansCode();
        if (aObj == null) {
            aObj = new PaymentMeansCodeType(valueParam);
            setPaymentMeansCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentDueDateType and never <code>null</code>
     */
    @Nonnull
    public PaymentDueDateType setPaymentDueDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        PaymentDueDateType aObj = getPaymentDueDate();
        if (aObj == null) {
            aObj = new PaymentDueDateType(valueParam);
            setPaymentDueDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentDueDateType and never <code>null</code>
     */
    @Nonnull
    public PaymentDueDateType setPaymentDueDate(
        @Nullable
        final LocalDate valueParam) {
        PaymentDueDateType aObj = getPaymentDueDate();
        if (aObj == null) {
            aObj = new PaymentDueDateType(valueParam);
            setPaymentDueDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentChannelCodeType and never <code>null</code>
     */
    @Nonnull
    public PaymentChannelCodeType setPaymentChannelCode(
        @Nullable
        final String valueParam) {
        PaymentChannelCodeType aObj = getPaymentChannelCode();
        if (aObj == null) {
            aObj = new PaymentChannelCodeType(valueParam);
            setPaymentChannelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type InstructionIDType and never <code>null</code>
     */
    @Nonnull
    public InstructionIDType setInstructionID(
        @Nullable
        final String valueParam) {
        InstructionIDType aObj = getInstructionID();
        if (aObj == null) {
            aObj = new InstructionIDType(valueParam);
            setInstructionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChargeBearerCodeType and never <code>null</code>
     */
    @Nonnull
    public ChargeBearerCodeType setChargeBearerCode(
        @Nullable
        final String valueParam) {
        ChargeBearerCodeType aObj = getChargeBearerCode();
        if (aObj == null) {
            aObj = new ChargeBearerCodeType(valueParam);
            setChargeBearerCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ServiceLevelCodeType and never <code>null</code>
     */
    @Nonnull
    public ServiceLevelCodeType setServiceLevelCode(
        @Nullable
        final String valueParam) {
        ServiceLevelCodeType aObj = getServiceLevelCode();
        if (aObj == null) {
            aObj = new ServiceLevelCodeType(valueParam);
            setServiceLevelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaymentMeansCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentMeansCodeType object or <code>null</code>
     */
    @Nullable
    public String getPaymentMeansCodeValue() {
        PaymentMeansCodeType aObj = getPaymentMeansCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaymentDueDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentDueDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getPaymentDueDateValue() {
        PaymentDueDateType aObj = getPaymentDueDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaymentDueDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentDueDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getPaymentDueDateValueLocal() {
        PaymentDueDateType aObj = getPaymentDueDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained PaymentChannelCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentChannelCodeType object or <code>null</code>
     */
    @Nullable
    public String getPaymentChannelCodeValue() {
        PaymentChannelCodeType aObj = getPaymentChannelCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained InstructionIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained InstructionIDType object or <code>null</code>
     */
    @Nullable
    public String getInstructionIDValue() {
        InstructionIDType aObj = getInstructionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ChargeBearerCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChargeBearerCodeType object or <code>null</code>
     */
    @Nullable
    public String getChargeBearerCodeValue() {
        ChargeBearerCodeType aObj = getChargeBearerCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ServiceLevelCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ServiceLevelCodeType object or <code>null</code>
     */
    @Nullable
    public String getServiceLevelCodeValue() {
        ServiceLevelCodeType aObj = getServiceLevelCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
