
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.BirthDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.BirthplaceNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.FamilyNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.FirstNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.GenderCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.JobTitleType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MiddleNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NameSuffixType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NationalityIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.OrganizationDepartmentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.OtherNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RoleCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TitleType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for PersonType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PersonType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FirstName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FamilyName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Title" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MiddleName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OtherName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NameSuffix" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}JobTitle" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NationalityID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GenderCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BirthDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BirthplaceName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OrganizationDepartment" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RoleCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}BirthplaceLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CitizenshipCountry" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Contact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FinancialAccount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}IdentityDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ResidenceAddress" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonType", propOrder = {
    "ublExtensions",
    "id",
    "firstName",
    "familyName",
    "title",
    "middleName",
    "otherName",
    "nameSuffix",
    "jobTitle",
    "nationalityID",
    "genderCode",
    "birthDate",
    "birthplaceName",
    "organizationDepartment",
    "roleCode",
    "birthplaceLocation",
    "citizenshipCountry",
    "contact",
    "financialAccount",
    "identityDocumentReference",
    "residenceAddress"
})
@CodingStyleguideUnaware
public class PersonType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "FirstName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FirstNameType firstName;
    @XmlElement(name = "FamilyName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FamilyNameType familyName;
    @XmlElement(name = "Title", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TitleType title;
    @XmlElement(name = "MiddleName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MiddleNameType middleName;
    @XmlElement(name = "OtherName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OtherNameType otherName;
    @XmlElement(name = "NameSuffix", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NameSuffixType nameSuffix;
    @XmlElement(name = "JobTitle", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private JobTitleType jobTitle;
    @XmlElement(name = "NationalityID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NationalityIDType nationalityID;
    @XmlElement(name = "GenderCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GenderCodeType genderCode;
    @XmlElement(name = "BirthDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private BirthDateType birthDate;
    @XmlElement(name = "BirthplaceName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private BirthplaceNameType birthplaceName;
    @XmlElement(name = "OrganizationDepartment", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OrganizationDepartmentType organizationDepartment;
    @XmlElement(name = "RoleCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RoleCodeType roleCode;
    @XmlElement(name = "BirthplaceLocation")
    private LocationType birthplaceLocation;
    @XmlElement(name = "CitizenshipCountry")
    private CountryType citizenshipCountry;
    @XmlElement(name = "Contact")
    private ContactType contact;
    @XmlElement(name = "FinancialAccount")
    private FinancialAccountType financialAccount;
    @XmlElement(name = "IdentityDocumentReference")
    private List<DocumentReferenceType> identityDocumentReference;
    @XmlElement(name = "ResidenceAddress")
    private AddressType residenceAddress;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PersonType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the firstName property.
     * 
     * @return
     *     possible object is
     *     {@link FirstNameType }
     *     
     */
    @Nullable
    public FirstNameType getFirstName() {
        return firstName;
    }

    /**
     * Sets the value of the firstName property.
     * 
     * @param value
     *     allowed object is
     *     {@link FirstNameType }
     *     
     */
    public void setFirstName(
        @Nullable
        FirstNameType value) {
        this.firstName = value;
    }

    /**
     * Gets the value of the familyName property.
     * 
     * @return
     *     possible object is
     *     {@link FamilyNameType }
     *     
     */
    @Nullable
    public FamilyNameType getFamilyName() {
        return familyName;
    }

    /**
     * Sets the value of the familyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link FamilyNameType }
     *     
     */
    public void setFamilyName(
        @Nullable
        FamilyNameType value) {
        this.familyName = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link TitleType }
     *     
     */
    @Nullable
    public TitleType getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link TitleType }
     *     
     */
    public void setTitle(
        @Nullable
        TitleType value) {
        this.title = value;
    }

    /**
     * Gets the value of the middleName property.
     * 
     * @return
     *     possible object is
     *     {@link MiddleNameType }
     *     
     */
    @Nullable
    public MiddleNameType getMiddleName() {
        return middleName;
    }

    /**
     * Sets the value of the middleName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiddleNameType }
     *     
     */
    public void setMiddleName(
        @Nullable
        MiddleNameType value) {
        this.middleName = value;
    }

    /**
     * Gets the value of the otherName property.
     * 
     * @return
     *     possible object is
     *     {@link OtherNameType }
     *     
     */
    @Nullable
    public OtherNameType getOtherName() {
        return otherName;
    }

    /**
     * Sets the value of the otherName property.
     * 
     * @param value
     *     allowed object is
     *     {@link OtherNameType }
     *     
     */
    public void setOtherName(
        @Nullable
        OtherNameType value) {
        this.otherName = value;
    }

    /**
     * Gets the value of the nameSuffix property.
     * 
     * @return
     *     possible object is
     *     {@link NameSuffixType }
     *     
     */
    @Nullable
    public NameSuffixType getNameSuffix() {
        return nameSuffix;
    }

    /**
     * Sets the value of the nameSuffix property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameSuffixType }
     *     
     */
    public void setNameSuffix(
        @Nullable
        NameSuffixType value) {
        this.nameSuffix = value;
    }

    /**
     * Gets the value of the jobTitle property.
     * 
     * @return
     *     possible object is
     *     {@link JobTitleType }
     *     
     */
    @Nullable
    public JobTitleType getJobTitle() {
        return jobTitle;
    }

    /**
     * Sets the value of the jobTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobTitleType }
     *     
     */
    public void setJobTitle(
        @Nullable
        JobTitleType value) {
        this.jobTitle = value;
    }

    /**
     * Gets the value of the nationalityID property.
     * 
     * @return
     *     possible object is
     *     {@link NationalityIDType }
     *     
     */
    @Nullable
    public NationalityIDType getNationalityID() {
        return nationalityID;
    }

    /**
     * Sets the value of the nationalityID property.
     * 
     * @param value
     *     allowed object is
     *     {@link NationalityIDType }
     *     
     */
    public void setNationalityID(
        @Nullable
        NationalityIDType value) {
        this.nationalityID = value;
    }

    /**
     * Gets the value of the genderCode property.
     * 
     * @return
     *     possible object is
     *     {@link GenderCodeType }
     *     
     */
    @Nullable
    public GenderCodeType getGenderCode() {
        return genderCode;
    }

    /**
     * Sets the value of the genderCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link GenderCodeType }
     *     
     */
    public void setGenderCode(
        @Nullable
        GenderCodeType value) {
        this.genderCode = value;
    }

    /**
     * Gets the value of the birthDate property.
     * 
     * @return
     *     possible object is
     *     {@link BirthDateType }
     *     
     */
    @Nullable
    public BirthDateType getBirthDate() {
        return birthDate;
    }

    /**
     * Sets the value of the birthDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link BirthDateType }
     *     
     */
    public void setBirthDate(
        @Nullable
        BirthDateType value) {
        this.birthDate = value;
    }

    /**
     * Gets the value of the birthplaceName property.
     * 
     * @return
     *     possible object is
     *     {@link BirthplaceNameType }
     *     
     */
    @Nullable
    public BirthplaceNameType getBirthplaceName() {
        return birthplaceName;
    }

    /**
     * Sets the value of the birthplaceName property.
     * 
     * @param value
     *     allowed object is
     *     {@link BirthplaceNameType }
     *     
     */
    public void setBirthplaceName(
        @Nullable
        BirthplaceNameType value) {
        this.birthplaceName = value;
    }

    /**
     * Gets the value of the organizationDepartment property.
     * 
     * @return
     *     possible object is
     *     {@link OrganizationDepartmentType }
     *     
     */
    @Nullable
    public OrganizationDepartmentType getOrganizationDepartment() {
        return organizationDepartment;
    }

    /**
     * Sets the value of the organizationDepartment property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrganizationDepartmentType }
     *     
     */
    public void setOrganizationDepartment(
        @Nullable
        OrganizationDepartmentType value) {
        this.organizationDepartment = value;
    }

    /**
     * Gets the value of the roleCode property.
     * 
     * @return
     *     possible object is
     *     {@link RoleCodeType }
     *     
     */
    @Nullable
    public RoleCodeType getRoleCode() {
        return roleCode;
    }

    /**
     * Sets the value of the roleCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link RoleCodeType }
     *     
     */
    public void setRoleCode(
        @Nullable
        RoleCodeType value) {
        this.roleCode = value;
    }

    /**
     * Gets the value of the birthplaceLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getBirthplaceLocation() {
        return birthplaceLocation;
    }

    /**
     * Sets the value of the birthplaceLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setBirthplaceLocation(
        @Nullable
        LocationType value) {
        this.birthplaceLocation = value;
    }

    /**
     * Gets the value of the citizenshipCountry property.
     * 
     * @return
     *     possible object is
     *     {@link CountryType }
     *     
     */
    @Nullable
    public CountryType getCitizenshipCountry() {
        return citizenshipCountry;
    }

    /**
     * Sets the value of the citizenshipCountry property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryType }
     *     
     */
    public void setCitizenshipCountry(
        @Nullable
        CountryType value) {
        this.citizenshipCountry = value;
    }

    /**
     * Gets the value of the contact property.
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getContact() {
        return contact;
    }

    /**
     * Sets the value of the contact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     */
    public void setContact(
        @Nullable
        ContactType value) {
        this.contact = value;
    }

    /**
     * Gets the value of the financialAccount property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialAccountType }
     *     
     */
    @Nullable
    public FinancialAccountType getFinancialAccount() {
        return financialAccount;
    }

    /**
     * Sets the value of the financialAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialAccountType }
     *     
     */
    public void setFinancialAccount(
        @Nullable
        FinancialAccountType value) {
        this.financialAccount = value;
    }

    /**
     * Gets the value of the identityDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the identityDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getIdentityDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the identityDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getIdentityDocumentReference() {
        if (identityDocumentReference == null) {
            identityDocumentReference = new ArrayList<>();
        }
        return this.identityDocumentReference;
    }

    /**
     * Gets the value of the residenceAddress property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getResidenceAddress() {
        return residenceAddress;
    }

    /**
     * Sets the value of the residenceAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setResidenceAddress(
        @Nullable
        AddressType value) {
        this.residenceAddress = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PersonType rhs = ((PersonType) o);
        if (!EqualsHelper.equals(birthDate, rhs.birthDate)) {
            return false;
        }
        if (!EqualsHelper.equals(birthplaceLocation, rhs.birthplaceLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(birthplaceName, rhs.birthplaceName)) {
            return false;
        }
        if (!EqualsHelper.equals(citizenshipCountry, rhs.citizenshipCountry)) {
            return false;
        }
        if (!EqualsHelper.equals(contact, rhs.contact)) {
            return false;
        }
        if (!EqualsHelper.equals(familyName, rhs.familyName)) {
            return false;
        }
        if (!EqualsHelper.equals(financialAccount, rhs.financialAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(firstName, rhs.firstName)) {
            return false;
        }
        if (!EqualsHelper.equals(genderCode, rhs.genderCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(identityDocumentReference, rhs.identityDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(jobTitle, rhs.jobTitle)) {
            return false;
        }
        if (!EqualsHelper.equals(middleName, rhs.middleName)) {
            return false;
        }
        if (!EqualsHelper.equals(nameSuffix, rhs.nameSuffix)) {
            return false;
        }
        if (!EqualsHelper.equals(nationalityID, rhs.nationalityID)) {
            return false;
        }
        if (!EqualsHelper.equals(organizationDepartment, rhs.organizationDepartment)) {
            return false;
        }
        if (!EqualsHelper.equals(otherName, rhs.otherName)) {
            return false;
        }
        if (!EqualsHelper.equals(residenceAddress, rhs.residenceAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(roleCode, rhs.roleCode)) {
            return false;
        }
        if (!EqualsHelper.equals(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(birthDate).append(birthplaceLocation).append(birthplaceName).append(citizenshipCountry).append(contact).append(familyName).append(financialAccount).append(firstName).append(genderCode).append(id).append(identityDocumentReference).append(jobTitle).append(middleName).append(nameSuffix).append(nationalityID).append(organizationDepartment).append(otherName).append(residenceAddress).append(roleCode).append(title).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("birthDate", birthDate).append("birthplaceLocation", birthplaceLocation).append("birthplaceName", birthplaceName).append("citizenshipCountry", citizenshipCountry).append("contact", contact).append("familyName", familyName).append("financialAccount", financialAccount).append("firstName", firstName).append("genderCode", genderCode).append("id", id).append("identityDocumentReference", identityDocumentReference).append("jobTitle", jobTitle).append("middleName", middleName).append("nameSuffix", nameSuffix).append("nationalityID", nationalityID).append("organizationDepartment", organizationDepartment).append("otherName", otherName).append("residenceAddress", residenceAddress).append("roleCode", roleCode).append("title", title).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIdentityDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        identityDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIdentityDocumentReferenceEntries() {
        return (!getIdentityDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIdentityDocumentReferenceEntries() {
        return getIdentityDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIdentityDocumentReferenceCount() {
        return getIdentityDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getIdentityDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIdentityDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIdentityDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getIdentityDocumentReference().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PersonType ret) {
        ret.birthDate = ((birthDate == null)?null:birthDate.clone());
        ret.birthplaceLocation = ((birthplaceLocation == null)?null:birthplaceLocation.clone());
        ret.birthplaceName = ((birthplaceName == null)?null:birthplaceName.clone());
        ret.citizenshipCountry = ((citizenshipCountry == null)?null:citizenshipCountry.clone());
        ret.contact = ((contact == null)?null:contact.clone());
        ret.familyName = ((familyName == null)?null:familyName.clone());
        ret.financialAccount = ((financialAccount == null)?null:financialAccount.clone());
        ret.firstName = ((firstName == null)?null:firstName.clone());
        ret.genderCode = ((genderCode == null)?null:genderCode.clone());
        ret.id = ((id == null)?null:id.clone());
        if (identityDocumentReference == null) {
            ret.identityDocumentReference = null;
        } else {
            List<DocumentReferenceType> retIdentityDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getIdentityDocumentReference()) {
                retIdentityDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.identityDocumentReference = retIdentityDocumentReference;
        }
        ret.jobTitle = ((jobTitle == null)?null:jobTitle.clone());
        ret.middleName = ((middleName == null)?null:middleName.clone());
        ret.nameSuffix = ((nameSuffix == null)?null:nameSuffix.clone());
        ret.nationalityID = ((nationalityID == null)?null:nationalityID.clone());
        ret.organizationDepartment = ((organizationDepartment == null)?null:organizationDepartment.clone());
        ret.otherName = ((otherName == null)?null:otherName.clone());
        ret.residenceAddress = ((residenceAddress == null)?null:residenceAddress.clone());
        ret.roleCode = ((roleCode == null)?null:roleCode.clone());
        ret.title = ((title == null)?null:title.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PersonType clone() {
        PersonType ret = new PersonType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FirstNameType and never <code>null</code>
     */
    @Nonnull
    public FirstNameType setFirstName(
        @Nullable
        final String valueParam) {
        FirstNameType aObj = getFirstName();
        if (aObj == null) {
            aObj = new FirstNameType(valueParam);
            setFirstName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FamilyNameType and never <code>null</code>
     */
    @Nonnull
    public FamilyNameType setFamilyName(
        @Nullable
        final String valueParam) {
        FamilyNameType aObj = getFamilyName();
        if (aObj == null) {
            aObj = new FamilyNameType(valueParam);
            setFamilyName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TitleType and never <code>null</code>
     */
    @Nonnull
    public TitleType setTitle(
        @Nullable
        final String valueParam) {
        TitleType aObj = getTitle();
        if (aObj == null) {
            aObj = new TitleType(valueParam);
            setTitle(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MiddleNameType and never <code>null</code>
     */
    @Nonnull
    public MiddleNameType setMiddleName(
        @Nullable
        final String valueParam) {
        MiddleNameType aObj = getMiddleName();
        if (aObj == null) {
            aObj = new MiddleNameType(valueParam);
            setMiddleName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OtherNameType and never <code>null</code>
     */
    @Nonnull
    public OtherNameType setOtherName(
        @Nullable
        final String valueParam) {
        OtherNameType aObj = getOtherName();
        if (aObj == null) {
            aObj = new OtherNameType(valueParam);
            setOtherName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameSuffixType and never <code>null</code>
     */
    @Nonnull
    public NameSuffixType setNameSuffix(
        @Nullable
        final String valueParam) {
        NameSuffixType aObj = getNameSuffix();
        if (aObj == null) {
            aObj = new NameSuffixType(valueParam);
            setNameSuffix(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type JobTitleType and never <code>null</code>
     */
    @Nonnull
    public JobTitleType setJobTitle(
        @Nullable
        final String valueParam) {
        JobTitleType aObj = getJobTitle();
        if (aObj == null) {
            aObj = new JobTitleType(valueParam);
            setJobTitle(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NationalityIDType and never <code>null</code>
     */
    @Nonnull
    public NationalityIDType setNationalityID(
        @Nullable
        final String valueParam) {
        NationalityIDType aObj = getNationalityID();
        if (aObj == null) {
            aObj = new NationalityIDType(valueParam);
            setNationalityID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GenderCodeType and never <code>null</code>
     */
    @Nonnull
    public GenderCodeType setGenderCode(
        @Nullable
        final String valueParam) {
        GenderCodeType aObj = getGenderCode();
        if (aObj == null) {
            aObj = new GenderCodeType(valueParam);
            setGenderCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BirthDateType and never <code>null</code>
     */
    @Nonnull
    public BirthDateType setBirthDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        BirthDateType aObj = getBirthDate();
        if (aObj == null) {
            aObj = new BirthDateType(valueParam);
            setBirthDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BirthDateType and never <code>null</code>
     */
    @Nonnull
    public BirthDateType setBirthDate(
        @Nullable
        final LocalDate valueParam) {
        BirthDateType aObj = getBirthDate();
        if (aObj == null) {
            aObj = new BirthDateType(valueParam);
            setBirthDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BirthplaceNameType and never <code>null</code>
     */
    @Nonnull
    public BirthplaceNameType setBirthplaceName(
        @Nullable
        final String valueParam) {
        BirthplaceNameType aObj = getBirthplaceName();
        if (aObj == null) {
            aObj = new BirthplaceNameType(valueParam);
            setBirthplaceName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OrganizationDepartmentType and never <code>null</code>
     */
    @Nonnull
    public OrganizationDepartmentType setOrganizationDepartment(
        @Nullable
        final String valueParam) {
        OrganizationDepartmentType aObj = getOrganizationDepartment();
        if (aObj == null) {
            aObj = new OrganizationDepartmentType(valueParam);
            setOrganizationDepartment(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RoleCodeType and never <code>null</code>
     */
    @Nonnull
    public RoleCodeType setRoleCode(
        @Nullable
        final String valueParam) {
        RoleCodeType aObj = getRoleCode();
        if (aObj == null) {
            aObj = new RoleCodeType(valueParam);
            setRoleCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FirstNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FirstNameType object or <code>null</code>
     */
    @Nullable
    public String getFirstNameValue() {
        FirstNameType aObj = getFirstName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FamilyNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FamilyNameType object or <code>null</code>
     */
    @Nullable
    public String getFamilyNameValue() {
        FamilyNameType aObj = getFamilyName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TitleType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TitleType object or <code>null</code>
     */
    @Nullable
    public String getTitleValue() {
        TitleType aObj = getTitle();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MiddleNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MiddleNameType object or <code>null</code>
     */
    @Nullable
    public String getMiddleNameValue() {
        MiddleNameType aObj = getMiddleName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OtherNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OtherNameType object or <code>null</code>
     */
    @Nullable
    public String getOtherNameValue() {
        OtherNameType aObj = getOtherName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NameSuffixType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameSuffixType object or <code>null</code>
     */
    @Nullable
    public String getNameSuffixValue() {
        NameSuffixType aObj = getNameSuffix();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained JobTitleType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained JobTitleType object or <code>null</code>
     */
    @Nullable
    public String getJobTitleValue() {
        JobTitleType aObj = getJobTitle();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NationalityIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NationalityIDType object or <code>null</code>
     */
    @Nullable
    public String getNationalityIDValue() {
        NationalityIDType aObj = getNationalityID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GenderCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GenderCodeType object or <code>null</code>
     */
    @Nullable
    public String getGenderCodeValue() {
        GenderCodeType aObj = getGenderCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained BirthDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BirthDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getBirthDateValue() {
        BirthDateType aObj = getBirthDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained BirthDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BirthDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getBirthDateValueLocal() {
        BirthDateType aObj = getBirthDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained BirthplaceNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BirthplaceNameType object or <code>null</code>
     */
    @Nullable
    public String getBirthplaceNameValue() {
        BirthplaceNameType aObj = getBirthplaceName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OrganizationDepartmentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OrganizationDepartmentType object or <code>null</code>
     */
    @Nullable
    public String getOrganizationDepartmentValue() {
        OrganizationDepartmentType aObj = getOrganizationDepartment();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RoleCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RoleCodeType object or <code>null</code>
     */
    @Nullable
    public String getRoleCodeValue() {
        RoleCodeType aObj = getRoleCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
