
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ActualPickupDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ActualPickupTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EarliestPickupDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EarliestPickupTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LatestPickupDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LatestPickupTimeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for PickupType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PickupType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ActualPickupDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ActualPickupTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EarliestPickupDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EarliestPickupTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatestPickupDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatestPickupTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PickupLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PickupParty" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PickupType", propOrder = {
    "ublExtensions",
    "id",
    "actualPickupDate",
    "actualPickupTime",
    "earliestPickupDate",
    "earliestPickupTime",
    "latestPickupDate",
    "latestPickupTime",
    "pickupLocation",
    "pickupParty"
})
@CodingStyleguideUnaware
public class PickupType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "ActualPickupDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ActualPickupDateType actualPickupDate;
    @XmlElement(name = "ActualPickupTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ActualPickupTimeType actualPickupTime;
    @XmlElement(name = "EarliestPickupDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EarliestPickupDateType earliestPickupDate;
    @XmlElement(name = "EarliestPickupTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EarliestPickupTimeType earliestPickupTime;
    @XmlElement(name = "LatestPickupDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatestPickupDateType latestPickupDate;
    @XmlElement(name = "LatestPickupTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatestPickupTimeType latestPickupTime;
    @XmlElement(name = "PickupLocation")
    private LocationType pickupLocation;
    @XmlElement(name = "PickupParty")
    private PartyType pickupParty;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PickupType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the actualPickupDate property.
     * 
     * @return
     *     possible object is
     *     {@link ActualPickupDateType }
     *     
     */
    @Nullable
    public ActualPickupDateType getActualPickupDate() {
        return actualPickupDate;
    }

    /**
     * Sets the value of the actualPickupDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActualPickupDateType }
     *     
     */
    public void setActualPickupDate(
        @Nullable
        ActualPickupDateType value) {
        this.actualPickupDate = value;
    }

    /**
     * Gets the value of the actualPickupTime property.
     * 
     * @return
     *     possible object is
     *     {@link ActualPickupTimeType }
     *     
     */
    @Nullable
    public ActualPickupTimeType getActualPickupTime() {
        return actualPickupTime;
    }

    /**
     * Sets the value of the actualPickupTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActualPickupTimeType }
     *     
     */
    public void setActualPickupTime(
        @Nullable
        ActualPickupTimeType value) {
        this.actualPickupTime = value;
    }

    /**
     * Gets the value of the earliestPickupDate property.
     * 
     * @return
     *     possible object is
     *     {@link EarliestPickupDateType }
     *     
     */
    @Nullable
    public EarliestPickupDateType getEarliestPickupDate() {
        return earliestPickupDate;
    }

    /**
     * Sets the value of the earliestPickupDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link EarliestPickupDateType }
     *     
     */
    public void setEarliestPickupDate(
        @Nullable
        EarliestPickupDateType value) {
        this.earliestPickupDate = value;
    }

    /**
     * Gets the value of the earliestPickupTime property.
     * 
     * @return
     *     possible object is
     *     {@link EarliestPickupTimeType }
     *     
     */
    @Nullable
    public EarliestPickupTimeType getEarliestPickupTime() {
        return earliestPickupTime;
    }

    /**
     * Sets the value of the earliestPickupTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link EarliestPickupTimeType }
     *     
     */
    public void setEarliestPickupTime(
        @Nullable
        EarliestPickupTimeType value) {
        this.earliestPickupTime = value;
    }

    /**
     * Gets the value of the latestPickupDate property.
     * 
     * @return
     *     possible object is
     *     {@link LatestPickupDateType }
     *     
     */
    @Nullable
    public LatestPickupDateType getLatestPickupDate() {
        return latestPickupDate;
    }

    /**
     * Sets the value of the latestPickupDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestPickupDateType }
     *     
     */
    public void setLatestPickupDate(
        @Nullable
        LatestPickupDateType value) {
        this.latestPickupDate = value;
    }

    /**
     * Gets the value of the latestPickupTime property.
     * 
     * @return
     *     possible object is
     *     {@link LatestPickupTimeType }
     *     
     */
    @Nullable
    public LatestPickupTimeType getLatestPickupTime() {
        return latestPickupTime;
    }

    /**
     * Sets the value of the latestPickupTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestPickupTimeType }
     *     
     */
    public void setLatestPickupTime(
        @Nullable
        LatestPickupTimeType value) {
        this.latestPickupTime = value;
    }

    /**
     * Gets the value of the pickupLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getPickupLocation() {
        return pickupLocation;
    }

    /**
     * Sets the value of the pickupLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setPickupLocation(
        @Nullable
        LocationType value) {
        this.pickupLocation = value;
    }

    /**
     * Gets the value of the pickupParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getPickupParty() {
        return pickupParty;
    }

    /**
     * Sets the value of the pickupParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setPickupParty(
        @Nullable
        PartyType value) {
        this.pickupParty = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PickupType rhs = ((PickupType) o);
        if (!EqualsHelper.equals(actualPickupDate, rhs.actualPickupDate)) {
            return false;
        }
        if (!EqualsHelper.equals(actualPickupTime, rhs.actualPickupTime)) {
            return false;
        }
        if (!EqualsHelper.equals(earliestPickupDate, rhs.earliestPickupDate)) {
            return false;
        }
        if (!EqualsHelper.equals(earliestPickupTime, rhs.earliestPickupTime)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(latestPickupDate, rhs.latestPickupDate)) {
            return false;
        }
        if (!EqualsHelper.equals(latestPickupTime, rhs.latestPickupTime)) {
            return false;
        }
        if (!EqualsHelper.equals(pickupLocation, rhs.pickupLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(pickupParty, rhs.pickupParty)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualPickupDate).append(actualPickupTime).append(earliestPickupDate).append(earliestPickupTime).append(id).append(latestPickupDate).append(latestPickupTime).append(pickupLocation).append(pickupParty).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualPickupDate", actualPickupDate).append("actualPickupTime", actualPickupTime).append("earliestPickupDate", earliestPickupDate).append("earliestPickupTime", earliestPickupTime).append("id", id).append("latestPickupDate", latestPickupDate).append("latestPickupTime", latestPickupTime).append("pickupLocation", pickupLocation).append("pickupParty", pickupParty).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PickupType ret) {
        ret.actualPickupDate = ((actualPickupDate == null)?null:actualPickupDate.clone());
        ret.actualPickupTime = ((actualPickupTime == null)?null:actualPickupTime.clone());
        ret.earliestPickupDate = ((earliestPickupDate == null)?null:earliestPickupDate.clone());
        ret.earliestPickupTime = ((earliestPickupTime == null)?null:earliestPickupTime.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.latestPickupDate = ((latestPickupDate == null)?null:latestPickupDate.clone());
        ret.latestPickupTime = ((latestPickupTime == null)?null:latestPickupTime.clone());
        ret.pickupLocation = ((pickupLocation == null)?null:pickupLocation.clone());
        ret.pickupParty = ((pickupParty == null)?null:pickupParty.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PickupType clone() {
        PickupType ret = new PickupType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualPickupDateType and never <code>null</code>
     */
    @Nonnull
    public ActualPickupDateType setActualPickupDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ActualPickupDateType aObj = getActualPickupDate();
        if (aObj == null) {
            aObj = new ActualPickupDateType(valueParam);
            setActualPickupDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualPickupDateType and never <code>null</code>
     */
    @Nonnull
    public ActualPickupDateType setActualPickupDate(
        @Nullable
        final LocalDate valueParam) {
        ActualPickupDateType aObj = getActualPickupDate();
        if (aObj == null) {
            aObj = new ActualPickupDateType(valueParam);
            setActualPickupDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualPickupTimeType and never <code>null</code>
     */
    @Nonnull
    public ActualPickupTimeType setActualPickupTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        ActualPickupTimeType aObj = getActualPickupTime();
        if (aObj == null) {
            aObj = new ActualPickupTimeType(valueParam);
            setActualPickupTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActualPickupTimeType and never <code>null</code>
     */
    @Nonnull
    public ActualPickupTimeType setActualPickupTime(
        @Nullable
        final LocalTime valueParam) {
        ActualPickupTimeType aObj = getActualPickupTime();
        if (aObj == null) {
            aObj = new ActualPickupTimeType(valueParam);
            setActualPickupTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EarliestPickupDateType and never <code>null</code>
     */
    @Nonnull
    public EarliestPickupDateType setEarliestPickupDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        EarliestPickupDateType aObj = getEarliestPickupDate();
        if (aObj == null) {
            aObj = new EarliestPickupDateType(valueParam);
            setEarliestPickupDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EarliestPickupDateType and never <code>null</code>
     */
    @Nonnull
    public EarliestPickupDateType setEarliestPickupDate(
        @Nullable
        final LocalDate valueParam) {
        EarliestPickupDateType aObj = getEarliestPickupDate();
        if (aObj == null) {
            aObj = new EarliestPickupDateType(valueParam);
            setEarliestPickupDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EarliestPickupTimeType and never <code>null</code>
     */
    @Nonnull
    public EarliestPickupTimeType setEarliestPickupTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        EarliestPickupTimeType aObj = getEarliestPickupTime();
        if (aObj == null) {
            aObj = new EarliestPickupTimeType(valueParam);
            setEarliestPickupTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EarliestPickupTimeType and never <code>null</code>
     */
    @Nonnull
    public EarliestPickupTimeType setEarliestPickupTime(
        @Nullable
        final LocalTime valueParam) {
        EarliestPickupTimeType aObj = getEarliestPickupTime();
        if (aObj == null) {
            aObj = new EarliestPickupTimeType(valueParam);
            setEarliestPickupTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestPickupDateType and never <code>null</code>
     */
    @Nonnull
    public LatestPickupDateType setLatestPickupDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        LatestPickupDateType aObj = getLatestPickupDate();
        if (aObj == null) {
            aObj = new LatestPickupDateType(valueParam);
            setLatestPickupDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestPickupDateType and never <code>null</code>
     */
    @Nonnull
    public LatestPickupDateType setLatestPickupDate(
        @Nullable
        final LocalDate valueParam) {
        LatestPickupDateType aObj = getLatestPickupDate();
        if (aObj == null) {
            aObj = new LatestPickupDateType(valueParam);
            setLatestPickupDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestPickupTimeType and never <code>null</code>
     */
    @Nonnull
    public LatestPickupTimeType setLatestPickupTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        LatestPickupTimeType aObj = getLatestPickupTime();
        if (aObj == null) {
            aObj = new LatestPickupTimeType(valueParam);
            setLatestPickupTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestPickupTimeType and never <code>null</code>
     */
    @Nonnull
    public LatestPickupTimeType setLatestPickupTime(
        @Nullable
        final LocalTime valueParam) {
        LatestPickupTimeType aObj = getLatestPickupTime();
        if (aObj == null) {
            aObj = new LatestPickupTimeType(valueParam);
            setLatestPickupTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ActualPickupDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualPickupDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getActualPickupDateValue() {
        ActualPickupDateType aObj = getActualPickupDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ActualPickupDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualPickupDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getActualPickupDateValueLocal() {
        ActualPickupDateType aObj = getActualPickupDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ActualPickupTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualPickupTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getActualPickupTimeValue() {
        ActualPickupTimeType aObj = getActualPickupTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ActualPickupTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActualPickupTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getActualPickupTimeValueLocal() {
        ActualPickupTimeType aObj = getActualPickupTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained EarliestPickupDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EarliestPickupDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getEarliestPickupDateValue() {
        EarliestPickupDateType aObj = getEarliestPickupDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EarliestPickupDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EarliestPickupDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getEarliestPickupDateValueLocal() {
        EarliestPickupDateType aObj = getEarliestPickupDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained EarliestPickupTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EarliestPickupTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getEarliestPickupTimeValue() {
        EarliestPickupTimeType aObj = getEarliestPickupTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EarliestPickupTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EarliestPickupTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getEarliestPickupTimeValueLocal() {
        EarliestPickupTimeType aObj = getEarliestPickupTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained LatestPickupDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestPickupDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getLatestPickupDateValue() {
        LatestPickupDateType aObj = getLatestPickupDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatestPickupDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestPickupDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getLatestPickupDateValueLocal() {
        LatestPickupDateType aObj = getLatestPickupDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained LatestPickupTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestPickupTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getLatestPickupTimeValue() {
        LatestPickupTimeType aObj = getLatestPickupTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatestPickupTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestPickupTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getLatestPickupTimeValueLocal() {
        LatestPickupTimeType aObj = getLatestPickupTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
