
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.BusinessClassificationEvidenceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.BusinessIdentityEvidenceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EmployeeQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.OperatingYearsQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ParticipationPercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PersonalSituationType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TendererRoleCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for QualifyingPartyType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="QualifyingPartyType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ParticipationPercent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PersonalSituation" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OperatingYearsQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EmployeeQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BusinessClassificationEvidenceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BusinessIdentityEvidenceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TendererRoleCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}BusinessClassificationScheme" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TechnicalCapability" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FinancialCapability" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CompletedTask" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Declaration" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Party" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EconomicOperatorRole" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "QualifyingPartyType", propOrder = {
    "ublExtensions",
    "participationPercent",
    "personalSituation",
    "operatingYearsQuantity",
    "employeeQuantity",
    "businessClassificationEvidenceID",
    "businessIdentityEvidenceID",
    "tendererRoleCode",
    "businessClassificationScheme",
    "technicalCapability",
    "financialCapability",
    "completedTask",
    "declaration",
    "party",
    "economicOperatorRole"
})
@CodingStyleguideUnaware
public class QualifyingPartyType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ParticipationPercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ParticipationPercentType participationPercent;
    @XmlElement(name = "PersonalSituation", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PersonalSituationType> personalSituation;
    @XmlElement(name = "OperatingYearsQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OperatingYearsQuantityType operatingYearsQuantity;
    @XmlElement(name = "EmployeeQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EmployeeQuantityType employeeQuantity;
    @XmlElement(name = "BusinessClassificationEvidenceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private BusinessClassificationEvidenceIDType businessClassificationEvidenceID;
    @XmlElement(name = "BusinessIdentityEvidenceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private BusinessIdentityEvidenceIDType businessIdentityEvidenceID;
    @XmlElement(name = "TendererRoleCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TendererRoleCodeType tendererRoleCode;
    @XmlElement(name = "BusinessClassificationScheme")
    private ClassificationSchemeType businessClassificationScheme;
    @XmlElement(name = "TechnicalCapability")
    private List<CapabilityType> technicalCapability;
    @XmlElement(name = "FinancialCapability")
    private List<CapabilityType> financialCapability;
    @XmlElement(name = "CompletedTask")
    private List<CompletedTaskType> completedTask;
    @XmlElement(name = "Declaration")
    private List<DeclarationType> declaration;
    @XmlElement(name = "Party")
    private PartyType party;
    @XmlElement(name = "EconomicOperatorRole")
    private EconomicOperatorRoleType economicOperatorRole;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public QualifyingPartyType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the participationPercent property.
     * 
     * @return
     *     possible object is
     *     {@link ParticipationPercentType }
     *     
     */
    @Nullable
    public ParticipationPercentType getParticipationPercent() {
        return participationPercent;
    }

    /**
     * Sets the value of the participationPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link ParticipationPercentType }
     *     
     */
    public void setParticipationPercent(
        @Nullable
        ParticipationPercentType value) {
        this.participationPercent = value;
    }

    /**
     * Gets the value of the personalSituation property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personalSituation property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPersonalSituation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonalSituationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the personalSituation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonalSituationType> getPersonalSituation() {
        if (personalSituation == null) {
            personalSituation = new ArrayList<>();
        }
        return this.personalSituation;
    }

    /**
     * Gets the value of the operatingYearsQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link OperatingYearsQuantityType }
     *     
     */
    @Nullable
    public OperatingYearsQuantityType getOperatingYearsQuantity() {
        return operatingYearsQuantity;
    }

    /**
     * Sets the value of the operatingYearsQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link OperatingYearsQuantityType }
     *     
     */
    public void setOperatingYearsQuantity(
        @Nullable
        OperatingYearsQuantityType value) {
        this.operatingYearsQuantity = value;
    }

    /**
     * Gets the value of the employeeQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link EmployeeQuantityType }
     *     
     */
    @Nullable
    public EmployeeQuantityType getEmployeeQuantity() {
        return employeeQuantity;
    }

    /**
     * Sets the value of the employeeQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmployeeQuantityType }
     *     
     */
    public void setEmployeeQuantity(
        @Nullable
        EmployeeQuantityType value) {
        this.employeeQuantity = value;
    }

    /**
     * Gets the value of the businessClassificationEvidenceID property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessClassificationEvidenceIDType }
     *     
     */
    @Nullable
    public BusinessClassificationEvidenceIDType getBusinessClassificationEvidenceID() {
        return businessClassificationEvidenceID;
    }

    /**
     * Sets the value of the businessClassificationEvidenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessClassificationEvidenceIDType }
     *     
     */
    public void setBusinessClassificationEvidenceID(
        @Nullable
        BusinessClassificationEvidenceIDType value) {
        this.businessClassificationEvidenceID = value;
    }

    /**
     * Gets the value of the businessIdentityEvidenceID property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessIdentityEvidenceIDType }
     *     
     */
    @Nullable
    public BusinessIdentityEvidenceIDType getBusinessIdentityEvidenceID() {
        return businessIdentityEvidenceID;
    }

    /**
     * Sets the value of the businessIdentityEvidenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessIdentityEvidenceIDType }
     *     
     */
    public void setBusinessIdentityEvidenceID(
        @Nullable
        BusinessIdentityEvidenceIDType value) {
        this.businessIdentityEvidenceID = value;
    }

    /**
     * Gets the value of the tendererRoleCode property.
     * 
     * @return
     *     possible object is
     *     {@link TendererRoleCodeType }
     *     
     */
    @Nullable
    public TendererRoleCodeType getTendererRoleCode() {
        return tendererRoleCode;
    }

    /**
     * Sets the value of the tendererRoleCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TendererRoleCodeType }
     *     
     */
    public void setTendererRoleCode(
        @Nullable
        TendererRoleCodeType value) {
        this.tendererRoleCode = value;
    }

    /**
     * Gets the value of the businessClassificationScheme property.
     * 
     * @return
     *     possible object is
     *     {@link ClassificationSchemeType }
     *     
     */
    @Nullable
    public ClassificationSchemeType getBusinessClassificationScheme() {
        return businessClassificationScheme;
    }

    /**
     * Sets the value of the businessClassificationScheme property.
     * 
     * @param value
     *     allowed object is
     *     {@link ClassificationSchemeType }
     *     
     */
    public void setBusinessClassificationScheme(
        @Nullable
        ClassificationSchemeType value) {
        this.businessClassificationScheme = value;
    }

    /**
     * Gets the value of the technicalCapability property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the technicalCapability property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTechnicalCapability().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CapabilityType }
     * </p>
     * 
     * 
     * @return
     *     The value of the technicalCapability property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CapabilityType> getTechnicalCapability() {
        if (technicalCapability == null) {
            technicalCapability = new ArrayList<>();
        }
        return this.technicalCapability;
    }

    /**
     * Gets the value of the financialCapability property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the financialCapability property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFinancialCapability().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CapabilityType }
     * </p>
     * 
     * 
     * @return
     *     The value of the financialCapability property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CapabilityType> getFinancialCapability() {
        if (financialCapability == null) {
            financialCapability = new ArrayList<>();
        }
        return this.financialCapability;
    }

    /**
     * Gets the value of the completedTask property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the completedTask property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCompletedTask().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CompletedTaskType }
     * </p>
     * 
     * 
     * @return
     *     The value of the completedTask property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CompletedTaskType> getCompletedTask() {
        if (completedTask == null) {
            completedTask = new ArrayList<>();
        }
        return this.completedTask;
    }

    /**
     * Gets the value of the declaration property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the declaration property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDeclaration().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DeclarationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the declaration property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DeclarationType> getDeclaration() {
        if (declaration == null) {
            declaration = new ArrayList<>();
        }
        return this.declaration;
    }

    /**
     * Gets the value of the party property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getParty() {
        return party;
    }

    /**
     * Sets the value of the party property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setParty(
        @Nullable
        PartyType value) {
        this.party = value;
    }

    /**
     * Gets the value of the economicOperatorRole property.
     * 
     * @return
     *     possible object is
     *     {@link EconomicOperatorRoleType }
     *     
     */
    @Nullable
    public EconomicOperatorRoleType getEconomicOperatorRole() {
        return economicOperatorRole;
    }

    /**
     * Sets the value of the economicOperatorRole property.
     * 
     * @param value
     *     allowed object is
     *     {@link EconomicOperatorRoleType }
     *     
     */
    public void setEconomicOperatorRole(
        @Nullable
        EconomicOperatorRoleType value) {
        this.economicOperatorRole = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final QualifyingPartyType rhs = ((QualifyingPartyType) o);
        if (!EqualsHelper.equals(businessClassificationEvidenceID, rhs.businessClassificationEvidenceID)) {
            return false;
        }
        if (!EqualsHelper.equals(businessClassificationScheme, rhs.businessClassificationScheme)) {
            return false;
        }
        if (!EqualsHelper.equals(businessIdentityEvidenceID, rhs.businessIdentityEvidenceID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(completedTask, rhs.completedTask)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(declaration, rhs.declaration)) {
            return false;
        }
        if (!EqualsHelper.equals(economicOperatorRole, rhs.economicOperatorRole)) {
            return false;
        }
        if (!EqualsHelper.equals(employeeQuantity, rhs.employeeQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(financialCapability, rhs.financialCapability)) {
            return false;
        }
        if (!EqualsHelper.equals(operatingYearsQuantity, rhs.operatingYearsQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(participationPercent, rhs.participationPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(party, rhs.party)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personalSituation, rhs.personalSituation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(technicalCapability, rhs.technicalCapability)) {
            return false;
        }
        if (!EqualsHelper.equals(tendererRoleCode, rhs.tendererRoleCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(businessClassificationEvidenceID).append(businessClassificationScheme).append(businessIdentityEvidenceID).append(completedTask).append(declaration).append(economicOperatorRole).append(employeeQuantity).append(financialCapability).append(operatingYearsQuantity).append(participationPercent).append(party).append(personalSituation).append(technicalCapability).append(tendererRoleCode).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("businessClassificationEvidenceID", businessClassificationEvidenceID).append("businessClassificationScheme", businessClassificationScheme).append("businessIdentityEvidenceID", businessIdentityEvidenceID).append("completedTask", completedTask).append("declaration", declaration).append("economicOperatorRole", economicOperatorRole).append("employeeQuantity", employeeQuantity).append("financialCapability", financialCapability).append("operatingYearsQuantity", operatingYearsQuantity).append("participationPercent", participationPercent).append("party", party).append("personalSituation", personalSituation).append("technicalCapability", technicalCapability).append("tendererRoleCode", tendererRoleCode).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonalSituation(
        @Nullable
        final List<PersonalSituationType> aList) {
        personalSituation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTechnicalCapability(
        @Nullable
        final List<CapabilityType> aList) {
        technicalCapability = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFinancialCapability(
        @Nullable
        final List<CapabilityType> aList) {
        financialCapability = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCompletedTask(
        @Nullable
        final List<CompletedTaskType> aList) {
        completedTask = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDeclaration(
        @Nullable
        final List<DeclarationType> aList) {
        declaration = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonalSituationEntries() {
        return (!getPersonalSituation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonalSituationEntries() {
        return getPersonalSituation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonalSituationCount() {
        return getPersonalSituation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonalSituationType getPersonalSituationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonalSituation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonalSituation(
        @Nonnull
        final PersonalSituationType elem) {
        getPersonalSituation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTechnicalCapabilityEntries() {
        return (!getTechnicalCapability().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTechnicalCapabilityEntries() {
        return getTechnicalCapability().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTechnicalCapabilityCount() {
        return getTechnicalCapability().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CapabilityType getTechnicalCapabilityAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTechnicalCapability().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTechnicalCapability(
        @Nonnull
        final CapabilityType elem) {
        getTechnicalCapability().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFinancialCapabilityEntries() {
        return (!getFinancialCapability().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFinancialCapabilityEntries() {
        return getFinancialCapability().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFinancialCapabilityCount() {
        return getFinancialCapability().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CapabilityType getFinancialCapabilityAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFinancialCapability().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFinancialCapability(
        @Nonnull
        final CapabilityType elem) {
        getFinancialCapability().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCompletedTaskEntries() {
        return (!getCompletedTask().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCompletedTaskEntries() {
        return getCompletedTask().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCompletedTaskCount() {
        return getCompletedTask().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CompletedTaskType getCompletedTaskAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCompletedTask().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCompletedTask(
        @Nonnull
        final CompletedTaskType elem) {
        getCompletedTask().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDeclarationEntries() {
        return (!getDeclaration().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDeclarationEntries() {
        return getDeclaration().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDeclarationCount() {
        return getDeclaration().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DeclarationType getDeclarationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDeclaration().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDeclaration(
        @Nonnull
        final DeclarationType elem) {
        getDeclaration().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        QualifyingPartyType ret) {
        ret.businessClassificationEvidenceID = ((businessClassificationEvidenceID == null)?null:businessClassificationEvidenceID.clone());
        ret.businessClassificationScheme = ((businessClassificationScheme == null)?null:businessClassificationScheme.clone());
        ret.businessIdentityEvidenceID = ((businessIdentityEvidenceID == null)?null:businessIdentityEvidenceID.clone());
        if (completedTask == null) {
            ret.completedTask = null;
        } else {
            List<CompletedTaskType> retCompletedTask = new ArrayList<>();
            for (CompletedTaskType aItem: getCompletedTask()) {
                retCompletedTask.add(((aItem == null)?null:aItem.clone()));
            }
            ret.completedTask = retCompletedTask;
        }
        if (declaration == null) {
            ret.declaration = null;
        } else {
            List<DeclarationType> retDeclaration = new ArrayList<>();
            for (DeclarationType aItem: getDeclaration()) {
                retDeclaration.add(((aItem == null)?null:aItem.clone()));
            }
            ret.declaration = retDeclaration;
        }
        ret.economicOperatorRole = ((economicOperatorRole == null)?null:economicOperatorRole.clone());
        ret.employeeQuantity = ((employeeQuantity == null)?null:employeeQuantity.clone());
        if (financialCapability == null) {
            ret.financialCapability = null;
        } else {
            List<CapabilityType> retFinancialCapability = new ArrayList<>();
            for (CapabilityType aItem: getFinancialCapability()) {
                retFinancialCapability.add(((aItem == null)?null:aItem.clone()));
            }
            ret.financialCapability = retFinancialCapability;
        }
        ret.operatingYearsQuantity = ((operatingYearsQuantity == null)?null:operatingYearsQuantity.clone());
        ret.participationPercent = ((participationPercent == null)?null:participationPercent.clone());
        ret.party = ((party == null)?null:party.clone());
        if (personalSituation == null) {
            ret.personalSituation = null;
        } else {
            List<PersonalSituationType> retPersonalSituation = new ArrayList<>();
            for (PersonalSituationType aItem: getPersonalSituation()) {
                retPersonalSituation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personalSituation = retPersonalSituation;
        }
        if (technicalCapability == null) {
            ret.technicalCapability = null;
        } else {
            List<CapabilityType> retTechnicalCapability = new ArrayList<>();
            for (CapabilityType aItem: getTechnicalCapability()) {
                retTechnicalCapability.add(((aItem == null)?null:aItem.clone()));
            }
            ret.technicalCapability = retTechnicalCapability;
        }
        ret.tendererRoleCode = ((tendererRoleCode == null)?null:tendererRoleCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public QualifyingPartyType clone() {
        QualifyingPartyType ret = new QualifyingPartyType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ParticipationPercentType and never <code>null</code>
     */
    @Nonnull
    public ParticipationPercentType setParticipationPercent(
        @Nullable
        final BigDecimal valueParam) {
        ParticipationPercentType aObj = getParticipationPercent();
        if (aObj == null) {
            aObj = new ParticipationPercentType(valueParam);
            setParticipationPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OperatingYearsQuantityType and never <code>null</code>
     */
    @Nonnull
    public OperatingYearsQuantityType setOperatingYearsQuantity(
        @Nullable
        final BigDecimal valueParam) {
        OperatingYearsQuantityType aObj = getOperatingYearsQuantity();
        if (aObj == null) {
            aObj = new OperatingYearsQuantityType(valueParam);
            setOperatingYearsQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EmployeeQuantityType and never <code>null</code>
     */
    @Nonnull
    public EmployeeQuantityType setEmployeeQuantity(
        @Nullable
        final BigDecimal valueParam) {
        EmployeeQuantityType aObj = getEmployeeQuantity();
        if (aObj == null) {
            aObj = new EmployeeQuantityType(valueParam);
            setEmployeeQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BusinessClassificationEvidenceIDType and never <code>null</code>
     */
    @Nonnull
    public BusinessClassificationEvidenceIDType setBusinessClassificationEvidenceID(
        @Nullable
        final String valueParam) {
        BusinessClassificationEvidenceIDType aObj = getBusinessClassificationEvidenceID();
        if (aObj == null) {
            aObj = new BusinessClassificationEvidenceIDType(valueParam);
            setBusinessClassificationEvidenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BusinessIdentityEvidenceIDType and never <code>null</code>
     */
    @Nonnull
    public BusinessIdentityEvidenceIDType setBusinessIdentityEvidenceID(
        @Nullable
        final String valueParam) {
        BusinessIdentityEvidenceIDType aObj = getBusinessIdentityEvidenceID();
        if (aObj == null) {
            aObj = new BusinessIdentityEvidenceIDType(valueParam);
            setBusinessIdentityEvidenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TendererRoleCodeType and never <code>null</code>
     */
    @Nonnull
    public TendererRoleCodeType setTendererRoleCode(
        @Nullable
        final String valueParam) {
        TendererRoleCodeType aObj = getTendererRoleCode();
        if (aObj == null) {
            aObj = new TendererRoleCodeType(valueParam);
            setTendererRoleCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ParticipationPercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ParticipationPercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getParticipationPercentValue() {
        ParticipationPercentType aObj = getParticipationPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OperatingYearsQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OperatingYearsQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getOperatingYearsQuantityValue() {
        OperatingYearsQuantityType aObj = getOperatingYearsQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EmployeeQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EmployeeQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getEmployeeQuantityValue() {
        EmployeeQuantityType aObj = getEmployeeQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained BusinessClassificationEvidenceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BusinessClassificationEvidenceIDType object or <code>null</code>
     */
    @Nullable
    public String getBusinessClassificationEvidenceIDValue() {
        BusinessClassificationEvidenceIDType aObj = getBusinessClassificationEvidenceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained BusinessIdentityEvidenceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BusinessIdentityEvidenceIDType object or <code>null</code>
     */
    @Nullable
    public String getBusinessIdentityEvidenceIDValue() {
        BusinessIdentityEvidenceIDType aObj = getBusinessIdentityEvidenceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TendererRoleCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TendererRoleCodeType object or <code>null</code>
     */
    @Nullable
    public String getTendererRoleCodeValue() {
        TendererRoleCodeType aObj = getTendererRoleCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
