
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseBinaryObjectType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ResponseURIType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for ResponseValueType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ResponseValueType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Response" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseBinaryObject" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ResponseURI" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ResponseValueType", propOrder = {
    "ublExtensions",
    "id",
    "description",
    "response",
    "responseAmount",
    "responseBinaryObject",
    "responseCode",
    "responseDate",
    "responseID",
    "responseIndicator",
    "responseMeasure",
    "responseNumeric",
    "responseQuantity",
    "responseTime",
    "responseURI"
})
@CodingStyleguideUnaware
public class ResponseValueType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "Response", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ResponseType> response;
    @XmlElement(name = "ResponseAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseAmountType responseAmount;
    @XmlElement(name = "ResponseBinaryObject", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseBinaryObjectType responseBinaryObject;
    @XmlElement(name = "ResponseCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseCodeType responseCode;
    @XmlElement(name = "ResponseDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseDateType responseDate;
    @XmlElement(name = "ResponseID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseIDType responseID;
    @XmlElement(name = "ResponseIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseIndicatorType responseIndicator;
    @XmlElement(name = "ResponseMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseMeasureType responseMeasure;
    @XmlElement(name = "ResponseNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseNumericType responseNumeric;
    @XmlElement(name = "ResponseQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseQuantityType responseQuantity;
    @XmlElement(name = "ResponseTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseTimeType responseTime;
    @XmlElement(name = "ResponseURI", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ResponseURIType responseURI;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ResponseValueType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the response property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the response property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getResponse().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResponseType }
     * </p>
     * 
     * 
     * @return
     *     The value of the response property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ResponseType> getResponse() {
        if (response == null) {
            response = new ArrayList<>();
        }
        return this.response;
    }

    /**
     * Gets the value of the responseAmount property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseAmountType }
     *     
     */
    @Nullable
    public ResponseAmountType getResponseAmount() {
        return responseAmount;
    }

    /**
     * Sets the value of the responseAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseAmountType }
     *     
     */
    public void setResponseAmount(
        @Nullable
        ResponseAmountType value) {
        this.responseAmount = value;
    }

    /**
     * Gets the value of the responseBinaryObject property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseBinaryObjectType }
     *     
     */
    @Nullable
    public ResponseBinaryObjectType getResponseBinaryObject() {
        return responseBinaryObject;
    }

    /**
     * Sets the value of the responseBinaryObject property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseBinaryObjectType }
     *     
     */
    public void setResponseBinaryObject(
        @Nullable
        ResponseBinaryObjectType value) {
        this.responseBinaryObject = value;
    }

    /**
     * Gets the value of the responseCode property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseCodeType }
     *     
     */
    @Nullable
    public ResponseCodeType getResponseCode() {
        return responseCode;
    }

    /**
     * Sets the value of the responseCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseCodeType }
     *     
     */
    public void setResponseCode(
        @Nullable
        ResponseCodeType value) {
        this.responseCode = value;
    }

    /**
     * Gets the value of the responseDate property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseDateType }
     *     
     */
    @Nullable
    public ResponseDateType getResponseDate() {
        return responseDate;
    }

    /**
     * Sets the value of the responseDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseDateType }
     *     
     */
    public void setResponseDate(
        @Nullable
        ResponseDateType value) {
        this.responseDate = value;
    }

    /**
     * Gets the value of the responseID property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseIDType }
     *     
     */
    @Nullable
    public ResponseIDType getResponseID() {
        return responseID;
    }

    /**
     * Sets the value of the responseID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseIDType }
     *     
     */
    public void setResponseID(
        @Nullable
        ResponseIDType value) {
        this.responseID = value;
    }

    /**
     * Gets the value of the responseIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseIndicatorType }
     *     
     */
    @Nullable
    public ResponseIndicatorType getResponseIndicator() {
        return responseIndicator;
    }

    /**
     * Sets the value of the responseIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseIndicatorType }
     *     
     */
    public void setResponseIndicator(
        @Nullable
        ResponseIndicatorType value) {
        this.responseIndicator = value;
    }

    /**
     * Gets the value of the responseMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseMeasureType }
     *     
     */
    @Nullable
    public ResponseMeasureType getResponseMeasure() {
        return responseMeasure;
    }

    /**
     * Sets the value of the responseMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseMeasureType }
     *     
     */
    public void setResponseMeasure(
        @Nullable
        ResponseMeasureType value) {
        this.responseMeasure = value;
    }

    /**
     * Gets the value of the responseNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseNumericType }
     *     
     */
    @Nullable
    public ResponseNumericType getResponseNumeric() {
        return responseNumeric;
    }

    /**
     * Sets the value of the responseNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseNumericType }
     *     
     */
    public void setResponseNumeric(
        @Nullable
        ResponseNumericType value) {
        this.responseNumeric = value;
    }

    /**
     * Gets the value of the responseQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseQuantityType }
     *     
     */
    @Nullable
    public ResponseQuantityType getResponseQuantity() {
        return responseQuantity;
    }

    /**
     * Sets the value of the responseQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseQuantityType }
     *     
     */
    public void setResponseQuantity(
        @Nullable
        ResponseQuantityType value) {
        this.responseQuantity = value;
    }

    /**
     * Gets the value of the responseTime property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseTimeType }
     *     
     */
    @Nullable
    public ResponseTimeType getResponseTime() {
        return responseTime;
    }

    /**
     * Sets the value of the responseTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseTimeType }
     *     
     */
    public void setResponseTime(
        @Nullable
        ResponseTimeType value) {
        this.responseTime = value;
    }

    /**
     * Gets the value of the responseURI property.
     * 
     * @return
     *     possible object is
     *     {@link ResponseURIType }
     *     
     */
    @Nullable
    public ResponseURIType getResponseURI() {
        return responseURI;
    }

    /**
     * Sets the value of the responseURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponseURIType }
     *     
     */
    public void setResponseURI(
        @Nullable
        ResponseURIType value) {
        this.responseURI = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ResponseValueType rhs = ((ResponseValueType) o);
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(response, rhs.response)) {
            return false;
        }
        if (!EqualsHelper.equals(responseAmount, rhs.responseAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(responseBinaryObject, rhs.responseBinaryObject)) {
            return false;
        }
        if (!EqualsHelper.equals(responseCode, rhs.responseCode)) {
            return false;
        }
        if (!EqualsHelper.equals(responseDate, rhs.responseDate)) {
            return false;
        }
        if (!EqualsHelper.equals(responseID, rhs.responseID)) {
            return false;
        }
        if (!EqualsHelper.equals(responseIndicator, rhs.responseIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(responseMeasure, rhs.responseMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(responseNumeric, rhs.responseNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(responseQuantity, rhs.responseQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(responseTime, rhs.responseTime)) {
            return false;
        }
        if (!EqualsHelper.equals(responseURI, rhs.responseURI)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(description).append(id).append(response).append(responseAmount).append(responseBinaryObject).append(responseCode).append(responseDate).append(responseID).append(responseIndicator).append(responseMeasure).append(responseNumeric).append(responseQuantity).append(responseTime).append(responseURI).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("description", description).append("id", id).append("response", response).append("responseAmount", responseAmount).append("responseBinaryObject", responseBinaryObject).append("responseCode", responseCode).append("responseDate", responseDate).append("responseID", responseID).append("responseIndicator", responseIndicator).append("responseMeasure", responseMeasure).append("responseNumeric", responseNumeric).append("responseQuantity", responseQuantity).append("responseTime", responseTime).append("responseURI", responseURI).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setResponse(
        @Nullable
        final List<ResponseType> aList) {
        response = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasResponseEntries() {
        return (!getResponse().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoResponseEntries() {
        return getResponse().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getResponseCount() {
        return getResponse().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ResponseType getResponseAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getResponse().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addResponse(
        @Nonnull
        final ResponseType elem) {
        getResponse().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ResponseValueType ret) {
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.id = ((id == null)?null:id.clone());
        if (response == null) {
            ret.response = null;
        } else {
            List<ResponseType> retResponse = new ArrayList<>();
            for (ResponseType aItem: getResponse()) {
                retResponse.add(((aItem == null)?null:aItem.clone()));
            }
            ret.response = retResponse;
        }
        ret.responseAmount = ((responseAmount == null)?null:responseAmount.clone());
        ret.responseBinaryObject = ((responseBinaryObject == null)?null:responseBinaryObject.clone());
        ret.responseCode = ((responseCode == null)?null:responseCode.clone());
        ret.responseDate = ((responseDate == null)?null:responseDate.clone());
        ret.responseID = ((responseID == null)?null:responseID.clone());
        ret.responseIndicator = ((responseIndicator == null)?null:responseIndicator.clone());
        ret.responseMeasure = ((responseMeasure == null)?null:responseMeasure.clone());
        ret.responseNumeric = ((responseNumeric == null)?null:responseNumeric.clone());
        ret.responseQuantity = ((responseQuantity == null)?null:responseQuantity.clone());
        ret.responseTime = ((responseTime == null)?null:responseTime.clone());
        ret.responseURI = ((responseURI == null)?null:responseURI.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ResponseValueType clone() {
        ResponseValueType ret = new ResponseValueType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseAmountType and never <code>null</code>
     */
    @Nonnull
    public ResponseAmountType setResponseAmount(
        @Nullable
        final BigDecimal valueParam) {
        ResponseAmountType aObj = getResponseAmount();
        if (aObj == null) {
            aObj = new ResponseAmountType(valueParam);
            setResponseAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseBinaryObjectType and never <code>null</code>
     */
    @Nonnull
    public ResponseBinaryObjectType setResponseBinaryObject(
        @Nullable
        final byte[] valueParam) {
        ResponseBinaryObjectType aObj = getResponseBinaryObject();
        if (aObj == null) {
            aObj = new ResponseBinaryObjectType(valueParam);
            setResponseBinaryObject(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseCodeType and never <code>null</code>
     */
    @Nonnull
    public ResponseCodeType setResponseCode(
        @Nullable
        final String valueParam) {
        ResponseCodeType aObj = getResponseCode();
        if (aObj == null) {
            aObj = new ResponseCodeType(valueParam);
            setResponseCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseDateType and never <code>null</code>
     */
    @Nonnull
    public ResponseDateType setResponseDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ResponseDateType aObj = getResponseDate();
        if (aObj == null) {
            aObj = new ResponseDateType(valueParam);
            setResponseDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseDateType and never <code>null</code>
     */
    @Nonnull
    public ResponseDateType setResponseDate(
        @Nullable
        final LocalDate valueParam) {
        ResponseDateType aObj = getResponseDate();
        if (aObj == null) {
            aObj = new ResponseDateType(valueParam);
            setResponseDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseIDType and never <code>null</code>
     */
    @Nonnull
    public ResponseIDType setResponseID(
        @Nullable
        final String valueParam) {
        ResponseIDType aObj = getResponseID();
        if (aObj == null) {
            aObj = new ResponseIDType(valueParam);
            setResponseID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ResponseIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ResponseIndicatorType setResponseIndicator(final boolean valueParam) {
        ResponseIndicatorType aObj = getResponseIndicator();
        if (aObj == null) {
            aObj = new ResponseIndicatorType(valueParam);
            setResponseIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseMeasureType and never <code>null</code>
     */
    @Nonnull
    public ResponseMeasureType setResponseMeasure(
        @Nullable
        final BigDecimal valueParam) {
        ResponseMeasureType aObj = getResponseMeasure();
        if (aObj == null) {
            aObj = new ResponseMeasureType(valueParam);
            setResponseMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseNumericType and never <code>null</code>
     */
    @Nonnull
    public ResponseNumericType setResponseNumeric(
        @Nullable
        final BigDecimal valueParam) {
        ResponseNumericType aObj = getResponseNumeric();
        if (aObj == null) {
            aObj = new ResponseNumericType(valueParam);
            setResponseNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseQuantityType and never <code>null</code>
     */
    @Nonnull
    public ResponseQuantityType setResponseQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ResponseQuantityType aObj = getResponseQuantity();
        if (aObj == null) {
            aObj = new ResponseQuantityType(valueParam);
            setResponseQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseTimeType and never <code>null</code>
     */
    @Nonnull
    public ResponseTimeType setResponseTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        ResponseTimeType aObj = getResponseTime();
        if (aObj == null) {
            aObj = new ResponseTimeType(valueParam);
            setResponseTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseTimeType and never <code>null</code>
     */
    @Nonnull
    public ResponseTimeType setResponseTime(
        @Nullable
        final LocalTime valueParam) {
        ResponseTimeType aObj = getResponseTime();
        if (aObj == null) {
            aObj = new ResponseTimeType(valueParam);
            setResponseTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ResponseURIType and never <code>null</code>
     */
    @Nonnull
    public ResponseURIType setResponseURI(
        @Nullable
        final String valueParam) {
        ResponseURIType aObj = getResponseURI();
        if (aObj == null) {
            aObj = new ResponseURIType(valueParam);
            setResponseURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getResponseAmountValue() {
        ResponseAmountType aObj = getResponseAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseBinaryObjectType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseBinaryObjectType object or <code>null</code>
     */
    @Nullable
    public byte[] getResponseBinaryObjectValue() {
        ResponseBinaryObjectType aObj = getResponseBinaryObject();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseCodeType object or <code>null</code>
     */
    @Nullable
    public String getResponseCodeValue() {
        ResponseCodeType aObj = getResponseCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getResponseDateValue() {
        ResponseDateType aObj = getResponseDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getResponseDateValueLocal() {
        ResponseDateType aObj = getResponseDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ResponseIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseIDType object or <code>null</code>
     */
    @Nullable
    public String getResponseIDValue() {
        ResponseIDType aObj = getResponseID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ResponseIndicatorType object or the passed nullValue
     */
    public boolean isResponseIndicatorValue(final boolean nullValue) {
        ResponseIndicatorType aObj = getResponseIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ResponseMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getResponseMeasureValue() {
        ResponseMeasureType aObj = getResponseMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getResponseNumericValue() {
        ResponseNumericType aObj = getResponseNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getResponseQuantityValue() {
        ResponseQuantityType aObj = getResponseQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getResponseTimeValue() {
        ResponseTimeType aObj = getResponseTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ResponseTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getResponseTimeValueLocal() {
        ResponseTimeType aObj = getResponseTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ResponseURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ResponseURIType object or <code>null</code>
     */
    @Nullable
    public String getResponseURIValue() {
        ResponseURIType aObj = getResponseURI();
        return (aObj == null)?null:aObj.getValue();
    }

}
