
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EmergencyProceduresCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ExtensionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PlacardEndorsementType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PlacardNotationType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for SecondaryHazardType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SecondaryHazardType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PlacardNotation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PlacardEndorsement" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EmergencyProceduresCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SecondaryHazardType", propOrder = {
    "ublExtensions",
    "id",
    "placardNotation",
    "placardEndorsement",
    "emergencyProceduresCode",
    "extension"
})
@CodingStyleguideUnaware
public class SecondaryHazardType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "PlacardNotation", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PlacardNotationType placardNotation;
    @XmlElement(name = "PlacardEndorsement", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PlacardEndorsementType placardEndorsement;
    @XmlElement(name = "EmergencyProceduresCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EmergencyProceduresCodeType emergencyProceduresCode;
    @XmlElement(name = "Extension", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ExtensionType> extension;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SecondaryHazardType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the placardNotation property.
     * 
     * @return
     *     possible object is
     *     {@link PlacardNotationType }
     *     
     */
    @Nullable
    public PlacardNotationType getPlacardNotation() {
        return placardNotation;
    }

    /**
     * Sets the value of the placardNotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link PlacardNotationType }
     *     
     */
    public void setPlacardNotation(
        @Nullable
        PlacardNotationType value) {
        this.placardNotation = value;
    }

    /**
     * Gets the value of the placardEndorsement property.
     * 
     * @return
     *     possible object is
     *     {@link PlacardEndorsementType }
     *     
     */
    @Nullable
    public PlacardEndorsementType getPlacardEndorsement() {
        return placardEndorsement;
    }

    /**
     * Sets the value of the placardEndorsement property.
     * 
     * @param value
     *     allowed object is
     *     {@link PlacardEndorsementType }
     *     
     */
    public void setPlacardEndorsement(
        @Nullable
        PlacardEndorsementType value) {
        this.placardEndorsement = value;
    }

    /**
     * Gets the value of the emergencyProceduresCode property.
     * 
     * @return
     *     possible object is
     *     {@link EmergencyProceduresCodeType }
     *     
     */
    @Nullable
    public EmergencyProceduresCodeType getEmergencyProceduresCode() {
        return emergencyProceduresCode;
    }

    /**
     * Sets the value of the emergencyProceduresCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmergencyProceduresCodeType }
     *     
     */
    public void setEmergencyProceduresCode(
        @Nullable
        EmergencyProceduresCodeType value) {
        this.emergencyProceduresCode = value;
    }

    /**
     * Gets the value of the extension property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extension property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getExtension().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExtensionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the extension property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ExtensionType> getExtension() {
        if (extension == null) {
            extension = new ArrayList<>();
        }
        return this.extension;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SecondaryHazardType rhs = ((SecondaryHazardType) o);
        if (!EqualsHelper.equals(emergencyProceduresCode, rhs.emergencyProceduresCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(extension, rhs.extension)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(placardEndorsement, rhs.placardEndorsement)) {
            return false;
        }
        if (!EqualsHelper.equals(placardNotation, rhs.placardNotation)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(emergencyProceduresCode).append(extension).append(id).append(placardEndorsement).append(placardNotation).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("emergencyProceduresCode", emergencyProceduresCode).append("extension", extension).append("id", id).append("placardEndorsement", placardEndorsement).append("placardNotation", placardNotation).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExtension(
        @Nullable
        final List<ExtensionType> aList) {
        extension = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExtensionEntries() {
        return (!getExtension().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExtensionEntries() {
        return getExtension().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExtensionCount() {
        return getExtension().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ExtensionType getExtensionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExtension().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExtension(
        @Nonnull
        final ExtensionType elem) {
        getExtension().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SecondaryHazardType ret) {
        ret.emergencyProceduresCode = ((emergencyProceduresCode == null)?null:emergencyProceduresCode.clone());
        if (extension == null) {
            ret.extension = null;
        } else {
            List<ExtensionType> retExtension = new ArrayList<>();
            for (ExtensionType aItem: getExtension()) {
                retExtension.add(((aItem == null)?null:aItem.clone()));
            }
            ret.extension = retExtension;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.placardEndorsement = ((placardEndorsement == null)?null:placardEndorsement.clone());
        ret.placardNotation = ((placardNotation == null)?null:placardNotation.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SecondaryHazardType clone() {
        SecondaryHazardType ret = new SecondaryHazardType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PlacardNotationType and never <code>null</code>
     */
    @Nonnull
    public PlacardNotationType setPlacardNotation(
        @Nullable
        final String valueParam) {
        PlacardNotationType aObj = getPlacardNotation();
        if (aObj == null) {
            aObj = new PlacardNotationType(valueParam);
            setPlacardNotation(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PlacardEndorsementType and never <code>null</code>
     */
    @Nonnull
    public PlacardEndorsementType setPlacardEndorsement(
        @Nullable
        final String valueParam) {
        PlacardEndorsementType aObj = getPlacardEndorsement();
        if (aObj == null) {
            aObj = new PlacardEndorsementType(valueParam);
            setPlacardEndorsement(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EmergencyProceduresCodeType and never <code>null</code>
     */
    @Nonnull
    public EmergencyProceduresCodeType setEmergencyProceduresCode(
        @Nullable
        final String valueParam) {
        EmergencyProceduresCodeType aObj = getEmergencyProceduresCode();
        if (aObj == null) {
            aObj = new EmergencyProceduresCodeType(valueParam);
            setEmergencyProceduresCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PlacardNotationType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PlacardNotationType object or <code>null</code>
     */
    @Nullable
    public String getPlacardNotationValue() {
        PlacardNotationType aObj = getPlacardNotation();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PlacardEndorsementType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PlacardEndorsementType object or <code>null</code>
     */
    @Nullable
    public String getPlacardEndorsementValue() {
        PlacardEndorsementType aObj = getPlacardEndorsement();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EmergencyProceduresCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EmergencyProceduresCodeType object or <code>null</code>
     */
    @Nullable
    public String getEmergencyProceduresCodeValue() {
        EmergencyProceduresCodeType aObj = getEmergencyProceduresCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
