
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CallBaseAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CallDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CallExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CallTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MovieTitleType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PayPerViewType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.QuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RoamingPartnerNameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ServiceNumberCalledType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TelecommunicationsServiceCallCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TelecommunicationsServiceCallType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TelecommunicationsServiceCategoryCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TelecommunicationsServiceCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for TelecommunicationsServiceType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TelecommunicationsServiceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CallDate"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CallTime"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ServiceNumberCalled"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TelecommunicationsServiceCategory" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TelecommunicationsServiceCategoryCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MovieTitle" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RoamingPartnerName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PayPerView" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Quantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TelecommunicationsServiceCall" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TelecommunicationsServiceCallCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CallBaseAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CallExtensionAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Price" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Country" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ExchangeRate" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AllowanceCharge" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TaxTotal" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CallDuty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TimeDuty" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TelecommunicationsServiceType", propOrder = {
    "ublExtensions",
    "id",
    "callDate",
    "callTime",
    "serviceNumberCalled",
    "telecommunicationsServiceCategory",
    "telecommunicationsServiceCategoryCode",
    "movieTitle",
    "roamingPartnerName",
    "payPerView",
    "quantity",
    "telecommunicationsServiceCall",
    "telecommunicationsServiceCallCode",
    "callBaseAmount",
    "callExtensionAmount",
    "price",
    "country",
    "exchangeRate",
    "allowanceCharge",
    "taxTotal",
    "callDuty",
    "timeDuty"
})
@CodingStyleguideUnaware
public class TelecommunicationsServiceType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "CallDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private CallDateType callDate;
    @XmlElement(name = "CallTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private CallTimeType callTime;
    @XmlElement(name = "ServiceNumberCalled", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private ServiceNumberCalledType serviceNumberCalled;
    @XmlElement(name = "TelecommunicationsServiceCategory", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TelecommunicationsServiceCategoryType telecommunicationsServiceCategory;
    @XmlElement(name = "TelecommunicationsServiceCategoryCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TelecommunicationsServiceCategoryCodeType telecommunicationsServiceCategoryCode;
    @XmlElement(name = "MovieTitle", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MovieTitleType movieTitle;
    @XmlElement(name = "RoamingPartnerName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RoamingPartnerNameType roamingPartnerName;
    @XmlElement(name = "PayPerView", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PayPerViewType payPerView;
    @XmlElement(name = "Quantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private QuantityType quantity;
    @XmlElement(name = "TelecommunicationsServiceCall", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TelecommunicationsServiceCallType telecommunicationsServiceCall;
    @XmlElement(name = "TelecommunicationsServiceCallCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TelecommunicationsServiceCallCodeType telecommunicationsServiceCallCode;
    @XmlElement(name = "CallBaseAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CallBaseAmountType callBaseAmount;
    @XmlElement(name = "CallExtensionAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CallExtensionAmountType callExtensionAmount;
    @XmlElement(name = "Price")
    private PriceType price;
    @XmlElement(name = "Country")
    private CountryType country;
    @XmlElement(name = "ExchangeRate")
    private List<ExchangeRateType> exchangeRate;
    @XmlElement(name = "AllowanceCharge")
    private List<AllowanceChargeType> allowanceCharge;
    @XmlElement(name = "TaxTotal")
    private List<TaxTotalType> taxTotal;
    @XmlElement(name = "CallDuty")
    private List<DutyType> callDuty;
    @XmlElement(name = "TimeDuty")
    private List<DutyType> timeDuty;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TelecommunicationsServiceType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the callDate property.
     * 
     * @return
     *     possible object is
     *     {@link CallDateType }
     *     
     */
    @Nullable
    public CallDateType getCallDate() {
        return callDate;
    }

    /**
     * Sets the value of the callDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CallDateType }
     *     
     */
    public void setCallDate(
        @Nullable
        CallDateType value) {
        this.callDate = value;
    }

    /**
     * Gets the value of the callTime property.
     * 
     * @return
     *     possible object is
     *     {@link CallTimeType }
     *     
     */
    @Nullable
    public CallTimeType getCallTime() {
        return callTime;
    }

    /**
     * Sets the value of the callTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link CallTimeType }
     *     
     */
    public void setCallTime(
        @Nullable
        CallTimeType value) {
        this.callTime = value;
    }

    /**
     * Gets the value of the serviceNumberCalled property.
     * 
     * @return
     *     possible object is
     *     {@link ServiceNumberCalledType }
     *     
     */
    @Nullable
    public ServiceNumberCalledType getServiceNumberCalled() {
        return serviceNumberCalled;
    }

    /**
     * Sets the value of the serviceNumberCalled property.
     * 
     * @param value
     *     allowed object is
     *     {@link ServiceNumberCalledType }
     *     
     */
    public void setServiceNumberCalled(
        @Nullable
        ServiceNumberCalledType value) {
        this.serviceNumberCalled = value;
    }

    /**
     * Gets the value of the telecommunicationsServiceCategory property.
     * 
     * @return
     *     possible object is
     *     {@link TelecommunicationsServiceCategoryType }
     *     
     */
    @Nullable
    public TelecommunicationsServiceCategoryType getTelecommunicationsServiceCategory() {
        return telecommunicationsServiceCategory;
    }

    /**
     * Sets the value of the telecommunicationsServiceCategory property.
     * 
     * @param value
     *     allowed object is
     *     {@link TelecommunicationsServiceCategoryType }
     *     
     */
    public void setTelecommunicationsServiceCategory(
        @Nullable
        TelecommunicationsServiceCategoryType value) {
        this.telecommunicationsServiceCategory = value;
    }

    /**
     * Gets the value of the telecommunicationsServiceCategoryCode property.
     * 
     * @return
     *     possible object is
     *     {@link TelecommunicationsServiceCategoryCodeType }
     *     
     */
    @Nullable
    public TelecommunicationsServiceCategoryCodeType getTelecommunicationsServiceCategoryCode() {
        return telecommunicationsServiceCategoryCode;
    }

    /**
     * Sets the value of the telecommunicationsServiceCategoryCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TelecommunicationsServiceCategoryCodeType }
     *     
     */
    public void setTelecommunicationsServiceCategoryCode(
        @Nullable
        TelecommunicationsServiceCategoryCodeType value) {
        this.telecommunicationsServiceCategoryCode = value;
    }

    /**
     * Gets the value of the movieTitle property.
     * 
     * @return
     *     possible object is
     *     {@link MovieTitleType }
     *     
     */
    @Nullable
    public MovieTitleType getMovieTitle() {
        return movieTitle;
    }

    /**
     * Sets the value of the movieTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link MovieTitleType }
     *     
     */
    public void setMovieTitle(
        @Nullable
        MovieTitleType value) {
        this.movieTitle = value;
    }

    /**
     * Gets the value of the roamingPartnerName property.
     * 
     * @return
     *     possible object is
     *     {@link RoamingPartnerNameType }
     *     
     */
    @Nullable
    public RoamingPartnerNameType getRoamingPartnerName() {
        return roamingPartnerName;
    }

    /**
     * Sets the value of the roamingPartnerName property.
     * 
     * @param value
     *     allowed object is
     *     {@link RoamingPartnerNameType }
     *     
     */
    public void setRoamingPartnerName(
        @Nullable
        RoamingPartnerNameType value) {
        this.roamingPartnerName = value;
    }

    /**
     * Gets the value of the payPerView property.
     * 
     * @return
     *     possible object is
     *     {@link PayPerViewType }
     *     
     */
    @Nullable
    public PayPerViewType getPayPerView() {
        return payPerView;
    }

    /**
     * Sets the value of the payPerView property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayPerViewType }
     *     
     */
    public void setPayPerView(
        @Nullable
        PayPerViewType value) {
        this.payPerView = value;
    }

    /**
     * Gets the value of the quantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getQuantity() {
        return quantity;
    }

    /**
     * Sets the value of the quantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setQuantity(
        @Nullable
        QuantityType value) {
        this.quantity = value;
    }

    /**
     * Gets the value of the telecommunicationsServiceCall property.
     * 
     * @return
     *     possible object is
     *     {@link TelecommunicationsServiceCallType }
     *     
     */
    @Nullable
    public TelecommunicationsServiceCallType getTelecommunicationsServiceCall() {
        return telecommunicationsServiceCall;
    }

    /**
     * Sets the value of the telecommunicationsServiceCall property.
     * 
     * @param value
     *     allowed object is
     *     {@link TelecommunicationsServiceCallType }
     *     
     */
    public void setTelecommunicationsServiceCall(
        @Nullable
        TelecommunicationsServiceCallType value) {
        this.telecommunicationsServiceCall = value;
    }

    /**
     * Gets the value of the telecommunicationsServiceCallCode property.
     * 
     * @return
     *     possible object is
     *     {@link TelecommunicationsServiceCallCodeType }
     *     
     */
    @Nullable
    public TelecommunicationsServiceCallCodeType getTelecommunicationsServiceCallCode() {
        return telecommunicationsServiceCallCode;
    }

    /**
     * Sets the value of the telecommunicationsServiceCallCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TelecommunicationsServiceCallCodeType }
     *     
     */
    public void setTelecommunicationsServiceCallCode(
        @Nullable
        TelecommunicationsServiceCallCodeType value) {
        this.telecommunicationsServiceCallCode = value;
    }

    /**
     * Gets the value of the callBaseAmount property.
     * 
     * @return
     *     possible object is
     *     {@link CallBaseAmountType }
     *     
     */
    @Nullable
    public CallBaseAmountType getCallBaseAmount() {
        return callBaseAmount;
    }

    /**
     * Sets the value of the callBaseAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link CallBaseAmountType }
     *     
     */
    public void setCallBaseAmount(
        @Nullable
        CallBaseAmountType value) {
        this.callBaseAmount = value;
    }

    /**
     * Gets the value of the callExtensionAmount property.
     * 
     * @return
     *     possible object is
     *     {@link CallExtensionAmountType }
     *     
     */
    @Nullable
    public CallExtensionAmountType getCallExtensionAmount() {
        return callExtensionAmount;
    }

    /**
     * Sets the value of the callExtensionAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link CallExtensionAmountType }
     *     
     */
    public void setCallExtensionAmount(
        @Nullable
        CallExtensionAmountType value) {
        this.callExtensionAmount = value;
    }

    /**
     * Gets the value of the price property.
     * 
     * @return
     *     possible object is
     *     {@link PriceType }
     *     
     */
    @Nullable
    public PriceType getPrice() {
        return price;
    }

    /**
     * Sets the value of the price property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceType }
     *     
     */
    public void setPrice(
        @Nullable
        PriceType value) {
        this.price = value;
    }

    /**
     * Gets the value of the country property.
     * 
     * @return
     *     possible object is
     *     {@link CountryType }
     *     
     */
    @Nullable
    public CountryType getCountry() {
        return country;
    }

    /**
     * Sets the value of the country property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryType }
     *     
     */
    public void setCountry(
        @Nullable
        CountryType value) {
        this.country = value;
    }

    /**
     * Gets the value of the exchangeRate property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the exchangeRate property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getExchangeRate().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExchangeRateType }
     * </p>
     * 
     * 
     * @return
     *     The value of the exchangeRate property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ExchangeRateType> getExchangeRate() {
        if (exchangeRate == null) {
            exchangeRate = new ArrayList<>();
        }
        return this.exchangeRate;
    }

    /**
     * Gets the value of the allowanceCharge property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the allowanceCharge property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAllowanceCharge().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AllowanceChargeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the allowanceCharge property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AllowanceChargeType> getAllowanceCharge() {
        if (allowanceCharge == null) {
            allowanceCharge = new ArrayList<>();
        }
        return this.allowanceCharge;
    }

    /**
     * Gets the value of the taxTotal property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the taxTotal property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTaxTotal().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TaxTotalType }
     * </p>
     * 
     * 
     * @return
     *     The value of the taxTotal property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TaxTotalType> getTaxTotal() {
        if (taxTotal == null) {
            taxTotal = new ArrayList<>();
        }
        return this.taxTotal;
    }

    /**
     * Gets the value of the callDuty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the callDuty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCallDuty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DutyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the callDuty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DutyType> getCallDuty() {
        if (callDuty == null) {
            callDuty = new ArrayList<>();
        }
        return this.callDuty;
    }

    /**
     * Gets the value of the timeDuty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeDuty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTimeDuty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DutyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the timeDuty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DutyType> getTimeDuty() {
        if (timeDuty == null) {
            timeDuty = new ArrayList<>();
        }
        return this.timeDuty;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TelecommunicationsServiceType rhs = ((TelecommunicationsServiceType) o);
        if (!EqualsHelper.equalsCollection(allowanceCharge, rhs.allowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equals(callBaseAmount, rhs.callBaseAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(callDate, rhs.callDate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(callDuty, rhs.callDuty)) {
            return false;
        }
        if (!EqualsHelper.equals(callExtensionAmount, rhs.callExtensionAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(callTime, rhs.callTime)) {
            return false;
        }
        if (!EqualsHelper.equals(country, rhs.country)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(exchangeRate, rhs.exchangeRate)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(movieTitle, rhs.movieTitle)) {
            return false;
        }
        if (!EqualsHelper.equals(payPerView, rhs.payPerView)) {
            return false;
        }
        if (!EqualsHelper.equals(price, rhs.price)) {
            return false;
        }
        if (!EqualsHelper.equals(quantity, rhs.quantity)) {
            return false;
        }
        if (!EqualsHelper.equals(roamingPartnerName, rhs.roamingPartnerName)) {
            return false;
        }
        if (!EqualsHelper.equals(serviceNumberCalled, rhs.serviceNumberCalled)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(taxTotal, rhs.taxTotal)) {
            return false;
        }
        if (!EqualsHelper.equals(telecommunicationsServiceCall, rhs.telecommunicationsServiceCall)) {
            return false;
        }
        if (!EqualsHelper.equals(telecommunicationsServiceCallCode, rhs.telecommunicationsServiceCallCode)) {
            return false;
        }
        if (!EqualsHelper.equals(telecommunicationsServiceCategory, rhs.telecommunicationsServiceCategory)) {
            return false;
        }
        if (!EqualsHelper.equals(telecommunicationsServiceCategoryCode, rhs.telecommunicationsServiceCategoryCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(timeDuty, rhs.timeDuty)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(allowanceCharge).append(callBaseAmount).append(callDate).append(callDuty).append(callExtensionAmount).append(callTime).append(country).append(exchangeRate).append(id).append(movieTitle).append(payPerView).append(price).append(quantity).append(roamingPartnerName).append(serviceNumberCalled).append(taxTotal).append(telecommunicationsServiceCall).append(telecommunicationsServiceCallCode).append(telecommunicationsServiceCategory).append(telecommunicationsServiceCategoryCode).append(timeDuty).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("allowanceCharge", allowanceCharge).append("callBaseAmount", callBaseAmount).append("callDate", callDate).append("callDuty", callDuty).append("callExtensionAmount", callExtensionAmount).append("callTime", callTime).append("country", country).append("exchangeRate", exchangeRate).append("id", id).append("movieTitle", movieTitle).append("payPerView", payPerView).append("price", price).append("quantity", quantity).append("roamingPartnerName", roamingPartnerName).append("serviceNumberCalled", serviceNumberCalled).append("taxTotal", taxTotal).append("telecommunicationsServiceCall", telecommunicationsServiceCall).append("telecommunicationsServiceCallCode", telecommunicationsServiceCallCode).append("telecommunicationsServiceCategory", telecommunicationsServiceCategory).append("telecommunicationsServiceCategoryCode", telecommunicationsServiceCategoryCode).append("timeDuty", timeDuty).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExchangeRate(
        @Nullable
        final List<ExchangeRateType> aList) {
        exchangeRate = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAllowanceCharge(
        @Nullable
        final List<AllowanceChargeType> aList) {
        allowanceCharge = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTaxTotal(
        @Nullable
        final List<TaxTotalType> aList) {
        taxTotal = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCallDuty(
        @Nullable
        final List<DutyType> aList) {
        callDuty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTimeDuty(
        @Nullable
        final List<DutyType> aList) {
        timeDuty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExchangeRateEntries() {
        return (!getExchangeRate().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExchangeRateEntries() {
        return getExchangeRate().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExchangeRateCount() {
        return getExchangeRate().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ExchangeRateType getExchangeRateAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExchangeRate().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExchangeRate(
        @Nonnull
        final ExchangeRateType elem) {
        getExchangeRate().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAllowanceChargeEntries() {
        return (!getAllowanceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAllowanceChargeEntries() {
        return getAllowanceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAllowanceChargeCount() {
        return getAllowanceCharge().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AllowanceChargeType getAllowanceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAllowanceCharge().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAllowanceCharge(
        @Nonnull
        final AllowanceChargeType elem) {
        getAllowanceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTaxTotalEntries() {
        return (!getTaxTotal().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTaxTotalEntries() {
        return getTaxTotal().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTaxTotalCount() {
        return getTaxTotal().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TaxTotalType getTaxTotalAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTaxTotal().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTaxTotal(
        @Nonnull
        final TaxTotalType elem) {
        getTaxTotal().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCallDutyEntries() {
        return (!getCallDuty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCallDutyEntries() {
        return getCallDuty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCallDutyCount() {
        return getCallDuty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DutyType getCallDutyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCallDuty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCallDuty(
        @Nonnull
        final DutyType elem) {
        getCallDuty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTimeDutyEntries() {
        return (!getTimeDuty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTimeDutyEntries() {
        return getTimeDuty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTimeDutyCount() {
        return getTimeDuty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DutyType getTimeDutyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTimeDuty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTimeDuty(
        @Nonnull
        final DutyType elem) {
        getTimeDuty().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TelecommunicationsServiceType ret) {
        if (allowanceCharge == null) {
            ret.allowanceCharge = null;
        } else {
            List<AllowanceChargeType> retAllowanceCharge = new ArrayList<>();
            for (AllowanceChargeType aItem: getAllowanceCharge()) {
                retAllowanceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.allowanceCharge = retAllowanceCharge;
        }
        ret.callBaseAmount = ((callBaseAmount == null)?null:callBaseAmount.clone());
        ret.callDate = ((callDate == null)?null:callDate.clone());
        if (callDuty == null) {
            ret.callDuty = null;
        } else {
            List<DutyType> retCallDuty = new ArrayList<>();
            for (DutyType aItem: getCallDuty()) {
                retCallDuty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.callDuty = retCallDuty;
        }
        ret.callExtensionAmount = ((callExtensionAmount == null)?null:callExtensionAmount.clone());
        ret.callTime = ((callTime == null)?null:callTime.clone());
        ret.country = ((country == null)?null:country.clone());
        if (exchangeRate == null) {
            ret.exchangeRate = null;
        } else {
            List<ExchangeRateType> retExchangeRate = new ArrayList<>();
            for (ExchangeRateType aItem: getExchangeRate()) {
                retExchangeRate.add(((aItem == null)?null:aItem.clone()));
            }
            ret.exchangeRate = retExchangeRate;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.movieTitle = ((movieTitle == null)?null:movieTitle.clone());
        ret.payPerView = ((payPerView == null)?null:payPerView.clone());
        ret.price = ((price == null)?null:price.clone());
        ret.quantity = ((quantity == null)?null:quantity.clone());
        ret.roamingPartnerName = ((roamingPartnerName == null)?null:roamingPartnerName.clone());
        ret.serviceNumberCalled = ((serviceNumberCalled == null)?null:serviceNumberCalled.clone());
        if (taxTotal == null) {
            ret.taxTotal = null;
        } else {
            List<TaxTotalType> retTaxTotal = new ArrayList<>();
            for (TaxTotalType aItem: getTaxTotal()) {
                retTaxTotal.add(((aItem == null)?null:aItem.clone()));
            }
            ret.taxTotal = retTaxTotal;
        }
        ret.telecommunicationsServiceCall = ((telecommunicationsServiceCall == null)?null:telecommunicationsServiceCall.clone());
        ret.telecommunicationsServiceCallCode = ((telecommunicationsServiceCallCode == null)?null:telecommunicationsServiceCallCode.clone());
        ret.telecommunicationsServiceCategory = ((telecommunicationsServiceCategory == null)?null:telecommunicationsServiceCategory.clone());
        ret.telecommunicationsServiceCategoryCode = ((telecommunicationsServiceCategoryCode == null)?null:telecommunicationsServiceCategoryCode.clone());
        if (timeDuty == null) {
            ret.timeDuty = null;
        } else {
            List<DutyType> retTimeDuty = new ArrayList<>();
            for (DutyType aItem: getTimeDuty()) {
                retTimeDuty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.timeDuty = retTimeDuty;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TelecommunicationsServiceType clone() {
        TelecommunicationsServiceType ret = new TelecommunicationsServiceType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CallDateType and never <code>null</code>
     */
    @Nonnull
    public CallDateType setCallDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        CallDateType aObj = getCallDate();
        if (aObj == null) {
            aObj = new CallDateType(valueParam);
            setCallDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CallDateType and never <code>null</code>
     */
    @Nonnull
    public CallDateType setCallDate(
        @Nullable
        final LocalDate valueParam) {
        CallDateType aObj = getCallDate();
        if (aObj == null) {
            aObj = new CallDateType(valueParam);
            setCallDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CallTimeType and never <code>null</code>
     */
    @Nonnull
    public CallTimeType setCallTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        CallTimeType aObj = getCallTime();
        if (aObj == null) {
            aObj = new CallTimeType(valueParam);
            setCallTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CallTimeType and never <code>null</code>
     */
    @Nonnull
    public CallTimeType setCallTime(
        @Nullable
        final LocalTime valueParam) {
        CallTimeType aObj = getCallTime();
        if (aObj == null) {
            aObj = new CallTimeType(valueParam);
            setCallTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ServiceNumberCalledType and never <code>null</code>
     */
    @Nonnull
    public ServiceNumberCalledType setServiceNumberCalled(
        @Nullable
        final String valueParam) {
        ServiceNumberCalledType aObj = getServiceNumberCalled();
        if (aObj == null) {
            aObj = new ServiceNumberCalledType(valueParam);
            setServiceNumberCalled(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TelecommunicationsServiceCategoryType and never <code>null</code>
     */
    @Nonnull
    public TelecommunicationsServiceCategoryType setTelecommunicationsServiceCategory(
        @Nullable
        final String valueParam) {
        TelecommunicationsServiceCategoryType aObj = getTelecommunicationsServiceCategory();
        if (aObj == null) {
            aObj = new TelecommunicationsServiceCategoryType(valueParam);
            setTelecommunicationsServiceCategory(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TelecommunicationsServiceCategoryCodeType and never <code>null</code>
     */
    @Nonnull
    public TelecommunicationsServiceCategoryCodeType setTelecommunicationsServiceCategoryCode(
        @Nullable
        final String valueParam) {
        TelecommunicationsServiceCategoryCodeType aObj = getTelecommunicationsServiceCategoryCode();
        if (aObj == null) {
            aObj = new TelecommunicationsServiceCategoryCodeType(valueParam);
            setTelecommunicationsServiceCategoryCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MovieTitleType and never <code>null</code>
     */
    @Nonnull
    public MovieTitleType setMovieTitle(
        @Nullable
        final String valueParam) {
        MovieTitleType aObj = getMovieTitle();
        if (aObj == null) {
            aObj = new MovieTitleType(valueParam);
            setMovieTitle(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RoamingPartnerNameType and never <code>null</code>
     */
    @Nonnull
    public RoamingPartnerNameType setRoamingPartnerName(
        @Nullable
        final String valueParam) {
        RoamingPartnerNameType aObj = getRoamingPartnerName();
        if (aObj == null) {
            aObj = new RoamingPartnerNameType(valueParam);
            setRoamingPartnerName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PayPerViewType and never <code>null</code>
     */
    @Nonnull
    public PayPerViewType setPayPerView(
        @Nullable
        final String valueParam) {
        PayPerViewType aObj = getPayPerView();
        if (aObj == null) {
            aObj = new PayPerViewType(valueParam);
            setPayPerView(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TelecommunicationsServiceCallType and never <code>null</code>
     */
    @Nonnull
    public TelecommunicationsServiceCallType setTelecommunicationsServiceCall(
        @Nullable
        final String valueParam) {
        TelecommunicationsServiceCallType aObj = getTelecommunicationsServiceCall();
        if (aObj == null) {
            aObj = new TelecommunicationsServiceCallType(valueParam);
            setTelecommunicationsServiceCall(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TelecommunicationsServiceCallCodeType and never <code>null</code>
     */
    @Nonnull
    public TelecommunicationsServiceCallCodeType setTelecommunicationsServiceCallCode(
        @Nullable
        final String valueParam) {
        TelecommunicationsServiceCallCodeType aObj = getTelecommunicationsServiceCallCode();
        if (aObj == null) {
            aObj = new TelecommunicationsServiceCallCodeType(valueParam);
            setTelecommunicationsServiceCallCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CallBaseAmountType and never <code>null</code>
     */
    @Nonnull
    public CallBaseAmountType setCallBaseAmount(
        @Nullable
        final BigDecimal valueParam) {
        CallBaseAmountType aObj = getCallBaseAmount();
        if (aObj == null) {
            aObj = new CallBaseAmountType(valueParam);
            setCallBaseAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CallExtensionAmountType and never <code>null</code>
     */
    @Nonnull
    public CallExtensionAmountType setCallExtensionAmount(
        @Nullable
        final BigDecimal valueParam) {
        CallExtensionAmountType aObj = getCallExtensionAmount();
        if (aObj == null) {
            aObj = new CallExtensionAmountType(valueParam);
            setCallExtensionAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CallDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CallDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getCallDateValue() {
        CallDateType aObj = getCallDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CallDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CallDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getCallDateValueLocal() {
        CallDateType aObj = getCallDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained CallTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CallTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getCallTimeValue() {
        CallTimeType aObj = getCallTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CallTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CallTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getCallTimeValueLocal() {
        CallTimeType aObj = getCallTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ServiceNumberCalledType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ServiceNumberCalledType object or <code>null</code>
     */
    @Nullable
    public String getServiceNumberCalledValue() {
        ServiceNumberCalledType aObj = getServiceNumberCalled();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TelecommunicationsServiceCategoryType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TelecommunicationsServiceCategoryType object or <code>null</code>
     */
    @Nullable
    public String getTelecommunicationsServiceCategoryValue() {
        TelecommunicationsServiceCategoryType aObj = getTelecommunicationsServiceCategory();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TelecommunicationsServiceCategoryCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TelecommunicationsServiceCategoryCodeType object or <code>null</code>
     */
    @Nullable
    public String getTelecommunicationsServiceCategoryCodeValue() {
        TelecommunicationsServiceCategoryCodeType aObj = getTelecommunicationsServiceCategoryCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MovieTitleType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MovieTitleType object or <code>null</code>
     */
    @Nullable
    public String getMovieTitleValue() {
        MovieTitleType aObj = getMovieTitle();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RoamingPartnerNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RoamingPartnerNameType object or <code>null</code>
     */
    @Nullable
    public String getRoamingPartnerNameValue() {
        RoamingPartnerNameType aObj = getRoamingPartnerName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PayPerViewType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PayPerViewType object or <code>null</code>
     */
    @Nullable
    public String getPayPerViewValue() {
        PayPerViewType aObj = getPayPerView();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getQuantityValue() {
        QuantityType aObj = getQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TelecommunicationsServiceCallType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TelecommunicationsServiceCallType object or <code>null</code>
     */
    @Nullable
    public String getTelecommunicationsServiceCallValue() {
        TelecommunicationsServiceCallType aObj = getTelecommunicationsServiceCall();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TelecommunicationsServiceCallCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TelecommunicationsServiceCallCodeType object or <code>null</code>
     */
    @Nullable
    public String getTelecommunicationsServiceCallCodeValue() {
        TelecommunicationsServiceCallCodeType aObj = getTelecommunicationsServiceCallCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CallBaseAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CallBaseAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCallBaseAmountValue() {
        CallBaseAmountType aObj = getCallBaseAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CallExtensionAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CallExtensionAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCallExtensionAmountValue() {
        CallExtensionAmountType aObj = getCallExtensionAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
