
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.FeeAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.FeeDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TenderEnvelopeIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TenderEnvelopeTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.VariantIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for TenderedProjectType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TenderedProjectType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VariantID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FeeAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FeeDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TenderEnvelopeID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TenderEnvelopeTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalFee" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ProcurementProjectLot" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EvidenceDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TaxTotal" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LegalMonetaryTotal" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TenderLine" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AwardingCriterionResponse" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TenderedProjectType", propOrder = {
    "ublExtensions",
    "variantID",
    "feeAmount",
    "feeDescription",
    "tenderEnvelopeID",
    "tenderEnvelopeTypeCode",
    "additionalFee",
    "procurementProjectLot",
    "evidenceDocumentReference",
    "taxTotal",
    "legalMonetaryTotal",
    "tenderLine",
    "awardingCriterionResponse"
})
@CodingStyleguideUnaware
public class TenderedProjectType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "VariantID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private VariantIDType variantID;
    @XmlElement(name = "FeeAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FeeAmountType feeAmount;
    @XmlElement(name = "FeeDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<FeeDescriptionType> feeDescription;
    @XmlElement(name = "TenderEnvelopeID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TenderEnvelopeIDType tenderEnvelopeID;
    @XmlElement(name = "TenderEnvelopeTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TenderEnvelopeTypeCodeType tenderEnvelopeTypeCode;
    @XmlElement(name = "AdditionalFee")
    private List<FeeType> additionalFee;
    @XmlElement(name = "ProcurementProjectLot")
    private List<ProcurementProjectLotType> procurementProjectLot;
    @XmlElement(name = "EvidenceDocumentReference")
    private List<DocumentReferenceType> evidenceDocumentReference;
    @XmlElement(name = "TaxTotal")
    private List<TaxTotalType> taxTotal;
    @XmlElement(name = "LegalMonetaryTotal")
    private MonetaryTotalType legalMonetaryTotal;
    @XmlElement(name = "TenderLine")
    private List<TenderLineType> tenderLine;
    @XmlElement(name = "AwardingCriterionResponse")
    private List<AwardingCriterionResponseType> awardingCriterionResponse;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TenderedProjectType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the variantID property.
     * 
     * @return
     *     possible object is
     *     {@link VariantIDType }
     *     
     */
    @Nullable
    public VariantIDType getVariantID() {
        return variantID;
    }

    /**
     * Sets the value of the variantID property.
     * 
     * @param value
     *     allowed object is
     *     {@link VariantIDType }
     *     
     */
    public void setVariantID(
        @Nullable
        VariantIDType value) {
        this.variantID = value;
    }

    /**
     * Gets the value of the feeAmount property.
     * 
     * @return
     *     possible object is
     *     {@link FeeAmountType }
     *     
     */
    @Nullable
    public FeeAmountType getFeeAmount() {
        return feeAmount;
    }

    /**
     * Sets the value of the feeAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link FeeAmountType }
     *     
     */
    public void setFeeAmount(
        @Nullable
        FeeAmountType value) {
        this.feeAmount = value;
    }

    /**
     * Gets the value of the feeDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the feeDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFeeDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FeeDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the feeDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FeeDescriptionType> getFeeDescription() {
        if (feeDescription == null) {
            feeDescription = new ArrayList<>();
        }
        return this.feeDescription;
    }

    /**
     * Gets the value of the tenderEnvelopeID property.
     * 
     * @return
     *     possible object is
     *     {@link TenderEnvelopeIDType }
     *     
     */
    @Nullable
    public TenderEnvelopeIDType getTenderEnvelopeID() {
        return tenderEnvelopeID;
    }

    /**
     * Sets the value of the tenderEnvelopeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TenderEnvelopeIDType }
     *     
     */
    public void setTenderEnvelopeID(
        @Nullable
        TenderEnvelopeIDType value) {
        this.tenderEnvelopeID = value;
    }

    /**
     * Gets the value of the tenderEnvelopeTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TenderEnvelopeTypeCodeType }
     *     
     */
    @Nullable
    public TenderEnvelopeTypeCodeType getTenderEnvelopeTypeCode() {
        return tenderEnvelopeTypeCode;
    }

    /**
     * Sets the value of the tenderEnvelopeTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TenderEnvelopeTypeCodeType }
     *     
     */
    public void setTenderEnvelopeTypeCode(
        @Nullable
        TenderEnvelopeTypeCodeType value) {
        this.tenderEnvelopeTypeCode = value;
    }

    /**
     * Gets the value of the additionalFee property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalFee property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalFee().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FeeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalFee property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FeeType> getAdditionalFee() {
        if (additionalFee == null) {
            additionalFee = new ArrayList<>();
        }
        return this.additionalFee;
    }

    /**
     * Gets the value of the procurementProjectLot property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the procurementProjectLot property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getProcurementProjectLot().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProcurementProjectLotType }
     * </p>
     * 
     * 
     * @return
     *     The value of the procurementProjectLot property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ProcurementProjectLotType> getProcurementProjectLot() {
        if (procurementProjectLot == null) {
            procurementProjectLot = new ArrayList<>();
        }
        return this.procurementProjectLot;
    }

    /**
     * Gets the value of the evidenceDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the evidenceDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEvidenceDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the evidenceDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getEvidenceDocumentReference() {
        if (evidenceDocumentReference == null) {
            evidenceDocumentReference = new ArrayList<>();
        }
        return this.evidenceDocumentReference;
    }

    /**
     * Gets the value of the taxTotal property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the taxTotal property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTaxTotal().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TaxTotalType }
     * </p>
     * 
     * 
     * @return
     *     The value of the taxTotal property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TaxTotalType> getTaxTotal() {
        if (taxTotal == null) {
            taxTotal = new ArrayList<>();
        }
        return this.taxTotal;
    }

    /**
     * Gets the value of the legalMonetaryTotal property.
     * 
     * @return
     *     possible object is
     *     {@link MonetaryTotalType }
     *     
     */
    @Nullable
    public MonetaryTotalType getLegalMonetaryTotal() {
        return legalMonetaryTotal;
    }

    /**
     * Sets the value of the legalMonetaryTotal property.
     * 
     * @param value
     *     allowed object is
     *     {@link MonetaryTotalType }
     *     
     */
    public void setLegalMonetaryTotal(
        @Nullable
        MonetaryTotalType value) {
        this.legalMonetaryTotal = value;
    }

    /**
     * Gets the value of the tenderLine property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tenderLine property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTenderLine().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TenderLineType }
     * </p>
     * 
     * 
     * @return
     *     The value of the tenderLine property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TenderLineType> getTenderLine() {
        if (tenderLine == null) {
            tenderLine = new ArrayList<>();
        }
        return this.tenderLine;
    }

    /**
     * Gets the value of the awardingCriterionResponse property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the awardingCriterionResponse property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAwardingCriterionResponse().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AwardingCriterionResponseType }
     * </p>
     * 
     * 
     * @return
     *     The value of the awardingCriterionResponse property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AwardingCriterionResponseType> getAwardingCriterionResponse() {
        if (awardingCriterionResponse == null) {
            awardingCriterionResponse = new ArrayList<>();
        }
        return this.awardingCriterionResponse;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TenderedProjectType rhs = ((TenderedProjectType) o);
        if (!EqualsHelper.equalsCollection(additionalFee, rhs.additionalFee)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(awardingCriterionResponse, rhs.awardingCriterionResponse)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(evidenceDocumentReference, rhs.evidenceDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(feeAmount, rhs.feeAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(feeDescription, rhs.feeDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(legalMonetaryTotal, rhs.legalMonetaryTotal)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(procurementProjectLot, rhs.procurementProjectLot)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(taxTotal, rhs.taxTotal)) {
            return false;
        }
        if (!EqualsHelper.equals(tenderEnvelopeID, rhs.tenderEnvelopeID)) {
            return false;
        }
        if (!EqualsHelper.equals(tenderEnvelopeTypeCode, rhs.tenderEnvelopeTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(tenderLine, rhs.tenderLine)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(variantID, rhs.variantID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalFee).append(awardingCriterionResponse).append(evidenceDocumentReference).append(feeAmount).append(feeDescription).append(legalMonetaryTotal).append(procurementProjectLot).append(taxTotal).append(tenderEnvelopeID).append(tenderEnvelopeTypeCode).append(tenderLine).append(ublExtensions).append(variantID).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalFee", additionalFee).append("awardingCriterionResponse", awardingCriterionResponse).append("evidenceDocumentReference", evidenceDocumentReference).append("feeAmount", feeAmount).append("feeDescription", feeDescription).append("legalMonetaryTotal", legalMonetaryTotal).append("procurementProjectLot", procurementProjectLot).append("taxTotal", taxTotal).append("tenderEnvelopeID", tenderEnvelopeID).append("tenderEnvelopeTypeCode", tenderEnvelopeTypeCode).append("tenderLine", tenderLine).append("ublExtensions", ublExtensions).append("variantID", variantID).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFeeDescription(
        @Nullable
        final List<FeeDescriptionType> aList) {
        feeDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalFee(
        @Nullable
        final List<FeeType> aList) {
        additionalFee = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProcurementProjectLot(
        @Nullable
        final List<ProcurementProjectLotType> aList) {
        procurementProjectLot = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEvidenceDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        evidenceDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTaxTotal(
        @Nullable
        final List<TaxTotalType> aList) {
        taxTotal = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTenderLine(
        @Nullable
        final List<TenderLineType> aList) {
        tenderLine = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAwardingCriterionResponse(
        @Nullable
        final List<AwardingCriterionResponseType> aList) {
        awardingCriterionResponse = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFeeDescriptionEntries() {
        return (!getFeeDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFeeDescriptionEntries() {
        return getFeeDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFeeDescriptionCount() {
        return getFeeDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FeeDescriptionType getFeeDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFeeDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFeeDescription(
        @Nonnull
        final FeeDescriptionType elem) {
        getFeeDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalFeeEntries() {
        return (!getAdditionalFee().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalFeeEntries() {
        return getAdditionalFee().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalFeeCount() {
        return getAdditionalFee().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FeeType getAdditionalFeeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalFee().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalFee(
        @Nonnull
        final FeeType elem) {
        getAdditionalFee().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProcurementProjectLotEntries() {
        return (!getProcurementProjectLot().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProcurementProjectLotEntries() {
        return getProcurementProjectLot().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProcurementProjectLotCount() {
        return getProcurementProjectLot().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ProcurementProjectLotType getProcurementProjectLotAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProcurementProjectLot().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProcurementProjectLot(
        @Nonnull
        final ProcurementProjectLotType elem) {
        getProcurementProjectLot().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEvidenceDocumentReferenceEntries() {
        return (!getEvidenceDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEvidenceDocumentReferenceEntries() {
        return getEvidenceDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEvidenceDocumentReferenceCount() {
        return getEvidenceDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getEvidenceDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEvidenceDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEvidenceDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getEvidenceDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTaxTotalEntries() {
        return (!getTaxTotal().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTaxTotalEntries() {
        return getTaxTotal().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTaxTotalCount() {
        return getTaxTotal().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TaxTotalType getTaxTotalAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTaxTotal().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTaxTotal(
        @Nonnull
        final TaxTotalType elem) {
        getTaxTotal().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTenderLineEntries() {
        return (!getTenderLine().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTenderLineEntries() {
        return getTenderLine().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTenderLineCount() {
        return getTenderLine().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TenderLineType getTenderLineAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTenderLine().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTenderLine(
        @Nonnull
        final TenderLineType elem) {
        getTenderLine().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAwardingCriterionResponseEntries() {
        return (!getAwardingCriterionResponse().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAwardingCriterionResponseEntries() {
        return getAwardingCriterionResponse().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAwardingCriterionResponseCount() {
        return getAwardingCriterionResponse().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AwardingCriterionResponseType getAwardingCriterionResponseAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAwardingCriterionResponse().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAwardingCriterionResponse(
        @Nonnull
        final AwardingCriterionResponseType elem) {
        getAwardingCriterionResponse().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TenderedProjectType ret) {
        if (additionalFee == null) {
            ret.additionalFee = null;
        } else {
            List<FeeType> retAdditionalFee = new ArrayList<>();
            for (FeeType aItem: getAdditionalFee()) {
                retAdditionalFee.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalFee = retAdditionalFee;
        }
        if (awardingCriterionResponse == null) {
            ret.awardingCriterionResponse = null;
        } else {
            List<AwardingCriterionResponseType> retAwardingCriterionResponse = new ArrayList<>();
            for (AwardingCriterionResponseType aItem: getAwardingCriterionResponse()) {
                retAwardingCriterionResponse.add(((aItem == null)?null:aItem.clone()));
            }
            ret.awardingCriterionResponse = retAwardingCriterionResponse;
        }
        if (evidenceDocumentReference == null) {
            ret.evidenceDocumentReference = null;
        } else {
            List<DocumentReferenceType> retEvidenceDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getEvidenceDocumentReference()) {
                retEvidenceDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.evidenceDocumentReference = retEvidenceDocumentReference;
        }
        ret.feeAmount = ((feeAmount == null)?null:feeAmount.clone());
        if (feeDescription == null) {
            ret.feeDescription = null;
        } else {
            List<FeeDescriptionType> retFeeDescription = new ArrayList<>();
            for (FeeDescriptionType aItem: getFeeDescription()) {
                retFeeDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.feeDescription = retFeeDescription;
        }
        ret.legalMonetaryTotal = ((legalMonetaryTotal == null)?null:legalMonetaryTotal.clone());
        if (procurementProjectLot == null) {
            ret.procurementProjectLot = null;
        } else {
            List<ProcurementProjectLotType> retProcurementProjectLot = new ArrayList<>();
            for (ProcurementProjectLotType aItem: getProcurementProjectLot()) {
                retProcurementProjectLot.add(((aItem == null)?null:aItem.clone()));
            }
            ret.procurementProjectLot = retProcurementProjectLot;
        }
        if (taxTotal == null) {
            ret.taxTotal = null;
        } else {
            List<TaxTotalType> retTaxTotal = new ArrayList<>();
            for (TaxTotalType aItem: getTaxTotal()) {
                retTaxTotal.add(((aItem == null)?null:aItem.clone()));
            }
            ret.taxTotal = retTaxTotal;
        }
        ret.tenderEnvelopeID = ((tenderEnvelopeID == null)?null:tenderEnvelopeID.clone());
        ret.tenderEnvelopeTypeCode = ((tenderEnvelopeTypeCode == null)?null:tenderEnvelopeTypeCode.clone());
        if (tenderLine == null) {
            ret.tenderLine = null;
        } else {
            List<TenderLineType> retTenderLine = new ArrayList<>();
            for (TenderLineType aItem: getTenderLine()) {
                retTenderLine.add(((aItem == null)?null:aItem.clone()));
            }
            ret.tenderLine = retTenderLine;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.variantID = ((variantID == null)?null:variantID.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TenderedProjectType clone() {
        TenderedProjectType ret = new TenderedProjectType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VariantIDType and never <code>null</code>
     */
    @Nonnull
    public VariantIDType setVariantID(
        @Nullable
        final String valueParam) {
        VariantIDType aObj = getVariantID();
        if (aObj == null) {
            aObj = new VariantIDType(valueParam);
            setVariantID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FeeAmountType and never <code>null</code>
     */
    @Nonnull
    public FeeAmountType setFeeAmount(
        @Nullable
        final BigDecimal valueParam) {
        FeeAmountType aObj = getFeeAmount();
        if (aObj == null) {
            aObj = new FeeAmountType(valueParam);
            setFeeAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TenderEnvelopeIDType and never <code>null</code>
     */
    @Nonnull
    public TenderEnvelopeIDType setTenderEnvelopeID(
        @Nullable
        final String valueParam) {
        TenderEnvelopeIDType aObj = getTenderEnvelopeID();
        if (aObj == null) {
            aObj = new TenderEnvelopeIDType(valueParam);
            setTenderEnvelopeID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TenderEnvelopeTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public TenderEnvelopeTypeCodeType setTenderEnvelopeTypeCode(
        @Nullable
        final String valueParam) {
        TenderEnvelopeTypeCodeType aObj = getTenderEnvelopeTypeCode();
        if (aObj == null) {
            aObj = new TenderEnvelopeTypeCodeType(valueParam);
            setTenderEnvelopeTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained VariantIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VariantIDType object or <code>null</code>
     */
    @Nullable
    public String getVariantIDValue() {
        VariantIDType aObj = getVariantID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FeeAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FeeAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getFeeAmountValue() {
        FeeAmountType aObj = getFeeAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TenderEnvelopeIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TenderEnvelopeIDType object or <code>null</code>
     */
    @Nullable
    public String getTenderEnvelopeIDValue() {
        TenderEnvelopeIDType aObj = getTenderEnvelopeID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TenderEnvelopeTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TenderEnvelopeTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTenderEnvelopeTypeCodeValue() {
        TenderEnvelopeTypeCodeType aObj = getTenderEnvelopeTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
