
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ConfidentialityLevelCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ValidatedCriterionPropertyIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for TenderingCriterionResponseType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TenderingCriterionResponseType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Name" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ValidatedCriterionPropertyID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ConfidentialityLevelCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ResponseValue" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ApplicablePeriod" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EvidenceSupplied" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ProcurementProjectLotReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CommodityClassification" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TenderingCriterionResponseType", propOrder = {
    "ublExtensions",
    "id",
    "name",
    "description",
    "validatedCriterionPropertyID",
    "confidentialityLevelCode",
    "responseValue",
    "applicablePeriod",
    "evidenceSupplied",
    "procurementProjectLotReference",
    "commodityClassification"
})
@CodingStyleguideUnaware
public class TenderingCriterionResponseType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "Name", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NameType name;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "ValidatedCriterionPropertyID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ValidatedCriterionPropertyIDType validatedCriterionPropertyID;
    @XmlElement(name = "ConfidentialityLevelCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ConfidentialityLevelCodeType confidentialityLevelCode;
    @XmlElement(name = "ResponseValue")
    private List<ResponseValueType> responseValue;
    @XmlElement(name = "ApplicablePeriod")
    private List<PeriodType> applicablePeriod;
    @XmlElement(name = "EvidenceSupplied")
    private List<EvidenceSuppliedType> evidenceSupplied;
    @XmlElement(name = "ProcurementProjectLotReference")
    private List<ProcurementProjectLotReferenceType> procurementProjectLotReference;
    @XmlElement(name = "CommodityClassification")
    private List<CommodityClassificationType> commodityClassification;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TenderingCriterionResponseType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setName(
        @Nullable
        NameType value) {
        this.name = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the validatedCriterionPropertyID property.
     * 
     * @return
     *     possible object is
     *     {@link ValidatedCriterionPropertyIDType }
     *     
     */
    @Nullable
    public ValidatedCriterionPropertyIDType getValidatedCriterionPropertyID() {
        return validatedCriterionPropertyID;
    }

    /**
     * Sets the value of the validatedCriterionPropertyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValidatedCriterionPropertyIDType }
     *     
     */
    public void setValidatedCriterionPropertyID(
        @Nullable
        ValidatedCriterionPropertyIDType value) {
        this.validatedCriterionPropertyID = value;
    }

    /**
     * Gets the value of the confidentialityLevelCode property.
     * 
     * @return
     *     possible object is
     *     {@link ConfidentialityLevelCodeType }
     *     
     */
    @Nullable
    public ConfidentialityLevelCodeType getConfidentialityLevelCode() {
        return confidentialityLevelCode;
    }

    /**
     * Sets the value of the confidentialityLevelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConfidentialityLevelCodeType }
     *     
     */
    public void setConfidentialityLevelCode(
        @Nullable
        ConfidentialityLevelCodeType value) {
        this.confidentialityLevelCode = value;
    }

    /**
     * Gets the value of the responseValue property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the responseValue property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getResponseValue().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResponseValueType }
     * </p>
     * 
     * 
     * @return
     *     The value of the responseValue property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ResponseValueType> getResponseValue() {
        if (responseValue == null) {
            responseValue = new ArrayList<>();
        }
        return this.responseValue;
    }

    /**
     * Gets the value of the applicablePeriod property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the applicablePeriod property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getApplicablePeriod().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PeriodType }
     * </p>
     * 
     * 
     * @return
     *     The value of the applicablePeriod property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PeriodType> getApplicablePeriod() {
        if (applicablePeriod == null) {
            applicablePeriod = new ArrayList<>();
        }
        return this.applicablePeriod;
    }

    /**
     * Gets the value of the evidenceSupplied property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the evidenceSupplied property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEvidenceSupplied().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EvidenceSuppliedType }
     * </p>
     * 
     * 
     * @return
     *     The value of the evidenceSupplied property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EvidenceSuppliedType> getEvidenceSupplied() {
        if (evidenceSupplied == null) {
            evidenceSupplied = new ArrayList<>();
        }
        return this.evidenceSupplied;
    }

    /**
     * Gets the value of the procurementProjectLotReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the procurementProjectLotReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getProcurementProjectLotReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProcurementProjectLotReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the procurementProjectLotReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ProcurementProjectLotReferenceType> getProcurementProjectLotReference() {
        if (procurementProjectLotReference == null) {
            procurementProjectLotReference = new ArrayList<>();
        }
        return this.procurementProjectLotReference;
    }

    /**
     * Gets the value of the commodityClassification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the commodityClassification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCommodityClassification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommodityClassificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the commodityClassification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommodityClassificationType> getCommodityClassification() {
        if (commodityClassification == null) {
            commodityClassification = new ArrayList<>();
        }
        return this.commodityClassification;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TenderingCriterionResponseType rhs = ((TenderingCriterionResponseType) o);
        if (!EqualsHelper.equalsCollection(applicablePeriod, rhs.applicablePeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(commodityClassification, rhs.commodityClassification)) {
            return false;
        }
        if (!EqualsHelper.equals(confidentialityLevelCode, rhs.confidentialityLevelCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(evidenceSupplied, rhs.evidenceSupplied)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(procurementProjectLotReference, rhs.procurementProjectLotReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(responseValue, rhs.responseValue)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(validatedCriterionPropertyID, rhs.validatedCriterionPropertyID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(applicablePeriod).append(commodityClassification).append(confidentialityLevelCode).append(description).append(evidenceSupplied).append(id).append(name).append(procurementProjectLotReference).append(responseValue).append(ublExtensions).append(validatedCriterionPropertyID).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("applicablePeriod", applicablePeriod).append("commodityClassification", commodityClassification).append("confidentialityLevelCode", confidentialityLevelCode).append("description", description).append("evidenceSupplied", evidenceSupplied).append("id", id).append("name", name).append("procurementProjectLotReference", procurementProjectLotReference).append("responseValue", responseValue).append("ublExtensions", ublExtensions).append("validatedCriterionPropertyID", validatedCriterionPropertyID).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setResponseValue(
        @Nullable
        final List<ResponseValueType> aList) {
        responseValue = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setApplicablePeriod(
        @Nullable
        final List<PeriodType> aList) {
        applicablePeriod = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEvidenceSupplied(
        @Nullable
        final List<EvidenceSuppliedType> aList) {
        evidenceSupplied = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProcurementProjectLotReference(
        @Nullable
        final List<ProcurementProjectLotReferenceType> aList) {
        procurementProjectLotReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCommodityClassification(
        @Nullable
        final List<CommodityClassificationType> aList) {
        commodityClassification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasResponseValueEntries() {
        return (!getResponseValue().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoResponseValueEntries() {
        return getResponseValue().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getResponseValueCount() {
        return getResponseValue().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ResponseValueType getResponseValueAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getResponseValue().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addResponseValue(
        @Nonnull
        final ResponseValueType elem) {
        getResponseValue().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasApplicablePeriodEntries() {
        return (!getApplicablePeriod().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoApplicablePeriodEntries() {
        return getApplicablePeriod().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getApplicablePeriodCount() {
        return getApplicablePeriod().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PeriodType getApplicablePeriodAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getApplicablePeriod().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addApplicablePeriod(
        @Nonnull
        final PeriodType elem) {
        getApplicablePeriod().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEvidenceSuppliedEntries() {
        return (!getEvidenceSupplied().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEvidenceSuppliedEntries() {
        return getEvidenceSupplied().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEvidenceSuppliedCount() {
        return getEvidenceSupplied().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EvidenceSuppliedType getEvidenceSuppliedAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEvidenceSupplied().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEvidenceSupplied(
        @Nonnull
        final EvidenceSuppliedType elem) {
        getEvidenceSupplied().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProcurementProjectLotReferenceEntries() {
        return (!getProcurementProjectLotReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProcurementProjectLotReferenceEntries() {
        return getProcurementProjectLotReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProcurementProjectLotReferenceCount() {
        return getProcurementProjectLotReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ProcurementProjectLotReferenceType getProcurementProjectLotReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProcurementProjectLotReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProcurementProjectLotReference(
        @Nonnull
        final ProcurementProjectLotReferenceType elem) {
        getProcurementProjectLotReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommodityClassificationEntries() {
        return (!getCommodityClassification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommodityClassificationEntries() {
        return getCommodityClassification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommodityClassificationCount() {
        return getCommodityClassification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommodityClassificationType getCommodityClassificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCommodityClassification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCommodityClassification(
        @Nonnull
        final CommodityClassificationType elem) {
        getCommodityClassification().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TenderingCriterionResponseType ret) {
        if (applicablePeriod == null) {
            ret.applicablePeriod = null;
        } else {
            List<PeriodType> retApplicablePeriod = new ArrayList<>();
            for (PeriodType aItem: getApplicablePeriod()) {
                retApplicablePeriod.add(((aItem == null)?null:aItem.clone()));
            }
            ret.applicablePeriod = retApplicablePeriod;
        }
        if (commodityClassification == null) {
            ret.commodityClassification = null;
        } else {
            List<CommodityClassificationType> retCommodityClassification = new ArrayList<>();
            for (CommodityClassificationType aItem: getCommodityClassification()) {
                retCommodityClassification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.commodityClassification = retCommodityClassification;
        }
        ret.confidentialityLevelCode = ((confidentialityLevelCode == null)?null:confidentialityLevelCode.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (evidenceSupplied == null) {
            ret.evidenceSupplied = null;
        } else {
            List<EvidenceSuppliedType> retEvidenceSupplied = new ArrayList<>();
            for (EvidenceSuppliedType aItem: getEvidenceSupplied()) {
                retEvidenceSupplied.add(((aItem == null)?null:aItem.clone()));
            }
            ret.evidenceSupplied = retEvidenceSupplied;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.name = ((name == null)?null:name.clone());
        if (procurementProjectLotReference == null) {
            ret.procurementProjectLotReference = null;
        } else {
            List<ProcurementProjectLotReferenceType> retProcurementProjectLotReference = new ArrayList<>();
            for (ProcurementProjectLotReferenceType aItem: getProcurementProjectLotReference()) {
                retProcurementProjectLotReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.procurementProjectLotReference = retProcurementProjectLotReference;
        }
        if (responseValue == null) {
            ret.responseValue = null;
        } else {
            List<ResponseValueType> retResponseValue = new ArrayList<>();
            for (ResponseValueType aItem: getResponseValue()) {
                retResponseValue.add(((aItem == null)?null:aItem.clone()));
            }
            ret.responseValue = retResponseValue;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.validatedCriterionPropertyID = ((validatedCriterionPropertyID == null)?null:validatedCriterionPropertyID.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TenderingCriterionResponseType clone() {
        TenderingCriterionResponseType ret = new TenderingCriterionResponseType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setName(
        @Nullable
        final String valueParam) {
        NameType aObj = getName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ValidatedCriterionPropertyIDType and never <code>null</code>
     */
    @Nonnull
    public ValidatedCriterionPropertyIDType setValidatedCriterionPropertyID(
        @Nullable
        final String valueParam) {
        ValidatedCriterionPropertyIDType aObj = getValidatedCriterionPropertyID();
        if (aObj == null) {
            aObj = new ValidatedCriterionPropertyIDType(valueParam);
            setValidatedCriterionPropertyID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ConfidentialityLevelCodeType and never <code>null</code>
     */
    @Nonnull
    public ConfidentialityLevelCodeType setConfidentialityLevelCode(
        @Nullable
        final String valueParam) {
        ConfidentialityLevelCodeType aObj = getConfidentialityLevelCode();
        if (aObj == null) {
            aObj = new ConfidentialityLevelCodeType(valueParam);
            setConfidentialityLevelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        NameType aObj = getName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ValidatedCriterionPropertyIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ValidatedCriterionPropertyIDType object or <code>null</code>
     */
    @Nullable
    public String getValidatedCriterionPropertyIDValue() {
        ValidatedCriterionPropertyIDType aObj = getValidatedCriterionPropertyID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ConfidentialityLevelCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ConfidentialityLevelCodeType object or <code>null</code>
     */
    @Nullable
    public String getConfidentialityLevelCodeValue() {
        ConfidentialityLevelCodeType aObj = getConfidentialityLevelCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
