
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.AccessToolsURIType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.CandidateReductionConstraintIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ContractingSystemCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ExpenseCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.GovernmentAgreementConstraintIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NegotiationDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.OriginalContractingSystemIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PartPresentationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.ProcedureCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.SubmissionMethodCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TerminatedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.UrgencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for TenderingProcessType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TenderingProcessType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OriginalContractingSystemID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NegotiationDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ProcedureCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UrgencyCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExpenseCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PartPresentationCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ContractingSystemCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SubmissionMethodCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CandidateReductionConstraintIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GovernmentAgreementConstraintIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AccessToolsURI" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TerminatedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentAvailabilityPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TenderSubmissionDeadlinePeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}InvitationSubmissionPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ParticipationInvitationPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ParticipationRequestReceptionPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalInformationRequestPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}NoticeDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ProcessJustification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EconomicOperatorShortList" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OpenTenderEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AuctionTerms" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FrameworkAgreement" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContractingSystem" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TenderingProcessType", propOrder = {
    "ublExtensions",
    "id",
    "originalContractingSystemID",
    "description",
    "negotiationDescription",
    "procedureCode",
    "urgencyCode",
    "expenseCode",
    "partPresentationCode",
    "contractingSystemCode",
    "submissionMethodCode",
    "candidateReductionConstraintIndicator",
    "governmentAgreementConstraintIndicator",
    "accessToolsURI",
    "terminatedIndicator",
    "documentAvailabilityPeriod",
    "tenderSubmissionDeadlinePeriod",
    "invitationSubmissionPeriod",
    "participationInvitationPeriod",
    "participationRequestReceptionPeriod",
    "additionalInformationRequestPeriod",
    "noticeDocumentReference",
    "additionalDocumentReference",
    "processJustification",
    "economicOperatorShortList",
    "openTenderEvent",
    "auctionTerms",
    "frameworkAgreement",
    "contractingSystem"
})
@CodingStyleguideUnaware
public class TenderingProcessType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "OriginalContractingSystemID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OriginalContractingSystemIDType originalContractingSystemID;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "NegotiationDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NegotiationDescriptionType> negotiationDescription;
    @XmlElement(name = "ProcedureCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ProcedureCodeType procedureCode;
    @XmlElement(name = "UrgencyCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UrgencyCodeType urgencyCode;
    @XmlElement(name = "ExpenseCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExpenseCodeType expenseCode;
    @XmlElement(name = "PartPresentationCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PartPresentationCodeType partPresentationCode;
    @XmlElement(name = "ContractingSystemCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ContractingSystemCodeType contractingSystemCode;
    @XmlElement(name = "SubmissionMethodCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SubmissionMethodCodeType submissionMethodCode;
    @XmlElement(name = "CandidateReductionConstraintIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CandidateReductionConstraintIndicatorType candidateReductionConstraintIndicator;
    @XmlElement(name = "GovernmentAgreementConstraintIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GovernmentAgreementConstraintIndicatorType governmentAgreementConstraintIndicator;
    @XmlElement(name = "AccessToolsURI", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AccessToolsURIType accessToolsURI;
    @XmlElement(name = "TerminatedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TerminatedIndicatorType terminatedIndicator;
    @XmlElement(name = "DocumentAvailabilityPeriod")
    private PeriodType documentAvailabilityPeriod;
    @XmlElement(name = "TenderSubmissionDeadlinePeriod")
    private PeriodType tenderSubmissionDeadlinePeriod;
    @XmlElement(name = "InvitationSubmissionPeriod")
    private PeriodType invitationSubmissionPeriod;
    @XmlElement(name = "ParticipationInvitationPeriod")
    private PeriodType participationInvitationPeriod;
    @XmlElement(name = "ParticipationRequestReceptionPeriod")
    private PeriodType participationRequestReceptionPeriod;
    @XmlElement(name = "AdditionalInformationRequestPeriod")
    private PeriodType additionalInformationRequestPeriod;
    @XmlElement(name = "NoticeDocumentReference")
    private List<DocumentReferenceType> noticeDocumentReference;
    @XmlElement(name = "AdditionalDocumentReference")
    private List<DocumentReferenceType> additionalDocumentReference;
    @XmlElement(name = "ProcessJustification")
    private List<ProcessJustificationType> processJustification;
    @XmlElement(name = "EconomicOperatorShortList")
    private List<EconomicOperatorShortListType> economicOperatorShortList;
    @XmlElement(name = "OpenTenderEvent")
    private List<EventType> openTenderEvent;
    @XmlElement(name = "AuctionTerms")
    private AuctionTermsType auctionTerms;
    @XmlElement(name = "FrameworkAgreement")
    private FrameworkAgreementType frameworkAgreement;
    @XmlElement(name = "ContractingSystem")
    private List<ContractingSystemType> contractingSystem;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TenderingProcessType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the originalContractingSystemID property.
     * 
     * @return
     *     possible object is
     *     {@link OriginalContractingSystemIDType }
     *     
     */
    @Nullable
    public OriginalContractingSystemIDType getOriginalContractingSystemID() {
        return originalContractingSystemID;
    }

    /**
     * Sets the value of the originalContractingSystemID property.
     * 
     * @param value
     *     allowed object is
     *     {@link OriginalContractingSystemIDType }
     *     
     */
    public void setOriginalContractingSystemID(
        @Nullable
        OriginalContractingSystemIDType value) {
        this.originalContractingSystemID = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the negotiationDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the negotiationDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNegotiationDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NegotiationDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the negotiationDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NegotiationDescriptionType> getNegotiationDescription() {
        if (negotiationDescription == null) {
            negotiationDescription = new ArrayList<>();
        }
        return this.negotiationDescription;
    }

    /**
     * Gets the value of the procedureCode property.
     * 
     * @return
     *     possible object is
     *     {@link ProcedureCodeType }
     *     
     */
    @Nullable
    public ProcedureCodeType getProcedureCode() {
        return procedureCode;
    }

    /**
     * Sets the value of the procedureCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProcedureCodeType }
     *     
     */
    public void setProcedureCode(
        @Nullable
        ProcedureCodeType value) {
        this.procedureCode = value;
    }

    /**
     * Gets the value of the urgencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link UrgencyCodeType }
     *     
     */
    @Nullable
    public UrgencyCodeType getUrgencyCode() {
        return urgencyCode;
    }

    /**
     * Sets the value of the urgencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link UrgencyCodeType }
     *     
     */
    public void setUrgencyCode(
        @Nullable
        UrgencyCodeType value) {
        this.urgencyCode = value;
    }

    /**
     * Gets the value of the expenseCode property.
     * 
     * @return
     *     possible object is
     *     {@link ExpenseCodeType }
     *     
     */
    @Nullable
    public ExpenseCodeType getExpenseCode() {
        return expenseCode;
    }

    /**
     * Sets the value of the expenseCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExpenseCodeType }
     *     
     */
    public void setExpenseCode(
        @Nullable
        ExpenseCodeType value) {
        this.expenseCode = value;
    }

    /**
     * Gets the value of the partPresentationCode property.
     * 
     * @return
     *     possible object is
     *     {@link PartPresentationCodeType }
     *     
     */
    @Nullable
    public PartPresentationCodeType getPartPresentationCode() {
        return partPresentationCode;
    }

    /**
     * Sets the value of the partPresentationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartPresentationCodeType }
     *     
     */
    public void setPartPresentationCode(
        @Nullable
        PartPresentationCodeType value) {
        this.partPresentationCode = value;
    }

    /**
     * Gets the value of the contractingSystemCode property.
     * 
     * @return
     *     possible object is
     *     {@link ContractingSystemCodeType }
     *     
     */
    @Nullable
    public ContractingSystemCodeType getContractingSystemCode() {
        return contractingSystemCode;
    }

    /**
     * Sets the value of the contractingSystemCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContractingSystemCodeType }
     *     
     */
    public void setContractingSystemCode(
        @Nullable
        ContractingSystemCodeType value) {
        this.contractingSystemCode = value;
    }

    /**
     * Gets the value of the submissionMethodCode property.
     * 
     * @return
     *     possible object is
     *     {@link SubmissionMethodCodeType }
     *     
     */
    @Nullable
    public SubmissionMethodCodeType getSubmissionMethodCode() {
        return submissionMethodCode;
    }

    /**
     * Sets the value of the submissionMethodCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SubmissionMethodCodeType }
     *     
     */
    public void setSubmissionMethodCode(
        @Nullable
        SubmissionMethodCodeType value) {
        this.submissionMethodCode = value;
    }

    /**
     * Gets the value of the candidateReductionConstraintIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link CandidateReductionConstraintIndicatorType }
     *     
     */
    @Nullable
    public CandidateReductionConstraintIndicatorType getCandidateReductionConstraintIndicator() {
        return candidateReductionConstraintIndicator;
    }

    /**
     * Sets the value of the candidateReductionConstraintIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link CandidateReductionConstraintIndicatorType }
     *     
     */
    public void setCandidateReductionConstraintIndicator(
        @Nullable
        CandidateReductionConstraintIndicatorType value) {
        this.candidateReductionConstraintIndicator = value;
    }

    /**
     * Gets the value of the governmentAgreementConstraintIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link GovernmentAgreementConstraintIndicatorType }
     *     
     */
    @Nullable
    public GovernmentAgreementConstraintIndicatorType getGovernmentAgreementConstraintIndicator() {
        return governmentAgreementConstraintIndicator;
    }

    /**
     * Sets the value of the governmentAgreementConstraintIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link GovernmentAgreementConstraintIndicatorType }
     *     
     */
    public void setGovernmentAgreementConstraintIndicator(
        @Nullable
        GovernmentAgreementConstraintIndicatorType value) {
        this.governmentAgreementConstraintIndicator = value;
    }

    /**
     * Gets the value of the accessToolsURI property.
     * 
     * @return
     *     possible object is
     *     {@link AccessToolsURIType }
     *     
     */
    @Nullable
    public AccessToolsURIType getAccessToolsURI() {
        return accessToolsURI;
    }

    /**
     * Sets the value of the accessToolsURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccessToolsURIType }
     *     
     */
    public void setAccessToolsURI(
        @Nullable
        AccessToolsURIType value) {
        this.accessToolsURI = value;
    }

    /**
     * Gets the value of the terminatedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link TerminatedIndicatorType }
     *     
     */
    @Nullable
    public TerminatedIndicatorType getTerminatedIndicator() {
        return terminatedIndicator;
    }

    /**
     * Sets the value of the terminatedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link TerminatedIndicatorType }
     *     
     */
    public void setTerminatedIndicator(
        @Nullable
        TerminatedIndicatorType value) {
        this.terminatedIndicator = value;
    }

    /**
     * Gets the value of the documentAvailabilityPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getDocumentAvailabilityPeriod() {
        return documentAvailabilityPeriod;
    }

    /**
     * Sets the value of the documentAvailabilityPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setDocumentAvailabilityPeriod(
        @Nullable
        PeriodType value) {
        this.documentAvailabilityPeriod = value;
    }

    /**
     * Gets the value of the tenderSubmissionDeadlinePeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getTenderSubmissionDeadlinePeriod() {
        return tenderSubmissionDeadlinePeriod;
    }

    /**
     * Sets the value of the tenderSubmissionDeadlinePeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setTenderSubmissionDeadlinePeriod(
        @Nullable
        PeriodType value) {
        this.tenderSubmissionDeadlinePeriod = value;
    }

    /**
     * Gets the value of the invitationSubmissionPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getInvitationSubmissionPeriod() {
        return invitationSubmissionPeriod;
    }

    /**
     * Sets the value of the invitationSubmissionPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setInvitationSubmissionPeriod(
        @Nullable
        PeriodType value) {
        this.invitationSubmissionPeriod = value;
    }

    /**
     * Gets the value of the participationInvitationPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getParticipationInvitationPeriod() {
        return participationInvitationPeriod;
    }

    /**
     * Sets the value of the participationInvitationPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setParticipationInvitationPeriod(
        @Nullable
        PeriodType value) {
        this.participationInvitationPeriod = value;
    }

    /**
     * Gets the value of the participationRequestReceptionPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getParticipationRequestReceptionPeriod() {
        return participationRequestReceptionPeriod;
    }

    /**
     * Sets the value of the participationRequestReceptionPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setParticipationRequestReceptionPeriod(
        @Nullable
        PeriodType value) {
        this.participationRequestReceptionPeriod = value;
    }

    /**
     * Gets the value of the additionalInformationRequestPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getAdditionalInformationRequestPeriod() {
        return additionalInformationRequestPeriod;
    }

    /**
     * Sets the value of the additionalInformationRequestPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setAdditionalInformationRequestPeriod(
        @Nullable
        PeriodType value) {
        this.additionalInformationRequestPeriod = value;
    }

    /**
     * Gets the value of the noticeDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the noticeDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNoticeDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the noticeDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getNoticeDocumentReference() {
        if (noticeDocumentReference == null) {
            noticeDocumentReference = new ArrayList<>();
        }
        return this.noticeDocumentReference;
    }

    /**
     * Gets the value of the additionalDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getAdditionalDocumentReference() {
        if (additionalDocumentReference == null) {
            additionalDocumentReference = new ArrayList<>();
        }
        return this.additionalDocumentReference;
    }

    /**
     * Gets the value of the processJustification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the processJustification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getProcessJustification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProcessJustificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the processJustification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ProcessJustificationType> getProcessJustification() {
        if (processJustification == null) {
            processJustification = new ArrayList<>();
        }
        return this.processJustification;
    }

    /**
     * Gets the value of the economicOperatorShortList property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the economicOperatorShortList property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEconomicOperatorShortList().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EconomicOperatorShortListType }
     * </p>
     * 
     * 
     * @return
     *     The value of the economicOperatorShortList property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EconomicOperatorShortListType> getEconomicOperatorShortList() {
        if (economicOperatorShortList == null) {
            economicOperatorShortList = new ArrayList<>();
        }
        return this.economicOperatorShortList;
    }

    /**
     * Gets the value of the openTenderEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the openTenderEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getOpenTenderEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the openTenderEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EventType> getOpenTenderEvent() {
        if (openTenderEvent == null) {
            openTenderEvent = new ArrayList<>();
        }
        return this.openTenderEvent;
    }

    /**
     * Gets the value of the auctionTerms property.
     * 
     * @return
     *     possible object is
     *     {@link AuctionTermsType }
     *     
     */
    @Nullable
    public AuctionTermsType getAuctionTerms() {
        return auctionTerms;
    }

    /**
     * Sets the value of the auctionTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link AuctionTermsType }
     *     
     */
    public void setAuctionTerms(
        @Nullable
        AuctionTermsType value) {
        this.auctionTerms = value;
    }

    /**
     * Gets the value of the frameworkAgreement property.
     * 
     * @return
     *     possible object is
     *     {@link FrameworkAgreementType }
     *     
     */
    @Nullable
    public FrameworkAgreementType getFrameworkAgreement() {
        return frameworkAgreement;
    }

    /**
     * Sets the value of the frameworkAgreement property.
     * 
     * @param value
     *     allowed object is
     *     {@link FrameworkAgreementType }
     *     
     */
    public void setFrameworkAgreement(
        @Nullable
        FrameworkAgreementType value) {
        this.frameworkAgreement = value;
    }

    /**
     * Gets the value of the contractingSystem property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the contractingSystem property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getContractingSystem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ContractingSystemType }
     * </p>
     * 
     * 
     * @return
     *     The value of the contractingSystem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ContractingSystemType> getContractingSystem() {
        if (contractingSystem == null) {
            contractingSystem = new ArrayList<>();
        }
        return this.contractingSystem;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TenderingProcessType rhs = ((TenderingProcessType) o);
        if (!EqualsHelper.equals(accessToolsURI, rhs.accessToolsURI)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(additionalDocumentReference, rhs.additionalDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(additionalInformationRequestPeriod, rhs.additionalInformationRequestPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(auctionTerms, rhs.auctionTerms)) {
            return false;
        }
        if (!EqualsHelper.equals(candidateReductionConstraintIndicator, rhs.candidateReductionConstraintIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(contractingSystem, rhs.contractingSystem)) {
            return false;
        }
        if (!EqualsHelper.equals(contractingSystemCode, rhs.contractingSystemCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(documentAvailabilityPeriod, rhs.documentAvailabilityPeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(economicOperatorShortList, rhs.economicOperatorShortList)) {
            return false;
        }
        if (!EqualsHelper.equals(expenseCode, rhs.expenseCode)) {
            return false;
        }
        if (!EqualsHelper.equals(frameworkAgreement, rhs.frameworkAgreement)) {
            return false;
        }
        if (!EqualsHelper.equals(governmentAgreementConstraintIndicator, rhs.governmentAgreementConstraintIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(invitationSubmissionPeriod, rhs.invitationSubmissionPeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(negotiationDescription, rhs.negotiationDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(noticeDocumentReference, rhs.noticeDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(openTenderEvent, rhs.openTenderEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(originalContractingSystemID, rhs.originalContractingSystemID)) {
            return false;
        }
        if (!EqualsHelper.equals(partPresentationCode, rhs.partPresentationCode)) {
            return false;
        }
        if (!EqualsHelper.equals(participationInvitationPeriod, rhs.participationInvitationPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(participationRequestReceptionPeriod, rhs.participationRequestReceptionPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(procedureCode, rhs.procedureCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(processJustification, rhs.processJustification)) {
            return false;
        }
        if (!EqualsHelper.equals(submissionMethodCode, rhs.submissionMethodCode)) {
            return false;
        }
        if (!EqualsHelper.equals(tenderSubmissionDeadlinePeriod, rhs.tenderSubmissionDeadlinePeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(terminatedIndicator, rhs.terminatedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(urgencyCode, rhs.urgencyCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(accessToolsURI).append(additionalDocumentReference).append(additionalInformationRequestPeriod).append(auctionTerms).append(candidateReductionConstraintIndicator).append(contractingSystem).append(contractingSystemCode).append(description).append(documentAvailabilityPeriod).append(economicOperatorShortList).append(expenseCode).append(frameworkAgreement).append(governmentAgreementConstraintIndicator).append(id).append(invitationSubmissionPeriod).append(negotiationDescription).append(noticeDocumentReference).append(openTenderEvent).append(originalContractingSystemID).append(partPresentationCode).append(participationInvitationPeriod).append(participationRequestReceptionPeriod).append(procedureCode).append(processJustification).append(submissionMethodCode).append(tenderSubmissionDeadlinePeriod).append(terminatedIndicator).append(ublExtensions).append(urgencyCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("accessToolsURI", accessToolsURI).append("additionalDocumentReference", additionalDocumentReference).append("additionalInformationRequestPeriod", additionalInformationRequestPeriod).append("auctionTerms", auctionTerms).append("candidateReductionConstraintIndicator", candidateReductionConstraintIndicator).append("contractingSystem", contractingSystem).append("contractingSystemCode", contractingSystemCode).append("description", description).append("documentAvailabilityPeriod", documentAvailabilityPeriod).append("economicOperatorShortList", economicOperatorShortList).append("expenseCode", expenseCode).append("frameworkAgreement", frameworkAgreement).append("governmentAgreementConstraintIndicator", governmentAgreementConstraintIndicator).append("id", id).append("invitationSubmissionPeriod", invitationSubmissionPeriod).append("negotiationDescription", negotiationDescription).append("noticeDocumentReference", noticeDocumentReference).append("openTenderEvent", openTenderEvent).append("originalContractingSystemID", originalContractingSystemID).append("partPresentationCode", partPresentationCode).append("participationInvitationPeriod", participationInvitationPeriod).append("participationRequestReceptionPeriod", participationRequestReceptionPeriod).append("procedureCode", procedureCode).append("processJustification", processJustification).append("submissionMethodCode", submissionMethodCode).append("tenderSubmissionDeadlinePeriod", tenderSubmissionDeadlinePeriod).append("terminatedIndicator", terminatedIndicator).append("ublExtensions", ublExtensions).append("urgencyCode", urgencyCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNegotiationDescription(
        @Nullable
        final List<NegotiationDescriptionType> aList) {
        negotiationDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNoticeDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        noticeDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        additionalDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProcessJustification(
        @Nullable
        final List<ProcessJustificationType> aList) {
        processJustification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEconomicOperatorShortList(
        @Nullable
        final List<EconomicOperatorShortListType> aList) {
        economicOperatorShortList = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setOpenTenderEvent(
        @Nullable
        final List<EventType> aList) {
        openTenderEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContractingSystem(
        @Nullable
        final List<ContractingSystemType> aList) {
        contractingSystem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNegotiationDescriptionEntries() {
        return (!getNegotiationDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNegotiationDescriptionEntries() {
        return getNegotiationDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNegotiationDescriptionCount() {
        return getNegotiationDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NegotiationDescriptionType getNegotiationDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNegotiationDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNegotiationDescription(
        @Nonnull
        final NegotiationDescriptionType elem) {
        getNegotiationDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoticeDocumentReferenceEntries() {
        return (!getNoticeDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoticeDocumentReferenceEntries() {
        return getNoticeDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoticeDocumentReferenceCount() {
        return getNoticeDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getNoticeDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNoticeDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNoticeDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getNoticeDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalDocumentReferenceEntries() {
        return (!getAdditionalDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalDocumentReferenceEntries() {
        return getAdditionalDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalDocumentReferenceCount() {
        return getAdditionalDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getAdditionalDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getAdditionalDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProcessJustificationEntries() {
        return (!getProcessJustification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProcessJustificationEntries() {
        return getProcessJustification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProcessJustificationCount() {
        return getProcessJustification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ProcessJustificationType getProcessJustificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProcessJustification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProcessJustification(
        @Nonnull
        final ProcessJustificationType elem) {
        getProcessJustification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEconomicOperatorShortListEntries() {
        return (!getEconomicOperatorShortList().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEconomicOperatorShortListEntries() {
        return getEconomicOperatorShortList().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEconomicOperatorShortListCount() {
        return getEconomicOperatorShortList().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EconomicOperatorShortListType getEconomicOperatorShortListAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEconomicOperatorShortList().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEconomicOperatorShortList(
        @Nonnull
        final EconomicOperatorShortListType elem) {
        getEconomicOperatorShortList().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasOpenTenderEventEntries() {
        return (!getOpenTenderEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoOpenTenderEventEntries() {
        return getOpenTenderEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getOpenTenderEventCount() {
        return getOpenTenderEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EventType getOpenTenderEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getOpenTenderEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addOpenTenderEvent(
        @Nonnull
        final EventType elem) {
        getOpenTenderEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContractingSystemEntries() {
        return (!getContractingSystem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContractingSystemEntries() {
        return getContractingSystem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContractingSystemCount() {
        return getContractingSystem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ContractingSystemType getContractingSystemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContractingSystem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContractingSystem(
        @Nonnull
        final ContractingSystemType elem) {
        getContractingSystem().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TenderingProcessType ret) {
        ret.accessToolsURI = ((accessToolsURI == null)?null:accessToolsURI.clone());
        if (additionalDocumentReference == null) {
            ret.additionalDocumentReference = null;
        } else {
            List<DocumentReferenceType> retAdditionalDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getAdditionalDocumentReference()) {
                retAdditionalDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalDocumentReference = retAdditionalDocumentReference;
        }
        ret.additionalInformationRequestPeriod = ((additionalInformationRequestPeriod == null)?null:additionalInformationRequestPeriod.clone());
        ret.auctionTerms = ((auctionTerms == null)?null:auctionTerms.clone());
        ret.candidateReductionConstraintIndicator = ((candidateReductionConstraintIndicator == null)?null:candidateReductionConstraintIndicator.clone());
        if (contractingSystem == null) {
            ret.contractingSystem = null;
        } else {
            List<ContractingSystemType> retContractingSystem = new ArrayList<>();
            for (ContractingSystemType aItem: getContractingSystem()) {
                retContractingSystem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.contractingSystem = retContractingSystem;
        }
        ret.contractingSystemCode = ((contractingSystemCode == null)?null:contractingSystemCode.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.documentAvailabilityPeriod = ((documentAvailabilityPeriod == null)?null:documentAvailabilityPeriod.clone());
        if (economicOperatorShortList == null) {
            ret.economicOperatorShortList = null;
        } else {
            List<EconomicOperatorShortListType> retEconomicOperatorShortList = new ArrayList<>();
            for (EconomicOperatorShortListType aItem: getEconomicOperatorShortList()) {
                retEconomicOperatorShortList.add(((aItem == null)?null:aItem.clone()));
            }
            ret.economicOperatorShortList = retEconomicOperatorShortList;
        }
        ret.expenseCode = ((expenseCode == null)?null:expenseCode.clone());
        ret.frameworkAgreement = ((frameworkAgreement == null)?null:frameworkAgreement.clone());
        ret.governmentAgreementConstraintIndicator = ((governmentAgreementConstraintIndicator == null)?null:governmentAgreementConstraintIndicator.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.invitationSubmissionPeriod = ((invitationSubmissionPeriod == null)?null:invitationSubmissionPeriod.clone());
        if (negotiationDescription == null) {
            ret.negotiationDescription = null;
        } else {
            List<NegotiationDescriptionType> retNegotiationDescription = new ArrayList<>();
            for (NegotiationDescriptionType aItem: getNegotiationDescription()) {
                retNegotiationDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.negotiationDescription = retNegotiationDescription;
        }
        if (noticeDocumentReference == null) {
            ret.noticeDocumentReference = null;
        } else {
            List<DocumentReferenceType> retNoticeDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getNoticeDocumentReference()) {
                retNoticeDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.noticeDocumentReference = retNoticeDocumentReference;
        }
        if (openTenderEvent == null) {
            ret.openTenderEvent = null;
        } else {
            List<EventType> retOpenTenderEvent = new ArrayList<>();
            for (EventType aItem: getOpenTenderEvent()) {
                retOpenTenderEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.openTenderEvent = retOpenTenderEvent;
        }
        ret.originalContractingSystemID = ((originalContractingSystemID == null)?null:originalContractingSystemID.clone());
        ret.partPresentationCode = ((partPresentationCode == null)?null:partPresentationCode.clone());
        ret.participationInvitationPeriod = ((participationInvitationPeriod == null)?null:participationInvitationPeriod.clone());
        ret.participationRequestReceptionPeriod = ((participationRequestReceptionPeriod == null)?null:participationRequestReceptionPeriod.clone());
        ret.procedureCode = ((procedureCode == null)?null:procedureCode.clone());
        if (processJustification == null) {
            ret.processJustification = null;
        } else {
            List<ProcessJustificationType> retProcessJustification = new ArrayList<>();
            for (ProcessJustificationType aItem: getProcessJustification()) {
                retProcessJustification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.processJustification = retProcessJustification;
        }
        ret.submissionMethodCode = ((submissionMethodCode == null)?null:submissionMethodCode.clone());
        ret.tenderSubmissionDeadlinePeriod = ((tenderSubmissionDeadlinePeriod == null)?null:tenderSubmissionDeadlinePeriod.clone());
        ret.terminatedIndicator = ((terminatedIndicator == null)?null:terminatedIndicator.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.urgencyCode = ((urgencyCode == null)?null:urgencyCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TenderingProcessType clone() {
        TenderingProcessType ret = new TenderingProcessType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OriginalContractingSystemIDType and never <code>null</code>
     */
    @Nonnull
    public OriginalContractingSystemIDType setOriginalContractingSystemID(
        @Nullable
        final String valueParam) {
        OriginalContractingSystemIDType aObj = getOriginalContractingSystemID();
        if (aObj == null) {
            aObj = new OriginalContractingSystemIDType(valueParam);
            setOriginalContractingSystemID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ProcedureCodeType and never <code>null</code>
     */
    @Nonnull
    public ProcedureCodeType setProcedureCode(
        @Nullable
        final String valueParam) {
        ProcedureCodeType aObj = getProcedureCode();
        if (aObj == null) {
            aObj = new ProcedureCodeType(valueParam);
            setProcedureCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UrgencyCodeType and never <code>null</code>
     */
    @Nonnull
    public UrgencyCodeType setUrgencyCode(
        @Nullable
        final String valueParam) {
        UrgencyCodeType aObj = getUrgencyCode();
        if (aObj == null) {
            aObj = new UrgencyCodeType(valueParam);
            setUrgencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExpenseCodeType and never <code>null</code>
     */
    @Nonnull
    public ExpenseCodeType setExpenseCode(
        @Nullable
        final String valueParam) {
        ExpenseCodeType aObj = getExpenseCode();
        if (aObj == null) {
            aObj = new ExpenseCodeType(valueParam);
            setExpenseCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PartPresentationCodeType and never <code>null</code>
     */
    @Nonnull
    public PartPresentationCodeType setPartPresentationCode(
        @Nullable
        final String valueParam) {
        PartPresentationCodeType aObj = getPartPresentationCode();
        if (aObj == null) {
            aObj = new PartPresentationCodeType(valueParam);
            setPartPresentationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ContractingSystemCodeType and never <code>null</code>
     */
    @Nonnull
    public ContractingSystemCodeType setContractingSystemCode(
        @Nullable
        final String valueParam) {
        ContractingSystemCodeType aObj = getContractingSystemCode();
        if (aObj == null) {
            aObj = new ContractingSystemCodeType(valueParam);
            setContractingSystemCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SubmissionMethodCodeType and never <code>null</code>
     */
    @Nonnull
    public SubmissionMethodCodeType setSubmissionMethodCode(
        @Nullable
        final String valueParam) {
        SubmissionMethodCodeType aObj = getSubmissionMethodCode();
        if (aObj == null) {
            aObj = new SubmissionMethodCodeType(valueParam);
            setSubmissionMethodCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type CandidateReductionConstraintIndicatorType and never <code>null</code>
     */
    @Nonnull
    public CandidateReductionConstraintIndicatorType setCandidateReductionConstraintIndicator(final boolean valueParam) {
        CandidateReductionConstraintIndicatorType aObj = getCandidateReductionConstraintIndicator();
        if (aObj == null) {
            aObj = new CandidateReductionConstraintIndicatorType(valueParam);
            setCandidateReductionConstraintIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type GovernmentAgreementConstraintIndicatorType and never <code>null</code>
     */
    @Nonnull
    public GovernmentAgreementConstraintIndicatorType setGovernmentAgreementConstraintIndicator(final boolean valueParam) {
        GovernmentAgreementConstraintIndicatorType aObj = getGovernmentAgreementConstraintIndicator();
        if (aObj == null) {
            aObj = new GovernmentAgreementConstraintIndicatorType(valueParam);
            setGovernmentAgreementConstraintIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AccessToolsURIType and never <code>null</code>
     */
    @Nonnull
    public AccessToolsURIType setAccessToolsURI(
        @Nullable
        final String valueParam) {
        AccessToolsURIType aObj = getAccessToolsURI();
        if (aObj == null) {
            aObj = new AccessToolsURIType(valueParam);
            setAccessToolsURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type TerminatedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public TerminatedIndicatorType setTerminatedIndicator(final boolean valueParam) {
        TerminatedIndicatorType aObj = getTerminatedIndicator();
        if (aObj == null) {
            aObj = new TerminatedIndicatorType(valueParam);
            setTerminatedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OriginalContractingSystemIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OriginalContractingSystemIDType object or <code>null</code>
     */
    @Nullable
    public String getOriginalContractingSystemIDValue() {
        OriginalContractingSystemIDType aObj = getOriginalContractingSystemID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ProcedureCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ProcedureCodeType object or <code>null</code>
     */
    @Nullable
    public String getProcedureCodeValue() {
        ProcedureCodeType aObj = getProcedureCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained UrgencyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UrgencyCodeType object or <code>null</code>
     */
    @Nullable
    public String getUrgencyCodeValue() {
        UrgencyCodeType aObj = getUrgencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExpenseCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExpenseCodeType object or <code>null</code>
     */
    @Nullable
    public String getExpenseCodeValue() {
        ExpenseCodeType aObj = getExpenseCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PartPresentationCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PartPresentationCodeType object or <code>null</code>
     */
    @Nullable
    public String getPartPresentationCodeValue() {
        PartPresentationCodeType aObj = getPartPresentationCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ContractingSystemCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ContractingSystemCodeType object or <code>null</code>
     */
    @Nullable
    public String getContractingSystemCodeValue() {
        ContractingSystemCodeType aObj = getContractingSystemCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SubmissionMethodCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SubmissionMethodCodeType object or <code>null</code>
     */
    @Nullable
    public String getSubmissionMethodCodeValue() {
        SubmissionMethodCodeType aObj = getSubmissionMethodCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CandidateReductionConstraintIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained CandidateReductionConstraintIndicatorType object or the passed nullValue
     */
    public boolean isCandidateReductionConstraintIndicatorValue(final boolean nullValue) {
        CandidateReductionConstraintIndicatorType aObj = getCandidateReductionConstraintIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained GovernmentAgreementConstraintIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained GovernmentAgreementConstraintIndicatorType object or the passed nullValue
     */
    public boolean isGovernmentAgreementConstraintIndicatorValue(final boolean nullValue) {
        GovernmentAgreementConstraintIndicatorType aObj = getGovernmentAgreementConstraintIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained AccessToolsURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AccessToolsURIType object or <code>null</code>
     */
    @Nullable
    public String getAccessToolsURIValue() {
        AccessToolsURIType aObj = getAccessToolsURI();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TerminatedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained TerminatedIndicatorType object or the passed nullValue
     */
    public boolean isTerminatedIndicatorValue(final boolean nullValue) {
        TerminatedIndicatorType aObj = getTerminatedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
