
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.AcceptedVariantsDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.AdditionalConditionsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.AwardingMethodTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DocumentationFeeAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EconomicOperatorRegistryURIType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.EstimatedTimingFurtherPublicationType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.FundingProgramCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.FundingProgramType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.LatestSecurityClearanceDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MaximumAdvertisementAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MaximumVariantQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.MultipleTendersCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.OtherConditionsIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PaymentFrequencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PriceEvaluationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.PriceRevisionFormulaDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RecurringProcurementDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RecurringProcurementIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RequiredCurriculaCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.RequiredCurriculaIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.VariantConstraintCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.VariantConstraintIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for TenderingTermsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TenderingTermsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AwardingMethodTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PriceEvaluationCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumVariantQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VariantConstraintIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AcceptedVariantsDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VariantConstraintCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PriceRevisionFormulaDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FundingProgramCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FundingProgram" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumAdvertisementAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaymentFrequencyCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EconomicOperatorRegistryURI" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RequiredCurriculaIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RequiredCurriculaCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OtherConditionsIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RecurringProcurementIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RecurringProcurementDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedTimingFurtherPublication" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AdditionalConditions" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatestSecurityClearanceDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DocumentationFeeAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MultipleTendersCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PenaltyClause" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RequiredFinancialGuarantee" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ProcurementLegislationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FiscalLegislationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EnvironmentalLegislationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EmploymentLegislationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContractualDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CallForTendersDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}WarrantyValidityPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PaymentTerms" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TendererQualificationRequest" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AllowedSubcontractTerms" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TenderPreparation" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContractExecutionRequirement" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AwardingTerms" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalInformationParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentProviderParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TenderRecipientParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContractResponsibleParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TenderEvaluationParty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}QualificationRequestRecipientParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TenderValidityPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContractAcceptancePeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AppealTerms" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Language" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}BudgetAccountLine" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReplacedNoticeDocumentReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LotDistribution" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PostAwardProcess" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EconomicOperatorShortList" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SecurityClearanceTerm" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TenderingTermsType", propOrder = {
    "ublExtensions",
    "awardingMethodTypeCode",
    "priceEvaluationCode",
    "maximumVariantQuantity",
    "variantConstraintIndicator",
    "acceptedVariantsDescription",
    "variantConstraintCode",
    "priceRevisionFormulaDescription",
    "fundingProgramCode",
    "fundingProgram",
    "maximumAdvertisementAmount",
    "note",
    "paymentFrequencyCode",
    "economicOperatorRegistryURI",
    "requiredCurriculaIndicator",
    "requiredCurriculaCode",
    "otherConditionsIndicator",
    "recurringProcurementIndicator",
    "recurringProcurementDescription",
    "estimatedTimingFurtherPublication",
    "additionalConditions",
    "latestSecurityClearanceDate",
    "documentationFeeAmount",
    "multipleTendersCode",
    "penaltyClause",
    "requiredFinancialGuarantee",
    "procurementLegislationDocumentReference",
    "fiscalLegislationDocumentReference",
    "environmentalLegislationDocumentReference",
    "employmentLegislationDocumentReference",
    "contractualDocumentReference",
    "callForTendersDocumentReference",
    "warrantyValidityPeriod",
    "paymentTerms",
    "tendererQualificationRequest",
    "allowedSubcontractTerms",
    "tenderPreparation",
    "contractExecutionRequirement",
    "awardingTerms",
    "additionalInformationParty",
    "documentProviderParty",
    "tenderRecipientParty",
    "contractResponsibleParty",
    "tenderEvaluationParty",
    "qualificationRequestRecipientParty",
    "tenderValidityPeriod",
    "contractAcceptancePeriod",
    "appealTerms",
    "language",
    "budgetAccountLine",
    "replacedNoticeDocumentReference",
    "lotDistribution",
    "postAwardProcess",
    "economicOperatorShortList",
    "securityClearanceTerm"
})
@CodingStyleguideUnaware
public class TenderingTermsType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "AwardingMethodTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AwardingMethodTypeCodeType awardingMethodTypeCode;
    @XmlElement(name = "PriceEvaluationCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PriceEvaluationCodeType priceEvaluationCode;
    @XmlElement(name = "MaximumVariantQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumVariantQuantityType maximumVariantQuantity;
    @XmlElement(name = "VariantConstraintIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private VariantConstraintIndicatorType variantConstraintIndicator;
    @XmlElement(name = "AcceptedVariantsDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<AcceptedVariantsDescriptionType> acceptedVariantsDescription;
    @XmlElement(name = "VariantConstraintCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private VariantConstraintCodeType variantConstraintCode;
    @XmlElement(name = "PriceRevisionFormulaDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PriceRevisionFormulaDescriptionType> priceRevisionFormulaDescription;
    @XmlElement(name = "FundingProgramCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FundingProgramCodeType fundingProgramCode;
    @XmlElement(name = "FundingProgram", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<FundingProgramType> fundingProgram;
    @XmlElement(name = "MaximumAdvertisementAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumAdvertisementAmountType maximumAdvertisementAmount;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "PaymentFrequencyCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PaymentFrequencyCodeType paymentFrequencyCode;
    @XmlElement(name = "EconomicOperatorRegistryURI", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EconomicOperatorRegistryURIType economicOperatorRegistryURI;
    @XmlElement(name = "RequiredCurriculaIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RequiredCurriculaIndicatorType requiredCurriculaIndicator;
    @XmlElement(name = "RequiredCurriculaCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RequiredCurriculaCodeType requiredCurriculaCode;
    @XmlElement(name = "OtherConditionsIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OtherConditionsIndicatorType otherConditionsIndicator;
    @XmlElement(name = "RecurringProcurementIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RecurringProcurementIndicatorType recurringProcurementIndicator;
    @XmlElement(name = "RecurringProcurementDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<RecurringProcurementDescriptionType> recurringProcurementDescription;
    @XmlElement(name = "EstimatedTimingFurtherPublication", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<EstimatedTimingFurtherPublicationType> estimatedTimingFurtherPublication;
    @XmlElement(name = "AdditionalConditions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<AdditionalConditionsType> additionalConditions;
    @XmlElement(name = "LatestSecurityClearanceDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatestSecurityClearanceDateType latestSecurityClearanceDate;
    @XmlElement(name = "DocumentationFeeAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DocumentationFeeAmountType documentationFeeAmount;
    @XmlElement(name = "MultipleTendersCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MultipleTendersCodeType multipleTendersCode;
    @XmlElement(name = "PenaltyClause")
    private List<ClauseType> penaltyClause;
    @XmlElement(name = "RequiredFinancialGuarantee")
    private List<FinancialGuaranteeType> requiredFinancialGuarantee;
    @XmlElement(name = "ProcurementLegislationDocumentReference")
    private List<DocumentReferenceType> procurementLegislationDocumentReference;
    @XmlElement(name = "FiscalLegislationDocumentReference")
    private List<DocumentReferenceType> fiscalLegislationDocumentReference;
    @XmlElement(name = "EnvironmentalLegislationDocumentReference")
    private List<DocumentReferenceType> environmentalLegislationDocumentReference;
    @XmlElement(name = "EmploymentLegislationDocumentReference")
    private List<DocumentReferenceType> employmentLegislationDocumentReference;
    @XmlElement(name = "ContractualDocumentReference")
    private List<DocumentReferenceType> contractualDocumentReference;
    @XmlElement(name = "CallForTendersDocumentReference")
    private List<DocumentReferenceType> callForTendersDocumentReference;
    @XmlElement(name = "WarrantyValidityPeriod")
    private PeriodType warrantyValidityPeriod;
    @XmlElement(name = "PaymentTerms")
    private List<PaymentTermsType> paymentTerms;
    @XmlElement(name = "TendererQualificationRequest")
    private List<TendererQualificationRequestType> tendererQualificationRequest;
    @XmlElement(name = "AllowedSubcontractTerms")
    private List<SubcontractTermsType> allowedSubcontractTerms;
    @XmlElement(name = "TenderPreparation")
    private List<TenderPreparationType> tenderPreparation;
    @XmlElement(name = "ContractExecutionRequirement")
    private List<ContractExecutionRequirementType> contractExecutionRequirement;
    @XmlElement(name = "AwardingTerms")
    private AwardingTermsType awardingTerms;
    @XmlElement(name = "AdditionalInformationParty")
    private PartyType additionalInformationParty;
    @XmlElement(name = "DocumentProviderParty")
    private PartyType documentProviderParty;
    @XmlElement(name = "TenderRecipientParty")
    private PartyType tenderRecipientParty;
    @XmlElement(name = "ContractResponsibleParty")
    private PartyType contractResponsibleParty;
    @XmlElement(name = "TenderEvaluationParty")
    private List<PartyType> tenderEvaluationParty;
    @XmlElement(name = "QualificationRequestRecipientParty")
    private PartyType qualificationRequestRecipientParty;
    @XmlElement(name = "TenderValidityPeriod")
    private PeriodType tenderValidityPeriod;
    @XmlElement(name = "ContractAcceptancePeriod")
    private PeriodType contractAcceptancePeriod;
    @XmlElement(name = "AppealTerms")
    private AppealTermsType appealTerms;
    @XmlElement(name = "Language")
    private List<LanguageType> language;
    @XmlElement(name = "BudgetAccountLine")
    private List<BudgetAccountLineType> budgetAccountLine;
    @XmlElement(name = "ReplacedNoticeDocumentReference")
    private DocumentReferenceType replacedNoticeDocumentReference;
    @XmlElement(name = "LotDistribution")
    private LotDistributionType lotDistribution;
    @XmlElement(name = "PostAwardProcess")
    private PostAwardProcessType postAwardProcess;
    @XmlElement(name = "EconomicOperatorShortList")
    private EconomicOperatorShortListType economicOperatorShortList;
    @XmlElement(name = "SecurityClearanceTerm")
    private List<SecurityClearanceTermType> securityClearanceTerm;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TenderingTermsType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the awardingMethodTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link AwardingMethodTypeCodeType }
     *     
     */
    @Nullable
    public AwardingMethodTypeCodeType getAwardingMethodTypeCode() {
        return awardingMethodTypeCode;
    }

    /**
     * Sets the value of the awardingMethodTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link AwardingMethodTypeCodeType }
     *     
     */
    public void setAwardingMethodTypeCode(
        @Nullable
        AwardingMethodTypeCodeType value) {
        this.awardingMethodTypeCode = value;
    }

    /**
     * Gets the value of the priceEvaluationCode property.
     * 
     * @return
     *     possible object is
     *     {@link PriceEvaluationCodeType }
     *     
     */
    @Nullable
    public PriceEvaluationCodeType getPriceEvaluationCode() {
        return priceEvaluationCode;
    }

    /**
     * Sets the value of the priceEvaluationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceEvaluationCodeType }
     *     
     */
    public void setPriceEvaluationCode(
        @Nullable
        PriceEvaluationCodeType value) {
        this.priceEvaluationCode = value;
    }

    /**
     * Gets the value of the maximumVariantQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumVariantQuantityType }
     *     
     */
    @Nullable
    public MaximumVariantQuantityType getMaximumVariantQuantity() {
        return maximumVariantQuantity;
    }

    /**
     * Sets the value of the maximumVariantQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumVariantQuantityType }
     *     
     */
    public void setMaximumVariantQuantity(
        @Nullable
        MaximumVariantQuantityType value) {
        this.maximumVariantQuantity = value;
    }

    /**
     * Gets the value of the variantConstraintIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link VariantConstraintIndicatorType }
     *     
     */
    @Nullable
    public VariantConstraintIndicatorType getVariantConstraintIndicator() {
        return variantConstraintIndicator;
    }

    /**
     * Sets the value of the variantConstraintIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link VariantConstraintIndicatorType }
     *     
     */
    public void setVariantConstraintIndicator(
        @Nullable
        VariantConstraintIndicatorType value) {
        this.variantConstraintIndicator = value;
    }

    /**
     * Gets the value of the acceptedVariantsDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the acceptedVariantsDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAcceptedVariantsDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AcceptedVariantsDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the acceptedVariantsDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AcceptedVariantsDescriptionType> getAcceptedVariantsDescription() {
        if (acceptedVariantsDescription == null) {
            acceptedVariantsDescription = new ArrayList<>();
        }
        return this.acceptedVariantsDescription;
    }

    /**
     * Gets the value of the variantConstraintCode property.
     * 
     * @return
     *     possible object is
     *     {@link VariantConstraintCodeType }
     *     
     */
    @Nullable
    public VariantConstraintCodeType getVariantConstraintCode() {
        return variantConstraintCode;
    }

    /**
     * Sets the value of the variantConstraintCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link VariantConstraintCodeType }
     *     
     */
    public void setVariantConstraintCode(
        @Nullable
        VariantConstraintCodeType value) {
        this.variantConstraintCode = value;
    }

    /**
     * Gets the value of the priceRevisionFormulaDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the priceRevisionFormulaDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPriceRevisionFormulaDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PriceRevisionFormulaDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the priceRevisionFormulaDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PriceRevisionFormulaDescriptionType> getPriceRevisionFormulaDescription() {
        if (priceRevisionFormulaDescription == null) {
            priceRevisionFormulaDescription = new ArrayList<>();
        }
        return this.priceRevisionFormulaDescription;
    }

    /**
     * Gets the value of the fundingProgramCode property.
     * 
     * @return
     *     possible object is
     *     {@link FundingProgramCodeType }
     *     
     */
    @Nullable
    public FundingProgramCodeType getFundingProgramCode() {
        return fundingProgramCode;
    }

    /**
     * Sets the value of the fundingProgramCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link FundingProgramCodeType }
     *     
     */
    public void setFundingProgramCode(
        @Nullable
        FundingProgramCodeType value) {
        this.fundingProgramCode = value;
    }

    /**
     * Gets the value of the fundingProgram property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fundingProgram property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFundingProgram().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FundingProgramType }
     * </p>
     * 
     * 
     * @return
     *     The value of the fundingProgram property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FundingProgramType> getFundingProgram() {
        if (fundingProgram == null) {
            fundingProgram = new ArrayList<>();
        }
        return this.fundingProgram;
    }

    /**
     * Gets the value of the maximumAdvertisementAmount property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumAdvertisementAmountType }
     *     
     */
    @Nullable
    public MaximumAdvertisementAmountType getMaximumAdvertisementAmount() {
        return maximumAdvertisementAmount;
    }

    /**
     * Sets the value of the maximumAdvertisementAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumAdvertisementAmountType }
     *     
     */
    public void setMaximumAdvertisementAmount(
        @Nullable
        MaximumAdvertisementAmountType value) {
        this.maximumAdvertisementAmount = value;
    }

    /**
     * Gets the value of the note property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the note property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the note property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<>();
        }
        return this.note;
    }

    /**
     * Gets the value of the paymentFrequencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentFrequencyCodeType }
     *     
     */
    @Nullable
    public PaymentFrequencyCodeType getPaymentFrequencyCode() {
        return paymentFrequencyCode;
    }

    /**
     * Sets the value of the paymentFrequencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentFrequencyCodeType }
     *     
     */
    public void setPaymentFrequencyCode(
        @Nullable
        PaymentFrequencyCodeType value) {
        this.paymentFrequencyCode = value;
    }

    /**
     * Gets the value of the economicOperatorRegistryURI property.
     * 
     * @return
     *     possible object is
     *     {@link EconomicOperatorRegistryURIType }
     *     
     */
    @Nullable
    public EconomicOperatorRegistryURIType getEconomicOperatorRegistryURI() {
        return economicOperatorRegistryURI;
    }

    /**
     * Sets the value of the economicOperatorRegistryURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link EconomicOperatorRegistryURIType }
     *     
     */
    public void setEconomicOperatorRegistryURI(
        @Nullable
        EconomicOperatorRegistryURIType value) {
        this.economicOperatorRegistryURI = value;
    }

    /**
     * Gets the value of the requiredCurriculaIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link RequiredCurriculaIndicatorType }
     *     
     */
    @Nullable
    public RequiredCurriculaIndicatorType getRequiredCurriculaIndicator() {
        return requiredCurriculaIndicator;
    }

    /**
     * Sets the value of the requiredCurriculaIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequiredCurriculaIndicatorType }
     *     
     */
    public void setRequiredCurriculaIndicator(
        @Nullable
        RequiredCurriculaIndicatorType value) {
        this.requiredCurriculaIndicator = value;
    }

    /**
     * Gets the value of the requiredCurriculaCode property.
     * 
     * @return
     *     possible object is
     *     {@link RequiredCurriculaCodeType }
     *     
     */
    @Nullable
    public RequiredCurriculaCodeType getRequiredCurriculaCode() {
        return requiredCurriculaCode;
    }

    /**
     * Sets the value of the requiredCurriculaCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequiredCurriculaCodeType }
     *     
     */
    public void setRequiredCurriculaCode(
        @Nullable
        RequiredCurriculaCodeType value) {
        this.requiredCurriculaCode = value;
    }

    /**
     * Gets the value of the otherConditionsIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link OtherConditionsIndicatorType }
     *     
     */
    @Nullable
    public OtherConditionsIndicatorType getOtherConditionsIndicator() {
        return otherConditionsIndicator;
    }

    /**
     * Sets the value of the otherConditionsIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link OtherConditionsIndicatorType }
     *     
     */
    public void setOtherConditionsIndicator(
        @Nullable
        OtherConditionsIndicatorType value) {
        this.otherConditionsIndicator = value;
    }

    /**
     * Gets the value of the recurringProcurementIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link RecurringProcurementIndicatorType }
     *     
     */
    @Nullable
    public RecurringProcurementIndicatorType getRecurringProcurementIndicator() {
        return recurringProcurementIndicator;
    }

    /**
     * Sets the value of the recurringProcurementIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link RecurringProcurementIndicatorType }
     *     
     */
    public void setRecurringProcurementIndicator(
        @Nullable
        RecurringProcurementIndicatorType value) {
        this.recurringProcurementIndicator = value;
    }

    /**
     * Gets the value of the recurringProcurementDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the recurringProcurementDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRecurringProcurementDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RecurringProcurementDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the recurringProcurementDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RecurringProcurementDescriptionType> getRecurringProcurementDescription() {
        if (recurringProcurementDescription == null) {
            recurringProcurementDescription = new ArrayList<>();
        }
        return this.recurringProcurementDescription;
    }

    /**
     * Gets the value of the estimatedTimingFurtherPublication property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the estimatedTimingFurtherPublication property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEstimatedTimingFurtherPublication().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EstimatedTimingFurtherPublicationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the estimatedTimingFurtherPublication property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EstimatedTimingFurtherPublicationType> getEstimatedTimingFurtherPublication() {
        if (estimatedTimingFurtherPublication == null) {
            estimatedTimingFurtherPublication = new ArrayList<>();
        }
        return this.estimatedTimingFurtherPublication;
    }

    /**
     * Gets the value of the additionalConditions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalConditions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalConditions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AdditionalConditionsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalConditions property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AdditionalConditionsType> getAdditionalConditions() {
        if (additionalConditions == null) {
            additionalConditions = new ArrayList<>();
        }
        return this.additionalConditions;
    }

    /**
     * Gets the value of the latestSecurityClearanceDate property.
     * 
     * @return
     *     possible object is
     *     {@link LatestSecurityClearanceDateType }
     *     
     */
    @Nullable
    public LatestSecurityClearanceDateType getLatestSecurityClearanceDate() {
        return latestSecurityClearanceDate;
    }

    /**
     * Sets the value of the latestSecurityClearanceDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestSecurityClearanceDateType }
     *     
     */
    public void setLatestSecurityClearanceDate(
        @Nullable
        LatestSecurityClearanceDateType value) {
        this.latestSecurityClearanceDate = value;
    }

    /**
     * Gets the value of the documentationFeeAmount property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentationFeeAmountType }
     *     
     */
    @Nullable
    public DocumentationFeeAmountType getDocumentationFeeAmount() {
        return documentationFeeAmount;
    }

    /**
     * Sets the value of the documentationFeeAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentationFeeAmountType }
     *     
     */
    public void setDocumentationFeeAmount(
        @Nullable
        DocumentationFeeAmountType value) {
        this.documentationFeeAmount = value;
    }

    /**
     * Gets the value of the multipleTendersCode property.
     * 
     * @return
     *     possible object is
     *     {@link MultipleTendersCodeType }
     *     
     */
    @Nullable
    public MultipleTendersCodeType getMultipleTendersCode() {
        return multipleTendersCode;
    }

    /**
     * Sets the value of the multipleTendersCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MultipleTendersCodeType }
     *     
     */
    public void setMultipleTendersCode(
        @Nullable
        MultipleTendersCodeType value) {
        this.multipleTendersCode = value;
    }

    /**
     * Gets the value of the penaltyClause property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the penaltyClause property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPenaltyClause().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ClauseType }
     * </p>
     * 
     * 
     * @return
     *     The value of the penaltyClause property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ClauseType> getPenaltyClause() {
        if (penaltyClause == null) {
            penaltyClause = new ArrayList<>();
        }
        return this.penaltyClause;
    }

    /**
     * Gets the value of the requiredFinancialGuarantee property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the requiredFinancialGuarantee property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRequiredFinancialGuarantee().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialGuaranteeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the requiredFinancialGuarantee property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FinancialGuaranteeType> getRequiredFinancialGuarantee() {
        if (requiredFinancialGuarantee == null) {
            requiredFinancialGuarantee = new ArrayList<>();
        }
        return this.requiredFinancialGuarantee;
    }

    /**
     * Gets the value of the procurementLegislationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the procurementLegislationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getProcurementLegislationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the procurementLegislationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getProcurementLegislationDocumentReference() {
        if (procurementLegislationDocumentReference == null) {
            procurementLegislationDocumentReference = new ArrayList<>();
        }
        return this.procurementLegislationDocumentReference;
    }

    /**
     * Gets the value of the fiscalLegislationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fiscalLegislationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFiscalLegislationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the fiscalLegislationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getFiscalLegislationDocumentReference() {
        if (fiscalLegislationDocumentReference == null) {
            fiscalLegislationDocumentReference = new ArrayList<>();
        }
        return this.fiscalLegislationDocumentReference;
    }

    /**
     * Gets the value of the environmentalLegislationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the environmentalLegislationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEnvironmentalLegislationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the environmentalLegislationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getEnvironmentalLegislationDocumentReference() {
        if (environmentalLegislationDocumentReference == null) {
            environmentalLegislationDocumentReference = new ArrayList<>();
        }
        return this.environmentalLegislationDocumentReference;
    }

    /**
     * Gets the value of the employmentLegislationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the employmentLegislationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEmploymentLegislationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the employmentLegislationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getEmploymentLegislationDocumentReference() {
        if (employmentLegislationDocumentReference == null) {
            employmentLegislationDocumentReference = new ArrayList<>();
        }
        return this.employmentLegislationDocumentReference;
    }

    /**
     * Gets the value of the contractualDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the contractualDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getContractualDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the contractualDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getContractualDocumentReference() {
        if (contractualDocumentReference == null) {
            contractualDocumentReference = new ArrayList<>();
        }
        return this.contractualDocumentReference;
    }

    /**
     * Gets the value of the callForTendersDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the callForTendersDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCallForTendersDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the callForTendersDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getCallForTendersDocumentReference() {
        if (callForTendersDocumentReference == null) {
            callForTendersDocumentReference = new ArrayList<>();
        }
        return this.callForTendersDocumentReference;
    }

    /**
     * Gets the value of the warrantyValidityPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getWarrantyValidityPeriod() {
        return warrantyValidityPeriod;
    }

    /**
     * Sets the value of the warrantyValidityPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setWarrantyValidityPeriod(
        @Nullable
        PeriodType value) {
        this.warrantyValidityPeriod = value;
    }

    /**
     * Gets the value of the paymentTerms property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentTerms property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPaymentTerms().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentTermsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the paymentTerms property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PaymentTermsType> getPaymentTerms() {
        if (paymentTerms == null) {
            paymentTerms = new ArrayList<>();
        }
        return this.paymentTerms;
    }

    /**
     * Gets the value of the tendererQualificationRequest property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tendererQualificationRequest property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTendererQualificationRequest().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TendererQualificationRequestType }
     * </p>
     * 
     * 
     * @return
     *     The value of the tendererQualificationRequest property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TendererQualificationRequestType> getTendererQualificationRequest() {
        if (tendererQualificationRequest == null) {
            tendererQualificationRequest = new ArrayList<>();
        }
        return this.tendererQualificationRequest;
    }

    /**
     * Gets the value of the allowedSubcontractTerms property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the allowedSubcontractTerms property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAllowedSubcontractTerms().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SubcontractTermsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the allowedSubcontractTerms property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SubcontractTermsType> getAllowedSubcontractTerms() {
        if (allowedSubcontractTerms == null) {
            allowedSubcontractTerms = new ArrayList<>();
        }
        return this.allowedSubcontractTerms;
    }

    /**
     * Gets the value of the tenderPreparation property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tenderPreparation property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTenderPreparation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TenderPreparationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the tenderPreparation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TenderPreparationType> getTenderPreparation() {
        if (tenderPreparation == null) {
            tenderPreparation = new ArrayList<>();
        }
        return this.tenderPreparation;
    }

    /**
     * Gets the value of the contractExecutionRequirement property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the contractExecutionRequirement property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getContractExecutionRequirement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ContractExecutionRequirementType }
     * </p>
     * 
     * 
     * @return
     *     The value of the contractExecutionRequirement property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ContractExecutionRequirementType> getContractExecutionRequirement() {
        if (contractExecutionRequirement == null) {
            contractExecutionRequirement = new ArrayList<>();
        }
        return this.contractExecutionRequirement;
    }

    /**
     * Gets the value of the awardingTerms property.
     * 
     * @return
     *     possible object is
     *     {@link AwardingTermsType }
     *     
     */
    @Nullable
    public AwardingTermsType getAwardingTerms() {
        return awardingTerms;
    }

    /**
     * Sets the value of the awardingTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link AwardingTermsType }
     *     
     */
    public void setAwardingTerms(
        @Nullable
        AwardingTermsType value) {
        this.awardingTerms = value;
    }

    /**
     * Gets the value of the additionalInformationParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getAdditionalInformationParty() {
        return additionalInformationParty;
    }

    /**
     * Sets the value of the additionalInformationParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setAdditionalInformationParty(
        @Nullable
        PartyType value) {
        this.additionalInformationParty = value;
    }

    /**
     * Gets the value of the documentProviderParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getDocumentProviderParty() {
        return documentProviderParty;
    }

    /**
     * Sets the value of the documentProviderParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setDocumentProviderParty(
        @Nullable
        PartyType value) {
        this.documentProviderParty = value;
    }

    /**
     * Gets the value of the tenderRecipientParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getTenderRecipientParty() {
        return tenderRecipientParty;
    }

    /**
     * Sets the value of the tenderRecipientParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setTenderRecipientParty(
        @Nullable
        PartyType value) {
        this.tenderRecipientParty = value;
    }

    /**
     * Gets the value of the contractResponsibleParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getContractResponsibleParty() {
        return contractResponsibleParty;
    }

    /**
     * Sets the value of the contractResponsibleParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setContractResponsibleParty(
        @Nullable
        PartyType value) {
        this.contractResponsibleParty = value;
    }

    /**
     * Gets the value of the tenderEvaluationParty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tenderEvaluationParty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTenderEvaluationParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the tenderEvaluationParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyType> getTenderEvaluationParty() {
        if (tenderEvaluationParty == null) {
            tenderEvaluationParty = new ArrayList<>();
        }
        return this.tenderEvaluationParty;
    }

    /**
     * Gets the value of the qualificationRequestRecipientParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getQualificationRequestRecipientParty() {
        return qualificationRequestRecipientParty;
    }

    /**
     * Sets the value of the qualificationRequestRecipientParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setQualificationRequestRecipientParty(
        @Nullable
        PartyType value) {
        this.qualificationRequestRecipientParty = value;
    }

    /**
     * Gets the value of the tenderValidityPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getTenderValidityPeriod() {
        return tenderValidityPeriod;
    }

    /**
     * Sets the value of the tenderValidityPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setTenderValidityPeriod(
        @Nullable
        PeriodType value) {
        this.tenderValidityPeriod = value;
    }

    /**
     * Gets the value of the contractAcceptancePeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getContractAcceptancePeriod() {
        return contractAcceptancePeriod;
    }

    /**
     * Sets the value of the contractAcceptancePeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setContractAcceptancePeriod(
        @Nullable
        PeriodType value) {
        this.contractAcceptancePeriod = value;
    }

    /**
     * Gets the value of the appealTerms property.
     * 
     * @return
     *     possible object is
     *     {@link AppealTermsType }
     *     
     */
    @Nullable
    public AppealTermsType getAppealTerms() {
        return appealTerms;
    }

    /**
     * Sets the value of the appealTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppealTermsType }
     *     
     */
    public void setAppealTerms(
        @Nullable
        AppealTermsType value) {
        this.appealTerms = value;
    }

    /**
     * Gets the value of the language property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the language property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getLanguage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageType }
     * </p>
     * 
     * 
     * @return
     *     The value of the language property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageType> getLanguage() {
        if (language == null) {
            language = new ArrayList<>();
        }
        return this.language;
    }

    /**
     * Gets the value of the budgetAccountLine property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the budgetAccountLine property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getBudgetAccountLine().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BudgetAccountLineType }
     * </p>
     * 
     * 
     * @return
     *     The value of the budgetAccountLine property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BudgetAccountLineType> getBudgetAccountLine() {
        if (budgetAccountLine == null) {
            budgetAccountLine = new ArrayList<>();
        }
        return this.budgetAccountLine;
    }

    /**
     * Gets the value of the replacedNoticeDocumentReference property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentReferenceType }
     *     
     */
    @Nullable
    public DocumentReferenceType getReplacedNoticeDocumentReference() {
        return replacedNoticeDocumentReference;
    }

    /**
     * Sets the value of the replacedNoticeDocumentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentReferenceType }
     *     
     */
    public void setReplacedNoticeDocumentReference(
        @Nullable
        DocumentReferenceType value) {
        this.replacedNoticeDocumentReference = value;
    }

    /**
     * Gets the value of the lotDistribution property.
     * 
     * @return
     *     possible object is
     *     {@link LotDistributionType }
     *     
     */
    @Nullable
    public LotDistributionType getLotDistribution() {
        return lotDistribution;
    }

    /**
     * Sets the value of the lotDistribution property.
     * 
     * @param value
     *     allowed object is
     *     {@link LotDistributionType }
     *     
     */
    public void setLotDistribution(
        @Nullable
        LotDistributionType value) {
        this.lotDistribution = value;
    }

    /**
     * Gets the value of the postAwardProcess property.
     * 
     * @return
     *     possible object is
     *     {@link PostAwardProcessType }
     *     
     */
    @Nullable
    public PostAwardProcessType getPostAwardProcess() {
        return postAwardProcess;
    }

    /**
     * Sets the value of the postAwardProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link PostAwardProcessType }
     *     
     */
    public void setPostAwardProcess(
        @Nullable
        PostAwardProcessType value) {
        this.postAwardProcess = value;
    }

    /**
     * Gets the value of the economicOperatorShortList property.
     * 
     * @return
     *     possible object is
     *     {@link EconomicOperatorShortListType }
     *     
     */
    @Nullable
    public EconomicOperatorShortListType getEconomicOperatorShortList() {
        return economicOperatorShortList;
    }

    /**
     * Sets the value of the economicOperatorShortList property.
     * 
     * @param value
     *     allowed object is
     *     {@link EconomicOperatorShortListType }
     *     
     */
    public void setEconomicOperatorShortList(
        @Nullable
        EconomicOperatorShortListType value) {
        this.economicOperatorShortList = value;
    }

    /**
     * Gets the value of the securityClearanceTerm property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the securityClearanceTerm property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSecurityClearanceTerm().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SecurityClearanceTermType }
     * </p>
     * 
     * 
     * @return
     *     The value of the securityClearanceTerm property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SecurityClearanceTermType> getSecurityClearanceTerm() {
        if (securityClearanceTerm == null) {
            securityClearanceTerm = new ArrayList<>();
        }
        return this.securityClearanceTerm;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TenderingTermsType rhs = ((TenderingTermsType) o);
        if (!EqualsHelper.equalsCollection(acceptedVariantsDescription, rhs.acceptedVariantsDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(additionalConditions, rhs.additionalConditions)) {
            return false;
        }
        if (!EqualsHelper.equals(additionalInformationParty, rhs.additionalInformationParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(allowedSubcontractTerms, rhs.allowedSubcontractTerms)) {
            return false;
        }
        if (!EqualsHelper.equals(appealTerms, rhs.appealTerms)) {
            return false;
        }
        if (!EqualsHelper.equals(awardingMethodTypeCode, rhs.awardingMethodTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(awardingTerms, rhs.awardingTerms)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(budgetAccountLine, rhs.budgetAccountLine)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(callForTendersDocumentReference, rhs.callForTendersDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(contractAcceptancePeriod, rhs.contractAcceptancePeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(contractExecutionRequirement, rhs.contractExecutionRequirement)) {
            return false;
        }
        if (!EqualsHelper.equals(contractResponsibleParty, rhs.contractResponsibleParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(contractualDocumentReference, rhs.contractualDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(documentProviderParty, rhs.documentProviderParty)) {
            return false;
        }
        if (!EqualsHelper.equals(documentationFeeAmount, rhs.documentationFeeAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(economicOperatorRegistryURI, rhs.economicOperatorRegistryURI)) {
            return false;
        }
        if (!EqualsHelper.equals(economicOperatorShortList, rhs.economicOperatorShortList)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(employmentLegislationDocumentReference, rhs.employmentLegislationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(environmentalLegislationDocumentReference, rhs.environmentalLegislationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(estimatedTimingFurtherPublication, rhs.estimatedTimingFurtherPublication)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(fiscalLegislationDocumentReference, rhs.fiscalLegislationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(fundingProgram, rhs.fundingProgram)) {
            return false;
        }
        if (!EqualsHelper.equals(fundingProgramCode, rhs.fundingProgramCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(language, rhs.language)) {
            return false;
        }
        if (!EqualsHelper.equals(latestSecurityClearanceDate, rhs.latestSecurityClearanceDate)) {
            return false;
        }
        if (!EqualsHelper.equals(lotDistribution, rhs.lotDistribution)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumAdvertisementAmount, rhs.maximumAdvertisementAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumVariantQuantity, rhs.maximumVariantQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(multipleTendersCode, rhs.multipleTendersCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equals(otherConditionsIndicator, rhs.otherConditionsIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(paymentFrequencyCode, rhs.paymentFrequencyCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(paymentTerms, rhs.paymentTerms)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(penaltyClause, rhs.penaltyClause)) {
            return false;
        }
        if (!EqualsHelper.equals(postAwardProcess, rhs.postAwardProcess)) {
            return false;
        }
        if (!EqualsHelper.equals(priceEvaluationCode, rhs.priceEvaluationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(priceRevisionFormulaDescription, rhs.priceRevisionFormulaDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(procurementLegislationDocumentReference, rhs.procurementLegislationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(qualificationRequestRecipientParty, rhs.qualificationRequestRecipientParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(recurringProcurementDescription, rhs.recurringProcurementDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(recurringProcurementIndicator, rhs.recurringProcurementIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(replacedNoticeDocumentReference, rhs.replacedNoticeDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(requiredCurriculaCode, rhs.requiredCurriculaCode)) {
            return false;
        }
        if (!EqualsHelper.equals(requiredCurriculaIndicator, rhs.requiredCurriculaIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requiredFinancialGuarantee, rhs.requiredFinancialGuarantee)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(securityClearanceTerm, rhs.securityClearanceTerm)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(tenderEvaluationParty, rhs.tenderEvaluationParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(tenderPreparation, rhs.tenderPreparation)) {
            return false;
        }
        if (!EqualsHelper.equals(tenderRecipientParty, rhs.tenderRecipientParty)) {
            return false;
        }
        if (!EqualsHelper.equals(tenderValidityPeriod, rhs.tenderValidityPeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(tendererQualificationRequest, rhs.tendererQualificationRequest)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(variantConstraintCode, rhs.variantConstraintCode)) {
            return false;
        }
        if (!EqualsHelper.equals(variantConstraintIndicator, rhs.variantConstraintIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(warrantyValidityPeriod, rhs.warrantyValidityPeriod)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(acceptedVariantsDescription).append(additionalConditions).append(additionalInformationParty).append(allowedSubcontractTerms).append(appealTerms).append(awardingMethodTypeCode).append(awardingTerms).append(budgetAccountLine).append(callForTendersDocumentReference).append(contractAcceptancePeriod).append(contractExecutionRequirement).append(contractResponsibleParty).append(contractualDocumentReference).append(documentProviderParty).append(documentationFeeAmount).append(economicOperatorRegistryURI).append(economicOperatorShortList).append(employmentLegislationDocumentReference).append(environmentalLegislationDocumentReference).append(estimatedTimingFurtherPublication).append(fiscalLegislationDocumentReference).append(fundingProgram).append(fundingProgramCode).append(language).append(latestSecurityClearanceDate).append(lotDistribution).append(maximumAdvertisementAmount).append(maximumVariantQuantity).append(multipleTendersCode).append(note).append(otherConditionsIndicator).append(paymentFrequencyCode).append(paymentTerms).append(penaltyClause).append(postAwardProcess).append(priceEvaluationCode).append(priceRevisionFormulaDescription).append(procurementLegislationDocumentReference).append(qualificationRequestRecipientParty).append(recurringProcurementDescription).append(recurringProcurementIndicator).append(replacedNoticeDocumentReference).append(requiredCurriculaCode).append(requiredCurriculaIndicator).append(requiredFinancialGuarantee).append(securityClearanceTerm).append(tenderEvaluationParty).append(tenderPreparation).append(tenderRecipientParty).append(tenderValidityPeriod).append(tendererQualificationRequest).append(ublExtensions).append(variantConstraintCode).append(variantConstraintIndicator).append(warrantyValidityPeriod).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("acceptedVariantsDescription", acceptedVariantsDescription).append("additionalConditions", additionalConditions).append("additionalInformationParty", additionalInformationParty).append("allowedSubcontractTerms", allowedSubcontractTerms).append("appealTerms", appealTerms).append("awardingMethodTypeCode", awardingMethodTypeCode).append("awardingTerms", awardingTerms).append("budgetAccountLine", budgetAccountLine).append("callForTendersDocumentReference", callForTendersDocumentReference).append("contractAcceptancePeriod", contractAcceptancePeriod).append("contractExecutionRequirement", contractExecutionRequirement).append("contractResponsibleParty", contractResponsibleParty).append("contractualDocumentReference", contractualDocumentReference).append("documentProviderParty", documentProviderParty).append("documentationFeeAmount", documentationFeeAmount).append("economicOperatorRegistryURI", economicOperatorRegistryURI).append("economicOperatorShortList", economicOperatorShortList).append("employmentLegislationDocumentReference", employmentLegislationDocumentReference).append("environmentalLegislationDocumentReference", environmentalLegislationDocumentReference).append("estimatedTimingFurtherPublication", estimatedTimingFurtherPublication).append("fiscalLegislationDocumentReference", fiscalLegislationDocumentReference).append("fundingProgram", fundingProgram).append("fundingProgramCode", fundingProgramCode).append("language", language).append("latestSecurityClearanceDate", latestSecurityClearanceDate).append("lotDistribution", lotDistribution).append("maximumAdvertisementAmount", maximumAdvertisementAmount).append("maximumVariantQuantity", maximumVariantQuantity).append("multipleTendersCode", multipleTendersCode).append("note", note).append("otherConditionsIndicator", otherConditionsIndicator).append("paymentFrequencyCode", paymentFrequencyCode).append("paymentTerms", paymentTerms).append("penaltyClause", penaltyClause).append("postAwardProcess", postAwardProcess).append("priceEvaluationCode", priceEvaluationCode).append("priceRevisionFormulaDescription", priceRevisionFormulaDescription).append("procurementLegislationDocumentReference", procurementLegislationDocumentReference).append("qualificationRequestRecipientParty", qualificationRequestRecipientParty).append("recurringProcurementDescription", recurringProcurementDescription).append("recurringProcurementIndicator", recurringProcurementIndicator).append("replacedNoticeDocumentReference", replacedNoticeDocumentReference).append("requiredCurriculaCode", requiredCurriculaCode).append("requiredCurriculaIndicator", requiredCurriculaIndicator).append("requiredFinancialGuarantee", requiredFinancialGuarantee).append("securityClearanceTerm", securityClearanceTerm).append("tenderEvaluationParty", tenderEvaluationParty).append("tenderPreparation", tenderPreparation).append("tenderRecipientParty", tenderRecipientParty).append("tenderValidityPeriod", tenderValidityPeriod).append("tendererQualificationRequest", tendererQualificationRequest).append("ublExtensions", ublExtensions).append("variantConstraintCode", variantConstraintCode).append("variantConstraintIndicator", variantConstraintIndicator).append("warrantyValidityPeriod", warrantyValidityPeriod).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAcceptedVariantsDescription(
        @Nullable
        final List<AcceptedVariantsDescriptionType> aList) {
        acceptedVariantsDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPriceRevisionFormulaDescription(
        @Nullable
        final List<PriceRevisionFormulaDescriptionType> aList) {
        priceRevisionFormulaDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFundingProgram(
        @Nullable
        final List<FundingProgramType> aList) {
        fundingProgram = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRecurringProcurementDescription(
        @Nullable
        final List<RecurringProcurementDescriptionType> aList) {
        recurringProcurementDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEstimatedTimingFurtherPublication(
        @Nullable
        final List<EstimatedTimingFurtherPublicationType> aList) {
        estimatedTimingFurtherPublication = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalConditions(
        @Nullable
        final List<AdditionalConditionsType> aList) {
        additionalConditions = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPenaltyClause(
        @Nullable
        final List<ClauseType> aList) {
        penaltyClause = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequiredFinancialGuarantee(
        @Nullable
        final List<FinancialGuaranteeType> aList) {
        requiredFinancialGuarantee = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProcurementLegislationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        procurementLegislationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFiscalLegislationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        fiscalLegislationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEnvironmentalLegislationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        environmentalLegislationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEmploymentLegislationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        employmentLegislationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContractualDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        contractualDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCallForTendersDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        callForTendersDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPaymentTerms(
        @Nullable
        final List<PaymentTermsType> aList) {
        paymentTerms = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTendererQualificationRequest(
        @Nullable
        final List<TendererQualificationRequestType> aList) {
        tendererQualificationRequest = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAllowedSubcontractTerms(
        @Nullable
        final List<SubcontractTermsType> aList) {
        allowedSubcontractTerms = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTenderPreparation(
        @Nullable
        final List<TenderPreparationType> aList) {
        tenderPreparation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContractExecutionRequirement(
        @Nullable
        final List<ContractExecutionRequirementType> aList) {
        contractExecutionRequirement = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTenderEvaluationParty(
        @Nullable
        final List<PartyType> aList) {
        tenderEvaluationParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLanguage(
        @Nullable
        final List<LanguageType> aList) {
        language = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBudgetAccountLine(
        @Nullable
        final List<BudgetAccountLineType> aList) {
        budgetAccountLine = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSecurityClearanceTerm(
        @Nullable
        final List<SecurityClearanceTermType> aList) {
        securityClearanceTerm = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAcceptedVariantsDescriptionEntries() {
        return (!getAcceptedVariantsDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAcceptedVariantsDescriptionEntries() {
        return getAcceptedVariantsDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAcceptedVariantsDescriptionCount() {
        return getAcceptedVariantsDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AcceptedVariantsDescriptionType getAcceptedVariantsDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAcceptedVariantsDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAcceptedVariantsDescription(
        @Nonnull
        final AcceptedVariantsDescriptionType elem) {
        getAcceptedVariantsDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPriceRevisionFormulaDescriptionEntries() {
        return (!getPriceRevisionFormulaDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPriceRevisionFormulaDescriptionEntries() {
        return getPriceRevisionFormulaDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPriceRevisionFormulaDescriptionCount() {
        return getPriceRevisionFormulaDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PriceRevisionFormulaDescriptionType getPriceRevisionFormulaDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPriceRevisionFormulaDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPriceRevisionFormulaDescription(
        @Nonnull
        final PriceRevisionFormulaDescriptionType elem) {
        getPriceRevisionFormulaDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFundingProgramEntries() {
        return (!getFundingProgram().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFundingProgramEntries() {
        return getFundingProgram().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFundingProgramCount() {
        return getFundingProgram().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FundingProgramType getFundingProgramAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFundingProgram().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFundingProgram(
        @Nonnull
        final FundingProgramType elem) {
        getFundingProgram().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRecurringProcurementDescriptionEntries() {
        return (!getRecurringProcurementDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRecurringProcurementDescriptionEntries() {
        return getRecurringProcurementDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRecurringProcurementDescriptionCount() {
        return getRecurringProcurementDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RecurringProcurementDescriptionType getRecurringProcurementDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRecurringProcurementDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRecurringProcurementDescription(
        @Nonnull
        final RecurringProcurementDescriptionType elem) {
        getRecurringProcurementDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEstimatedTimingFurtherPublicationEntries() {
        return (!getEstimatedTimingFurtherPublication().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEstimatedTimingFurtherPublicationEntries() {
        return getEstimatedTimingFurtherPublication().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEstimatedTimingFurtherPublicationCount() {
        return getEstimatedTimingFurtherPublication().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EstimatedTimingFurtherPublicationType getEstimatedTimingFurtherPublicationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEstimatedTimingFurtherPublication().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEstimatedTimingFurtherPublication(
        @Nonnull
        final EstimatedTimingFurtherPublicationType elem) {
        getEstimatedTimingFurtherPublication().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalConditionsEntries() {
        return (!getAdditionalConditions().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalConditionsEntries() {
        return getAdditionalConditions().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalConditionsCount() {
        return getAdditionalConditions().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AdditionalConditionsType getAdditionalConditionsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalConditions().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalConditions(
        @Nonnull
        final AdditionalConditionsType elem) {
        getAdditionalConditions().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPenaltyClauseEntries() {
        return (!getPenaltyClause().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPenaltyClauseEntries() {
        return getPenaltyClause().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPenaltyClauseCount() {
        return getPenaltyClause().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ClauseType getPenaltyClauseAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPenaltyClause().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPenaltyClause(
        @Nonnull
        final ClauseType elem) {
        getPenaltyClause().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequiredFinancialGuaranteeEntries() {
        return (!getRequiredFinancialGuarantee().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequiredFinancialGuaranteeEntries() {
        return getRequiredFinancialGuarantee().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequiredFinancialGuaranteeCount() {
        return getRequiredFinancialGuarantee().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FinancialGuaranteeType getRequiredFinancialGuaranteeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequiredFinancialGuarantee().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequiredFinancialGuarantee(
        @Nonnull
        final FinancialGuaranteeType elem) {
        getRequiredFinancialGuarantee().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProcurementLegislationDocumentReferenceEntries() {
        return (!getProcurementLegislationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProcurementLegislationDocumentReferenceEntries() {
        return getProcurementLegislationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProcurementLegislationDocumentReferenceCount() {
        return getProcurementLegislationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getProcurementLegislationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProcurementLegislationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProcurementLegislationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getProcurementLegislationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFiscalLegislationDocumentReferenceEntries() {
        return (!getFiscalLegislationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFiscalLegislationDocumentReferenceEntries() {
        return getFiscalLegislationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFiscalLegislationDocumentReferenceCount() {
        return getFiscalLegislationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getFiscalLegislationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFiscalLegislationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFiscalLegislationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getFiscalLegislationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEnvironmentalLegislationDocumentReferenceEntries() {
        return (!getEnvironmentalLegislationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEnvironmentalLegislationDocumentReferenceEntries() {
        return getEnvironmentalLegislationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEnvironmentalLegislationDocumentReferenceCount() {
        return getEnvironmentalLegislationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getEnvironmentalLegislationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEnvironmentalLegislationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEnvironmentalLegislationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getEnvironmentalLegislationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEmploymentLegislationDocumentReferenceEntries() {
        return (!getEmploymentLegislationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEmploymentLegislationDocumentReferenceEntries() {
        return getEmploymentLegislationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEmploymentLegislationDocumentReferenceCount() {
        return getEmploymentLegislationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getEmploymentLegislationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEmploymentLegislationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEmploymentLegislationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getEmploymentLegislationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContractualDocumentReferenceEntries() {
        return (!getContractualDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContractualDocumentReferenceEntries() {
        return getContractualDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContractualDocumentReferenceCount() {
        return getContractualDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getContractualDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContractualDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContractualDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getContractualDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCallForTendersDocumentReferenceEntries() {
        return (!getCallForTendersDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCallForTendersDocumentReferenceEntries() {
        return getCallForTendersDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCallForTendersDocumentReferenceCount() {
        return getCallForTendersDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getCallForTendersDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCallForTendersDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCallForTendersDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getCallForTendersDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPaymentTermsEntries() {
        return (!getPaymentTerms().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPaymentTermsEntries() {
        return getPaymentTerms().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPaymentTermsCount() {
        return getPaymentTerms().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PaymentTermsType getPaymentTermsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPaymentTerms().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPaymentTerms(
        @Nonnull
        final PaymentTermsType elem) {
        getPaymentTerms().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTendererQualificationRequestEntries() {
        return (!getTendererQualificationRequest().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTendererQualificationRequestEntries() {
        return getTendererQualificationRequest().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTendererQualificationRequestCount() {
        return getTendererQualificationRequest().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TendererQualificationRequestType getTendererQualificationRequestAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTendererQualificationRequest().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTendererQualificationRequest(
        @Nonnull
        final TendererQualificationRequestType elem) {
        getTendererQualificationRequest().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAllowedSubcontractTermsEntries() {
        return (!getAllowedSubcontractTerms().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAllowedSubcontractTermsEntries() {
        return getAllowedSubcontractTerms().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAllowedSubcontractTermsCount() {
        return getAllowedSubcontractTerms().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SubcontractTermsType getAllowedSubcontractTermsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAllowedSubcontractTerms().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAllowedSubcontractTerms(
        @Nonnull
        final SubcontractTermsType elem) {
        getAllowedSubcontractTerms().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTenderPreparationEntries() {
        return (!getTenderPreparation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTenderPreparationEntries() {
        return getTenderPreparation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTenderPreparationCount() {
        return getTenderPreparation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TenderPreparationType getTenderPreparationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTenderPreparation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTenderPreparation(
        @Nonnull
        final TenderPreparationType elem) {
        getTenderPreparation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContractExecutionRequirementEntries() {
        return (!getContractExecutionRequirement().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContractExecutionRequirementEntries() {
        return getContractExecutionRequirement().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContractExecutionRequirementCount() {
        return getContractExecutionRequirement().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ContractExecutionRequirementType getContractExecutionRequirementAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContractExecutionRequirement().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContractExecutionRequirement(
        @Nonnull
        final ContractExecutionRequirementType elem) {
        getContractExecutionRequirement().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTenderEvaluationPartyEntries() {
        return (!getTenderEvaluationParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTenderEvaluationPartyEntries() {
        return getTenderEvaluationParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTenderEvaluationPartyCount() {
        return getTenderEvaluationParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyType getTenderEvaluationPartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTenderEvaluationParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTenderEvaluationParty(
        @Nonnull
        final PartyType elem) {
        getTenderEvaluationParty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLanguageEntries() {
        return (!getLanguage().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLanguageEntries() {
        return getLanguage().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLanguageCount() {
        return getLanguage().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageType getLanguageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLanguage().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLanguage(
        @Nonnull
        final LanguageType elem) {
        getLanguage().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBudgetAccountLineEntries() {
        return (!getBudgetAccountLine().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBudgetAccountLineEntries() {
        return getBudgetAccountLine().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBudgetAccountLineCount() {
        return getBudgetAccountLine().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BudgetAccountLineType getBudgetAccountLineAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBudgetAccountLine().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBudgetAccountLine(
        @Nonnull
        final BudgetAccountLineType elem) {
        getBudgetAccountLine().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSecurityClearanceTermEntries() {
        return (!getSecurityClearanceTerm().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSecurityClearanceTermEntries() {
        return getSecurityClearanceTerm().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSecurityClearanceTermCount() {
        return getSecurityClearanceTerm().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SecurityClearanceTermType getSecurityClearanceTermAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSecurityClearanceTerm().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSecurityClearanceTerm(
        @Nonnull
        final SecurityClearanceTermType elem) {
        getSecurityClearanceTerm().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TenderingTermsType ret) {
        if (acceptedVariantsDescription == null) {
            ret.acceptedVariantsDescription = null;
        } else {
            List<AcceptedVariantsDescriptionType> retAcceptedVariantsDescription = new ArrayList<>();
            for (AcceptedVariantsDescriptionType aItem: getAcceptedVariantsDescription()) {
                retAcceptedVariantsDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.acceptedVariantsDescription = retAcceptedVariantsDescription;
        }
        if (additionalConditions == null) {
            ret.additionalConditions = null;
        } else {
            List<AdditionalConditionsType> retAdditionalConditions = new ArrayList<>();
            for (AdditionalConditionsType aItem: getAdditionalConditions()) {
                retAdditionalConditions.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalConditions = retAdditionalConditions;
        }
        ret.additionalInformationParty = ((additionalInformationParty == null)?null:additionalInformationParty.clone());
        if (allowedSubcontractTerms == null) {
            ret.allowedSubcontractTerms = null;
        } else {
            List<SubcontractTermsType> retAllowedSubcontractTerms = new ArrayList<>();
            for (SubcontractTermsType aItem: getAllowedSubcontractTerms()) {
                retAllowedSubcontractTerms.add(((aItem == null)?null:aItem.clone()));
            }
            ret.allowedSubcontractTerms = retAllowedSubcontractTerms;
        }
        ret.appealTerms = ((appealTerms == null)?null:appealTerms.clone());
        ret.awardingMethodTypeCode = ((awardingMethodTypeCode == null)?null:awardingMethodTypeCode.clone());
        ret.awardingTerms = ((awardingTerms == null)?null:awardingTerms.clone());
        if (budgetAccountLine == null) {
            ret.budgetAccountLine = null;
        } else {
            List<BudgetAccountLineType> retBudgetAccountLine = new ArrayList<>();
            for (BudgetAccountLineType aItem: getBudgetAccountLine()) {
                retBudgetAccountLine.add(((aItem == null)?null:aItem.clone()));
            }
            ret.budgetAccountLine = retBudgetAccountLine;
        }
        if (callForTendersDocumentReference == null) {
            ret.callForTendersDocumentReference = null;
        } else {
            List<DocumentReferenceType> retCallForTendersDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getCallForTendersDocumentReference()) {
                retCallForTendersDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.callForTendersDocumentReference = retCallForTendersDocumentReference;
        }
        ret.contractAcceptancePeriod = ((contractAcceptancePeriod == null)?null:contractAcceptancePeriod.clone());
        if (contractExecutionRequirement == null) {
            ret.contractExecutionRequirement = null;
        } else {
            List<ContractExecutionRequirementType> retContractExecutionRequirement = new ArrayList<>();
            for (ContractExecutionRequirementType aItem: getContractExecutionRequirement()) {
                retContractExecutionRequirement.add(((aItem == null)?null:aItem.clone()));
            }
            ret.contractExecutionRequirement = retContractExecutionRequirement;
        }
        ret.contractResponsibleParty = ((contractResponsibleParty == null)?null:contractResponsibleParty.clone());
        if (contractualDocumentReference == null) {
            ret.contractualDocumentReference = null;
        } else {
            List<DocumentReferenceType> retContractualDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getContractualDocumentReference()) {
                retContractualDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.contractualDocumentReference = retContractualDocumentReference;
        }
        ret.documentProviderParty = ((documentProviderParty == null)?null:documentProviderParty.clone());
        ret.documentationFeeAmount = ((documentationFeeAmount == null)?null:documentationFeeAmount.clone());
        ret.economicOperatorRegistryURI = ((economicOperatorRegistryURI == null)?null:economicOperatorRegistryURI.clone());
        ret.economicOperatorShortList = ((economicOperatorShortList == null)?null:economicOperatorShortList.clone());
        if (employmentLegislationDocumentReference == null) {
            ret.employmentLegislationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retEmploymentLegislationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getEmploymentLegislationDocumentReference()) {
                retEmploymentLegislationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.employmentLegislationDocumentReference = retEmploymentLegislationDocumentReference;
        }
        if (environmentalLegislationDocumentReference == null) {
            ret.environmentalLegislationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retEnvironmentalLegislationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getEnvironmentalLegislationDocumentReference()) {
                retEnvironmentalLegislationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.environmentalLegislationDocumentReference = retEnvironmentalLegislationDocumentReference;
        }
        if (estimatedTimingFurtherPublication == null) {
            ret.estimatedTimingFurtherPublication = null;
        } else {
            List<EstimatedTimingFurtherPublicationType> retEstimatedTimingFurtherPublication = new ArrayList<>();
            for (EstimatedTimingFurtherPublicationType aItem: getEstimatedTimingFurtherPublication()) {
                retEstimatedTimingFurtherPublication.add(((aItem == null)?null:aItem.clone()));
            }
            ret.estimatedTimingFurtherPublication = retEstimatedTimingFurtherPublication;
        }
        if (fiscalLegislationDocumentReference == null) {
            ret.fiscalLegislationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retFiscalLegislationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getFiscalLegislationDocumentReference()) {
                retFiscalLegislationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.fiscalLegislationDocumentReference = retFiscalLegislationDocumentReference;
        }
        if (fundingProgram == null) {
            ret.fundingProgram = null;
        } else {
            List<FundingProgramType> retFundingProgram = new ArrayList<>();
            for (FundingProgramType aItem: getFundingProgram()) {
                retFundingProgram.add(((aItem == null)?null:aItem.clone()));
            }
            ret.fundingProgram = retFundingProgram;
        }
        ret.fundingProgramCode = ((fundingProgramCode == null)?null:fundingProgramCode.clone());
        if (language == null) {
            ret.language = null;
        } else {
            List<LanguageType> retLanguage = new ArrayList<>();
            for (LanguageType aItem: getLanguage()) {
                retLanguage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.language = retLanguage;
        }
        ret.latestSecurityClearanceDate = ((latestSecurityClearanceDate == null)?null:latestSecurityClearanceDate.clone());
        ret.lotDistribution = ((lotDistribution == null)?null:lotDistribution.clone());
        ret.maximumAdvertisementAmount = ((maximumAdvertisementAmount == null)?null:maximumAdvertisementAmount.clone());
        ret.maximumVariantQuantity = ((maximumVariantQuantity == null)?null:maximumVariantQuantity.clone());
        ret.multipleTendersCode = ((multipleTendersCode == null)?null:multipleTendersCode.clone());
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        ret.otherConditionsIndicator = ((otherConditionsIndicator == null)?null:otherConditionsIndicator.clone());
        ret.paymentFrequencyCode = ((paymentFrequencyCode == null)?null:paymentFrequencyCode.clone());
        if (paymentTerms == null) {
            ret.paymentTerms = null;
        } else {
            List<PaymentTermsType> retPaymentTerms = new ArrayList<>();
            for (PaymentTermsType aItem: getPaymentTerms()) {
                retPaymentTerms.add(((aItem == null)?null:aItem.clone()));
            }
            ret.paymentTerms = retPaymentTerms;
        }
        if (penaltyClause == null) {
            ret.penaltyClause = null;
        } else {
            List<ClauseType> retPenaltyClause = new ArrayList<>();
            for (ClauseType aItem: getPenaltyClause()) {
                retPenaltyClause.add(((aItem == null)?null:aItem.clone()));
            }
            ret.penaltyClause = retPenaltyClause;
        }
        ret.postAwardProcess = ((postAwardProcess == null)?null:postAwardProcess.clone());
        ret.priceEvaluationCode = ((priceEvaluationCode == null)?null:priceEvaluationCode.clone());
        if (priceRevisionFormulaDescription == null) {
            ret.priceRevisionFormulaDescription = null;
        } else {
            List<PriceRevisionFormulaDescriptionType> retPriceRevisionFormulaDescription = new ArrayList<>();
            for (PriceRevisionFormulaDescriptionType aItem: getPriceRevisionFormulaDescription()) {
                retPriceRevisionFormulaDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.priceRevisionFormulaDescription = retPriceRevisionFormulaDescription;
        }
        if (procurementLegislationDocumentReference == null) {
            ret.procurementLegislationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retProcurementLegislationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getProcurementLegislationDocumentReference()) {
                retProcurementLegislationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.procurementLegislationDocumentReference = retProcurementLegislationDocumentReference;
        }
        ret.qualificationRequestRecipientParty = ((qualificationRequestRecipientParty == null)?null:qualificationRequestRecipientParty.clone());
        if (recurringProcurementDescription == null) {
            ret.recurringProcurementDescription = null;
        } else {
            List<RecurringProcurementDescriptionType> retRecurringProcurementDescription = new ArrayList<>();
            for (RecurringProcurementDescriptionType aItem: getRecurringProcurementDescription()) {
                retRecurringProcurementDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.recurringProcurementDescription = retRecurringProcurementDescription;
        }
        ret.recurringProcurementIndicator = ((recurringProcurementIndicator == null)?null:recurringProcurementIndicator.clone());
        ret.replacedNoticeDocumentReference = ((replacedNoticeDocumentReference == null)?null:replacedNoticeDocumentReference.clone());
        ret.requiredCurriculaCode = ((requiredCurriculaCode == null)?null:requiredCurriculaCode.clone());
        ret.requiredCurriculaIndicator = ((requiredCurriculaIndicator == null)?null:requiredCurriculaIndicator.clone());
        if (requiredFinancialGuarantee == null) {
            ret.requiredFinancialGuarantee = null;
        } else {
            List<FinancialGuaranteeType> retRequiredFinancialGuarantee = new ArrayList<>();
            for (FinancialGuaranteeType aItem: getRequiredFinancialGuarantee()) {
                retRequiredFinancialGuarantee.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requiredFinancialGuarantee = retRequiredFinancialGuarantee;
        }
        if (securityClearanceTerm == null) {
            ret.securityClearanceTerm = null;
        } else {
            List<SecurityClearanceTermType> retSecurityClearanceTerm = new ArrayList<>();
            for (SecurityClearanceTermType aItem: getSecurityClearanceTerm()) {
                retSecurityClearanceTerm.add(((aItem == null)?null:aItem.clone()));
            }
            ret.securityClearanceTerm = retSecurityClearanceTerm;
        }
        if (tenderEvaluationParty == null) {
            ret.tenderEvaluationParty = null;
        } else {
            List<PartyType> retTenderEvaluationParty = new ArrayList<>();
            for (PartyType aItem: getTenderEvaluationParty()) {
                retTenderEvaluationParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.tenderEvaluationParty = retTenderEvaluationParty;
        }
        if (tenderPreparation == null) {
            ret.tenderPreparation = null;
        } else {
            List<TenderPreparationType> retTenderPreparation = new ArrayList<>();
            for (TenderPreparationType aItem: getTenderPreparation()) {
                retTenderPreparation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.tenderPreparation = retTenderPreparation;
        }
        ret.tenderRecipientParty = ((tenderRecipientParty == null)?null:tenderRecipientParty.clone());
        ret.tenderValidityPeriod = ((tenderValidityPeriod == null)?null:tenderValidityPeriod.clone());
        if (tendererQualificationRequest == null) {
            ret.tendererQualificationRequest = null;
        } else {
            List<TendererQualificationRequestType> retTendererQualificationRequest = new ArrayList<>();
            for (TendererQualificationRequestType aItem: getTendererQualificationRequest()) {
                retTendererQualificationRequest.add(((aItem == null)?null:aItem.clone()));
            }
            ret.tendererQualificationRequest = retTendererQualificationRequest;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.variantConstraintCode = ((variantConstraintCode == null)?null:variantConstraintCode.clone());
        ret.variantConstraintIndicator = ((variantConstraintIndicator == null)?null:variantConstraintIndicator.clone());
        ret.warrantyValidityPeriod = ((warrantyValidityPeriod == null)?null:warrantyValidityPeriod.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TenderingTermsType clone() {
        TenderingTermsType ret = new TenderingTermsType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AwardingMethodTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public AwardingMethodTypeCodeType setAwardingMethodTypeCode(
        @Nullable
        final String valueParam) {
        AwardingMethodTypeCodeType aObj = getAwardingMethodTypeCode();
        if (aObj == null) {
            aObj = new AwardingMethodTypeCodeType(valueParam);
            setAwardingMethodTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PriceEvaluationCodeType and never <code>null</code>
     */
    @Nonnull
    public PriceEvaluationCodeType setPriceEvaluationCode(
        @Nullable
        final String valueParam) {
        PriceEvaluationCodeType aObj = getPriceEvaluationCode();
        if (aObj == null) {
            aObj = new PriceEvaluationCodeType(valueParam);
            setPriceEvaluationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumVariantQuantityType and never <code>null</code>
     */
    @Nonnull
    public MaximumVariantQuantityType setMaximumVariantQuantity(
        @Nullable
        final BigDecimal valueParam) {
        MaximumVariantQuantityType aObj = getMaximumVariantQuantity();
        if (aObj == null) {
            aObj = new MaximumVariantQuantityType(valueParam);
            setMaximumVariantQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type VariantConstraintIndicatorType and never <code>null</code>
     */
    @Nonnull
    public VariantConstraintIndicatorType setVariantConstraintIndicator(final boolean valueParam) {
        VariantConstraintIndicatorType aObj = getVariantConstraintIndicator();
        if (aObj == null) {
            aObj = new VariantConstraintIndicatorType(valueParam);
            setVariantConstraintIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VariantConstraintCodeType and never <code>null</code>
     */
    @Nonnull
    public VariantConstraintCodeType setVariantConstraintCode(
        @Nullable
        final String valueParam) {
        VariantConstraintCodeType aObj = getVariantConstraintCode();
        if (aObj == null) {
            aObj = new VariantConstraintCodeType(valueParam);
            setVariantConstraintCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FundingProgramCodeType and never <code>null</code>
     */
    @Nonnull
    public FundingProgramCodeType setFundingProgramCode(
        @Nullable
        final String valueParam) {
        FundingProgramCodeType aObj = getFundingProgramCode();
        if (aObj == null) {
            aObj = new FundingProgramCodeType(valueParam);
            setFundingProgramCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumAdvertisementAmountType and never <code>null</code>
     */
    @Nonnull
    public MaximumAdvertisementAmountType setMaximumAdvertisementAmount(
        @Nullable
        final BigDecimal valueParam) {
        MaximumAdvertisementAmountType aObj = getMaximumAdvertisementAmount();
        if (aObj == null) {
            aObj = new MaximumAdvertisementAmountType(valueParam);
            setMaximumAdvertisementAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentFrequencyCodeType and never <code>null</code>
     */
    @Nonnull
    public PaymentFrequencyCodeType setPaymentFrequencyCode(
        @Nullable
        final String valueParam) {
        PaymentFrequencyCodeType aObj = getPaymentFrequencyCode();
        if (aObj == null) {
            aObj = new PaymentFrequencyCodeType(valueParam);
            setPaymentFrequencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EconomicOperatorRegistryURIType and never <code>null</code>
     */
    @Nonnull
    public EconomicOperatorRegistryURIType setEconomicOperatorRegistryURI(
        @Nullable
        final String valueParam) {
        EconomicOperatorRegistryURIType aObj = getEconomicOperatorRegistryURI();
        if (aObj == null) {
            aObj = new EconomicOperatorRegistryURIType(valueParam);
            setEconomicOperatorRegistryURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type RequiredCurriculaIndicatorType and never <code>null</code>
     */
    @Nonnull
    public RequiredCurriculaIndicatorType setRequiredCurriculaIndicator(final boolean valueParam) {
        RequiredCurriculaIndicatorType aObj = getRequiredCurriculaIndicator();
        if (aObj == null) {
            aObj = new RequiredCurriculaIndicatorType(valueParam);
            setRequiredCurriculaIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequiredCurriculaCodeType and never <code>null</code>
     */
    @Nonnull
    public RequiredCurriculaCodeType setRequiredCurriculaCode(
        @Nullable
        final String valueParam) {
        RequiredCurriculaCodeType aObj = getRequiredCurriculaCode();
        if (aObj == null) {
            aObj = new RequiredCurriculaCodeType(valueParam);
            setRequiredCurriculaCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type OtherConditionsIndicatorType and never <code>null</code>
     */
    @Nonnull
    public OtherConditionsIndicatorType setOtherConditionsIndicator(final boolean valueParam) {
        OtherConditionsIndicatorType aObj = getOtherConditionsIndicator();
        if (aObj == null) {
            aObj = new OtherConditionsIndicatorType(valueParam);
            setOtherConditionsIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type RecurringProcurementIndicatorType and never <code>null</code>
     */
    @Nonnull
    public RecurringProcurementIndicatorType setRecurringProcurementIndicator(final boolean valueParam) {
        RecurringProcurementIndicatorType aObj = getRecurringProcurementIndicator();
        if (aObj == null) {
            aObj = new RecurringProcurementIndicatorType(valueParam);
            setRecurringProcurementIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestSecurityClearanceDateType and never <code>null</code>
     */
    @Nonnull
    public LatestSecurityClearanceDateType setLatestSecurityClearanceDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        LatestSecurityClearanceDateType aObj = getLatestSecurityClearanceDate();
        if (aObj == null) {
            aObj = new LatestSecurityClearanceDateType(valueParam);
            setLatestSecurityClearanceDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestSecurityClearanceDateType and never <code>null</code>
     */
    @Nonnull
    public LatestSecurityClearanceDateType setLatestSecurityClearanceDate(
        @Nullable
        final LocalDate valueParam) {
        LatestSecurityClearanceDateType aObj = getLatestSecurityClearanceDate();
        if (aObj == null) {
            aObj = new LatestSecurityClearanceDateType(valueParam);
            setLatestSecurityClearanceDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DocumentationFeeAmountType and never <code>null</code>
     */
    @Nonnull
    public DocumentationFeeAmountType setDocumentationFeeAmount(
        @Nullable
        final BigDecimal valueParam) {
        DocumentationFeeAmountType aObj = getDocumentationFeeAmount();
        if (aObj == null) {
            aObj = new DocumentationFeeAmountType(valueParam);
            setDocumentationFeeAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MultipleTendersCodeType and never <code>null</code>
     */
    @Nonnull
    public MultipleTendersCodeType setMultipleTendersCode(
        @Nullable
        final String valueParam) {
        MultipleTendersCodeType aObj = getMultipleTendersCode();
        if (aObj == null) {
            aObj = new MultipleTendersCodeType(valueParam);
            setMultipleTendersCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained AwardingMethodTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AwardingMethodTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getAwardingMethodTypeCodeValue() {
        AwardingMethodTypeCodeType aObj = getAwardingMethodTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PriceEvaluationCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PriceEvaluationCodeType object or <code>null</code>
     */
    @Nullable
    public String getPriceEvaluationCodeValue() {
        PriceEvaluationCodeType aObj = getPriceEvaluationCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumVariantQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumVariantQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumVariantQuantityValue() {
        MaximumVariantQuantityType aObj = getMaximumVariantQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained VariantConstraintIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained VariantConstraintIndicatorType object or the passed nullValue
     */
    public boolean isVariantConstraintIndicatorValue(final boolean nullValue) {
        VariantConstraintIndicatorType aObj = getVariantConstraintIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained VariantConstraintCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VariantConstraintCodeType object or <code>null</code>
     */
    @Nullable
    public String getVariantConstraintCodeValue() {
        VariantConstraintCodeType aObj = getVariantConstraintCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FundingProgramCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FundingProgramCodeType object or <code>null</code>
     */
    @Nullable
    public String getFundingProgramCodeValue() {
        FundingProgramCodeType aObj = getFundingProgramCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumAdvertisementAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumAdvertisementAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumAdvertisementAmountValue() {
        MaximumAdvertisementAmountType aObj = getMaximumAdvertisementAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaymentFrequencyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentFrequencyCodeType object or <code>null</code>
     */
    @Nullable
    public String getPaymentFrequencyCodeValue() {
        PaymentFrequencyCodeType aObj = getPaymentFrequencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EconomicOperatorRegistryURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EconomicOperatorRegistryURIType object or <code>null</code>
     */
    @Nullable
    public String getEconomicOperatorRegistryURIValue() {
        EconomicOperatorRegistryURIType aObj = getEconomicOperatorRegistryURI();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RequiredCurriculaIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained RequiredCurriculaIndicatorType object or the passed nullValue
     */
    public boolean isRequiredCurriculaIndicatorValue(final boolean nullValue) {
        RequiredCurriculaIndicatorType aObj = getRequiredCurriculaIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained RequiredCurriculaCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequiredCurriculaCodeType object or <code>null</code>
     */
    @Nullable
    public String getRequiredCurriculaCodeValue() {
        RequiredCurriculaCodeType aObj = getRequiredCurriculaCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OtherConditionsIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained OtherConditionsIndicatorType object or the passed nullValue
     */
    public boolean isOtherConditionsIndicatorValue(final boolean nullValue) {
        OtherConditionsIndicatorType aObj = getOtherConditionsIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained RecurringProcurementIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained RecurringProcurementIndicatorType object or the passed nullValue
     */
    public boolean isRecurringProcurementIndicatorValue(final boolean nullValue) {
        RecurringProcurementIndicatorType aObj = getRecurringProcurementIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained LatestSecurityClearanceDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestSecurityClearanceDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getLatestSecurityClearanceDateValue() {
        LatestSecurityClearanceDateType aObj = getLatestSecurityClearanceDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatestSecurityClearanceDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestSecurityClearanceDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getLatestSecurityClearanceDateValueLocal() {
        LatestSecurityClearanceDateType aObj = getLatestSecurityClearanceDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained DocumentationFeeAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DocumentationFeeAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDocumentationFeeAmountValue() {
        DocumentationFeeAmountType aObj = getDocumentationFeeAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MultipleTendersCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MultipleTendersCodeType object or <code>null</code>
     */
    @Nullable
    public String getMultipleTendersCodeValue() {
        MultipleTendersCodeType aObj = getMultipleTendersCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
