
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.SequenceNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.TransportExecutionPlanReferenceIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for TransportationSegmentType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TransportationSegmentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SequenceNumeric"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportExecutionPlanReferenceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransportationService"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransportServiceProviderParty"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReferencedConsignment" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipmentStage" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransportationSegmentType", propOrder = {
    "ublExtensions",
    "sequenceNumeric",
    "transportExecutionPlanReferenceID",
    "transportationService",
    "transportServiceProviderParty",
    "referencedConsignment",
    "shipmentStage"
})
@CodingStyleguideUnaware
public class TransportationSegmentType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "SequenceNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private SequenceNumericType sequenceNumeric;
    @XmlElement(name = "TransportExecutionPlanReferenceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransportExecutionPlanReferenceIDType transportExecutionPlanReferenceID;
    @XmlElement(name = "TransportationService", required = true)
    private TransportationServiceType transportationService;
    @XmlElement(name = "TransportServiceProviderParty", required = true)
    private PartyType transportServiceProviderParty;
    @XmlElement(name = "ReferencedConsignment")
    private ConsignmentType referencedConsignment;
    @XmlElement(name = "ShipmentStage")
    private List<ShipmentStageType> shipmentStage;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TransportationSegmentType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the sequenceNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceNumericType }
     *     
     */
    @Nullable
    public SequenceNumericType getSequenceNumeric() {
        return sequenceNumeric;
    }

    /**
     * Sets the value of the sequenceNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceNumericType }
     *     
     */
    public void setSequenceNumeric(
        @Nullable
        SequenceNumericType value) {
        this.sequenceNumeric = value;
    }

    /**
     * Gets the value of the transportExecutionPlanReferenceID property.
     * 
     * @return
     *     possible object is
     *     {@link TransportExecutionPlanReferenceIDType }
     *     
     */
    @Nullable
    public TransportExecutionPlanReferenceIDType getTransportExecutionPlanReferenceID() {
        return transportExecutionPlanReferenceID;
    }

    /**
     * Sets the value of the transportExecutionPlanReferenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportExecutionPlanReferenceIDType }
     *     
     */
    public void setTransportExecutionPlanReferenceID(
        @Nullable
        TransportExecutionPlanReferenceIDType value) {
        this.transportExecutionPlanReferenceID = value;
    }

    /**
     * Gets the value of the transportationService property.
     * 
     * @return
     *     possible object is
     *     {@link TransportationServiceType }
     *     
     */
    @Nullable
    public TransportationServiceType getTransportationService() {
        return transportationService;
    }

    /**
     * Sets the value of the transportationService property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportationServiceType }
     *     
     */
    public void setTransportationService(
        @Nullable
        TransportationServiceType value) {
        this.transportationService = value;
    }

    /**
     * Gets the value of the transportServiceProviderParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getTransportServiceProviderParty() {
        return transportServiceProviderParty;
    }

    /**
     * Sets the value of the transportServiceProviderParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setTransportServiceProviderParty(
        @Nullable
        PartyType value) {
        this.transportServiceProviderParty = value;
    }

    /**
     * Gets the value of the referencedConsignment property.
     * 
     * @return
     *     possible object is
     *     {@link ConsignmentType }
     *     
     */
    @Nullable
    public ConsignmentType getReferencedConsignment() {
        return referencedConsignment;
    }

    /**
     * Sets the value of the referencedConsignment property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConsignmentType }
     *     
     */
    public void setReferencedConsignment(
        @Nullable
        ConsignmentType value) {
        this.referencedConsignment = value;
    }

    /**
     * Gets the value of the shipmentStage property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipmentStage property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipmentStage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipmentStageType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipmentStage property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipmentStageType> getShipmentStage() {
        if (shipmentStage == null) {
            shipmentStage = new ArrayList<>();
        }
        return this.shipmentStage;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TransportationSegmentType rhs = ((TransportationSegmentType) o);
        if (!EqualsHelper.equals(referencedConsignment, rhs.referencedConsignment)) {
            return false;
        }
        if (!EqualsHelper.equals(sequenceNumeric, rhs.sequenceNumeric)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipmentStage, rhs.shipmentStage)) {
            return false;
        }
        if (!EqualsHelper.equals(transportExecutionPlanReferenceID, rhs.transportExecutionPlanReferenceID)) {
            return false;
        }
        if (!EqualsHelper.equals(transportServiceProviderParty, rhs.transportServiceProviderParty)) {
            return false;
        }
        if (!EqualsHelper.equals(transportationService, rhs.transportationService)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(referencedConsignment).append(sequenceNumeric).append(shipmentStage).append(transportExecutionPlanReferenceID).append(transportServiceProviderParty).append(transportationService).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("referencedConsignment", referencedConsignment).append("sequenceNumeric", sequenceNumeric).append("shipmentStage", shipmentStage).append("transportExecutionPlanReferenceID", transportExecutionPlanReferenceID).append("transportServiceProviderParty", transportServiceProviderParty).append("transportationService", transportationService).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipmentStage(
        @Nullable
        final List<ShipmentStageType> aList) {
        shipmentStage = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipmentStageEntries() {
        return (!getShipmentStage().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipmentStageEntries() {
        return getShipmentStage().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipmentStageCount() {
        return getShipmentStage().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipmentStageType getShipmentStageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipmentStage().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipmentStage(
        @Nonnull
        final ShipmentStageType elem) {
        getShipmentStage().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TransportationSegmentType ret) {
        ret.referencedConsignment = ((referencedConsignment == null)?null:referencedConsignment.clone());
        ret.sequenceNumeric = ((sequenceNumeric == null)?null:sequenceNumeric.clone());
        if (shipmentStage == null) {
            ret.shipmentStage = null;
        } else {
            List<ShipmentStageType> retShipmentStage = new ArrayList<>();
            for (ShipmentStageType aItem: getShipmentStage()) {
                retShipmentStage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipmentStage = retShipmentStage;
        }
        ret.transportExecutionPlanReferenceID = ((transportExecutionPlanReferenceID == null)?null:transportExecutionPlanReferenceID.clone());
        ret.transportServiceProviderParty = ((transportServiceProviderParty == null)?null:transportServiceProviderParty.clone());
        ret.transportationService = ((transportationService == null)?null:transportationService.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TransportationSegmentType clone() {
        TransportationSegmentType ret = new TransportationSegmentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SequenceNumericType and never <code>null</code>
     */
    @Nonnull
    public SequenceNumericType setSequenceNumeric(
        @Nullable
        final BigDecimal valueParam) {
        SequenceNumericType aObj = getSequenceNumeric();
        if (aObj == null) {
            aObj = new SequenceNumericType(valueParam);
            setSequenceNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportExecutionPlanReferenceIDType and never <code>null</code>
     */
    @Nonnull
    public TransportExecutionPlanReferenceIDType setTransportExecutionPlanReferenceID(
        @Nullable
        final String valueParam) {
        TransportExecutionPlanReferenceIDType aObj = getTransportExecutionPlanReferenceID();
        if (aObj == null) {
            aObj = new TransportExecutionPlanReferenceIDType(valueParam);
            setTransportExecutionPlanReferenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained SequenceNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SequenceNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSequenceNumericValue() {
        SequenceNumericType aObj = getSequenceNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransportExecutionPlanReferenceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportExecutionPlanReferenceIDType object or <code>null</code>
     */
    @Nullable
    public String getTransportExecutionPlanReferenceIDValue() {
        TransportExecutionPlanReferenceIDType aObj = getTransportExecutionPlanReferenceID();
        return (aObj == null)?null:aObj.getValue();
    }

}
