
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.GrossMassMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.WeighingDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.WeighingDeviceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.WeighingDeviceTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.WeighingMethodCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.WeighingTimeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;


/**
 * <p>Java class for VerifiedGrossMassType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="VerifiedGrossMassType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeighingDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeighingTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeighingMethodCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeighingDeviceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeighingDeviceType" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GrossMassMeasure"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}WeighingParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipperParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ResponsibleParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentReference" maxOccurs="unbounded"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "VerifiedGrossMassType", propOrder = {
    "ublExtensions",
    "id",
    "weighingDate",
    "weighingTime",
    "weighingMethodCode",
    "weighingDeviceID",
    "weighingDeviceType",
    "grossMassMeasure",
    "weighingParty",
    "shipperParty",
    "responsibleParty",
    "documentReference"
})
@CodingStyleguideUnaware
public class VerifiedGrossMassType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "WeighingDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WeighingDateType weighingDate;
    @XmlElement(name = "WeighingTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WeighingTimeType weighingTime;
    @XmlElement(name = "WeighingMethodCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private WeighingMethodCodeType weighingMethodCode;
    @XmlElement(name = "WeighingDeviceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WeighingDeviceIDType weighingDeviceID;
    @XmlElement(name = "WeighingDeviceType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WeighingDeviceTypeType weighingDeviceType;
    @XmlElement(name = "GrossMassMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private GrossMassMeasureType grossMassMeasure;
    @XmlElement(name = "WeighingParty")
    private PartyType weighingParty;
    @XmlElement(name = "ShipperParty")
    private PartyType shipperParty;
    @XmlElement(name = "ResponsibleParty")
    private PartyType responsibleParty;
    @XmlElement(name = "DocumentReference", required = true)
    private List<DocumentReferenceType> documentReference;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public VerifiedGrossMassType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the weighingDate property.
     * 
     * @return
     *     possible object is
     *     {@link WeighingDateType }
     *     
     */
    @Nullable
    public WeighingDateType getWeighingDate() {
        return weighingDate;
    }

    /**
     * Sets the value of the weighingDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeighingDateType }
     *     
     */
    public void setWeighingDate(
        @Nullable
        WeighingDateType value) {
        this.weighingDate = value;
    }

    /**
     * Gets the value of the weighingTime property.
     * 
     * @return
     *     possible object is
     *     {@link WeighingTimeType }
     *     
     */
    @Nullable
    public WeighingTimeType getWeighingTime() {
        return weighingTime;
    }

    /**
     * Sets the value of the weighingTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeighingTimeType }
     *     
     */
    public void setWeighingTime(
        @Nullable
        WeighingTimeType value) {
        this.weighingTime = value;
    }

    /**
     * Gets the value of the weighingMethodCode property.
     * 
     * @return
     *     possible object is
     *     {@link WeighingMethodCodeType }
     *     
     */
    @Nullable
    public WeighingMethodCodeType getWeighingMethodCode() {
        return weighingMethodCode;
    }

    /**
     * Sets the value of the weighingMethodCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeighingMethodCodeType }
     *     
     */
    public void setWeighingMethodCode(
        @Nullable
        WeighingMethodCodeType value) {
        this.weighingMethodCode = value;
    }

    /**
     * Gets the value of the weighingDeviceID property.
     * 
     * @return
     *     possible object is
     *     {@link WeighingDeviceIDType }
     *     
     */
    @Nullable
    public WeighingDeviceIDType getWeighingDeviceID() {
        return weighingDeviceID;
    }

    /**
     * Sets the value of the weighingDeviceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeighingDeviceIDType }
     *     
     */
    public void setWeighingDeviceID(
        @Nullable
        WeighingDeviceIDType value) {
        this.weighingDeviceID = value;
    }

    /**
     * Gets the value of the weighingDeviceType property.
     * 
     * @return
     *     possible object is
     *     {@link WeighingDeviceTypeType }
     *     
     */
    @Nullable
    public WeighingDeviceTypeType getWeighingDeviceType() {
        return weighingDeviceType;
    }

    /**
     * Sets the value of the weighingDeviceType property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeighingDeviceTypeType }
     *     
     */
    public void setWeighingDeviceType(
        @Nullable
        WeighingDeviceTypeType value) {
        this.weighingDeviceType = value;
    }

    /**
     * Gets the value of the grossMassMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link GrossMassMeasureType }
     *     
     */
    @Nullable
    public GrossMassMeasureType getGrossMassMeasure() {
        return grossMassMeasure;
    }

    /**
     * Sets the value of the grossMassMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link GrossMassMeasureType }
     *     
     */
    public void setGrossMassMeasure(
        @Nullable
        GrossMassMeasureType value) {
        this.grossMassMeasure = value;
    }

    /**
     * Gets the value of the weighingParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getWeighingParty() {
        return weighingParty;
    }

    /**
     * Sets the value of the weighingParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setWeighingParty(
        @Nullable
        PartyType value) {
        this.weighingParty = value;
    }

    /**
     * Gets the value of the shipperParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getShipperParty() {
        return shipperParty;
    }

    /**
     * Sets the value of the shipperParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setShipperParty(
        @Nullable
        PartyType value) {
        this.shipperParty = value;
    }

    /**
     * Gets the value of the responsibleParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getResponsibleParty() {
        return responsibleParty;
    }

    /**
     * Sets the value of the responsibleParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setResponsibleParty(
        @Nullable
        PartyType value) {
        this.responsibleParty = value;
    }

    /**
     * Gets the value of the documentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the documentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the documentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getDocumentReference() {
        if (documentReference == null) {
            documentReference = new ArrayList<>();
        }
        return this.documentReference;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final VerifiedGrossMassType rhs = ((VerifiedGrossMassType) o);
        if (!EqualsHelper.equalsCollection(documentReference, rhs.documentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(grossMassMeasure, rhs.grossMassMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(responsibleParty, rhs.responsibleParty)) {
            return false;
        }
        if (!EqualsHelper.equals(shipperParty, rhs.shipperParty)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(weighingDate, rhs.weighingDate)) {
            return false;
        }
        if (!EqualsHelper.equals(weighingDeviceID, rhs.weighingDeviceID)) {
            return false;
        }
        if (!EqualsHelper.equals(weighingDeviceType, rhs.weighingDeviceType)) {
            return false;
        }
        if (!EqualsHelper.equals(weighingMethodCode, rhs.weighingMethodCode)) {
            return false;
        }
        if (!EqualsHelper.equals(weighingParty, rhs.weighingParty)) {
            return false;
        }
        if (!EqualsHelper.equals(weighingTime, rhs.weighingTime)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(documentReference).append(grossMassMeasure).append(id).append(responsibleParty).append(shipperParty).append(ublExtensions).append(weighingDate).append(weighingDeviceID).append(weighingDeviceType).append(weighingMethodCode).append(weighingParty).append(weighingTime).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("documentReference", documentReference).append("grossMassMeasure", grossMassMeasure).append("id", id).append("responsibleParty", responsibleParty).append("shipperParty", shipperParty).append("ublExtensions", ublExtensions).append("weighingDate", weighingDate).append("weighingDeviceID", weighingDeviceID).append("weighingDeviceType", weighingDeviceType).append("weighingMethodCode", weighingMethodCode).append("weighingParty", weighingParty).append("weighingTime", weighingTime).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        documentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDocumentReferenceEntries() {
        return (!getDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDocumentReferenceEntries() {
        return getDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDocumentReferenceCount() {
        return getDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getDocumentReference().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        VerifiedGrossMassType ret) {
        if (documentReference == null) {
            ret.documentReference = null;
        } else {
            List<DocumentReferenceType> retDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getDocumentReference()) {
                retDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.documentReference = retDocumentReference;
        }
        ret.grossMassMeasure = ((grossMassMeasure == null)?null:grossMassMeasure.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.responsibleParty = ((responsibleParty == null)?null:responsibleParty.clone());
        ret.shipperParty = ((shipperParty == null)?null:shipperParty.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.weighingDate = ((weighingDate == null)?null:weighingDate.clone());
        ret.weighingDeviceID = ((weighingDeviceID == null)?null:weighingDeviceID.clone());
        ret.weighingDeviceType = ((weighingDeviceType == null)?null:weighingDeviceType.clone());
        ret.weighingMethodCode = ((weighingMethodCode == null)?null:weighingMethodCode.clone());
        ret.weighingParty = ((weighingParty == null)?null:weighingParty.clone());
        ret.weighingTime = ((weighingTime == null)?null:weighingTime.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public VerifiedGrossMassType clone() {
        VerifiedGrossMassType ret = new VerifiedGrossMassType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeighingDateType and never <code>null</code>
     */
    @Nonnull
    public WeighingDateType setWeighingDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        WeighingDateType aObj = getWeighingDate();
        if (aObj == null) {
            aObj = new WeighingDateType(valueParam);
            setWeighingDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeighingDateType and never <code>null</code>
     */
    @Nonnull
    public WeighingDateType setWeighingDate(
        @Nullable
        final LocalDate valueParam) {
        WeighingDateType aObj = getWeighingDate();
        if (aObj == null) {
            aObj = new WeighingDateType(valueParam);
            setWeighingDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeighingTimeType and never <code>null</code>
     */
    @Nonnull
    public WeighingTimeType setWeighingTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        WeighingTimeType aObj = getWeighingTime();
        if (aObj == null) {
            aObj = new WeighingTimeType(valueParam);
            setWeighingTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeighingTimeType and never <code>null</code>
     */
    @Nonnull
    public WeighingTimeType setWeighingTime(
        @Nullable
        final LocalTime valueParam) {
        WeighingTimeType aObj = getWeighingTime();
        if (aObj == null) {
            aObj = new WeighingTimeType(valueParam);
            setWeighingTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeighingMethodCodeType and never <code>null</code>
     */
    @Nonnull
    public WeighingMethodCodeType setWeighingMethodCode(
        @Nullable
        final String valueParam) {
        WeighingMethodCodeType aObj = getWeighingMethodCode();
        if (aObj == null) {
            aObj = new WeighingMethodCodeType(valueParam);
            setWeighingMethodCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeighingDeviceIDType and never <code>null</code>
     */
    @Nonnull
    public WeighingDeviceIDType setWeighingDeviceID(
        @Nullable
        final String valueParam) {
        WeighingDeviceIDType aObj = getWeighingDeviceID();
        if (aObj == null) {
            aObj = new WeighingDeviceIDType(valueParam);
            setWeighingDeviceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeighingDeviceTypeType and never <code>null</code>
     */
    @Nonnull
    public WeighingDeviceTypeType setWeighingDeviceType(
        @Nullable
        final String valueParam) {
        WeighingDeviceTypeType aObj = getWeighingDeviceType();
        if (aObj == null) {
            aObj = new WeighingDeviceTypeType(valueParam);
            setWeighingDeviceType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GrossMassMeasureType and never <code>null</code>
     */
    @Nonnull
    public GrossMassMeasureType setGrossMassMeasure(
        @Nullable
        final BigDecimal valueParam) {
        GrossMassMeasureType aObj = getGrossMassMeasure();
        if (aObj == null) {
            aObj = new GrossMassMeasureType(valueParam);
            setGrossMassMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeighingDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeighingDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getWeighingDateValue() {
        WeighingDateType aObj = getWeighingDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeighingDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeighingDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getWeighingDateValueLocal() {
        WeighingDateType aObj = getWeighingDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained WeighingTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeighingTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getWeighingTimeValue() {
        WeighingTimeType aObj = getWeighingTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeighingTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeighingTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getWeighingTimeValueLocal() {
        WeighingTimeType aObj = getWeighingTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained WeighingMethodCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeighingMethodCodeType object or <code>null</code>
     */
    @Nullable
    public String getWeighingMethodCodeValue() {
        WeighingMethodCodeType aObj = getWeighingMethodCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeighingDeviceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeighingDeviceIDType object or <code>null</code>
     */
    @Nullable
    public String getWeighingDeviceIDValue() {
        WeighingDeviceIDType aObj = getWeighingDeviceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeighingDeviceTypeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeighingDeviceTypeType object or <code>null</code>
     */
    @Nullable
    public String getWeighingDeviceTypeValue() {
        WeighingDeviceTypeType aObj = getWeighingDeviceType();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GrossMassMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GrossMassMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossMassMeasureValue() {
        GrossMassMeasureType aObj = getGrossMassMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

}
