/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.digestauth;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.string.StringHelper;
import com.helger.http.HttpStringHelper;
import com.helger.http.digestauth.DigestAuthClientCredentials;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class HttpDigestAuth {
    public static final String HEADER_VALUE_PREFIX_DIGEST = "Digest";
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_MD5_SESS = "MD5-sess";
    public static final String DEFAULT_ALGORITHM = "MD5";
    public static final String QOP_AUTH = "auth";
    public static final String QOP_AUTH_INT = "auth-int";
    public static final String DEFAULT_QOP = "auth";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDigestAuth.class);
    private static final char SEPARATOR = ':';
    private static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private static final HttpDigestAuth INSTANCE = new HttpDigestAuth();

    private HttpDigestAuth() {
    }

    @Nullable
    public static ICommonsOrderedMap<String, String> getDigestAuthParams(@Nullable String string) {
        CommonsLinkedHashMap commonsLinkedHashMap;
        block20: {
            String string2;
            String string3 = StringHelper.trim((String)string);
            if (StringHelper.hasNoText((String)string3)) {
                return null;
            }
            if (!string3.startsWith(HEADER_VALUE_PREFIX_DIGEST)) {
                LOGGER.error("String does not start with 'Digest'");
                return null;
            }
            char[] cArray = string3.toCharArray();
            int n = HEADER_VALUE_PREFIX_DIGEST.length();
            if (n >= cArray.length || !HttpStringHelper.isLinearWhitespaceChar(cArray[n])) {
                LOGGER.error("No whitespace after 'Digest'");
                return null;
            }
            ++n;
            commonsLinkedHashMap = new CommonsLinkedHashMap();
            while (true) {
                String string4;
                if (n < cArray.length && HttpStringHelper.isLinearWhitespaceChar(cArray[n])) {
                    ++n;
                    continue;
                }
                int n2 = n;
                while (n < cArray.length && HttpStringHelper.isTokenChar(cArray[n])) {
                    ++n;
                }
                if (n2 == n) {
                    LOGGER.error("No token and no whitespace found for auth-param name: '" + cArray[n] + "'");
                    return null;
                }
                string2 = string3.substring(n2, n);
                while (n < cArray.length && HttpStringHelper.isLinearWhitespaceChar(cArray[n])) {
                    ++n;
                }
                if (n >= cArray.length || cArray[n] != '=') {
                    LOGGER.error("No separator char '=' found after '" + string2 + "'");
                    return null;
                }
                ++n;
                while (n < cArray.length && HttpStringHelper.isLinearWhitespaceChar(cArray[n])) {
                    ++n;
                }
                if (n >= cArray.length) {
                    LOGGER.error("Found nothing after '=' of '" + string2 + "'");
                    return null;
                }
                if (cArray[n] == '\"') {
                    n2 = ++n;
                    while (n < cArray.length && HttpStringHelper.isQuotedTextChar(cArray[n])) {
                        ++n;
                    }
                    if (n >= cArray.length) {
                        LOGGER.error("Unexpected EOF in quoted text for '" + string2 + "'");
                        return null;
                    }
                    if (cArray[n] != '\"') {
                        LOGGER.error("Quoted string of token '" + string2 + "' is not terminated correctly: '" + cArray[n] + "'");
                        return null;
                    }
                    string4 = string3.substring(n2, n);
                    ++n;
                } else {
                    n2 = n;
                    while (n < cArray.length && HttpStringHelper.isTokenChar(cArray[n])) {
                        ++n;
                    }
                    if (n2 == n) {
                        LOGGER.error("No token and no whitespace found for auth-param value of '" + string2 + "': '" + cArray[n] + "'");
                        return null;
                    }
                    string4 = string3.substring(n2, n);
                }
                commonsLinkedHashMap.put((Object)string2, (Object)string4);
                while (n < cArray.length && HttpStringHelper.isLinearWhitespaceChar(cArray[n])) {
                    ++n;
                }
                if (n >= cArray.length) break block20;
                if (cArray[n] != ',') {
                    LOGGER.error("Illegal character after auth-param '" + string2 + "': '" + cArray[n] + "'");
                    return null;
                }
                if (++n >= cArray.length) break;
            }
            LOGGER.error("Found nothing after continuation of auth-param '" + string2 + "'");
            return null;
        }
        return commonsLinkedHashMap;
    }

    @Nullable
    public static DigestAuthClientCredentials getDigestAuthClientCredentials(@Nullable String string) {
        ICommonsOrderedMap<String, String> iCommonsOrderedMap = HttpDigestAuth.getDigestAuthParams(string);
        if (iCommonsOrderedMap == null) {
            return null;
        }
        String string2 = (String)iCommonsOrderedMap.remove((Object)"username");
        if (string2 == null) {
            LOGGER.error("Digest Auth does not container 'username'");
            return null;
        }
        String string3 = (String)iCommonsOrderedMap.remove((Object)"realm");
        if (string3 == null) {
            LOGGER.error("Digest Auth does not container 'realm'");
            return null;
        }
        String string4 = (String)iCommonsOrderedMap.remove((Object)"nonce");
        if (string4 == null) {
            LOGGER.error("Digest Auth does not container 'nonce'");
            return null;
        }
        String string5 = (String)iCommonsOrderedMap.remove((Object)"uri");
        if (string5 == null) {
            LOGGER.error("Digest Auth does not container 'uri'");
            return null;
        }
        String string6 = (String)iCommonsOrderedMap.remove((Object)"response");
        if (string6 == null) {
            LOGGER.error("Digest Auth does not container 'response'");
            return null;
        }
        String string7 = (String)iCommonsOrderedMap.remove((Object)"algorithm");
        String string8 = (String)iCommonsOrderedMap.remove((Object)"cnonce");
        String string9 = (String)iCommonsOrderedMap.remove((Object)"opaque");
        String string10 = (String)iCommonsOrderedMap.remove((Object)"qop");
        String string11 = (String)iCommonsOrderedMap.remove((Object)"nc");
        if (iCommonsOrderedMap.isNotEmpty()) {
            LOGGER.warn("Digest Auth contains unhandled parameters: " + iCommonsOrderedMap.toString());
        }
        return new DigestAuthClientCredentials(string2, string3, string4, string5, string6, string7, string8, string9, string10, string11);
    }

    @Nullable
    public static String getNonceCountString(@CheckForSigned int n) {
        return n <= 0 ? null : StringHelper.getLeadingZero((String)StringHelper.getHexString((int)n), (int)8);
    }

    @Nonnull
    private static String _md5(@Nonnull String string) {
        return MessageDigestValue.create((byte[])string.getBytes(CHARSET), (EMessageDigestAlgorithm)EMessageDigestAlgorithm.MD5).getHexEncodedDigestString();
    }

    @Nonnull
    public static DigestAuthClientCredentials createDigestAuthClientCredentials(@Nonnull EHttpMethod eHttpMethod, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9, @CheckForSigned int n) {
        String string10;
        ValueEnforcer.notNull((Object)eHttpMethod, (String)"Method");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DigestURI");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"UserName");
        ValueEnforcer.notNull((Object)string3, (String)"Password");
        ValueEnforcer.notEmpty((CharSequence)string4, (String)"Realm");
        ValueEnforcer.notEmpty((CharSequence)string5, (String)"ServerNonce");
        if (string9 != null && StringHelper.hasNoText((String)string7)) {
            throw new IllegalArgumentException("If a QOP is defined, client nonce must be set!");
        }
        if (string9 != null && n <= 0) {
            throw new IllegalArgumentException("If a QOP is defined, nonce count must be positive!");
        }
        String string11 = string10 = string6 == null ? "MD5" : string6;
        if (!string10.equals("MD5") && !string10.equals(ALGORITHM_MD5_SESS)) {
            throw new IllegalArgumentException("Currently only 'MD5' and 'MD5-sess' algorithms are supported!");
        }
        if (string9 != null && !string9.equals("auth")) {
            throw new IllegalArgumentException("Currently only 'auth' QOP is supported!");
        }
        String string12 = HttpDigestAuth.getNonceCountString(n);
        String string13 = HttpDigestAuth._md5(string2 + ":" + string4 + ":" + string3);
        if (string10.equals(ALGORITHM_MD5_SESS)) {
            if (StringHelper.hasNoText((String)string7)) {
                throw new IllegalArgumentException("Algorithm requires client nonce!");
            }
            string13 = HttpDigestAuth._md5(string13 + ":" + string5 + ":" + string7);
        }
        String string14 = HttpDigestAuth._md5(eHttpMethod.getName() + ":" + string);
        String string15 = string9 == null ? HttpDigestAuth._md5(string13 + ":" + string5 + ":" + string14) : HttpDigestAuth._md5(string13 + ":" + string5 + ":" + string12 + ":" + string7 + ":" + string9 + ":" + string14);
        return new DigestAuthClientCredentials(string2, string4, string5, string, string15, string6, string7, string8, string9, string12);
    }
}

