/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.http.AcceptMimeTypeList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AcceptMimeTypeHandler {
    public static final IMimeType ANY_MIMETYPE = new MimeType(EMimeContentType._STAR, "*");
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptMimeTypeHandler.class);
    private static final AcceptMimeTypeHandler INSTANCE = new AcceptMimeTypeHandler();

    private AcceptMimeTypeHandler() {
    }

    @Nonnull
    public static AcceptMimeTypeList getAcceptMimeTypes(@Nullable String string) {
        AcceptMimeTypeList acceptMimeTypeList = new AcceptMimeTypeList();
        if (StringHelper.hasNoText((String)string)) {
            acceptMimeTypeList.addMimeType(ANY_MIMETYPE, 1.0);
        } else {
            for (String string2 : StringHelper.getExploded((char)',', (String)string)) {
                String string3;
                MimeType mimeType;
                String[] stringArray = StringHelper.getExplodedArray((char)';', (String)string2.trim(), (int)2);
                double d = 1.0;
                if (stringArray.length == 2 && stringArray[1].trim().startsWith("q=")) {
                    d = StringParser.parseDouble((String)stringArray[1].trim().substring(2), (double)1.0);
                }
                if ((mimeType = MimeTypeParser.safeParseMimeType((String)(string3 = stringArray[0]))) != null) {
                    if (mimeType.hasAnyParameters()) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Ignoring all contained MIME type parameter from '" + string3 + "'!");
                        }
                        mimeType = mimeType.getCopyWithoutParameters();
                    }
                    acceptMimeTypeList.addMimeType((IMimeType)mimeType, d);
                    continue;
                }
                if ("*".equals(string3)) {
                    acceptMimeTypeList.addMimeType(ANY_MIMETYPE, d);
                    continue;
                }
                if ("xml/xml".equals(string3) || !LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Failed to parse Mime type '" + string3 + "' as part of '" + string + "'!");
            }
        }
        return acceptMimeTypeList;
    }

    @Nullable
    @Deprecated
    public static IMimeType safeParseMimeType(@Nullable String string) {
        return MimeTypeParser.safeParseMimeType((String)string);
    }
}

